/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.common.autoshape.pathbuilder.rect;

import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.AutoShape;

public class RectPathBuilder {
    private static RectF rectF = new RectF();
    private static Path path = new Path();

    public static Path getRectPath(AutoShape shape, Rect rect) {
        path.reset();
        switch (shape.getShapeType()) {
            case 1: 
            case 136: 
            case 202: {
                return RectPathBuilder.getRectanglePath(shape, rect);
            }
            case 2: {
                return RectPathBuilder.getRoundRectanglePath(shape, rect);
            }
            case 210: {
                return RectPathBuilder.getRound1Path(shape, rect);
            }
            case 211: {
                return RectPathBuilder.getRound2Path(shape, rect);
            }
            case 212: {
                return RectPathBuilder.getRound2DiagRectPath(shape, rect);
            }
            case 213: {
                return RectPathBuilder.getSnip1RectPath(shape, rect);
            }
            case 214: {
                return RectPathBuilder.getSnip2SameRectPath(shape, rect);
            }
            case 215: {
                return RectPathBuilder.getSnip2DiagPath(shape, rect);
            }
            case 216: {
                return RectPathBuilder.getSnipRoundPath(shape, rect);
            }
        }
        return null;
    }

    private static Path getRectanglePath(AutoShape shape, Rect rect) {
        path.addRect((float)rect.left, (float)rect.top, (float)rect.right, (float)rect.bottom, Path.Direction.CW);
        return path;
    }

    private static Path getRoundRectanglePath(AutoShape shape, Rect rect) {
        float x = (float)Math.min(rect.width(), rect.height()) * 0.18f;
        Float[] values = shape.getAdjustData();
        if (values != null && values.length >= 1 && values[0] != null) {
            x = (float)Math.min(rect.width(), rect.height()) * values[0].floatValue();
        }
        rectF.set((float)rect.left, (float)rect.top, (float)rect.right, (float)rect.bottom);
        path.addRoundRect(rectF, new float[]{x, x, x, x, x, x, x, x}, Path.Direction.CW);
        return path;
    }

    private static Path getRound1Path(AutoShape shape, Rect rect) {
        float x = (float)Math.min(rect.width(), rect.height()) * 0.18f;
        Float[] values = shape.getAdjustData();
        if (values != null && values.length >= 1 && values[0] != null) {
            x = (float)Math.min(rect.width(), rect.height()) * values[0].floatValue();
        }
        rectF.set((float)rect.left, (float)rect.top, (float)rect.right, (float)rect.bottom);
        path.addRoundRect(rectF, new float[]{0.0f, 0.0f, x, x, 0.0f, 0.0f, 0.0f, 0.0f}, Path.Direction.CW);
        return path;
    }

    private static Path getRound2Path(AutoShape shape, Rect rect) {
        float x = (float)Math.min(rect.width(), rect.height()) * 0.18f;
        float y = 0.0f;
        Float[] values = shape.getAdjustData();
        if (values != null && values.length >= 2) {
            if (values[0] != null) {
                x = (float)Math.min(rect.width(), rect.height()) * values[0].floatValue();
            }
            if (values[1] != null) {
                y = (float)Math.min(rect.width(), rect.height()) * values[1].floatValue();
            }
        }
        rectF.set((float)rect.left, (float)rect.top, (float)rect.right, (float)rect.bottom);
        path.addRoundRect(rectF, new float[]{x, x, x, x, y, y, y, y}, Path.Direction.CW);
        return path;
    }

    private static Path getRound2DiagRectPath(AutoShape shape, Rect rect) {
        float x = (float)Math.min(rect.width(), rect.height()) * 0.18f;
        float y = 0.0f;
        Float[] values = shape.getAdjustData();
        if (values != null && values.length >= 2) {
            if (values[0] != null) {
                x = (float)Math.min(rect.width(), rect.height()) * values[0].floatValue();
            }
            if (values[1] != null) {
                y = (float)Math.min(rect.width(), rect.height()) * values[1].floatValue();
            }
        }
        rectF.set((float)rect.left, (float)rect.top, (float)rect.right, (float)rect.bottom);
        path.addRoundRect(rectF, new float[]{x, x, y, y, x, x, y, y}, Path.Direction.CW);
        return path;
    }

    private static Path getSnip1RectPath(AutoShape shape, Rect rect) {
        float x = (float)Math.min(rect.width(), rect.height()) * 0.18f;
        Float[] values = shape.getAdjustData();
        if (values != null && values.length >= 1 && values[0] != null) {
            x = (float)Math.min(rect.width(), rect.height()) * values[0].floatValue();
        }
        path.moveTo((float)rect.left, (float)rect.top);
        path.lineTo((float)rect.right - x, (float)rect.top);
        path.lineTo((float)rect.right, (float)rect.top + x);
        path.lineTo((float)rect.right, (float)rect.bottom);
        path.lineTo((float)rect.left, (float)rect.bottom);
        path.close();
        return path;
    }

    private static Path getSnip2SameRectPath(AutoShape shape, Rect rect) {
        float x = (float)Math.min(rect.width(), rect.height()) * 0.18f;
        float y = 0.0f;
        Float[] values = shape.getAdjustData();
        if (values != null && values.length >= 2) {
            if (values[0] != null) {
                x = (float)Math.min(rect.width(), rect.height()) * values[0].floatValue();
            }
            if (values[1] != null) {
                y = (float)Math.min(rect.width(), rect.height()) * values[1].floatValue();
            }
        }
        path.moveTo((float)rect.left + x, (float)rect.top);
        path.lineTo((float)rect.right - x, (float)rect.top);
        path.lineTo((float)rect.right, (float)rect.top + x);
        path.lineTo((float)rect.right, (float)rect.bottom - y);
        path.lineTo((float)rect.right - y, (float)rect.bottom);
        path.lineTo((float)rect.left + y, (float)rect.bottom);
        path.lineTo((float)rect.left, (float)rect.bottom - y);
        path.lineTo((float)rect.left, (float)rect.top + x);
        path.close();
        return path;
    }

    private static Path getSnip2DiagPath(AutoShape shape, Rect rect) {
        float x = 0.0f;
        float y = (float)Math.min(rect.width(), rect.height()) * 0.18f;
        Float[] values = shape.getAdjustData();
        if (values != null && values.length >= 2) {
            if (values[0] != null) {
                x = (float)Math.min(rect.width(), rect.height()) * values[0].floatValue();
            }
            if (values[1] != null) {
                y = (float)Math.min(rect.width(), rect.height()) * values[1].floatValue();
            }
        }
        path.reset();
        path.moveTo((float)rect.left + x, (float)rect.top);
        path.lineTo((float)rect.right - y, (float)rect.top);
        path.lineTo((float)rect.right, (float)rect.top + y);
        path.lineTo((float)rect.right, (float)rect.bottom - x);
        path.lineTo((float)rect.right - x, (float)rect.bottom);
        path.lineTo((float)rect.left + y, (float)rect.bottom);
        path.lineTo((float)rect.left, (float)rect.bottom - y);
        path.lineTo((float)rect.left, (float)rect.top + x);
        path.close();
        return path;
    }

    private static Path getdrawSnipRoundRectPath(AutoShape shape, Rect rect) {
        float x = (float)Math.min(rect.width(), rect.height()) * 0.18f;
        float y = (float)Math.min(rect.width(), rect.height()) * 0.18f;
        Float[] values = shape.getAdjustData();
        if (values != null && values.length >= 2) {
            if (values[0] != null) {
                x = (float)Math.min(rect.width(), rect.height()) * values[0].floatValue();
            }
            if (values[1] != null) {
                y = (float)Math.min(rect.width(), rect.height()) * values[1].floatValue();
            }
        }
        path.moveTo((float)rect.left + x, (float)rect.top);
        path.lineTo((float)rect.right - y, (float)rect.top);
        path.lineTo((float)rect.right, (float)rect.top + y);
        path.lineTo((float)rect.right, (float)rect.bottom);
        path.lineTo((float)rect.left, (float)rect.bottom);
        path.lineTo((float)rect.left, (float)rect.top + x);
        rectF.set((float)rect.left, (float)rect.top, (float)rect.left + x * 2.0f, (float)rect.top + x * 2.0f);
        path.arcTo(rectF, 180.0f, 90.0f);
        path.close();
        return path;
    }

    private static Path getSnipRoundPath(AutoShape shape, Rect rect) {
        float x = (float)Math.min(rect.width(), rect.height()) * 0.18f;
        float y = (float)Math.min(rect.width(), rect.height()) * 0.18f;
        Float[] values = shape.getAdjustData();
        if (values != null && values.length >= 2) {
            if (values[0] != null) {
                x = (float)Math.min(rect.width(), rect.height()) * values[0].floatValue();
            }
            if (values[1] != null) {
                y = (float)Math.min(rect.width(), rect.height()) * values[1].floatValue();
            }
        }
        path.reset();
        path.moveTo((float)rect.left + x, (float)rect.top);
        path.lineTo((float)rect.right - y, (float)rect.top);
        path.lineTo((float)rect.right, (float)rect.top + y);
        path.lineTo((float)rect.right, (float)rect.bottom);
        path.lineTo((float)rect.left, (float)rect.bottom);
        path.lineTo((float)rect.left, (float)rect.top + x);
        rectF.set((float)rect.left, (float)rect.top, (float)rect.left + x * 2.0f, (float)rect.top + x * 2.0f);
        path.arcTo(rectF, 180.0f, 90.0f);
        path.close();
        return path;
    }
}

