/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.common.autoshape.pathbuilder.math;

import android.graphics.Path;
import android.graphics.Rect;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.AutoShape;

public class MathPathBuilder {
    private static Path path = new Path();

    public static Path getMathPath(AutoShape shape, Rect rect) {
        path.reset();
        switch (shape.getShapeType()) {
            case 227: {
                return MathPathBuilder.getMathPlusPath(shape, rect);
            }
            case 228: {
                return MathPathBuilder.getMathMinusPath(shape, rect);
            }
            case 229: {
                return MathPathBuilder.getMathMultiplyPath(shape, rect);
            }
            case 230: {
                return MathPathBuilder.getMathDividePath(shape, rect);
            }
            case 231: {
                return MathPathBuilder.getMathEqualPath(shape, rect);
            }
            case 232: {
                return MathPathBuilder.getMathNotEqualPath(shape, rect);
            }
        }
        return null;
    }

    private static Path getMathPlusPath(AutoShape shape, Rect rect) {
        float x = (float)Math.min(rect.width(), rect.height()) * 0.24f / 2.0f;
        Float[] values = shape.getAdjustData();
        if (values != null && values.length >= 1 && values[0] != null) {
            x = (float)Math.min(rect.width(), rect.height()) * values[0].floatValue() / 2.0f;
        }
        float left = (float)rect.left + (float)rect.width() / 8.0f;
        float right = (float)rect.right - (float)rect.width() / 8.0f;
        float top = (float)rect.top + (float)rect.height() / 8.0f;
        float bottom = (float)rect.bottom - (float)rect.height() / 8.0f;
        path.moveTo(left, rect.exactCenterY() - x);
        path.lineTo(rect.exactCenterX() - x, rect.exactCenterY() - x);
        path.lineTo(rect.exactCenterX() - x, top);
        path.lineTo(rect.exactCenterX() + x, top);
        path.lineTo(rect.exactCenterX() + x, rect.exactCenterY() - x);
        path.lineTo(right, rect.exactCenterY() - x);
        path.lineTo(right, rect.exactCenterY() + x);
        path.lineTo(rect.exactCenterX() + x, rect.exactCenterY() + x);
        path.lineTo(rect.exactCenterX() + x, bottom);
        path.lineTo(rect.exactCenterX() - x, bottom);
        path.lineTo(rect.exactCenterX() - x, rect.exactCenterY() + x);
        path.lineTo(left, rect.exactCenterY() + x);
        path.close();
        return path;
    }

    private static Path getMathMinusPath(AutoShape shape, Rect rect) {
        float x = (float)rect.height() * 0.24f / 2.0f;
        Float[] values = shape.getAdjustData();
        if (values != null && values.length >= 1 && values[0] != null) {
            x = (float)rect.height() * values[0].floatValue() / 2.0f;
        }
        float left = (float)rect.left + (float)rect.width() / 8.0f;
        float right = (float)rect.right - (float)rect.width() / 8.0f;
        float top = rect.exactCenterY() - x;
        float bottom = rect.exactCenterY() + x;
        path.addRect(left, top, right, bottom, Path.Direction.CW);
        return path;
    }

    private static Path getMathMultiplyPath(AutoShape shape, Rect rect) {
        float d = (float)rect.height() * 0.24f;
        Float[] values = shape.getAdjustData();
        if (values != null && values.length >= 1 && values[0] != null) {
            d = (float)rect.height() * values[0].floatValue();
        }
        float k = (float)rect.height() / (float)rect.width();
        float b = d * (float)Math.sqrt(k * k + 1.0f) / 2.0f;
        float c = (float)Math.sqrt(rect.width() * rect.width() + rect.height() * rect.height()) * (float)Math.sqrt(1.0f / (k * k) + 1.0f) / 4.0f;
        float x0 = (float)(rect.right + rect.left) / 2.0f;
        float y0 = rect.exactCenterY();
        float x1 = (c - b) / (k + 1.0f / k);
        float y1 = k * x1 + b;
        float x2 = (c + b) / (k + 1.0f / k);
        float y2 = k * x2 - b;
        path.moveTo(x0, y0 - b);
        path.lineTo(x0 + x1, y0 - y1);
        path.lineTo(x0 + x2, y0 - y2);
        path.lineTo(x0 + b / k, y0);
        path.lineTo(x0 + x2, y0 + y2);
        path.lineTo(x0 + x1, y0 + y1);
        path.lineTo(x0, y0 + b);
        path.lineTo(x0 - x1, y0 + y1);
        path.lineTo(x0 - x2, y0 + y2);
        path.lineTo(x0 - b / k, y0);
        path.lineTo(x0 - x2, y0 - y2);
        path.lineTo(x0 - x1, y0 - y1);
        path.close();
        return path;
    }

    private static Path getMathDividePath(AutoShape shape, Rect rect) {
        float x1 = (float)rect.height() * 0.2352f / 2.0f;
        float x2 = (float)rect.height() * 0.0588f;
        float r = (float)rect.height() * 0.1176f;
        Float[] values = shape.getAdjustData();
        if (values != null && values.length >= 3) {
            if (values[0] != null) {
                x1 = (float)rect.height() * values[0].floatValue() / 2.0f;
            }
            if (values[1] != null) {
                x2 = (float)rect.height() * values[1].floatValue();
            }
            if (values[2] != null) {
                r = (float)rect.height() * values[2].floatValue();
            }
        }
        path.addRect((float)rect.left + (float)rect.width() / 8.0f, rect.exactCenterY() - x1, (float)rect.right - (float)rect.width() / 8.0f, rect.exactCenterY() + x1, Path.Direction.CW);
        path.moveTo(rect.exactCenterX() + r, rect.exactCenterY() - x1 - x2 - r);
        path.addCircle(rect.exactCenterX(), rect.exactCenterY() - x1 - x2 - r, r, Path.Direction.CW);
        path.moveTo(rect.exactCenterX(), rect.exactCenterY() + x1 + x2 + r);
        path.addCircle(rect.exactCenterX(), rect.exactCenterY() + x1 + x2 + r, r, Path.Direction.CW);
        return path;
    }

    private static Path getMathEqualPath(AutoShape shape, Rect rect) {
        float x1 = (float)rect.height() * 0.2352f;
        float x2 = (float)rect.height() * 0.1176f / 2.0f;
        Float[] values = shape.getAdjustData();
        if (values != null && values.length >= 2) {
            if (values[0] != null) {
                x1 = (float)rect.height() * values[0].floatValue();
            }
            if (values[1] != null) {
                x2 = (float)rect.height() * values[1].floatValue() / 2.0f;
            }
        }
        path.reset();
        path.addRect((float)rect.left + (float)rect.width() / 8.0f, rect.exactCenterY() - x2 - x1, (float)rect.right - (float)rect.width() / 8.0f, rect.exactCenterY() - x2, Path.Direction.CW);
        path.moveTo((float)rect.left + (float)rect.width() / 8.0f, rect.exactCenterY() + x2);
        path.addRect((float)rect.left + (float)rect.width() / 8.0f, rect.exactCenterY() + x2, (float)rect.right - (float)rect.width() / 8.0f, rect.exactCenterY() + x2 + x1, Path.Direction.CW);
        return path;
    }

    private static Path getMathNotEqualPath(AutoShape shape, Rect rect) {
        float d1 = (float)rect.height() * 0.2352f;
        float angle = 110.0f;
        float d2 = (float)rect.height() * 0.1176f / 2.0f;
        Float[] values = shape.getAdjustData();
        if (values != null && values.length >= 3) {
            if (values[0] != null) {
                d1 = (float)rect.height() * values[0].floatValue();
            }
            if (values[1] != null) {
                angle = values[1].floatValue() * 10.0f / 6.0f;
            }
            if (values[2] != null) {
                d2 = (float)rect.height() * values[2].floatValue() / 2.0f;
            }
        }
        float k = -((float)Math.tan(Math.toRadians(angle)));
        float b = d1 * (float)Math.sqrt(k * k + 1.0f) / 2.0f;
        float c = (float)rect.height() / 2.0f - (b - (float)rect.height() / 2.0f) / (k * k);
        float x0 = rect.exactCenterX();
        float y0 = rect.exactCenterY();
        float x1 = ((float)rect.height() / 2.0f - b) / k;
        float y1 = (float)rect.height() / 2.0f;
        float x2 = (b + c) / (k + 1.0f / k);
        float y2 = k * x2 - b;
        float y3 = d2 + d1;
        float x3 = (y3 - b) / k;
        float y4 = y3;
        float x4 = (y4 + b) / k;
        float y5 = d2;
        float x5 = (d2 - b) / k;
        float y6 = y5;
        float x6 = (y6 + b) / k;
        path.reset();
        path.moveTo((float)rect.left + (float)rect.width() / 8.0f, rect.exactCenterY() - d2 - d1);
        if (k >= 0.0f) {
            path.lineTo(x0 + x3, y0 - y3);
            path.lineTo(x0 + x1, y0 - y1);
            path.lineTo(x0 + x2, y0 - y2);
            path.lineTo(x0 + x4, y0 - y4);
            path.lineTo((float)rect.right - (float)rect.width() / 8.0f, rect.exactCenterY() - d2 - d1);
            path.lineTo((float)rect.right - (float)rect.width() / 8.0f, rect.exactCenterY() - d2);
            path.lineTo(x0 + x6, y0 - y6);
            path.lineTo(x0 - x5, y0 + y5);
            path.lineTo((float)rect.right - (float)rect.width() / 8.0f, rect.exactCenterY() + d2);
            path.lineTo((float)rect.right - (float)rect.width() / 8.0f, rect.exactCenterY() + d2 + d1);
            path.lineTo(x0 - x3, y0 + y3);
            path.lineTo(x0 - x1, y0 + y1);
            path.lineTo(x0 - x2, y0 + y2);
            path.lineTo(x0 - x4, y0 + y4);
            path.lineTo((float)rect.left + (float)rect.width() / 8.0f, rect.exactCenterY() + d2 + d1);
            path.lineTo((float)rect.left + (float)rect.width() / 8.0f, rect.exactCenterY() + d2);
            path.lineTo(x0 - x6, y0 + y6);
            path.lineTo(x0 + x5, y0 - y5);
        } else {
            path.lineTo(x0 + x4, y0 - y4);
            path.lineTo(x0 + x2, y0 - y2);
            path.lineTo(x0 + x1, y0 - y1);
            path.lineTo(x0 + x3, y0 - y3);
            path.lineTo((float)rect.right - (float)rect.width() / 8.0f, rect.exactCenterY() - d2 - d1);
            path.lineTo((float)rect.right - (float)rect.width() / 8.0f, rect.exactCenterY() - d2);
            path.lineTo(x0 + x5, y0 - y5);
            path.lineTo(x0 - x6, y0 + y6);
            path.lineTo((float)rect.right - (float)rect.width() / 8.0f, rect.exactCenterY() + d2);
            path.lineTo((float)rect.right - (float)rect.width() / 8.0f, rect.exactCenterY() + d2 + d1);
            path.lineTo(x0 - x4, y0 + y4);
            path.lineTo(x0 - x2, y0 + y2);
            path.lineTo(x0 - x1, y0 + y1);
            path.lineTo(x0 - x3, y0 + y3);
            path.lineTo((float)rect.left + (float)rect.width() / 8.0f, rect.exactCenterY() + d2 + d1);
            path.lineTo((float)rect.left + (float)rect.width() / 8.0f, rect.exactCenterY() + d2);
            path.lineTo(x0 - x5, y0 + y5);
            path.lineTo(x0 + x6, y0 - y6);
        }
        path.lineTo((float)rect.left + (float)rect.width() / 8.0f, rect.exactCenterY() - d2);
        path.close();
        return path;
    }
}

