/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.common.autoshape.pathbuilder.line;

import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.Rect;
import com.ahmadullahpk.alldocumentreader.xs.common.autoshape.ExtendPath;
import com.ahmadullahpk.alldocumentreader.xs.common.autoshape.pathbuilder.ArrowPathAndTail;
import com.ahmadullahpk.alldocumentreader.xs.common.autoshape.pathbuilder.LineArrowPathBuilder;
import com.ahmadullahpk.alldocumentreader.xs.common.bg.BackgroundAndFill;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.LineShape;
import java.util.ArrayList;
import java.util.List;

public class LinePathBuilder {
    private static List<ExtendPath> paths = new ArrayList<ExtendPath>();

    public static List<ExtendPath> getLinePath(LineShape shape, Rect rect, float zoom) {
        paths.clear();
        switch (shape.getShapeType()) {
            case 20: 
            case 32: {
                return LinePathBuilder.getStraightConnectorPath(shape, rect, zoom);
            }
            case 33: {
                return LinePathBuilder.getBentConnectorPath2(shape, rect, zoom);
            }
            case 34: {
                return LinePathBuilder.getBentConnectorPath3(shape, rect, zoom);
            }
            case 37: {
                return LinePathBuilder.getCurvedConnector2Path(shape, rect, zoom);
            }
            case 38: {
                return LinePathBuilder.getCurvedConnector3Path(shape, rect, zoom);
            }
            case 39: {
                return LinePathBuilder.getCurvedConnector4Path(shape, rect, zoom);
            }
            case 40: {
                return LinePathBuilder.getCurvedConnector4Path(shape, rect, zoom);
            }
        }
        return null;
    }

    private static List<ExtendPath> getStraightConnectorPath(LineShape shape, Rect rect, float zoom) {
        int arrowLength;
        ExtendPath extendPath = new ExtendPath();
        Path path = new Path();
        int x0 = rect.left;
        int y0 = rect.top;
        int x1 = rect.right;
        int y1 = rect.bottom;
        double lineLength = Math.sqrt(rect.width() * rect.width() + rect.height() * rect.height());
        if (shape.getStartArrowhead() && (shape.getStartArrow().getType() == 1 || shape.getStartArrow().getType() == 2)) {
            arrowLength = LineArrowPathBuilder.getArrowLength(shape.getStartArrow(), shape.getLine().getLineWidth());
            if (Math.abs(x1 - x0) >= 1) {
                x0 = (int)((double)x0 + (double)((float)arrowLength * zoom) / lineLength * (double)(x1 - x0) * 0.75);
            }
            if (Math.abs(y1 - y0) >= 1) {
                y0 = (int)((double)y0 + (double)((float)arrowLength * zoom) / lineLength * (double)(y1 - y0) * 0.75);
            }
        }
        if (shape.getEndArrowhead() && (shape.getEndArrow().getType() == 1 || shape.getEndArrow().getType() == 2)) {
            arrowLength = LineArrowPathBuilder.getArrowLength(shape.getEndArrow(), shape.getLine().getLineWidth());
            if (Math.abs(x1 - x0) >= 1) {
                x1 = (int)((double)x1 + (double)((float)arrowLength * zoom) / lineLength * (double)(x0 - x1) * 0.75);
            }
            if (Math.abs(y1 - y0) >= 1) {
                y1 = (int)((double)y1 + (double)((float)arrowLength * zoom) / lineLength * (double)(y0 - y1) * 0.75);
            }
        }
        path.moveTo((float)x0, (float)y0);
        path.lineTo((float)x1, (float)y1);
        BackgroundAndFill bgFill = shape.getBackgroundAndFill();
        if (bgFill == null) {
            bgFill = shape.getLine().getBackgroundAndFill();
        }
        extendPath.setBackgroundAndFill(bgFill);
        extendPath.setLine(shape.getLine());
        extendPath.setPath(path);
        paths.add(extendPath);
        if (shape.getEndArrowhead()) {
            extendPath = new ExtendPath();
            extendPath.setArrowFlag(true);
            path = LineArrowPathBuilder.getDirectLineArrowPath(rect.left, rect.top, rect.right, rect.bottom, shape.getEndArrow(), shape.getLine().getLineWidth(), zoom).getArrowPath();
            extendPath.setPath(path);
            if (shape.getEndArrow().getType() != 5) {
                extendPath.setBackgroundAndFill(bgFill);
            } else {
                extendPath.setLine(shape.getLine());
            }
            paths.add(extendPath);
        }
        if (shape.getStartArrowhead()) {
            extendPath = new ExtendPath();
            extendPath.setArrowFlag(true);
            path = LineArrowPathBuilder.getDirectLineArrowPath(rect.right, rect.bottom, rect.left, rect.top, shape.getStartArrow(), shape.getLine().getLineWidth(), zoom).getArrowPath();
            extendPath.setPath(path);
            if (shape.getStartArrow().getType() != 5) {
                extendPath.setBackgroundAndFill(bgFill);
            } else {
                extendPath.setLine(shape.getLine());
            }
            paths.add(extendPath);
        }
        return paths;
    }

    private static List<ExtendPath> getBentConnectorPath2(LineShape shape, Rect rect, float zoom) {
        int length;
        float x = (float)rect.width() * 0.5f;
        Float[] values = shape.getAdjustData();
        if (values != null && values.length >= 1 && values[0] != null) {
            x = (float)rect.width() * values[0].floatValue();
        }
        ExtendPath extendPath = new ExtendPath();
        Path path = new Path();
        int x0 = rect.left;
        int y0 = rect.top;
        int x1 = rect.right;
        int y1 = rect.bottom;
        if (shape.getStartArrowhead() && (shape.getStartArrow().getType() == 1 || shape.getStartArrow().getType() == 2)) {
            length = LineArrowPathBuilder.getArrowLength(shape.getStartArrow(), shape.getLine().getLineWidth());
            x0 = (int)((double)x0 + Math.ceil((float)length * zoom / (float)Math.abs(x1 - x0) * (float)(x1 - x0) * 0.75f));
        }
        if (shape.getEndArrowhead() && (shape.getEndArrow().getType() == 1 || shape.getEndArrow().getType() == 2)) {
            length = LineArrowPathBuilder.getArrowLength(shape.getEndArrow(), shape.getLine().getLineWidth());
            y1 = (int)((double)y1 + Math.ceil((float)length * zoom / (float)Math.abs(y1 - y0) * (float)(y0 - y1) * 0.75f));
        }
        path.moveTo((float)x0, (float)y0);
        path.lineTo((float)rect.right, (float)rect.top);
        path.lineTo((float)x1, (float)y1);
        BackgroundAndFill bgFill = shape.getBackgroundAndFill();
        if (bgFill == null) {
            bgFill = shape.getLine().getBackgroundAndFill();
        }
        extendPath.setPath(path);
        extendPath.setLine(shape.getLine());
        paths.add(extendPath);
        if (shape.getEndArrowhead()) {
            extendPath = new ExtendPath();
            extendPath.setArrowFlag(true);
            path = LineArrowPathBuilder.getDirectLineArrowPath(rect.right, y1, rect.right, rect.bottom, shape.getEndArrow(), shape.getLine().getLineWidth(), zoom).getArrowPath();
            extendPath.setPath(path);
            if (shape.getEndArrow().getType() != 5) {
                extendPath.setBackgroundAndFill(bgFill);
            } else {
                extendPath.setLine(shape.getLine());
            }
            paths.add(extendPath);
        }
        if (shape.getStartArrowhead()) {
            extendPath = new ExtendPath();
            extendPath.setArrowFlag(true);
            path = LineArrowPathBuilder.getDirectLineArrowPath(x0, rect.top, rect.left, rect.top, shape.getStartArrow(), shape.getLine().getLineWidth(), zoom).getArrowPath();
            extendPath.setPath(path);
            if (shape.getStartArrow().getType() != 5) {
                extendPath.setBackgroundAndFill(bgFill);
            } else {
                extendPath.setLine(shape.getLine());
            }
            paths.add(extendPath);
        }
        return paths;
    }

    private static List<ExtendPath> getBentConnectorPath3(LineShape shape, Rect rect, float zoom) {
        int length;
        float x = (float)rect.width() * 0.5f;
        Float[] values = shape.getAdjustData();
        if (values != null && values.length >= 1 && values[0] != null) {
            x = (float)rect.width() * values[0].floatValue();
        }
        ExtendPath extendPath = new ExtendPath();
        Path path = new Path();
        int x0 = rect.left;
        int y0 = rect.top;
        int x1 = rect.right;
        int y1 = rect.bottom;
        if (shape.getStartArrowhead() && (shape.getStartArrow().getType() == 1 || shape.getStartArrow().getType() == 2)) {
            length = LineArrowPathBuilder.getArrowLength(shape.getStartArrow(), shape.getLine().getLineWidth());
            x0 = (int)((double)x0 + Math.ceil((float)length * zoom / (float)Math.abs(x1 - x0) * (float)(x1 - x0) * 0.75f));
        }
        if (shape.getEndArrowhead() && (shape.getEndArrow().getType() == 1 || shape.getEndArrow().getType() == 2)) {
            length = LineArrowPathBuilder.getArrowLength(shape.getEndArrow(), shape.getLine().getLineWidth());
            x1 = (int)((double)x1 + Math.ceil((float)length * zoom / (float)Math.abs(x1 - x0) * (float)(x0 - x1) * 0.75f));
        }
        path.moveTo((float)x0, (float)y0);
        path.lineTo((float)rect.left + x, (float)rect.top);
        path.lineTo((float)rect.left + x, (float)rect.bottom);
        path.lineTo((float)x1, (float)y1);
        BackgroundAndFill bgFill = shape.getBackgroundAndFill();
        if (bgFill == null) {
            bgFill = shape.getLine().getBackgroundAndFill();
        }
        extendPath.setPath(path);
        extendPath.setLine(shape.getLine());
        paths.add(extendPath);
        if (shape.getEndArrowhead()) {
            extendPath = new ExtendPath();
            extendPath.setArrowFlag(true);
            path = LineArrowPathBuilder.getDirectLineArrowPath((float)rect.left + x, rect.bottom, rect.right, rect.bottom, shape.getEndArrow(), shape.getLine().getLineWidth(), zoom).getArrowPath();
            extendPath.setPath(path);
            if (shape.getEndArrow().getType() != 5) {
                extendPath.setBackgroundAndFill(bgFill);
            } else {
                extendPath.setLine(shape.getLine());
            }
            paths.add(extendPath);
        }
        if (shape.getStartArrowhead()) {
            extendPath = new ExtendPath();
            extendPath.setArrowFlag(true);
            path = LineArrowPathBuilder.getDirectLineArrowPath((float)rect.left + x, rect.top, rect.left, rect.top, shape.getStartArrow(), shape.getLine().getLineWidth(), zoom).getArrowPath();
            extendPath.setPath(path);
            if (shape.getStartArrow().getType() != 5) {
                extendPath.setBackgroundAndFill(bgFill);
            } else {
                extendPath.setLine(shape.getLine());
            }
            paths.add(extendPath);
        }
        return paths;
    }

    private static List<ExtendPath> getCurvedConnector2Path(LineShape shape, Rect rect, float zoom) {
        ExtendPath extendPath = new ExtendPath();
        Path path = new Path();
        path.reset();
        path.moveTo((float)rect.left, (float)rect.top);
        path.quadTo((float)rect.right, (float)rect.top, (float)rect.right, (float)rect.bottom);
        BackgroundAndFill bgFill = shape.getBackgroundAndFill();
        if (bgFill == null) {
            bgFill = shape.getLine().getBackgroundAndFill();
        }
        extendPath.setPath(path);
        extendPath.setLine(shape.getLine());
        paths.add(extendPath);
        if (shape.getEndArrowhead()) {
            extendPath = new ExtendPath();
            extendPath.setArrowFlag(true);
            path = LineArrowPathBuilder.getQuadBezArrowPath(rect.left, rect.top, rect.right, rect.top, rect.right, rect.bottom, shape.getEndArrow(), shape.getLine().getLineWidth(), zoom).getArrowPath();
            extendPath.setPath(path);
            if (shape.getEndArrow().getType() != 5) {
                extendPath.setBackgroundAndFill(bgFill);
            } else {
                extendPath.setLine(shape.getLine());
            }
            paths.add(extendPath);
        }
        if (shape.getStartArrowhead()) {
            extendPath = new ExtendPath();
            extendPath.setArrowFlag(true);
            path = LineArrowPathBuilder.getQuadBezArrowPath(rect.right, rect.bottom, rect.right, rect.top, rect.left, rect.top, shape.getStartArrow(), shape.getLine().getLineWidth(), zoom).getArrowPath();
            extendPath.setPath(path);
            if (shape.getStartArrow().getType() != 5) {
                extendPath.setBackgroundAndFill(bgFill);
            } else {
                extendPath.setLine(shape.getLine());
            }
            paths.add(extendPath);
        }
        return paths;
    }

    private static List<ExtendPath> getCurvedConnector3Path(LineShape shape, Rect rect, float zoom) {
        byte arrowType;
        ArrowPathAndTail arrowPathAndTail;
        float x = (float)rect.width() * 0.5f;
        Float[] values = shape.getAdjustData();
        if (values != null && values.length >= 1 && values[0] != null) {
            x = (float)rect.width() * values[0].floatValue();
        }
        ExtendPath extendPath = null;
        BackgroundAndFill bgFill = shape.getBackgroundAndFill();
        if (bgFill == null) {
            bgFill = shape.getLine().getBackgroundAndFill();
        }
        PointF startArrowTailCenter = null;
        PointF endArrowTailCenter = null;
        if (shape.getEndArrowhead()) {
            extendPath = new ExtendPath();
            extendPath.setArrowFlag(true);
            arrowPathAndTail = LineArrowPathBuilder.getQuadBezArrowPath((float)rect.left + x, rect.exactCenterY(), (float)rect.left + x, rect.bottom, rect.right, rect.bottom, shape.getEndArrow(), shape.getLine().getLineWidth(), zoom);
            arrowType = shape.getEndArrow().getType();
            if (arrowType == 1 || arrowType == 2) {
                endArrowTailCenter = arrowPathAndTail.getArrowTailCenter();
            }
            extendPath.setPath(arrowPathAndTail.getArrowPath());
            if (arrowType != 5) {
                extendPath.setBackgroundAndFill(bgFill);
            } else {
                extendPath.setLine(shape.getLine());
            }
            paths.add(extendPath);
        }
        if (shape.getStartArrowhead()) {
            extendPath = new ExtendPath();
            extendPath.setArrowFlag(true);
            arrowPathAndTail = LineArrowPathBuilder.getQuadBezArrowPath((float)rect.left + x, rect.exactCenterY(), (float)rect.left + x, rect.top, rect.left, rect.top, shape.getStartArrow(), shape.getLine().getLineWidth(), zoom);
            arrowType = shape.getStartArrow().getType();
            if (arrowType == 1 || arrowType == 2) {
                startArrowTailCenter = arrowPathAndTail.getArrowTailCenter();
            }
            extendPath.setPath(arrowPathAndTail.getArrowPath());
            if (arrowType != 5) {
                extendPath.setBackgroundAndFill(bgFill);
            } else {
                extendPath.setLine(shape.getLine());
            }
            paths.add(extendPath);
        }
        extendPath = new ExtendPath();
        Path path = new Path();
        path.reset();
        if (startArrowTailCenter != null) {
            startArrowTailCenter = LineArrowPathBuilder.getReferencedPosition(rect.left, rect.top, startArrowTailCenter.x, startArrowTailCenter.y, shape.getStartArrow().getType());
            path.moveTo(startArrowTailCenter.x, startArrowTailCenter.y);
        } else {
            path.moveTo((float)rect.left, (float)rect.top);
        }
        path.quadTo((float)rect.left + x, (float)rect.top, (float)rect.left + x, rect.exactCenterY());
        path.moveTo((float)rect.left + x, rect.exactCenterY());
        if (endArrowTailCenter != null) {
            endArrowTailCenter = LineArrowPathBuilder.getReferencedPosition(rect.right, rect.bottom, endArrowTailCenter.x, endArrowTailCenter.y, shape.getEndArrow().getType());
            path.quadTo((float)rect.left + x, (float)rect.bottom, endArrowTailCenter.x, endArrowTailCenter.y);
        } else {
            path.quadTo((float)rect.left + x, (float)rect.bottom, (float)rect.right, (float)rect.bottom);
        }
        extendPath.setPath(path);
        extendPath.setLine(shape.getLine());
        paths.add(extendPath);
        return paths;
    }

    private static List<ExtendPath> getCurvedConnector4Path(LineShape shape, Rect rect, float zoom) {
        float x = (float)rect.width() * 0.5f;
        float y = (float)rect.height() * 0.5f;
        Float[] values = shape.getAdjustData();
        if (values != null && values.length >= 1) {
            if (values[0] != null) {
                x = (float)rect.width() * values[0].floatValue();
            }
            if (values[1] != null) {
                y = (float)rect.height() * values[1].floatValue();
            }
        }
        float x0 = (float)rect.left + x;
        float y0 = (float)rect.top + y / 2.0f;
        float x1 = (x0 + (float)rect.right) / 2.0f;
        float y1 = (float)rect.top + y;
        ExtendPath extendPath = new ExtendPath();
        Path path = new Path();
        path.reset();
        path.moveTo((float)rect.left, (float)rect.top);
        path.quadTo(x0, (float)rect.top, x0, y0);
        path.moveTo(x0, y0);
        path.quadTo(x0, y1, x1, y1);
        path.moveTo(x1, y1);
        path.quadTo((float)rect.right, y1, (float)rect.right, (float)rect.bottom);
        BackgroundAndFill bgFill = shape.getBackgroundAndFill();
        if (bgFill == null) {
            bgFill = shape.getLine().getBackgroundAndFill();
        }
        extendPath.setPath(path);
        extendPath.setLine(shape.getLine());
        paths.add(extendPath);
        if (shape.getEndArrowhead()) {
            extendPath = new ExtendPath();
            extendPath.setArrowFlag(true);
            path = LineArrowPathBuilder.getQuadBezArrowPath(x1, y1, rect.right, y1, rect.right, rect.bottom, shape.getEndArrow(), shape.getLine().getLineWidth(), zoom).getArrowPath();
            extendPath.setPath(path);
            if (shape.getEndArrow().getType() != 5) {
                extendPath.setBackgroundAndFill(bgFill);
            } else {
                extendPath.setLine(shape.getLine());
            }
            paths.add(extendPath);
        }
        if (shape.getStartArrowhead()) {
            extendPath = new ExtendPath();
            extendPath.setArrowFlag(true);
            path = LineArrowPathBuilder.getQuadBezArrowPath(x0, y0, x0, rect.top, rect.left, rect.top, shape.getStartArrow(), shape.getLine().getLineWidth(), zoom).getArrowPath();
            extendPath.setPath(path);
            if (shape.getStartArrow().getType() != 5) {
                extendPath.setBackgroundAndFill(bgFill);
            } else {
                extendPath.setLine(shape.getLine());
            }
            paths.add(extendPath);
        }
        return paths;
    }
}

