/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.common.autoshape.pathbuilder.arrow;

import android.graphics.Matrix;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.AutoShape;
import java.util.ArrayList;
import java.util.List;

public class LaterArrowPathBuilder {
    private static final float TODEGREE = 1.6666666f;
    private static RectF s_rect = new RectF();
    private static Path path = new Path();

    public static Object getArrowPath(AutoShape shape, Rect rect) {
        path.reset();
        switch (shape.getShapeType()) {
            case 13: {
                return LaterArrowPathBuilder.getRightArrowPath(shape, rect);
            }
            case 66: {
                return LaterArrowPathBuilder.getLeftArrowPath(shape, rect);
            }
            case 68: {
                return LaterArrowPathBuilder.getUpArrowPath(shape, rect);
            }
            case 67: {
                return LaterArrowPathBuilder.getDownArrowPath(shape, rect);
            }
            case 69: {
                return LaterArrowPathBuilder.getLeftRightArrowPath(shape, rect);
            }
            case 70: {
                return LaterArrowPathBuilder.getUpDownArrowPath(shape, rect);
            }
            case 76: {
                return LaterArrowPathBuilder.getQuadArrowPath(shape, rect);
            }
            case 182: {
                return LaterArrowPathBuilder.getLeftRightUpArrowPath(shape, rect);
            }
            case 91: {
                return LaterArrowPathBuilder.getBentArrowPath(shape, rect);
            }
            case 101: {
                return LaterArrowPathBuilder.getUturnArrowPath(shape, rect);
            }
            case 89: {
                return LaterArrowPathBuilder.getLeftUpArrowPath(shape, rect);
            }
            case 90: {
                return LaterArrowPathBuilder.getBentUpArrowPath(shape, rect);
            }
            case 102: {
                return LaterArrowPathBuilder.getCurvedRightArrowPath(shape, rect);
            }
            case 103: {
                return LaterArrowPathBuilder.getCurvedLeftArrowPath(shape, rect);
            }
            case 104: {
                return LaterArrowPathBuilder.getCurvedUpArrowPath(shape, rect);
            }
            case 105: {
                return LaterArrowPathBuilder.getCurvedDownArrowPath(shape, rect);
            }
            case 93: {
                return LaterArrowPathBuilder.getStripedRightArrowPath(shape, rect);
            }
            case 94: {
                return LaterArrowPathBuilder.getNotchedRightArrowPath(shape, rect);
            }
            case 15: {
                return LaterArrowPathBuilder.getHomePlatePath(shape, rect);
            }
            case 55: {
                return LaterArrowPathBuilder.getChevronPath(shape, rect);
            }
            case 78: {
                return LaterArrowPathBuilder.getRightArrowCalloutPath(shape, rect);
            }
            case 77: {
                return LaterArrowPathBuilder.getLeftArrowCalloutPath(shape, rect);
            }
            case 79: {
                return LaterArrowPathBuilder.getUpArrowCalloutPath(shape, rect);
            }
            case 80: {
                return LaterArrowPathBuilder.getDownArrowCalloutPath(shape, rect);
            }
            case 81: {
                return LaterArrowPathBuilder.getLeftRightArrowCalloutPath(shape, rect);
            }
            case 83: {
                return LaterArrowPathBuilder.getQuadArrowCalloutPath(shape, rect);
            }
            case 99: {
                return LaterArrowPathBuilder.getCircularArrowPath(shape, rect);
            }
        }
        return new Path();
    }

    private static Path getRightArrowPath(AutoShape shape, Rect rect) {
        Float[] values = shape.getAdjustData();
        int adj1 = 0;
        int adj2 = 0;
        int len1 = rect.height() / 2;
        int len2 = Math.min(rect.width(), rect.height());
        if (values != null && values.length == 2) {
            adj1 = Math.round((float)len1 * values[0].floatValue());
            adj2 = Math.round((float)len2 * values[1].floatValue());
        } else {
            adj1 = Math.round((float)len1 * 0.5f);
            adj2 = Math.round((float)len2 * 0.5f);
        }
        path.moveTo((float)rect.left, (float)(rect.centerY() - adj1));
        path.lineTo((float)(rect.right - adj2), (float)(rect.centerY() - adj1));
        path.lineTo((float)(rect.right - adj2), (float)rect.top);
        path.lineTo((float)rect.right, (float)rect.centerY());
        path.lineTo((float)(rect.right - adj2), (float)rect.bottom);
        path.lineTo((float)(rect.right - adj2), (float)(rect.centerY() + adj1));
        path.lineTo((float)rect.left, (float)(rect.centerY() + adj1));
        path.close();
        return path;
    }

    private static Path getLeftArrowPath(AutoShape shape, Rect rect) {
        Float[] values = shape.getAdjustData();
        int adj1 = 0;
        int adj2 = 0;
        int len1 = rect.height() / 2;
        int len2 = Math.min(rect.width(), rect.height());
        if (values != null && values.length == 2) {
            adj1 = Math.round((float)len1 * values[0].floatValue());
            adj2 = Math.round((float)len2 * values[1].floatValue());
        } else {
            adj1 = Math.round((float)len1 * 0.5f);
            adj2 = Math.round((float)len2 * 0.5f);
        }
        path.moveTo((float)rect.left, (float)rect.centerY());
        path.lineTo((float)(rect.left + adj2), (float)rect.top);
        path.lineTo((float)(rect.left + adj2), (float)(rect.centerY() - adj1));
        path.lineTo((float)rect.right, (float)(rect.centerY() - adj1));
        path.lineTo((float)rect.right, (float)(rect.centerY() + adj1));
        path.lineTo((float)(rect.left + adj2), (float)(rect.centerY() + adj1));
        path.lineTo((float)(rect.left + adj2), (float)rect.bottom);
        path.close();
        return path;
    }

    private static Path getUpArrowPath(AutoShape shape, Rect rect) {
        Float[] values = shape.getAdjustData();
        int adj1 = 0;
        int adj2 = 0;
        int len1 = rect.width() / 2;
        int len2 = Math.min(rect.width(), rect.height());
        if (values != null && values.length == 2) {
            adj1 = Math.round((float)len1 * values[0].floatValue());
            adj2 = Math.round((float)len2 * values[1].floatValue());
        } else {
            adj1 = Math.round((float)len1 * 0.5f);
            adj2 = Math.round((float)len2 * 0.5f);
        }
        path.moveTo((float)rect.centerX(), (float)rect.top);
        path.lineTo((float)rect.right, (float)(rect.top + adj2));
        path.lineTo((float)(rect.centerX() + adj1), (float)(rect.top + adj2));
        path.lineTo((float)(rect.centerX() + adj1), (float)rect.bottom);
        path.lineTo((float)(rect.centerX() - adj1), (float)rect.bottom);
        path.lineTo((float)(rect.centerX() - adj1), (float)(rect.top + adj2));
        path.lineTo((float)rect.left, (float)(rect.top + adj2));
        path.close();
        return path;
    }

    private static Path getDownArrowPath(AutoShape shape, Rect rect) {
        Float[] values = shape.getAdjustData();
        int adj1 = 0;
        int adj2 = 0;
        int len1 = rect.width() / 2;
        int len2 = Math.min(rect.width(), rect.height());
        if (values != null && values.length == 2) {
            adj1 = Math.round((float)len1 * values[0].floatValue());
            adj2 = Math.round((float)len2 * values[1].floatValue());
        } else {
            adj1 = Math.round((float)len1 * 0.5f);
            adj2 = Math.round((float)len2 * 0.5f);
        }
        path.moveTo((float)(rect.centerX() - adj1), (float)rect.top);
        path.lineTo((float)(rect.centerX() + adj1), (float)rect.top);
        path.lineTo((float)(rect.centerX() + adj1), (float)(rect.bottom - adj2));
        path.lineTo((float)rect.right, (float)(rect.bottom - adj2));
        path.lineTo((float)rect.centerX(), (float)rect.bottom);
        path.lineTo((float)rect.left, (float)(rect.bottom - adj2));
        path.lineTo((float)(rect.centerX() - adj1), (float)(rect.bottom - adj2));
        path.close();
        return path;
    }

    private static Path getLeftRightArrowPath(AutoShape shape, Rect rect) {
        Float[] values = shape.getAdjustData();
        int adj1 = 0;
        int adj2 = 0;
        int len1 = rect.height() / 2;
        int len2 = Math.min(rect.width(), rect.height());
        if (values != null && values.length == 2) {
            adj1 = Math.round((float)len1 * values[0].floatValue());
            adj2 = Math.round((float)len2 * values[1].floatValue());
            if (adj2 * 2 > rect.width()) {
                adj2 = len2 * 2;
            }
        } else {
            adj1 = Math.round((float)len1 * 0.5f);
            adj2 = Math.round((float)len2 * 0.5f);
        }
        path.moveTo((float)rect.left, (float)rect.centerY());
        path.lineTo((float)(rect.left + adj2), (float)rect.top);
        path.lineTo((float)(rect.left + adj2), (float)(rect.centerY() - adj1));
        path.lineTo((float)(rect.right - adj2), (float)(rect.centerY() - adj1));
        path.lineTo((float)(rect.right - adj2), (float)rect.top);
        path.lineTo((float)rect.right, (float)rect.centerY());
        path.lineTo((float)(rect.right - adj2), (float)rect.bottom);
        path.lineTo((float)(rect.right - adj2), (float)(rect.centerY() + adj1));
        path.lineTo((float)(rect.left + adj2), (float)(rect.centerY() + adj1));
        path.lineTo((float)(rect.left + adj2), (float)rect.bottom);
        path.close();
        return path;
    }

    private static Path getUpDownArrowPath(AutoShape shape, Rect rect) {
        Float[] values = shape.getAdjustData();
        int adj1 = 0;
        int adj2 = 0;
        int len1 = rect.width() / 2;
        int len2 = Math.min(rect.width(), rect.height());
        if (values != null && values.length == 2) {
            adj1 = Math.round((float)len1 * values[0].floatValue());
            adj2 = Math.round((float)len2 * values[1].floatValue());
            if (adj2 * 2 > rect.height()) {
                adj2 = len2 * 2;
            }
        } else {
            adj1 = Math.round((float)len1 * 0.5f);
            adj2 = Math.round((float)len2 * 0.5f);
        }
        path.moveTo((float)rect.centerX(), (float)rect.top);
        path.lineTo((float)rect.right, (float)(rect.top + adj2));
        path.lineTo((float)(rect.centerX() + adj1), (float)(rect.top + adj2));
        path.lineTo((float)(rect.centerX() + adj1), (float)(rect.bottom - adj2));
        path.lineTo((float)rect.right, (float)(rect.bottom - adj2));
        path.lineTo(rect.exactCenterX(), (float)rect.bottom);
        path.lineTo((float)rect.left, (float)(rect.bottom - adj2));
        path.lineTo((float)(rect.centerX() - adj1), (float)(rect.bottom - adj2));
        path.lineTo((float)(rect.centerX() - adj1), (float)(rect.top + adj2));
        path.lineTo((float)rect.left, (float)(rect.top + adj2));
        path.close();
        return path;
    }

    private static Path getQuadArrowPath(AutoShape shape, Rect rect) {
        Float[] values = shape.getAdjustData();
        int adj1 = 0;
        int adj2 = 0;
        int adj3 = 0;
        int len1 = Math.min(rect.width(), rect.height()) / 2;
        int len2 = Math.min(rect.width(), rect.height());
        if (values != null && values.length == 3) {
            adj1 = Math.round((float)len1 * values[0].floatValue());
            adj2 = Math.round((float)len2 * values[1].floatValue());
            adj3 = Math.round((float)len2 * values[2].floatValue());
            if (adj1 > adj2) {
                adj1 = adj2;
            }
            if (adj2 + adj3 > len2 / 2) {
                adj3 = len2 / 2 - adj2;
            }
        } else {
            adj1 = Math.round((float)len1 * 0.225f);
            adj2 = Math.round((float)len2 * 0.225f);
            adj3 = Math.round((float)len2 * 0.225f);
        }
        path.moveTo((float)rect.left, (float)rect.centerY());
        path.lineTo((float)(rect.left + adj3), (float)(rect.centerY() - adj2));
        path.lineTo((float)(rect.left + adj3), (float)(rect.centerY() - adj1));
        path.lineTo((float)(rect.centerX() - adj1), (float)(rect.centerY() - adj1));
        path.lineTo((float)(rect.centerX() - adj1), (float)(rect.top + adj3));
        path.lineTo((float)(rect.centerX() - adj2), (float)(rect.top + adj3));
        path.lineTo((float)rect.centerX(), (float)rect.top);
        path.lineTo((float)(rect.centerX() + adj2), (float)(rect.top + adj3));
        path.lineTo((float)(rect.centerX() + adj1), (float)(rect.top + adj3));
        path.lineTo((float)(rect.centerX() + adj1), (float)(rect.centerY() - adj1));
        path.lineTo((float)(rect.right - adj3), (float)(rect.centerY() - adj1));
        path.lineTo((float)(rect.right - adj3), (float)(rect.centerY() - adj2));
        path.lineTo((float)rect.right, (float)rect.centerY());
        path.lineTo((float)(rect.right - adj3), (float)(rect.centerY() + adj2));
        path.lineTo((float)(rect.right - adj3), (float)(rect.centerY() + adj1));
        path.lineTo((float)(rect.centerX() + adj1), (float)(rect.centerY() + adj1));
        path.lineTo((float)(rect.centerX() + adj1), (float)(rect.bottom - adj3));
        path.lineTo((float)(rect.centerX() + adj2), (float)(rect.bottom - adj3));
        path.lineTo((float)rect.centerX(), (float)rect.bottom);
        path.lineTo((float)(rect.centerX() - adj2), (float)(rect.bottom - adj3));
        path.lineTo((float)(rect.centerX() - adj1), (float)(rect.bottom - adj3));
        path.lineTo((float)(rect.centerX() - adj1), (float)(rect.centerY() + adj1));
        path.lineTo((float)(rect.left + adj3), (float)(rect.centerY() + adj1));
        path.lineTo((float)(rect.left + adj3), (float)(rect.centerY() + adj2));
        path.close();
        return path;
    }

    private static Path getLeftRightUpArrowPath(AutoShape shape, Rect rect) {
        Float[] values = shape.getAdjustData();
        int adj1 = 0;
        int adj2 = 0;
        int adj3 = 0;
        int len = Math.min(rect.width(), rect.height());
        if (values != null && values.length == 3) {
            adj1 = Math.round((float)len * values[0].floatValue() / 2.0f);
            adj2 = Math.round((float)len * values[1].floatValue());
            adj3 = Math.round((float)len * values[2].floatValue());
            if (adj1 > adj2) {
                adj1 = adj2;
            }
            if (adj2 + adj3 > rect.width()) {
                adj3 = len / 2 - adj2;
            }
            if (adj2 * 2 + adj3 > rect.height()) {
                adj3 = rect.height() - adj2 * 2;
            }
        } else {
            adj1 = Math.round((float)len * 0.225f / 2.0f);
            adj2 = Math.round((float)len * 0.225f);
            adj3 = Math.round((float)len * 0.225f);
        }
        path.moveTo((float)(rect.left + adj3), (float)(rect.bottom - adj2 + adj1));
        path.lineTo((float)(rect.left + adj3), (float)rect.bottom);
        path.lineTo((float)rect.left, (float)(rect.bottom - adj2));
        path.lineTo((float)(rect.left + adj3), (float)(rect.bottom - adj2 * 2));
        path.lineTo((float)(rect.left + adj3), (float)(rect.bottom - adj2 - adj1));
        path.lineTo((float)(rect.centerX() - adj1), (float)(rect.bottom - adj2 - adj1));
        path.lineTo((float)(rect.centerX() - adj1), (float)(rect.top + adj3));
        path.lineTo((float)(rect.centerX() - adj2), (float)(rect.top + adj3));
        path.lineTo((float)rect.centerX(), (float)rect.top);
        path.lineTo((float)(rect.centerX() + adj2), (float)(rect.top + adj3));
        path.lineTo((float)(rect.centerX() + adj1), (float)(rect.top + adj3));
        path.lineTo((float)(rect.centerX() + adj1), (float)(rect.bottom - adj2 - adj1));
        path.lineTo((float)(rect.right - adj3), (float)(rect.bottom - adj2 - adj1));
        path.lineTo((float)(rect.right - adj3), (float)(rect.bottom - adj2 * 2));
        path.lineTo((float)rect.right, (float)(rect.bottom - adj2));
        path.lineTo((float)(rect.right - adj3), (float)rect.bottom);
        path.lineTo((float)(rect.right - adj3), (float)(rect.bottom - adj2 + adj1));
        path.close();
        return path;
    }

    private static Path getBentArrowPath(AutoShape shape, Rect rect) {
        Float[] values = shape.getAdjustData();
        int adj1 = 0;
        int adj2 = 0;
        int adj3 = 0;
        int adj4 = 0;
        int len = Math.min(rect.width(), rect.height());
        if (values != null && values.length == 4) {
            adj1 = Math.round((float)len * values[0].floatValue());
            adj2 = Math.round((float)len * values[1].floatValue());
            adj3 = Math.round((float)len * values[2].floatValue());
            adj4 = Math.round((float)len * values[3].floatValue());
            if (adj1 > adj2 * 2) {
                adj1 = adj2 * 2;
            }
            if (adj3 + adj4 > rect.width()) {
                adj4 = rect.width() - adj3;
            }
            if (adj4 > rect.height()) {
                adj4 = rect.height();
            }
        } else {
            adj1 = Math.round((float)len * 0.25f);
            adj2 = Math.round((float)len * 0.25f);
            adj3 = Math.round((float)len * 0.25f);
            adj4 = Math.round((float)len * 0.4375f);
        }
        path.moveTo((float)rect.left, (float)rect.bottom);
        path.lineTo((float)rect.left, (float)(rect.top + adj2 - adj1 / 2 + adj4));
        s_rect.set((float)rect.left, (float)(rect.top + adj2 - adj1 / 2), (float)(rect.left + 2 * adj4), (float)(rect.top + adj2 - adj1 / 2 + 2 * adj4));
        path.arcTo(s_rect, 180.0f, 90.0f);
        path.lineTo((float)(rect.right - adj3), (float)(rect.top + adj2 - adj1 / 2));
        path.lineTo((float)(rect.right - adj3), (float)rect.top);
        path.lineTo((float)rect.right, (float)(rect.top + adj2));
        path.lineTo((float)(rect.right - adj3), (float)(rect.top + adj2 * 2));
        path.lineTo((float)(rect.right - adj3), (float)(rect.top + adj2 + adj1 / 2));
        if (adj4 >= adj1) {
            path.lineTo((float)(rect.left + adj4), (float)(rect.top + adj2 + adj1 / 2));
            s_rect.set((float)(rect.left + adj1), (float)(rect.top + adj2 + adj1 / 2), (float)(rect.left + 2 * (adj4 - adj1)), (float)(rect.top + adj2 + adj1 / 2 + 2 * (adj4 - adj1)));
            path.arcTo(s_rect, 270.0f, -90.0f);
            path.lineTo((float)(rect.left + adj1), (float)(rect.top + adj2 - adj1 / 2 + adj4));
        } else {
            path.lineTo((float)(rect.left + adj1), (float)(rect.top + adj2 + adj1 / 2));
        }
        path.lineTo((float)(rect.left + adj1), (float)rect.bottom);
        path.close();
        return path;
    }

    private static Path getUturnArrowPath(AutoShape shape, Rect rect) {
        Float[] values = shape.getAdjustData();
        int adj1 = 0;
        int adj2 = 0;
        int adj3 = 0;
        int adj4 = 0;
        int adj5 = 0;
        int len = Math.min(rect.width(), rect.height());
        if (values != null && values.length == 5) {
            adj1 = Math.round((float)len * values[0].floatValue());
            adj2 = Math.round((float)len * values[1].floatValue());
            adj3 = Math.round((float)len * values[2].floatValue());
            adj4 = Math.round((float)len * values[3].floatValue());
            adj5 = Math.round((float)rect.height() * values[4].floatValue());
            if (adj1 > adj2 * 2) {
                adj1 = adj2 * 2;
            }
            if (adj4 + adj3 >= adj5) {
                adj5 = adj3 + adj4;
            }
            if (adj5 > rect.height()) {
                adj5 = rect.height();
                adj3 = adj5 - adj4;
            }
            if (adj5 - adj3 < adj1) {
                adj3 = adj5 - adj1;
            }
        } else {
            adj1 = Math.round((float)len * 0.25f);
            adj2 = Math.round((float)len * 0.25f);
            adj3 = Math.round((float)len * 0.25f);
            adj4 = Math.round((float)len * 0.4375f);
            adj5 = Math.round((float)rect.height() * 0.75f);
        }
        path.moveTo((float)rect.left, (float)rect.bottom);
        path.lineTo((float)rect.left, (float)(rect.top + adj4));
        s_rect.set((float)rect.left, (float)rect.top, (float)(rect.left + 2 * adj4), (float)(rect.top + 2 * adj4));
        path.arcTo(s_rect, 180.0f, 90.0f);
        path.lineTo((float)(rect.right - adj2 + adj1 / 2 - adj4), (float)rect.top);
        s_rect.set((float)(rect.right - adj2 + adj1 / 2 - 2 * adj4), (float)rect.top, (float)(rect.right - adj2 + adj1 / 2), (float)(rect.top + 2 * adj4));
        path.arcTo(s_rect, 270.0f, 90.0f);
        path.lineTo((float)(rect.right - adj2 + adj1 / 2), (float)(rect.top + adj5 - adj3));
        path.lineTo((float)rect.right, (float)(rect.top + adj5 - adj3));
        path.lineTo((float)(rect.right - adj2), (float)(rect.top + adj5));
        path.lineTo((float)(rect.right - adj2 * 2), (float)(rect.top + adj5 - adj3));
        path.lineTo((float)(rect.right - adj2 - adj1 / 2), (float)(rect.top + adj5 - adj3));
        if (adj4 >= adj1) {
            path.lineTo((float)(rect.right - adj2 - adj1 / 2), (float)(rect.top + adj4));
            s_rect.set((float)(rect.right - adj2 - adj1 / 2 - 2 * (adj4 - adj1)), (float)(rect.top + adj1), (float)(rect.right - adj2 - adj1 / 2), (float)(rect.top + adj1 + 2 * (adj4 - adj1)));
            path.arcTo(s_rect, 0.0f, -90.0f);
            path.lineTo((float)(rect.right - adj2 + adj1 / 2 - adj4), (float)(rect.top + adj1));
            path.lineTo((float)(rect.left + adj4), (float)(rect.top + adj1));
            s_rect.set((float)(rect.left + adj1), (float)(rect.top + adj1), (float)(rect.left + adj1 + 2 * (adj4 - adj1)), (float)(rect.top + adj1 + 2 * (adj4 - adj1)));
            path.arcTo(s_rect, 270.0f, -90.0f);
            path.lineTo((float)(rect.left + adj1), (float)(rect.top + adj4));
        } else {
            path.lineTo((float)(rect.right - adj2 - adj1 / 2), (float)(rect.top + adj1));
            path.lineTo((float)(rect.left + adj1), (float)(rect.top + adj1));
        }
        path.lineTo((float)(rect.left + adj1), (float)rect.bottom);
        path.close();
        return path;
    }

    private static Path getLeftUpArrowPath(AutoShape shape, Rect rect) {
        Float[] values = shape.getAdjustData();
        int adj1 = 0;
        int adj2 = 0;
        int adj3 = 0;
        int len = Math.min(rect.width(), rect.height());
        if (values != null && values.length == 3) {
            adj1 = Math.round((float)len * values[0].floatValue());
            adj2 = Math.round((float)len * values[1].floatValue());
            adj3 = Math.round((float)len * values[2].floatValue());
            if (adj1 > adj2 * 2) {
                adj1 = adj2 * 2;
            }
            if (adj2 * 2 + adj3 > len) {
                adj3 = len - adj2 * 2;
            }
        } else {
            adj1 = Math.round((float)len * 0.25f);
            adj2 = Math.round((float)len * 0.25f);
            adj3 = Math.round((float)len * 0.25f);
        }
        path.moveTo((float)(rect.left + adj3), (float)(rect.bottom - adj2 + adj1 / 2));
        path.lineTo((float)(rect.left + adj3), (float)rect.bottom);
        path.lineTo((float)rect.left, (float)(rect.bottom - adj2));
        path.lineTo((float)(rect.left + adj3), (float)(rect.bottom - 2 * adj2));
        path.lineTo((float)(rect.left + adj3), (float)(rect.bottom - adj2 - adj1 / 2));
        path.lineTo((float)(rect.right - adj2 - adj1 / 2), (float)(rect.bottom - adj2 - adj1 / 2));
        path.lineTo((float)(rect.right - adj2 - adj1 / 2), (float)(rect.top + adj3));
        path.lineTo((float)(rect.right - adj2 * 2), (float)(rect.top + adj3));
        path.lineTo((float)(rect.right - adj2), (float)rect.top);
        path.lineTo((float)rect.right, (float)(rect.top + adj3));
        path.lineTo((float)(rect.right - adj2 + adj1 / 2), (float)(rect.top + adj3));
        path.lineTo((float)(rect.right - adj2 + adj1 / 2), (float)(rect.bottom - adj2 + adj1 / 2));
        path.close();
        return path;
    }

    private static Path getBentUpArrowPath(AutoShape shape, Rect rect) {
        Float[] values = shape.getAdjustData();
        int adj1 = 0;
        int adj2 = 0;
        int adj3 = 0;
        int len = Math.min(rect.width(), rect.height());
        if (values != null && values.length == 3) {
            adj1 = Math.round((float)len * values[0].floatValue());
            adj2 = Math.round((float)len * values[1].floatValue());
            adj3 = Math.round((float)len * values[2].floatValue());
        } else {
            adj1 = Math.round((float)len * 0.25f);
            adj2 = Math.round((float)len * 0.25f);
            adj3 = Math.round((float)len * 0.25f);
        }
        path.moveTo((float)rect.left, (float)rect.bottom);
        path.lineTo((float)rect.left, (float)(rect.bottom - adj1));
        path.lineTo((float)(rect.right - adj2 - adj1 / 2), (float)(rect.bottom - adj1));
        path.lineTo((float)(rect.right - adj2 - adj1 / 2), (float)(rect.top + adj3));
        path.lineTo((float)(rect.right - adj2 * 2), (float)(rect.top + adj3));
        path.lineTo((float)(rect.right - adj2), (float)rect.top);
        path.lineTo((float)rect.right, (float)(rect.top + adj3));
        path.lineTo((float)(rect.right - adj2 + adj1 / 2), (float)(rect.top + adj3));
        path.lineTo((float)(rect.right - adj2 + adj1 / 2), (float)rect.bottom);
        path.close();
        return path;
    }

    private static List<Path> getCurvedRightArrowPath(AutoShape shape, Rect rect) {
        ArrayList<Path> pathList = new ArrayList<Path>(2);
        Float[] values = shape.getAdjustData();
        Path path = new Path();
        int adj1 = 0;
        int adj2 = 0;
        int adj3 = 0;
        int len = Math.min(rect.width(), rect.height());
        if (values != null && values.length == 3) {
            adj1 = Math.round((float)len * values[0].floatValue());
            adj2 = Math.round((float)len * values[1].floatValue());
            adj3 = Math.round((float)len * values[2].floatValue());
        } else {
            adj1 = Math.round((float)len * 0.25f);
            adj2 = Math.round((float)len * 0.5f);
            adj3 = Math.round((float)len * 0.25f);
        }
        int ovalWidth = 2 * rect.width();
        int ovalHeight = rect.bottom - adj2 / 2 - adj1 / 2 - rect.top;
        path.moveTo((float)rect.right, (float)rect.top);
        s_rect.set((float)rect.left, (float)rect.top, (float)(rect.left + ovalWidth), (float)(rect.top + ovalHeight));
        path.arcTo(s_rect, 270.0f, -90.0f);
        path.lineTo((float)rect.left, (float)(rect.top + ovalHeight / 2 + adj1));
        s_rect.set((float)rect.left, (float)(rect.top + adj1), (float)(rect.left + ovalWidth), (float)(rect.top + ovalHeight + adj1));
        path.arcTo(s_rect, 180.0f, 90.0f);
        path.close();
        pathList.add(path);
        path = new Path();
        path.moveTo((float)rect.left, (float)(rect.top + ovalHeight / 2));
        double y = Math.sqrt(Math.pow(ovalHeight / 2, 2.0) * (Math.pow(ovalWidth / 2, 2.0) - Math.pow(adj3, 2.0)) / Math.pow(ovalWidth / 2, 2.0));
        int angle = (int)(Math.atan(y / (double)adj3) * 180.0 / Math.PI);
        s_rect.set((float)rect.left, (float)rect.top, (float)(rect.left + ovalWidth), (float)(rect.top + ovalHeight));
        path.arcTo(s_rect, 180.0f, (float)(-angle));
        path.setLastPoint((float)(rect.right - adj3), (float)(rect.top + ovalHeight / 2 + (int)y));
        path.lineTo((float)(rect.right - adj3), (float)(rect.top + ovalHeight / 2 + (int)y + adj1 / 2 - adj2 / 2));
        path.lineTo((float)rect.right, (float)(rect.bottom - adj2 / 2));
        path.lineTo((float)(rect.right - adj3), (float)(rect.top + ovalHeight / 2 + (int)y + adj1 / 2 + adj2 / 2));
        path.lineTo((float)(rect.right - adj3), (float)(rect.top + ovalHeight / 2 + (int)y + adj1));
        s_rect.set((float)rect.left, (float)(rect.top + adj1), (float)(rect.left + ovalWidth), (float)(rect.top + ovalHeight + adj1));
        path.arcTo(s_rect, (float)(180 - angle), (float)angle);
        path.close();
        pathList.add(path);
        return pathList;
    }

    private static List<Path> getCurvedLeftArrowPath(AutoShape shape, Rect rect) {
        ArrayList<Path> pathList = new ArrayList<Path>(2);
        Float[] values = shape.getAdjustData();
        Path path = new Path();
        int adj1 = 0;
        int adj2 = 0;
        int adj3 = 0;
        int len = Math.min(rect.width(), rect.height());
        if (values != null && values.length == 3) {
            adj1 = Math.round((float)len * values[0].floatValue());
            adj2 = Math.round((float)len * values[1].floatValue());
            adj3 = Math.round((float)len * values[2].floatValue());
        } else {
            adj1 = Math.round((float)len * 0.25f);
            adj2 = Math.round((float)len * 0.5f);
            adj3 = Math.round((float)len * 0.25f);
        }
        int ovalWidth = 2 * rect.width();
        int ovalHeight = rect.bottom - adj2 / 2 - adj1 / 2 - rect.top;
        path.moveTo((float)rect.right, (float)(rect.top + ovalHeight / 2));
        double y = Math.sqrt(Math.pow(ovalHeight / 2, 2.0) * (Math.pow(ovalWidth / 2, 2.0) - Math.pow(adj3, 2.0)) / Math.pow(ovalWidth / 2, 2.0));
        int angle = (int)(Math.atan(y / (double)adj3) * 180.0 / Math.PI);
        s_rect.set((float)(rect.right - ovalWidth), (float)rect.top, (float)rect.right, (float)(rect.top + ovalHeight));
        path.arcTo(s_rect, 0.0f, (float)angle);
        path.setLastPoint((float)(rect.left + adj3), (float)(rect.top + ovalHeight / 2 + (int)y));
        path.lineTo((float)(rect.left + adj3), (float)(rect.top + ovalHeight / 2 + (int)y + adj1 / 2 - adj2 / 2));
        path.lineTo((float)rect.left, (float)(rect.bottom - adj2 / 2));
        path.lineTo((float)(rect.left + adj3), (float)(rect.top + ovalHeight / 2 + (int)y + adj1 / 2 + adj2 / 2));
        path.lineTo((float)(rect.left + adj3), (float)(rect.top + ovalHeight / 2 + (int)y + adj1));
        s_rect.set((float)(rect.right - ovalWidth), (float)(rect.top + adj1), (float)rect.right, (float)(rect.top + ovalHeight + adj1));
        path.arcTo(s_rect, (float)angle, (float)(-angle));
        path.close();
        pathList.add(path);
        path = new Path();
        path.moveTo((float)rect.left, (float)rect.top);
        s_rect.set((float)(rect.right - ovalWidth), (float)rect.top, (float)rect.right, (float)(rect.top + ovalHeight));
        path.arcTo(s_rect, 270.0f, 90.0f);
        path.lineTo((float)rect.right, (float)(rect.top + ovalHeight / 2 + adj1));
        s_rect.set((float)(rect.right - ovalWidth), (float)(rect.top + adj1), (float)rect.right, (float)(rect.top + ovalHeight + adj1));
        path.arcTo(s_rect, 0.0f, -90.0f);
        path.close();
        pathList.add(path);
        return pathList;
    }

    private static List<Path> getCurvedUpArrowPath(AutoShape shape, Rect rect) {
        ArrayList<Path> pathList = new ArrayList<Path>(2);
        Float[] values = shape.getAdjustData();
        Path path = new Path();
        int adj1 = 0;
        int adj2 = 0;
        int adj3 = 0;
        int len = Math.min(rect.width(), rect.height());
        if (values != null && values.length == 3) {
            adj1 = Math.round((float)len * values[0].floatValue());
            adj2 = Math.round((float)len * values[1].floatValue());
            adj3 = Math.round((float)len * values[2].floatValue());
        } else {
            adj1 = Math.round((float)len * 0.25f);
            adj2 = Math.round((float)len * 0.5f);
            adj3 = Math.round((float)len * 0.25f);
        }
        int ovalHalfWidth = (rect.width() - adj2 / 2 - adj1 / 2) / 2;
        int ovalHalfHeight = rect.height();
        path.moveTo((float)(rect.left + ovalHalfWidth), (float)rect.bottom);
        double x = Math.sqrt(Math.pow(ovalHalfWidth, 2.0) * (Math.pow(ovalHalfHeight, 2.0) - Math.pow(adj3, 2.0)) / Math.pow(ovalHalfHeight, 2.0));
        int angle = (int)(Math.atan(x / (double)adj3) * 180.0 / Math.PI);
        s_rect.set((float)rect.left, (float)(rect.top - ovalHalfHeight), (float)(rect.left + ovalHalfWidth * 2), (float)(rect.top + ovalHalfHeight));
        path.arcTo(s_rect, 90.0f, (float)(-angle));
        path.setLastPoint((float)(rect.left + ovalHalfWidth) + (float)x, (float)(rect.top + adj3));
        path.lineTo((float)(rect.left + ovalHalfWidth) + (float)x + (float)(adj1 / 2) - (float)(adj2 / 2), (float)(rect.top + adj3));
        path.lineTo((float)(rect.right - adj2 / 2), (float)rect.top);
        path.lineTo((float)(rect.left + ovalHalfWidth) + (float)x + (float)(adj1 / 2) + (float)(adj2 / 2), (float)(rect.top + adj3));
        path.lineTo((float)(rect.left + ovalHalfWidth) + (float)x + (float)adj1, (float)(rect.top + adj3));
        s_rect.set((float)(rect.left + adj1), (float)(rect.top - ovalHalfHeight), (float)(rect.left + ovalHalfWidth * 2 + adj1), (float)(rect.top + ovalHalfHeight));
        path.arcTo(s_rect, (float)(90 - angle), (float)angle);
        path.close();
        pathList.add(path);
        path = new Path();
        path.moveTo((float)rect.left, (float)rect.top);
        s_rect.set((float)rect.left, (float)(rect.top - ovalHalfHeight), (float)(rect.left + ovalHalfWidth * 2), (float)(rect.top + ovalHalfHeight));
        path.arcTo(s_rect, 180.0f, -90.0f);
        path.lineTo((float)(rect.left + ovalHalfWidth + adj1), (float)rect.bottom);
        s_rect.set((float)(rect.left + adj1), (float)(rect.top - ovalHalfHeight), (float)(rect.left + ovalHalfWidth * 2 + adj1), (float)(rect.top + ovalHalfHeight));
        path.arcTo(s_rect, 90.0f, 90.0f);
        path.close();
        pathList.add(path);
        return pathList;
    }

    private static List<Path> getCurvedDownArrowPath(AutoShape shape, Rect rect) {
        ArrayList<Path> pathList = new ArrayList<Path>(2);
        Float[] values = shape.getAdjustData();
        Path path = new Path();
        int adj1 = 0;
        int adj2 = 0;
        int adj3 = 0;
        int len = Math.min(rect.width(), rect.height());
        if (values != null && values.length == 3) {
            adj1 = Math.round((float)len * values[0].floatValue());
            adj2 = Math.round((float)len * values[1].floatValue());
            adj3 = Math.round((float)len * values[2].floatValue());
        } else {
            adj1 = Math.round((float)len * 0.25f);
            adj2 = Math.round((float)len * 0.5f);
            adj3 = Math.round((float)len * 0.25f);
        }
        int ovalHalfWidth = (rect.width() - adj2 / 2 - adj1 / 2) / 2;
        int ovalHalfHeight = rect.height();
        path.moveTo((float)rect.left, (float)rect.bottom);
        s_rect.set((float)rect.left, (float)rect.top, (float)(rect.left + ovalHalfWidth * 2), (float)(rect.top + ovalHalfHeight * 2));
        path.arcTo(s_rect, 180.0f, 90.0f);
        path.lineTo((float)(rect.left + ovalHalfWidth + adj1), (float)rect.top);
        s_rect.set((float)(rect.left + adj1), (float)rect.top, (float)(rect.left + ovalHalfWidth * 2 + adj1), (float)(rect.top + ovalHalfHeight * 2));
        path.arcTo(s_rect, 270.0f, -90.0f);
        path.close();
        pathList.add(path);
        path = new Path();
        path.moveTo((float)(rect.left + ovalHalfWidth), (float)rect.top);
        double x = Math.sqrt(Math.pow(ovalHalfWidth, 2.0) * (Math.pow(ovalHalfHeight, 2.0) - Math.pow(adj3, 2.0)) / Math.pow(ovalHalfHeight, 2.0));
        int angle = (int)(Math.atan(x / (double)adj3) * 180.0 / Math.PI);
        s_rect.set((float)rect.left, (float)rect.top, (float)(rect.left + ovalHalfWidth * 2), (float)(rect.top + ovalHalfHeight * 2));
        path.arcTo(s_rect, 270.0f, (float)angle);
        path.setLastPoint((float)(rect.left + ovalHalfWidth) + (float)x, (float)(rect.bottom - adj3));
        path.lineTo((float)(rect.left + ovalHalfWidth) + (float)x + (float)(adj1 / 2) - (float)(adj2 / 2), (float)(rect.bottom - adj3));
        path.lineTo((float)(rect.right - adj2 / 2), (float)rect.bottom);
        path.lineTo((float)(rect.left + ovalHalfWidth) + (float)x + (float)(adj1 / 2) + (float)(adj2 / 2), (float)(rect.bottom - adj3));
        path.lineTo((float)(rect.left + ovalHalfWidth) + (float)x + (float)adj1, (float)(rect.bottom - adj3));
        s_rect.set((float)(rect.left + adj1), (float)rect.top, (float)(rect.left + ovalHalfWidth * 2 + adj1), (float)(rect.top + ovalHalfHeight * 2));
        path.arcTo(s_rect, (float)(270 + angle), (float)(-angle));
        path.close();
        pathList.add(path);
        return pathList;
    }

    private static Path getStripedRightArrowPath(AutoShape shape, Rect rect) {
        Float[] values = shape.getAdjustData();
        int adj1 = 0;
        int adj2 = 0;
        int len1 = rect.height() / 2;
        int len2 = Math.min(rect.width(), rect.height());
        if (values != null && values.length == 2) {
            adj1 = Math.round((float)len1 * values[0].floatValue());
            adj2 = Math.round((float)len2 * values[1].floatValue());
        } else {
            adj1 = Math.round((float)len1 * 0.5f);
            adj2 = Math.round((float)len2 * 0.5f);
        }
        len1 = len2 / 32;
        path.addRect((float)rect.left, (float)(rect.centerY() - adj1), (float)(rect.left + len1), (float)(rect.centerY() + adj1), Path.Direction.CW);
        path.addRect((float)(rect.left + len1 * 2), (float)(rect.centerY() - adj1), (float)(rect.left + len1 * 4), (float)(rect.centerY() + adj1), Path.Direction.CW);
        path.moveTo((float)(rect.left + len1 * 5), (float)(rect.centerY() - adj1));
        path.lineTo((float)(rect.right - adj2), (float)(rect.centerY() - adj1));
        path.lineTo((float)(rect.right - adj2), (float)rect.top);
        path.lineTo((float)rect.right, (float)rect.centerY());
        path.lineTo((float)(rect.right - adj2), (float)rect.bottom);
        path.lineTo((float)(rect.right - adj2), (float)(rect.centerY() + adj1));
        path.lineTo((float)(rect.left + len1 * 5), (float)(rect.centerY() + adj1));
        path.close();
        return path;
    }

    private static Path getNotchedRightArrowPath(AutoShape shape, Rect rect) {
        Float[] values = shape.getAdjustData();
        int adj1 = 0;
        int adj2 = 0;
        int len1 = rect.height() / 2;
        int len2 = Math.min(rect.width(), rect.height());
        if (values != null && values.length == 2) {
            adj1 = Math.round((float)len1 * values[0].floatValue());
            adj2 = Math.round((float)len2 * values[1].floatValue());
        } else {
            adj1 = Math.round((float)len1 * 0.5f);
            adj2 = Math.round((float)len2 * 0.5f);
        }
        int adj3 = 2 * adj1 * adj2 / rect.height();
        path.moveTo((float)rect.left, (float)(rect.centerY() - adj1));
        path.lineTo((float)(rect.right - adj2), (float)(rect.centerY() - adj1));
        path.lineTo((float)(rect.right - adj2), (float)rect.top);
        path.lineTo((float)rect.right, (float)rect.centerY());
        path.lineTo((float)(rect.right - adj2), (float)rect.bottom);
        path.lineTo((float)(rect.right - adj2), (float)(rect.centerY() + adj1));
        path.lineTo((float)rect.left, (float)(rect.centerY() + adj1));
        path.lineTo((float)(rect.left + adj3), (float)rect.centerY());
        path.close();
        return path;
    }

    private static Path getHomePlatePath(AutoShape shape, Rect rect) {
        Float[] values = shape.getAdjustData();
        int adj1 = 0;
        int len = Math.min(rect.width(), rect.height());
        adj1 = values != null && values.length == 1 ? Math.round((float)len * values[0].floatValue()) : Math.round((float)len * 0.5f);
        path.moveTo((float)rect.left, (float)rect.top);
        path.lineTo((float)(rect.right - adj1), (float)rect.top);
        path.lineTo((float)rect.right, (float)rect.centerY());
        path.lineTo((float)(rect.right - adj1), (float)rect.bottom);
        path.lineTo((float)rect.left, (float)rect.bottom);
        path.close();
        return path;
    }

    private static Path getChevronPath(AutoShape shape, Rect rect) {
        Float[] values = shape.getAdjustData();
        int adj1 = 0;
        int len = Math.min(rect.width(), rect.height());
        adj1 = values != null && values.length == 1 ? Math.round((float)len * values[0].floatValue()) : Math.round((float)len * 0.5f);
        path.moveTo((float)rect.left, (float)rect.top);
        path.lineTo((float)(rect.right - adj1), (float)rect.top);
        path.lineTo((float)rect.right, (float)rect.centerY());
        path.lineTo((float)(rect.right - adj1), (float)rect.bottom);
        path.lineTo((float)rect.left, (float)rect.bottom);
        path.lineTo((float)(rect.left + adj1), (float)rect.centerY());
        path.close();
        return path;
    }

    private static Path getRightArrowCalloutPath(AutoShape shape, Rect rect) {
        Float[] values = shape.getAdjustData();
        int adj1 = 0;
        int adj2 = 0;
        int adj3 = 0;
        int adj4 = 0;
        int len = Math.min(rect.width(), rect.height());
        if (values != null && values.length == 4) {
            for (int i = 0; i < 4; ++i) {
                if (!(values[i].floatValue() > 1.0f) || i == 2) continue;
                values[i] = Float.valueOf(1.0f);
            }
            adj1 = Math.round((float)len * values[0].floatValue());
            adj2 = Math.round((float)len * values[1].floatValue());
            adj3 = Math.round((float)len * values[2].floatValue());
            adj4 = Math.round((float)rect.width() * values[3].floatValue());
            if (adj1 > adj2 * 2) {
                adj1 = adj2 * 2;
            }
            if (adj3 > rect.width()) {
                adj3 = rect.width();
            }
            if (adj4 + adj3 > rect.width()) {
                adj4 = rect.width() - adj3;
            }
        } else {
            adj1 = Math.round((float)len * 0.25f);
            adj2 = Math.round((float)len * 0.25f);
            adj3 = Math.round((float)len * 0.25f);
            adj4 = Math.round((float)rect.width() * 0.65f);
        }
        path.moveTo((float)rect.left, (float)rect.top);
        path.lineTo((float)(rect.left + adj4), (float)rect.top);
        path.lineTo((float)(rect.left + adj4), (float)(rect.centerY() - adj1 / 2));
        path.lineTo((float)(rect.right - adj3), (float)(rect.centerY() - adj1 / 2));
        path.lineTo((float)(rect.right - adj3), (float)(rect.centerY() - adj2));
        path.lineTo((float)rect.right, (float)rect.centerY());
        path.lineTo((float)(rect.right - adj3), (float)(rect.centerY() + adj2));
        path.lineTo((float)(rect.right - adj3), (float)(rect.centerY() + adj1 / 2));
        path.lineTo((float)(rect.left + adj4), (float)(rect.centerY() + adj1 / 2));
        path.lineTo((float)(rect.left + adj4), (float)rect.bottom);
        path.lineTo((float)rect.left, (float)rect.bottom);
        path.close();
        return path;
    }

    private static Path getLeftArrowCalloutPath(AutoShape shape, Rect rect) {
        Float[] values = shape.getAdjustData();
        int adj1 = 0;
        int adj2 = 0;
        int adj3 = 0;
        int adj4 = 0;
        int len = Math.min(rect.width(), rect.height());
        if (values != null && values.length == 4) {
            for (int i = 0; i < 4; ++i) {
                if (!(values[i].floatValue() > 1.0f) || i == 2) continue;
                values[i] = Float.valueOf(1.0f);
            }
            adj1 = Math.round((float)len * values[0].floatValue());
            adj2 = Math.round((float)len * values[1].floatValue());
            adj3 = Math.round((float)len * values[2].floatValue());
            adj4 = Math.round((float)rect.width() * values[3].floatValue());
            if (adj1 > adj2 * 2) {
                adj1 = adj2 * 2;
            }
            if (adj3 > rect.width()) {
                adj3 = rect.width();
            }
            if (adj4 + adj3 > rect.width()) {
                adj4 = rect.width() - adj3;
            }
        } else {
            adj1 = Math.round((float)len * 0.25f);
            adj2 = Math.round((float)len * 0.25f);
            adj3 = Math.round((float)len * 0.25f);
            adj4 = Math.round((float)rect.width() * 0.65f);
        }
        path.moveTo((float)rect.left, (float)rect.centerY());
        path.lineTo((float)(rect.left + adj3), (float)(rect.centerY() - adj2));
        path.lineTo((float)(rect.left + adj3), (float)(rect.centerY() - adj1 / 2));
        path.lineTo((float)(rect.right - adj4), (float)(rect.centerY() - adj1 / 2));
        path.lineTo((float)(rect.right - adj4), (float)rect.top);
        path.lineTo((float)rect.right, (float)rect.top);
        path.lineTo((float)rect.right, (float)rect.bottom);
        path.lineTo((float)(rect.right - adj4), (float)rect.bottom);
        path.lineTo((float)(rect.right - adj4), (float)(rect.centerY() + adj1 / 2));
        path.lineTo((float)(rect.left + adj3), (float)(rect.centerY() + adj1 / 2));
        path.lineTo((float)(rect.left + adj3), (float)(rect.centerY() + adj2));
        path.close();
        return path;
    }

    private static Path getUpArrowCalloutPath(AutoShape shape, Rect rect) {
        Float[] values = shape.getAdjustData();
        int adj1 = 0;
        int adj2 = 0;
        int adj3 = 0;
        int adj4 = 0;
        int len = Math.min(rect.width(), rect.height());
        if (values != null && values.length == 4) {
            for (int i = 0; i < 4; ++i) {
                if (!(values[i].floatValue() > 1.0f) || i == 2) continue;
                values[i] = Float.valueOf(1.0f);
            }
            adj1 = Math.round((float)len * values[0].floatValue());
            adj2 = Math.round((float)len * values[1].floatValue());
            adj3 = Math.round((float)len * values[2].floatValue());
            adj4 = Math.round((float)rect.height() * values[3].floatValue());
            if (adj1 > adj2 * 2) {
                adj1 = adj2 * 2;
            }
            if (adj3 > rect.height()) {
                adj3 = rect.width();
            }
            if (adj4 + adj3 > rect.height()) {
                adj4 = rect.height() - adj3;
            }
        } else {
            adj1 = Math.round((float)len * 0.25f);
            adj2 = Math.round((float)len * 0.25f);
            adj3 = Math.round((float)len * 0.25f);
            adj4 = Math.round((float)rect.height() * 0.65f);
        }
        path.moveTo((float)rect.centerX(), (float)rect.top);
        path.lineTo((float)(rect.centerX() + adj2), (float)(rect.top + adj3));
        path.lineTo((float)(rect.centerX() + adj1 / 2), (float)(rect.top + adj3));
        path.lineTo((float)(rect.centerX() + adj1 / 2), (float)(rect.bottom - adj4));
        path.lineTo((float)rect.right, (float)(rect.bottom - adj4));
        path.lineTo((float)rect.right, (float)rect.bottom);
        path.lineTo((float)rect.left, (float)rect.bottom);
        path.lineTo((float)rect.left, (float)(rect.bottom - adj4));
        path.lineTo((float)(rect.centerX() - adj1 / 2), (float)(rect.bottom - adj4));
        path.lineTo((float)(rect.centerX() - adj1 / 2), (float)(rect.top + adj3));
        path.lineTo((float)(rect.centerX() - adj2), (float)(rect.top + adj3));
        path.close();
        return path;
    }

    private static Path getDownArrowCalloutPath(AutoShape shape, Rect rect) {
        Float[] values = shape.getAdjustData();
        int adj1 = 0;
        int adj2 = 0;
        int adj3 = 0;
        int adj4 = 0;
        int len = Math.min(rect.width(), rect.height());
        if (values != null && values.length == 4) {
            for (int i = 0; i < 4; ++i) {
                if (!(values[i].floatValue() > 1.0f) || i == 2) continue;
                values[i] = Float.valueOf(1.0f);
            }
            adj1 = Math.round((float)len * values[0].floatValue());
            adj2 = Math.round((float)len * values[1].floatValue());
            adj3 = Math.round((float)len * values[2].floatValue());
            adj4 = Math.round((float)rect.height() * values[3].floatValue());
            if (adj1 > adj2 * 2) {
                adj1 = adj2 * 2;
            }
            if (adj3 > rect.height()) {
                adj3 = rect.width();
            }
            if (adj4 + adj3 > rect.height()) {
                adj4 = rect.height() - adj3;
            }
        } else {
            adj1 = Math.round((float)len * 0.25f);
            adj2 = Math.round((float)len * 0.25f);
            adj3 = Math.round((float)len * 0.25f);
            adj4 = Math.round((float)rect.height() * 0.65f);
        }
        path.moveTo((float)rect.centerX(), (float)rect.bottom);
        path.lineTo((float)(rect.centerX() - adj2), (float)(rect.bottom - adj3));
        path.lineTo((float)(rect.centerX() - adj1 / 2), (float)(rect.bottom - adj3));
        path.lineTo((float)(rect.centerX() - adj1 / 2), (float)(rect.top + adj4));
        path.lineTo((float)rect.left, (float)(rect.top + adj4));
        path.lineTo((float)rect.left, (float)rect.top);
        path.lineTo((float)rect.right, (float)rect.top);
        path.lineTo((float)rect.right, (float)(rect.top + adj4));
        path.lineTo((float)(rect.centerX() + adj1 / 2), (float)(rect.top + adj4));
        path.lineTo((float)(rect.centerX() + adj1 / 2), (float)(rect.bottom - adj3));
        path.lineTo((float)(rect.centerX() + adj2), (float)(rect.bottom - adj3));
        path.close();
        return path;
    }

    private static Path getLeftRightArrowCalloutPath(AutoShape shape, Rect rect) {
        Float[] values = shape.getAdjustData();
        int adj1 = 0;
        int adj2 = 0;
        int adj3 = 0;
        int adj4 = 0;
        int len = Math.min(rect.width(), rect.height());
        if (values != null && values.length == 4) {
            for (int i = 0; i < 4; ++i) {
                if (!(values[i].floatValue() > 1.0f) || i == 2) continue;
                values[i] = Float.valueOf(1.0f);
            }
            adj1 = Math.round((float)len * values[0].floatValue());
            adj2 = Math.round((float)len * values[1].floatValue());
            adj3 = Math.round((float)len * values[2].floatValue());
            adj4 = Math.round((float)rect.width() * values[3].floatValue());
            if (2 * adj3 >= rect.width()) {
                adj3 = rect.width() / 2;
            }
            if (2 * adj3 + adj4 >= rect.width()) {
                adj4 = rect.width() - 2 * adj3;
            }
        } else {
            adj1 = Math.round((float)len * 0.25f);
            adj2 = Math.round((float)len * 0.25f);
            adj3 = Math.round((float)len * 0.25f);
            adj4 = Math.round((float)rect.width() * 0.5f);
        }
        path.moveTo((float)rect.left, (float)rect.centerY());
        path.lineTo((float)(rect.left + adj3), (float)(rect.centerY() - adj2));
        path.lineTo((float)(rect.left + adj3), (float)(rect.centerY() - adj1 / 2));
        path.lineTo((float)(rect.centerX() - adj4 / 2), (float)(rect.centerY() - adj1 / 2));
        path.lineTo((float)(rect.centerX() - adj4 / 2), (float)rect.top);
        path.lineTo((float)(rect.centerX() + adj4 / 2), (float)rect.top);
        path.lineTo((float)(rect.centerX() + adj4 / 2), (float)(rect.centerY() - adj1 / 2));
        path.lineTo((float)(rect.right - adj3), (float)(rect.centerY() - adj1 / 2));
        path.lineTo((float)(rect.right - adj3), (float)(rect.centerY() - adj2));
        path.lineTo((float)rect.right, (float)rect.centerY());
        path.lineTo((float)(rect.right - adj3), (float)(rect.centerY() + adj2));
        path.lineTo((float)(rect.right - adj3), (float)(rect.centerY() + adj1 / 2));
        path.lineTo((float)(rect.centerX() + adj4 / 2), (float)(rect.centerY() + adj1 / 2));
        path.lineTo((float)(rect.centerX() + adj4 / 2), (float)rect.bottom);
        path.lineTo((float)(rect.centerX() - adj4 / 2), (float)rect.bottom);
        path.lineTo((float)(rect.centerX() - adj4 / 2), (float)(rect.centerY() + adj1 / 2));
        path.lineTo((float)(rect.left + adj3), (float)(rect.centerY() + adj1 / 2));
        path.lineTo((float)(rect.left + adj3), (float)(rect.centerY() + adj2));
        path.close();
        return path;
    }

    private static Path getQuadArrowCalloutPath(AutoShape shape, Rect rect) {
        Float[] values = shape.getAdjustData();
        int adj1 = 0;
        int adj2 = 0;
        int adj3 = 0;
        int adj4 = 0;
        int len = Math.min(rect.width(), rect.height());
        if (values != null && values.length == 4) {
            for (int i = 0; i < 4; ++i) {
                if (!(values[i].floatValue() > 1.0f) || i == 2) continue;
                values[i] = Float.valueOf(1.0f);
            }
            adj1 = Math.round((float)len * values[0].floatValue());
            adj2 = Math.round((float)len * values[1].floatValue());
            adj3 = Math.round((float)len * values[2].floatValue());
            adj4 = Math.round((float)len * values[3].floatValue());
            if (adj1 > adj2 * 2) {
                adj1 = adj2 * 2;
            }
            if (adj4 > adj2 * 2) {
                adj4 = adj2 * 2;
            }
            if (adj2 * 2 >= len) {
                adj2 = len / 2;
                adj3 = 0;
            }
            if (adj3 * 2 >= len) {
                adj3 = len / 2;
            }
            if (adj2 + adj3 > len / 2) {
                adj3 = len / 2 - adj2;
            }
        } else {
            adj1 = Math.round((float)len * 0.18515f);
            adj2 = Math.round((float)len * 0.18515f);
            adj3 = Math.round((float)len * 0.18515f);
            adj4 = Math.round((float)len * 0.48f);
        }
        path.moveTo((float)rect.left, (float)rect.centerY());
        path.lineTo((float)(rect.left + adj3), (float)(rect.centerY() - adj2));
        path.lineTo((float)(rect.left + adj3), (float)(rect.centerY() - adj1 / 2));
        path.lineTo((float)(rect.centerX() - adj4 / 2), (float)(rect.centerY() - adj1 / 2));
        path.lineTo((float)(rect.centerX() - adj4 / 2), (float)(rect.centerY() - adj4 / 2));
        path.lineTo((float)(rect.centerX() - adj1 / 2), (float)(rect.centerY() - adj4 / 2));
        path.lineTo((float)(rect.centerX() - adj1 / 2), (float)(rect.top + adj3));
        path.lineTo((float)(rect.centerX() - adj2), (float)(rect.top + adj3));
        path.lineTo((float)rect.centerX(), (float)rect.top);
        path.lineTo((float)(rect.centerX() + adj2), (float)(rect.top + adj3));
        path.lineTo((float)(rect.centerX() + adj1 / 2), (float)(rect.top + adj3));
        path.lineTo((float)(rect.centerX() + adj1 / 2), (float)(rect.centerY() - adj4 / 2));
        path.lineTo((float)(rect.centerX() + adj4 / 2), (float)(rect.centerY() - adj4 / 2));
        path.lineTo((float)(rect.centerX() + adj4 / 2), (float)(rect.centerY() - adj1 / 2));
        path.lineTo((float)(rect.right - adj3), (float)(rect.centerY() - adj1 / 2));
        path.lineTo((float)(rect.right - adj3), (float)(rect.centerY() - adj2));
        path.lineTo((float)rect.right, (float)rect.centerY());
        path.lineTo((float)(rect.right - adj3), (float)(rect.centerY() + adj2));
        path.lineTo((float)(rect.right - adj3), (float)(rect.centerY() + adj1 / 2));
        path.lineTo((float)(rect.centerX() + adj4 / 2), (float)(rect.centerY() + adj1 / 2));
        path.lineTo((float)(rect.centerX() + adj4 / 2), (float)(rect.centerY() + adj4 / 2));
        path.lineTo((float)(rect.centerX() + adj1 / 2), (float)(rect.centerY() + adj4 / 2));
        path.lineTo((float)(rect.centerX() + adj1 / 2), (float)(rect.bottom - adj3));
        path.lineTo((float)(rect.centerX() + adj2), (float)(rect.bottom - adj3));
        path.lineTo((float)rect.centerX(), (float)rect.bottom);
        path.lineTo((float)(rect.centerX() - adj2), (float)(rect.bottom - adj3));
        path.lineTo((float)(rect.centerX() - adj1 / 2), (float)(rect.bottom - adj3));
        path.lineTo((float)(rect.centerX() - adj1 / 2), (float)(rect.centerY() + adj4 / 2));
        path.lineTo((float)(rect.centerX() - adj4 / 2), (float)(rect.centerY() + adj4 / 2));
        path.lineTo((float)(rect.centerX() - adj4 / 2), (float)(rect.centerY() + adj1 / 2));
        path.lineTo((float)(rect.left + adj3), (float)(rect.centerY() + adj1 / 2));
        path.lineTo((float)(rect.left + adj3), (float)(rect.centerY() + adj2));
        path.close();
        return path;
    }

    private static Path getCircularArrowPath(AutoShape shape, Rect rect) {
        Float[] values = shape.getAdjustData();
        int adj1 = 0;
        int adj2 = 0;
        int adj3 = 0;
        int adj4 = 0;
        int adj5 = 0;
        int len = 100;
        if (values != null && values.length == 5) {
            adj1 = Math.round((float)len * values[0].floatValue());
            adj2 = Math.round(values[1].floatValue() * 1.6666666f);
            adj3 = Math.round(values[2].floatValue() * 1.6666666f);
            adj4 = Math.round(values[3].floatValue() * 1.6666666f);
            adj5 = Math.round((float)len * values[4].floatValue());
        } else {
            adj1 = Math.round((float)len * 0.125f);
            adj2 = 20;
            adj3 = 340;
            adj4 = 180;
            adj5 = Math.round((float)len * 0.125f);
        }
        int insideRadius = len / 2 - adj5;
        double y = (double)insideRadius * Math.sin((double)adj3 * Math.PI / 180.0);
        double x = (double)insideRadius * Math.cos((double)adj3 * Math.PI / 180.0);
        double k = Math.tan((double)(adj3 + adj2) * Math.PI / 180.0);
        double b = y - k * x;
        double offX1 = Math.sqrt(Math.pow(adj5, 2.0) / (Math.pow(k, 2.0) + 1.0));
        double offX2 = Math.sqrt(Math.pow(adj1 / 2, 2.0) / (Math.pow(k, 2.0) + 1.0));
        if (adj3 > 90 && adj3 < 270) {
            offX1 = -offX1;
            offX2 = -offX2;
        }
        double outerDegree = LaterArrowPathBuilder.getAngle(x + offX2, k * (x + offX2) + b);
        double innerDegree = LaterArrowPathBuilder.getAngle(x - offX2, k * (x - offX2) + b);
        s_rect.set((float)(adj5 - adj1 / 2 - len / 2), (float)(adj5 - adj1 / 2 - len / 2), (float)(len / 2 - adj5 + adj1 / 2), (float)(len / 2 - adj5 + adj1 / 2));
        path.arcTo(s_rect, (float)adj4, (float)(outerDegree - (double)adj4 + 360.0) % 360.0f);
        path.lineTo((float)(x + offX1), (float)(k * (x + offX1) + b));
        path.lineTo((float)((double)insideRadius * Math.cos((double)(adj3 + adj2) * Math.PI / 180.0)), (float)((double)insideRadius * Math.sin((double)(adj3 + adj2) * Math.PI / 180.0)));
        path.lineTo((float)(x - offX1), (float)(k * (x - offX1) + b));
        s_rect.set((float)(adj5 + adj1 / 2 - len / 2), (float)(adj5 + adj1 / 2 - len / 2), (float)(len / 2 - adj5 - adj1 / 2), (float)(len / 2 - adj5 - adj1 / 2));
        path.arcTo(s_rect, (float)innerDegree, (float)((double)adj4 - innerDegree - 360.0) % 360.0f);
        path.close();
        Matrix m = new Matrix();
        m.postScale((float)rect.width() / 100.0f, (float)rect.height() / 100.0f);
        path.transform(m);
        path.offset((float)rect.centerX(), (float)rect.centerY());
        return path;
    }

    private static double getAngle(double x, double y) {
        double angle = Math.acos(x / Math.sqrt(x * x + y * y)) * 180.0 / Math.PI;
        if (y < 0.0) {
            angle = 360.0 - angle;
        }
        return angle;
    }
}

