/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.common.autoshape.pathbuilder;

import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.RectF;
import com.ahmadullahpk.alldocumentreader.xs.common.autoshape.pathbuilder.ArrowPathAndTail;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.Arrow;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.Element;

public class LineArrowPathBuilder {
    private static final int SMALL = 5;
    private static final int MEDIUM = 9;
    private static final int LARGE = 13;
    static PointF p = new PointF();

    private static int getArrowWidth(Arrow arrow, int lineWidth) {
        int width = 9;
        if (lineWidth >= 3) {
            width = lineWidth * 3;
        }
        return width;
    }

    public static int getArrowLength(Arrow arrow, int lineWidth) {
        int length = 9;
        if (lineWidth >= 3) {
            length = lineWidth * 3;
        }
        return length;
    }

    public static ArrowPathAndTail getDirectLineArrowPath(float startX, float startY, float endX, float endY, Arrow arrow, int lineWidth) {
        return LineArrowPathBuilder.getDirectLineArrowPath(startX, startY, endX, endY, arrow, lineWidth, 1.0f);
    }

    public static ArrowPathAndTail getDirectLineArrowPath(float startX, float startY, float endX, float endY, Arrow arrow, int lineWidth, float zoom) {
        ArrowPathAndTail arrowPathAndTail = new ArrowPathAndTail();
        int width = LineArrowPathBuilder.getArrowWidth(arrow, lineWidth);
        int length = LineArrowPathBuilder.getArrowLength(arrow, lineWidth);
        float ratio = (float)((double)((float)length * zoom) / Math.sqrt(Math.pow(endX - startX, 2.0) + Math.pow(endY - startY, 2.0)));
        startY = endY - (endY - startY) * ratio;
        startX = endX - (endX - startX) * ratio;
        arrowPathAndTail.setArrowPath(LineArrowPathBuilder.buildArrowPath(startX, startY, endX, endY, (float)width * zoom, (float)length * zoom, arrow.getType()));
        arrowPathAndTail.setArrowTailCenter(startX, startY);
        return arrowPathAndTail;
    }

    public static ArrowPathAndTail getQuadBezArrowPath(float startX, float startY, float ctrlX, float ctrlY, float endX, float endY, Arrow arrow, int lineWidth) {
        return LineArrowPathBuilder.getQuadBezArrowPath(startX, startY, ctrlX, ctrlY, endX, endY, arrow, lineWidth, 1.0f);
    }

    public static ArrowPathAndTail getQuadBezArrowPath(float startX, float startY, float ctrlX, float ctrlY, float endX, float endY, Arrow arrow, int lineWidth, float zoom) {
        ArrowPathAndTail arrowPathAndTail = new ArrowPathAndTail();
        float width = (float)LineArrowPathBuilder.getArrowWidth(arrow, lineWidth) * zoom;
        float length = (float)LineArrowPathBuilder.getArrowLength(arrow, lineWidth) * zoom;
        float r = 0.9f;
        float offRatio = 0.01f;
        PointF end = LineArrowPathBuilder.quadBezComputePoint(startX, startY, ctrlX, ctrlY, endX, endY, r);
        int dist = (int)Math.round(Math.sqrt(Math.pow(end.x - endX, 2.0) + Math.pow(end.y - endY, 2.0)));
        Boolean inc = null;
        while (Math.abs((float)dist - length) > 1.0f && r < 1.0f && r > 0.0f) {
            if ((float)dist - length > 1.0f) {
                r += offRatio;
                if (inc != null && !inc.booleanValue()) {
                    offRatio = (float)((double)offRatio * 0.1);
                    r -= offRatio;
                }
                inc = true;
            } else {
                r -= offRatio;
                if (inc != null && inc.booleanValue()) {
                    offRatio = (float)((double)offRatio * 0.1);
                    r += offRatio;
                }
                inc = false;
            }
            end = LineArrowPathBuilder.quadBezComputePoint(startX, startY, ctrlX, ctrlY, endX, endY, r);
            dist = (int)Math.round(Math.sqrt((end.x - endX) * (end.x - endX) + (end.y - endY) * (end.y - endY)));
        }
        arrowPathAndTail.setArrowPath(LineArrowPathBuilder.buildArrowPath(end.x, end.y, endX, endY, width, length, arrow.getType()));
        arrowPathAndTail.setArrowTailCenter(end.x, end.y);
        return arrowPathAndTail;
    }

    public static ArrowPathAndTail getCubicBezArrowPath(float startX, float startY, float ctrl1X, float ctrl1Y, float ctrl2X, float ctrl2Y, float endX, float endY, Arrow arrow, int lineWidth) {
        return LineArrowPathBuilder.getCubicBezArrowPath(startX, startY, ctrl1X, ctrl1Y, ctrl2X, ctrl2Y, endX, endY, arrow, lineWidth, 1.0f);
    }

    public static ArrowPathAndTail getCubicBezArrowPath(float startX, float startY, float ctrl1X, float ctrl1Y, float ctrl2X, float ctrl2Y, float endX, float endY, Arrow arrow, int lineWidth, float zoom) {
        ArrowPathAndTail arrowPathAndTail = new ArrowPathAndTail();
        int width = LineArrowPathBuilder.getArrowWidth(arrow, lineWidth);
        int length = LineArrowPathBuilder.getArrowLength(arrow, lineWidth);
        float r = 0.9f;
        float offRatio = 0.01f;
        PointF end = LineArrowPathBuilder.cubicBezComputePoint(startX, startY, ctrl1X, ctrl1Y, ctrl2X, ctrl2Y, endX, endY, r);
        int dist = (int)Math.round(Math.sqrt(Math.pow(end.x - endX, 2.0) + Math.pow(end.y - endY, 2.0)));
        Boolean inc = null;
        while (Math.abs(dist - length) > 1 && r < 1.0f && r > 0.0f) {
            if (dist - length > 1) {
                r += offRatio;
                if (inc != null && !inc.booleanValue()) {
                    offRatio = (float)((double)offRatio * 0.1);
                    r -= offRatio;
                }
                inc = true;
            } else {
                r -= offRatio;
                if (inc != null && inc.booleanValue()) {
                    offRatio = (float)((double)offRatio * 0.1);
                    r += offRatio;
                }
                inc = false;
            }
            end = LineArrowPathBuilder.cubicBezComputePoint(startX, startY, ctrl1X, ctrl1Y, ctrl2X, ctrl2Y, endX, endY, r);
            dist = (int)Math.round(Math.sqrt((end.x - endX) * (end.x - endX) + (end.y - endY) * (end.y - endY)));
        }
        arrowPathAndTail.setArrowPath(LineArrowPathBuilder.buildArrowPath(end.x, end.y, endX, endY, width, length, arrow.getType()));
        arrowPathAndTail.setArrowTailCenter(end.x, end.y);
        return arrowPathAndTail;
    }

    private static PointF quadBezComputePoint(float startX, float startY, float ctrlX, float ctrlY, float endX, float endY, float fU) {
        float f1subu = 1.0f - fU;
        float fBlend = f1subu * f1subu;
        LineArrowPathBuilder.p.x = fBlend * startX;
        LineArrowPathBuilder.p.y = fBlend * startY;
        fBlend = 2.0f * fU * f1subu;
        LineArrowPathBuilder.p.x += fBlend * ctrlX;
        LineArrowPathBuilder.p.y += fBlend * ctrlY;
        fBlend = fU * fU;
        LineArrowPathBuilder.p.x += fBlend * endX;
        LineArrowPathBuilder.p.y += fBlend * endY;
        return p;
    }

    private static PointF cubicBezComputePoint(float startX, float startY, float ctrl1X, float ctrl1Y, float ctrl2X, float ctrl2Y, float endX, float endY, float fU) {
        PointF p = new PointF();
        float f1subu = 1.0f - fU;
        float fBlend = f1subu * f1subu * f1subu;
        p.x = fBlend * startX;
        p.y = fBlend * startY;
        fBlend = 3.0f * fU * f1subu * f1subu;
        p.x += fBlend * ctrl1X;
        p.y += fBlend * ctrl1Y;
        fBlend = 3.0f * fU * fU * f1subu;
        p.x += fBlend * ctrl2X;
        p.y += fBlend * ctrl2Y;
        fBlend = fU * fU * fU;
        p.x += fBlend * endX;
        p.y += fBlend * endY;
        return p;
    }

    private static Path buildArrowPath(float startX, float startY, float endX, float endY, float zoom) {
        Path path = new Path();
        path.moveTo(endX, endY);
        int nWidth = (int)(15.0f * zoom);
        float fTheta = 1.0f;
        float vecLineX = endX - startX;
        float vecLineY = endY - startY;
        float vecLeftX = -vecLineY;
        float vecLeftY = vecLineX;
        float fLength = (float)Math.sqrt(vecLineX * vecLineX + vecLineY * vecLineY);
        float th = (float)nWidth / (2.0f * fLength);
        float ta = (float)((double)nWidth / (2.0 * (Math.tan(fTheta) / 2.0) * (double)fLength));
        float pBaseX = (int)(endX + -ta * vecLineX);
        float pBaseY = (int)(endY + -ta * vecLineY);
        path.lineTo(pBaseX + th * vecLeftX, pBaseY + th * vecLeftY / 2.0f);
        path.lineTo(pBaseX + -th * vecLeftX, pBaseY + -th * vecLeftY / 2.0f);
        path.close();
        return path;
    }

    private static Path buildArrowPath(float startX, float startY, float endX, float endY, float arrowWidth, float arrowLength, byte arrowType) {
        switch (arrowType) {
            case 1: {
                return LineArrowPathBuilder.buildTriangleArrowPath(startX, startY, endX, endY, arrowWidth);
            }
            case 5: {
                return LineArrowPathBuilder.buildArrowArrowPath(startX, startY, endX, endY, arrowWidth);
            }
            case 3: {
                return LineArrowPathBuilder.buildDiamondArrowPath(startX, startY, endX, endY, arrowWidth, arrowLength);
            }
            case 2: {
                return LineArrowPathBuilder.buildStealthArrowPath(startX, startY, endX, endY, arrowWidth, arrowLength);
            }
            case 4: {
                return LineArrowPathBuilder.buildOvalArrowPath(endX, endY, arrowWidth, arrowLength);
            }
        }
        return new Path();
    }

    private static Path buildTriangleArrowPath(float startX, float startY, float endX, float endY, float arrowWidth) {
        Path path = new Path();
        path.moveTo(endX, endY);
        if (endY == startY) {
            path.lineTo(startX, startY - arrowWidth / 2.0f);
            path.lineTo(startX, startY + arrowWidth / 2.0f);
        } else if (endX == startX) {
            path.lineTo(startX - arrowWidth / 2.0f, startY);
            path.lineTo(startX + arrowWidth / 2.0f, startY);
        } else {
            float k = (endY - startY) / (endX - startX);
            k = -1.0f / k;
            double angle = Math.atan(k);
            float offx = (float)((double)(arrowWidth / 2.0f) * Math.cos(angle));
            float offy = (float)((double)(arrowWidth / 2.0f) * Math.sin(angle));
            path.lineTo(startX + offx, startY + offy);
            path.lineTo(startX - offx, startY - offy);
        }
        path.close();
        return path;
    }

    private static Path buildArrowArrowPath(float startX, float startY, float endX, float endY, float arrowWidth) {
        Path path = new Path();
        if (endY == startY) {
            path.moveTo(startX, startY - arrowWidth / 2.0f);
            path.lineTo(endX, endY);
            path.lineTo(startX, startY + arrowWidth / 2.0f);
        } else if (endX == startX) {
            path.moveTo(startX - arrowWidth / 2.0f, startY);
            path.lineTo(endX, endY);
            path.lineTo(startX + arrowWidth / 2.0f, startY);
        } else {
            float k = (endY - startY) / (endX - startX);
            k = -1.0f / k;
            double angle = Math.atan(k);
            float offx = (float)((double)(arrowWidth / 2.0f) * Math.cos(angle));
            float offy = (float)((double)(arrowWidth / 2.0f) * Math.sin(angle));
            path.moveTo(startX + offx, startY + offy);
            path.lineTo(endX, endY);
            path.lineTo(startX - offx, startY - offy);
        }
        return path;
    }

    private static Path buildDiamondArrowPath(float startX, float startY, float endX, float endY, float arrowWidth, float arrowLength) {
        Path path = new Path();
        if (endY == startY || endX == startX) {
            path.moveTo(endX - arrowLength / 2.0f, endY);
            path.lineTo(endX, endY - arrowWidth / 2.0f);
            path.lineTo(endX + arrowLength / 2.0f, endY);
            path.lineTo(endX, endY + arrowWidth / 2.0f);
        } else {
            float k = (endY - startY) / (endX - startX);
            k = -1.0f / k;
            double angle = Math.atan(k);
            float offx = (float)((double)(arrowLength / 2.0f) * Math.cos(angle));
            float offy = (float)((double)(arrowWidth / 2.0f) * Math.sin(angle));
            path.moveTo(startX, startY);
            path.lineTo(endX + offx, endY + offy);
            path.lineTo(endX + (endX - startX), endY + (endY - startY));
            path.lineTo(endX - offx, endY - offy);
        }
        path.close();
        return path;
    }

    private static Path buildStealthArrowPath(float startX, float startY, float endX, float endY, float arrowWidth, float arrowLength) {
        Path path = new Path();
        path.moveTo(endX, endY);
        if (endY == startY) {
            path.lineTo(startX, startY - arrowWidth / 2.0f);
            path.lineTo(startX + (endX - startX) / 4.0f, endY);
            path.lineTo(startX, startY + arrowWidth / 2.0f);
        } else if (endX == startX) {
            path.lineTo(startX - arrowWidth / 2.0f, startY);
            path.lineTo(startX, startY + (endY - startY) / 4.0f);
            path.lineTo(startX + arrowWidth / 2.0f, startY);
        } else {
            float k = (endY - startY) / (endX - startX);
            k = -1.0f / k;
            double angle = Math.atan(k);
            float offx = (float)((double)(arrowLength / 2.0f) * Math.cos(angle));
            float offy = (float)((double)(arrowWidth / 2.0f) * Math.sin(angle));
            path.lineTo(startX + offx, startY + offy);
            path.lineTo(startX + (endX - startX) / 4.0f, startY + (endY - startY) / 4.0f);
            path.lineTo(startX - offx, startY - offy);
        }
        path.close();
        return path;
    }

    private static Path buildOvalArrowPath(float endX, float endY, float arrowWidth, float arrowLength) {
        Path path = new Path();
        path.addOval(new RectF(endX - arrowLength / 2.0f, endY - arrowWidth / 2.0f, endX + arrowLength / 2.0f, endY + arrowWidth / 2.0f), Path.Direction.CCW);
        return path;
    }

    public static PointF getReferencedPosition(Element head, PointF tail, byte arrowType) {
        float x = (float)Integer.parseInt(head.attributeValue("x")) * 96.0f / 914400.0f;
        float y = (float)Integer.parseInt(head.attributeValue("y")) * 96.0f / 914400.0f;
        switch (arrowType) {
            case 1: {
                x = x * 0.2f + tail.x * 0.8f;
                y = y * 0.2f + tail.y * 0.8f;
                break;
            }
            case 5: {
                break;
            }
            case 2: {
                x = x * 0.3f + tail.x * 0.7f;
                y = y * 0.3f + tail.y * 0.7f;
                break;
            }
        }
        return new PointF(x, y);
    }

    public static PointF getReferencedPosition(float headX, float headY, float tailX, float tailY, byte arrowType) {
        switch (arrowType) {
            case 1: {
                headX = headX * 0.2f + tailX * 0.8f;
                headY = headY * 0.2f + tailY * 0.8f;
                break;
            }
            case 5: {
                break;
            }
            case 2: {
                headX = headX * 0.3f + tailX * 0.7f;
                headY = headY * 0.3f + tailY * 0.7f;
                break;
            }
        }
        return new PointF(headX, headY);
    }
}

