/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.common.autoshape;

import com.ahmadullahpk.alldocumentreader.xs.common.autoshape.ArbitraryPolygonShapePath;
import com.ahmadullahpk.alldocumentreader.xs.common.autoshape.AutoShapeTypes;
import com.ahmadullahpk.alldocumentreader.xs.common.bg.BackgroundAndFill;
import com.ahmadullahpk.alldocumentreader.xs.common.bg.TileShader;
import com.ahmadullahpk.alldocumentreader.xs.common.borders.Line;
import com.ahmadullahpk.alldocumentreader.xs.common.pictureefftect.PictureStretchInfo;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.AbstractShape;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.ArbitraryPolygonShape;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.Arrow;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.AutoShape;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.LineShape;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.PictureShape;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.WPAutoShape;
import com.ahmadullahpk.alldocumentreader.xs.fc.LineKit;
import com.ahmadullahpk.alldocumentreader.xs.fc.ShaderKit;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.Element;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.PackagePart;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.PackageRelationship;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.ZipPackage;
import com.ahmadullahpk.alldocumentreader.xs.fc.ppt.reader.ReaderKit;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.Rectangle;
import com.ahmadullahpk.alldocumentreader.xs.ss.util.ColorUtil;
import com.ahmadullahpk.alldocumentreader.xs.system.IControl;
import java.util.List;
import java.util.Map;

public class AutoShapeDataKit {
    public static int getColor(Map<String, Integer> schemeColor, Element solidFillElement) {
        int color2 = -1;
        if (solidFillElement.element("srgbClr") != null) {
            Element clr = solidFillElement.element("srgbClr");
            color2 = (int)Long.parseLong(clr.attributeValue("val"), 16);
            color2 = 0xFF000000 | color2;
        } else {
            Element clr = solidFillElement.element("scrgbClr");
            if (clr != null) {
                int r = Integer.parseInt(clr.attributeValue("r")) * 255 / 100;
                int g = Integer.parseInt(clr.attributeValue("g")) * 255 / 100;
                int b = Integer.parseInt(clr.attributeValue("b")) * 255 / 100;
                return ColorUtil.rgb(r, g, b);
            }
            if (solidFillElement.element("schemeClr") != null || solidFillElement.element("prstClr") != null) {
                if (schemeColor != null && schemeColor.size() > 0) {
                    String val;
                    clr = solidFillElement.element("schemeClr");
                    if (clr == null) {
                        clr = solidFillElement.element("prstClr");
                    }
                    if ("black".equals(val = clr.attributeValue("val"))) {
                        color2 = -16777216;
                    } else if ("red".equals(val)) {
                        color2 = -65536;
                    } else if ("gray".equals(val)) {
                        color2 = -7829368;
                    } else if ("blue".equals(val)) {
                        color2 = -16776961;
                    } else if ("green".equals(val)) {
                        color2 = -16711936;
                    }
                    if (color2 == -1) {
                        color2 = schemeColor.get(val);
                    }
                    if (clr.element("tint") != null) {
                        color2 = ColorUtil.instance().getColorWithTint(color2, (double)Integer.parseInt(clr.element("tint").attributeValue("val")) / 100000.0);
                    } else if (clr.element("lumOff") != null) {
                        color2 = ColorUtil.instance().getColorWithTint(color2, (double)Integer.parseInt(clr.element("lumOff").attributeValue("val")) / 100000.0);
                    } else if (clr.element("lumMod") != null) {
                        color2 = ColorUtil.instance().getColorWithTint(color2, (double)Integer.parseInt(clr.element("lumMod").attributeValue("val")) / 100000.0 - 1.0);
                    } else if (clr.element("shade") != null) {
                        color2 = ColorUtil.instance().getColorWithTint(color2, (double)(-Integer.parseInt(clr.element("shade").attributeValue("val"))) / 200000.0);
                    }
                    if (clr.element("alpha") != null && (val = clr.element("alpha").attributeValue("val")) != null) {
                        int alpha = (int)((float)Integer.parseInt(val) / 100000.0f * 255.0f);
                        color2 = 0xFFFFFF & color2 | alpha << 24;
                    }
                }
            } else if (solidFillElement.element("sysClr") != null) {
                clr = solidFillElement.element("sysClr");
                color2 = Integer.parseInt(clr.attributeValue("lastClr"), 16);
                color2 = 0xFF000000 | color2;
            }
        }
        return color2;
    }

    public static BackgroundAndFill processBackground(IControl control, ZipPackage zipPackage, PackagePart drawingPart, Element bgPr, Map<String, Integer> schemeColor) {
        try {
            if (bgPr != null) {
                BackgroundAndFill bgFill = new BackgroundAndFill();
                Element fill = bgPr.element("solidFill");
                if (fill != null) {
                    bgFill.setFillType((byte)0);
                    bgFill.setForegroundColor(AutoShapeDataKit.getColor(schemeColor, fill));
                    return bgFill;
                }
                fill = bgPr.element("blipFill");
                if (fill != null) {
                    PackagePart picPart;
                    PackageRelationship imageShip;
                    String id2;
                    Element blip = fill.element("blip");
                    if (blip != null && blip.attribute("embed") != null && (id2 = blip.attributeValue("embed")) != null && (imageShip = drawingPart.getRelationship(id2)) != null && (picPart = zipPackage.getPart(imageShip.getTargetURI())) != null) {
                        Element tile = fill.element("tile");
                        if (tile == null) {
                            Element fillRect;
                            bgFill.setFillType((byte)3);
                            Element stretch = fill.element("stretch");
                            if (stretch != null && (fillRect = stretch.element("fillRect")) != null) {
                                PictureStretchInfo stretchInfo = new PictureStretchInfo();
                                boolean validate = false;
                                String str = fillRect.attributeValue("l");
                                if (str != null) {
                                    validate = true;
                                    stretchInfo.setLeftOffset(Float.parseFloat(str) / 100000.0f);
                                }
                                if ((str = fillRect.attributeValue("r")) != null) {
                                    validate = true;
                                    stretchInfo.setRightOffset(Float.parseFloat(str) / 100000.0f);
                                }
                                if ((str = fillRect.attributeValue("t")) != null) {
                                    validate = true;
                                    stretchInfo.setTopOffset(Float.parseFloat(str) / 100000.0f);
                                }
                                if ((str = fillRect.attributeValue("b")) != null) {
                                    validate = true;
                                    stretchInfo.setBottomOffset(Float.parseFloat(str) / 100000.0f);
                                }
                                if (validate) {
                                    bgFill.setStretch(stretchInfo);
                                }
                            }
                            bgFill.setPictureIndex(control.getSysKit().getPictureManage().addPicture(picPart));
                        } else {
                            String amt;
                            int index = control.getSysKit().getPictureManage().addPicture(picPart);
                            bgFill.setFillType((byte)2);
                            TileShader tileShader = ShaderKit.readTile(control.getSysKit().getPictureManage().getPicture(index), tile);
                            Element alphaModFix = blip.element("alphaModFix");
                            if (alphaModFix != null && (amt = alphaModFix.attributeValue("amt")) != null) {
                                tileShader.setAlpha(Math.round((float)Integer.parseInt(amt) / 100000.0f * 255.0f));
                            }
                            bgFill.setShader(tileShader);
                        }
                        return bgFill;
                    }
                } else {
                    fill = bgPr.element("gradFill");
                    if (fill != null) {
                        Element gsLst = fill.element("gsLst");
                        bgFill.setFillType(ShaderKit.getGradientType(fill));
                        bgFill.setShader(ShaderKit.readGradient(schemeColor, fill));
                        return bgFill;
                    }
                    fill = bgPr.element("fillRef");
                    if (fill != null) {
                        bgFill.setFillType((byte)0);
                        bgFill.setForegroundColor(AutoShapeDataKit.getColor(schemeColor, fill));
                        return bgFill;
                    }
                    fill = bgPr.element("pattFill");
                    if (fill != null) {
                        Element bgClr = fill.element("bgClr");
                        bgFill.setFillType((byte)0);
                        bgFill.setForegroundColor(AutoShapeDataKit.getColor(schemeColor, bgClr));
                        return bgFill;
                    }
                }
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static AbstractShape getAutoShape(IControl control, ZipPackage zipPackage, PackagePart drawingPart, Element sp, Rectangle rect, Map<String, Integer> schemeColor, int type) throws Exception {
        return AutoShapeDataKit.getAutoShape(control, zipPackage, drawingPart, sp, rect, schemeColor, type, false);
    }

    public static AbstractShape getAutoShape(IControl control, ZipPackage zipPackage, PackagePart drawingPart, Element sp, Rectangle rect, Map<String, Integer> schemeColor, int type, boolean hasTextbox) throws Exception {
        if (rect == null || sp == null) {
            return null;
        }
        int shapeType = 233;
        Element spPr = sp.element("spPr");
        if (spPr != null) {
            BackgroundAndFill fill;
            Float[] values = null;
            boolean border = true;
            String name = ReaderKit.instance().getPlaceholderName(sp);
            String spName = sp.getName();
            if (spName.equals("cxnSp")) {
                border = true;
                shapeType = 20;
            } else if (name != null && (name.contains("Text Box") || name.contains("TextBox"))) {
                shapeType = 1;
            }
            Element prstGeom = spPr.element("prstGeom");
            if (prstGeom != null) {
                List gds;
                Element avLst;
                String val;
                if (prstGeom.attribute("prst") != null && (val = prstGeom.attributeValue("prst")) != null && val.length() > 0) {
                    shapeType = AutoShapeTypes.instance().getAutoShapeType(val);
                }
                if ((avLst = prstGeom.element("avLst")) != null && (gds = avLst.elements("gd")).size() > 0) {
                    values = new Float[gds.size()];
                    for (int i = 0; i < gds.size(); ++i) {
                        Element gd = (Element)gds.get(i);
                        val = gd.attributeValue("fmla");
                        val = val.substring(4);
                        values[i] = Float.valueOf(Float.parseFloat(val) / 100000.0f);
                    }
                }
            } else if (spPr.element("custGeom") != null) {
                shapeType = 233;
            }
            if ((fill = null) == null && spPr.element("noFill") == null && !spName.equals("cxnSp") && (fill = AutoShapeDataKit.processBackground(control, zipPackage, drawingPart, spPr, schemeColor)) == null && shapeType != 19 && shapeType != 185 && shapeType != 85 && shapeType != 86 && shapeType != 186 && shapeType != 87 && shapeType != 88 && shapeType != 233) {
                fill = AutoShapeDataKit.processBackground(control, zipPackage, drawingPart, sp.element("style"), schemeColor);
            }
            Line line = LineKit.createShapeLine(control, zipPackage, drawingPart, sp, schemeColor);
            Element ln = spPr.element("ln");
            Element style2 = sp.element("style");
            if (ln != null) {
                if (ln.element("noFill") != null) {
                    border = false;
                }
            } else if (border && (style2 == null || style2.element("lnRef") == null)) {
                border = false;
            }
            if (shapeType != 20 && shapeType != 32 && rect != null && (rect.width == 0 || rect.height == 0)) {
                return null;
            }
            if (shapeType == 20 || shapeType == 32 || shapeType == 34 || shapeType == 38) {
                LineShape lineShape = null;
                lineShape = type == 0 ? new WPAutoShape() : new LineShape();
                lineShape.setShapeType(shapeType);
                lineShape.setBounds(rect);
                lineShape.setAdjustData(values);
                lineShape.setLine(line);
                if (ln != null) {
                    byte arrowType;
                    Element temp = ln.element("headEnd");
                    if (temp != null && temp.attribute("type") != null && (arrowType = Arrow.getArrowType(temp.attributeValue("type"))) != 0) {
                        lineShape.createStartArrow(arrowType, Arrow.getArrowSize(temp.attributeValue("w")), Arrow.getArrowSize(temp.attributeValue("len")));
                    }
                    if ((temp = ln.element("tailEnd")) != null && temp.attribute("type") != null && (arrowType = Arrow.getArrowType(temp.attributeValue("type"))) != 0) {
                        lineShape.createEndArrow(arrowType, Arrow.getArrowSize(temp.attributeValue("w")), Arrow.getArrowSize(temp.attributeValue("len")));
                    }
                }
                ReaderKit.instance().processRotation(spPr, lineShape);
                return lineShape;
            }
            if (shapeType == 233) {
                ArbitraryPolygonShape arbitraryPolygonShape = null;
                arbitraryPolygonShape = type == 0 ? new WPAutoShape() : new ArbitraryPolygonShape();
                BackgroundAndFill lineFill = null;
                if (line != null) {
                    lineFill = line.getBackgroundAndFill();
                }
                ArbitraryPolygonShapePath.processArbitraryPolygonShape(arbitraryPolygonShape, sp, fill, border, lineFill, ln, rect);
                arbitraryPolygonShape.setShapeType(shapeType);
                arbitraryPolygonShape.setLine(line);
                ReaderKit.instance().processRotation(spPr, arbitraryPolygonShape);
                return arbitraryPolygonShape;
            }
            if (hasTextbox || fill != null || border) {
                AutoShape autoShape = null;
                if (type == 0) {
                    autoShape = new WPAutoShape();
                    autoShape.setShapeType(shapeType);
                } else {
                    autoShape = new AutoShape(shapeType);
                }
                autoShape.setBounds(rect);
                if (fill != null) {
                    autoShape.setBackgroundAndFill(fill);
                }
                if (line != null) {
                    autoShape.setLine(line);
                }
                autoShape.setAdjustData(values);
                ReaderKit.instance().processRotation(spPr, autoShape);
                return autoShape;
            }
        }
        return null;
    }

    public static void processPictureShape(IControl control, ZipPackage zipPackage, PackagePart drawingPart, Element bgPr, Map<String, Integer> schemeColor, PictureShape shape) {
        if (shape == null) {
            return;
        }
        if (bgPr != null) {
            BackgroundAndFill fill = AutoShapeDataKit.processBackground(control, zipPackage, drawingPart, bgPr, schemeColor);
            shape.setBackgroundAndFill(fill);
            Line line = LineKit.createLine(control, zipPackage, drawingPart, bgPr.element("ln"), schemeColor);
            shape.setLine(line);
        }
    }
}

