/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.common.autoshape;

import android.graphics.Matrix;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.RectF;
import com.ahmadullahpk.alldocumentreader.xs.common.autoshape.ExtendPath;
import com.ahmadullahpk.alldocumentreader.xs.common.autoshape.pathbuilder.ArrowPathAndTail;
import com.ahmadullahpk.alldocumentreader.xs.common.autoshape.pathbuilder.LineArrowPathBuilder;
import com.ahmadullahpk.alldocumentreader.xs.common.bg.BackgroundAndFill;
import com.ahmadullahpk.alldocumentreader.xs.common.borders.Line;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.ArbitraryPolygonShape;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.Arrow;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.Element;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.Rectangle;
import java.util.List;

public class ArbitraryPolygonShapePath {
    public static void processArbitraryPolygonShape(ArbitraryPolygonShape arbitraryPolygonShape, Element sp, BackgroundAndFill fill, boolean border, BackgroundAndFill lineFill, Element ln, Rectangle rect) throws Exception {
        if (arbitraryPolygonShape == null) {
            return;
        }
        int lineWidth = 1;
        if (ln != null && ln.attributeValue("w") != null) {
            lineWidth = Math.round((float)Integer.parseInt(ln.attributeValue("w")) * 96.0f / 914400.0f);
        }
        Line line = arbitraryPolygonShape.createLine();
        line.setBackgroundAndFill(lineFill);
        line.setLineWidth(lineWidth);
        arbitraryPolygonShape.setBounds(rect);
        Element spPr = sp.element("spPr");
        List pathElements = spPr.element("custGeom").element("pathLst").elements("path");
        PointF headArrowTailCenter = null;
        PointF tailArrowTailCenter = null;
        ExtendPath pathExtend_Header = null;
        ExtendPath pathExtend_Tail = null;
        if (pathElements.size() == 1 && ln != null) {
            Path path1;
            ArrowPathAndTail arrowPathAndTail;
            Element pathElement1;
            Element temp;
            String width = ((Element)pathElements.get(0)).attributeValue("w");
            String height = ((Element)pathElements.get(0)).attributeValue("h");
            if (width != null && height != null) {
                float w = (float)Integer.parseInt(width) * 96.0f / 914400.0f;
                float h = (float)Integer.parseInt(height) * 96.0f / 914400.0f;
                lineWidth = (int)((float)lineWidth * Math.min(w / (float)rect.width, h / (float)rect.height));
            }
            if ((temp = ln.element("headEnd")) != null && temp.attribute("type") != null && !"none".equals(temp.attributeValue("type"))) {
                byte arrowType = Arrow.getArrowType(temp.attributeValue("type"));
                arbitraryPolygonShape.createStartArrow(arrowType, ArbitraryPolygonShapePath.getArrowSize(temp.attributeValue("w")), ArbitraryPolygonShapePath.getArrowSize(temp.attributeValue("len")));
                pathElement1 = (Element)pathElements.get(0);
                arrowPathAndTail = ArbitraryPolygonShapePath.getPathHeadArrowPath(arbitraryPolygonShape.getStartArrow(), lineWidth, pathElement1);
                if (arrowPathAndTail != null) {
                    path1 = arrowPathAndTail.getArrowPath();
                    headArrowTailCenter = arrowPathAndTail.getArrowTailCenter();
                    if (path1 != null) {
                        pathExtend_Header = new ExtendPath();
                        pathExtend_Header.setArrowFlag(true);
                        pathExtend_Header.setPath(path1);
                        if (fill != null || border) {
                            if (border && (pathElement1.attribute("stroke") == null || Integer.parseInt(pathElement1.attributeValue("stroke")) != 0)) {
                                if (arrowType != 5) {
                                    pathExtend_Header.setBackgroundAndFill(lineFill);
                                } else {
                                    pathExtend_Header.setLine(line);
                                }
                            } else if (fill != null) {
                                pathExtend_Header.setBackgroundAndFill(fill);
                            }
                        }
                    }
                }
            }
            if ((temp = ln.element("tailEnd")) != null && temp.attribute("type") != null && !"none".equals(temp.attributeValue("type"))) {
                byte arrowType = Arrow.getArrowType(temp.attributeValue("type"));
                arbitraryPolygonShape.createEndArrow(arrowType, ArbitraryPolygonShapePath.getArrowSize(temp.attributeValue("w")), ArbitraryPolygonShapePath.getArrowSize(temp.attributeValue("len")));
                pathElement1 = (Element)pathElements.get(0);
                arrowPathAndTail = ArbitraryPolygonShapePath.getPathTailArrowPath(arbitraryPolygonShape.getEndArrow(), lineWidth, pathElement1);
                if (arrowPathAndTail != null) {
                    path1 = arrowPathAndTail.getArrowPath();
                    tailArrowTailCenter = arrowPathAndTail.getArrowTailCenter();
                    if (path1 != null) {
                        pathExtend_Tail = new ExtendPath();
                        pathExtend_Tail.setArrowFlag(true);
                        pathExtend_Tail.setPath(path1);
                        if (fill != null || border) {
                            if (border && (pathElement1.attribute("stroke") == null || Integer.parseInt(pathElement1.attributeValue("stroke")) != 0)) {
                                if (arrowType != 5) {
                                    pathExtend_Tail.setBackgroundAndFill(lineFill);
                                } else {
                                    pathExtend_Tail.setLine(line);
                                }
                            } else if (fill != null) {
                                pathExtend_Tail.setBackgroundAndFill(fill);
                            }
                        }
                    }
                }
            }
        }
        for (int j = 0; j < pathElements.size(); ++j) {
            ExtendPath pathExtend = new ExtendPath();
            Path path = ArbitraryPolygonShapePath.getArrowPath(arbitraryPolygonShape, (Element)pathElements.get(j), rect, fill, border, headArrowTailCenter, tailArrowTailCenter);
            pathExtend.setPath(path);
            Element pathElement = (Element)pathElements.get(j);
            String width = pathElement.attributeValue("w");
            String height = pathElement.attributeValue("h");
            Matrix m = new Matrix();
            if (width != null && height != null) {
                float w = (float)Integer.parseInt(width) * 96.0f / 914400.0f;
                float h = (float)Integer.parseInt(height) * 96.0f / 914400.0f;
                m.postScale((float)rect.width / w, (float)rect.height / h);
                path.transform(m);
            }
            if (fill != null || border) {
                if (fill != null) {
                    if (pathElement.attribute("fill") != null && "none".equals(pathElement.attributeValue("fill"))) {
                        pathExtend.setBackgroundAndFill(null);
                    } else {
                        pathExtend.setBackgroundAndFill(fill);
                    }
                }
                if (border) {
                    if (pathElement.attribute("stroke") != null && Integer.parseInt(pathElement.attributeValue("stroke")) == 0) {
                        pathExtend.setLine(false);
                    } else {
                        pathExtend.setLine(line);
                    }
                }
            }
            arbitraryPolygonShape.appendPath(pathExtend);
            if (pathExtend_Header != null) {
                pathExtend_Header.getPath().transform(m);
                arbitraryPolygonShape.appendPath(pathExtend_Header);
            }
            if (pathExtend_Tail == null) continue;
            pathExtend_Tail.getPath().transform(m);
            arbitraryPolygonShape.appendPath(pathExtend_Tail);
        }
    }

    private static Path getArrowPath(ArbitraryPolygonShape arbitraryPolygonShape, Element pathElement, Rectangle rect, BackgroundAndFill fill, boolean border, PointF headerArrowTailCenter, PointF tailArrowTailCenter) {
        Path path = new Path();
        boolean pathClosed = false;
        List eleList = pathElement.elements();
        int cnt = eleList.size();
        Element e = (Element)eleList.get(cnt - 1);
        for (int i = 0; i < cnt; ++i) {
            float hR;
            e = (Element)eleList.get(i);
            if (headerArrowTailCenter != null && i == 0 && e.getName().equals("moveTo")) {
                pathClosed = false;
                headerArrowTailCenter = LineArrowPathBuilder.getReferencedPosition(e.element("pt"), headerArrowTailCenter, arbitraryPolygonShape.getStartArrowType());
                path.moveTo(headerArrowTailCenter.x, headerArrowTailCenter.y);
                continue;
            }
            if (tailArrowTailCenter != null && i == cnt - 1) {
                if (e.getName().equals("lnTo")) {
                    tailArrowTailCenter = LineArrowPathBuilder.getReferencedPosition(e.element("pt"), tailArrowTailCenter, arbitraryPolygonShape.getEndArrowType());
                    path.lineTo(tailArrowTailCenter.x, tailArrowTailCenter.y);
                    continue;
                }
                if (e.getName().equals("quadBezTo")) {
                    List ptList = e.elements();
                    if (ptList.size() != 2) break;
                    tailArrowTailCenter = LineArrowPathBuilder.getReferencedPosition((Element)ptList.get(1), tailArrowTailCenter, arbitraryPolygonShape.getEndArrowType());
                    path.quadTo((float)Integer.parseInt(((Element)ptList.get(0)).attributeValue("x")) * 96.0f / 914400.0f, (float)Integer.parseInt(((Element)ptList.get(0)).attributeValue("y")) * 96.0f / 914400.0f, tailArrowTailCenter.x, tailArrowTailCenter.y);
                    continue;
                }
                if (e.getName().equals("cubicBezTo")) {
                    List ptList = e.elements();
                    if (ptList.size() != 3) break;
                    tailArrowTailCenter = LineArrowPathBuilder.getReferencedPosition((Element)ptList.get(2), tailArrowTailCenter, arbitraryPolygonShape.getEndArrowType());
                    path.cubicTo((float)Integer.parseInt(((Element)ptList.get(0)).attributeValue("x")) * 96.0f / 914400.0f, (float)Integer.parseInt(((Element)ptList.get(0)).attributeValue("y")) * 96.0f / 914400.0f, (float)Integer.parseInt(((Element)ptList.get(1)).attributeValue("x")) * 96.0f / 914400.0f, (float)Integer.parseInt(((Element)ptList.get(1)).attributeValue("y")) * 96.0f / 914400.0f, tailArrowTailCenter.x, tailArrowTailCenter.y);
                    continue;
                }
                if (!e.getName().equals("arcTo")) continue;
                float wR = (float)Integer.parseInt(e.attributeValue("wR")) * 96.0f / 914400.0f;
                hR = (float)Integer.parseInt(e.attributeValue("hR")) * 96.0f / 914400.0f;
                path.arcTo(new RectF((float)rect.getCenterX() - wR - (float)rect.x, (float)rect.getCenterY() - hR - (float)rect.y, (float)rect.getCenterX() + wR - (float)rect.x, (float)rect.getCenterY() + hR - (float)rect.y), (float)Integer.parseInt(e.attributeValue("stAng")) / 60000.0f, (float)Integer.parseInt(e.attributeValue("swAng")) / 60000.0f);
                continue;
            }
            if (e.getName().equals("moveTo")) {
                pathClosed = false;
                e = e.element("pt");
                path.moveTo((float)Integer.parseInt(e.attributeValue("x")) * 96.0f / 914400.0f, (float)Integer.parseInt(e.attributeValue("y")) * 96.0f / 914400.0f);
                continue;
            }
            if (e.getName().equals("lnTo")) {
                e = e.element("pt");
                path.lineTo((float)Integer.parseInt(e.attributeValue("x")) * 96.0f / 914400.0f, (float)Integer.parseInt(e.attributeValue("y")) * 96.0f / 914400.0f);
                continue;
            }
            if (e.getName().equals("quadBezTo")) {
                List ptList = e.elements();
                if (ptList.size() != 2) break;
                path.quadTo((float)Integer.parseInt(((Element)ptList.get(0)).attributeValue("x")) * 96.0f / 914400.0f, (float)Integer.parseInt(((Element)ptList.get(0)).attributeValue("y")) * 96.0f / 914400.0f, (float)Integer.parseInt(((Element)ptList.get(1)).attributeValue("x")) * 96.0f / 914400.0f, (float)Integer.parseInt(((Element)ptList.get(1)).attributeValue("y")) * 96.0f / 914400.0f);
                continue;
            }
            if (e.getName().equals("cubicBezTo")) {
                List ptList = e.elements();
                if (ptList.size() != 3) break;
                path.cubicTo((float)Integer.parseInt(((Element)ptList.get(0)).attributeValue("x")) * 96.0f / 914400.0f, (float)Integer.parseInt(((Element)ptList.get(0)).attributeValue("y")) * 96.0f / 914400.0f, (float)Integer.parseInt(((Element)ptList.get(1)).attributeValue("x")) * 96.0f / 914400.0f, (float)Integer.parseInt(((Element)ptList.get(1)).attributeValue("y")) * 96.0f / 914400.0f, (float)Integer.parseInt(((Element)ptList.get(2)).attributeValue("x")) * 96.0f / 914400.0f, (float)Integer.parseInt(((Element)ptList.get(2)).attributeValue("y")) * 96.0f / 914400.0f);
                continue;
            }
            if (e.getName().equals("arcTo")) {
                float wR = (float)Integer.parseInt(e.attributeValue("wR")) * 96.0f / 914400.0f;
                hR = (float)Integer.parseInt(e.attributeValue("hR")) * 96.0f / 914400.0f;
                path.arcTo(new RectF((float)rect.getCenterX() - wR - (float)rect.x, (float)rect.getCenterY() - hR - (float)rect.y, (float)rect.getCenterX() + wR - (float)rect.x, (float)rect.getCenterY() + hR - (float)rect.y), (float)Integer.parseInt(e.attributeValue("stAng")) / 60000.0f, (float)Integer.parseInt(e.attributeValue("swAng")) / 60000.0f);
                continue;
            }
            if (!e.getName().equals("close")) continue;
            pathClosed = true;
            path.close();
        }
        return path;
    }

    public static ArrowPathAndTail getPathHeadArrowPath(Arrow arrow, int lineWidth, Element pathElement) {
        List ptList;
        List eleList = pathElement.elements();
        if (eleList == null || eleList.size() < 2) {
            return null;
        }
        Element e = ((Element)eleList.get(0)).element("pt");
        ArrowPathAndTail path = null;
        float p0X = (float)Integer.parseInt(e.attributeValue("x")) * 96.0f / 914400.0f;
        float p0Y = (float)Integer.parseInt(e.attributeValue("y")) * 96.0f / 914400.0f;
        float p1X = 0.0f;
        float p1Y = 0.0f;
        e = (Element)eleList.get(1);
        if (e.getName().equals("lnTo")) {
            e = e.element("pt");
            p1X = (float)Integer.parseInt(e.attributeValue("x")) * 96.0f / 914400.0f;
            p1Y = (float)Integer.parseInt(e.attributeValue("y")) * 96.0f / 914400.0f;
            path = LineArrowPathBuilder.getDirectLineArrowPath(p1X, p1Y, p0X, p0Y, arrow, lineWidth);
        } else if (e.getName().equals("quadBezTo")) {
            List ptList2 = e.elements();
            if (ptList2.size() == 2) {
                float ctrX1 = (float)Integer.parseInt(((Element)ptList2.get(0)).attributeValue("x")) * 96.0f / 914400.0f;
                float ctrY1 = (float)Integer.parseInt(((Element)ptList2.get(0)).attributeValue("y")) * 96.0f / 914400.0f;
                p1X = (float)Integer.parseInt(((Element)ptList2.get(1)).attributeValue("x")) * 96.0f / 914400.0f;
                p1Y = (float)Integer.parseInt(((Element)ptList2.get(1)).attributeValue("y")) * 96.0f / 914400.0f;
                path = LineArrowPathBuilder.getQuadBezArrowPath(p1X, p1Y, ctrX1, ctrY1, p0X, p0Y, arrow, lineWidth);
            }
        } else if (e.getName().equals("cubicBezTo") && (ptList = e.elements()).size() == 3) {
            float ctrX1 = (float)Integer.parseInt(((Element)ptList.get(0)).attributeValue("x")) * 96.0f / 914400.0f;
            float ctrY1 = (float)Integer.parseInt(((Element)ptList.get(0)).attributeValue("y")) * 96.0f / 914400.0f;
            float ctrX2 = (float)Integer.parseInt(((Element)ptList.get(1)).attributeValue("x")) * 96.0f / 914400.0f;
            float ctrY2 = (float)Integer.parseInt(((Element)ptList.get(1)).attributeValue("y")) * 96.0f / 914400.0f;
            p1X = (float)Integer.parseInt(((Element)ptList.get(2)).attributeValue("x")) * 96.0f / 914400.0f;
            p1Y = (float)Integer.parseInt(((Element)ptList.get(2)).attributeValue("y")) * 96.0f / 914400.0f;
            path = LineArrowPathBuilder.getCubicBezArrowPath(p1X, p1Y, ctrX2, ctrY2, ctrX1, ctrY1, p0X, p0Y, arrow, lineWidth);
        }
        return path;
    }

    public static ArrowPathAndTail getPathTailArrowPath(Arrow arrow, int lineWidth, Element pathElement) {
        List ptList;
        List ptList2;
        List eleList = pathElement.elements();
        ArrowPathAndTail arrowPathAndTail = null;
        int cnt = 0;
        if (eleList == null || (cnt = eleList.size()) < 2 || ((Element)eleList.get(cnt - 1)).getName().equals("close")) {
            return null;
        }
        Element e = (Element)eleList.get(cnt - 2);
        float p0X = 0.0f;
        float p0Y = 0.0f;
        if (e.getName().equals("lnTo")) {
            e = e.element("pt");
            p0X = (float)Integer.parseInt(e.attributeValue("x")) * 96.0f / 914400.0f;
            p0Y = (float)Integer.parseInt(e.attributeValue("y")) * 96.0f / 914400.0f;
        } else if (e.getName().equals("quadBezTo")) {
            ptList2 = e.elements();
            if (ptList2.size() == 2) {
                p0X = (float)Integer.parseInt(((Element)ptList2.get(1)).attributeValue("x")) * 96.0f / 914400.0f;
                p0Y = (float)Integer.parseInt(((Element)ptList2.get(1)).attributeValue("y")) * 96.0f / 914400.0f;
            }
        } else if (e.getName().equals("cubicBezTo") && (ptList2 = e.elements()).size() == 3) {
            p0X = (float)Integer.parseInt(((Element)ptList2.get(2)).attributeValue("x")) * 96.0f / 914400.0f;
            p0Y = (float)Integer.parseInt(((Element)ptList2.get(2)).attributeValue("y")) * 96.0f / 914400.0f;
        }
        e = (Element)eleList.get(cnt - 1);
        float p1X = 0.0f;
        float p1Y = 0.0f;
        if (e.getName().equals("lnTo")) {
            e = e.element("pt");
            p1X = (float)Integer.parseInt(e.attributeValue("x")) * 96.0f / 914400.0f;
            p1Y = (float)Integer.parseInt(e.attributeValue("y")) * 96.0f / 914400.0f;
            arrowPathAndTail = LineArrowPathBuilder.getDirectLineArrowPath(p0X, p0Y, p1X, p1Y, arrow, lineWidth);
        } else if (e.getName().equals("quadBezTo")) {
            List ptList3 = e.elements();
            if (ptList3.size() == 2) {
                float ctrX1 = (float)Integer.parseInt(((Element)ptList3.get(0)).attributeValue("x")) * 96.0f / 914400.0f;
                float ctrY1 = (float)Integer.parseInt(((Element)ptList3.get(0)).attributeValue("y")) * 96.0f / 914400.0f;
                p1X = (float)Integer.parseInt(((Element)ptList3.get(1)).attributeValue("x")) * 96.0f / 914400.0f;
                p1Y = (float)Integer.parseInt(((Element)ptList3.get(1)).attributeValue("y")) * 96.0f / 914400.0f;
                arrowPathAndTail = LineArrowPathBuilder.getQuadBezArrowPath(p0X, p0Y, ctrX1, ctrY1, p1X, p1Y, arrow, lineWidth);
            }
        } else if (e.getName().equals("cubicBezTo") && (ptList = e.elements()).size() == 3) {
            float ctrX1 = (float)Integer.parseInt(((Element)ptList.get(0)).attributeValue("x")) * 96.0f / 914400.0f;
            float ctrY1 = (float)Integer.parseInt(((Element)ptList.get(0)).attributeValue("y")) * 96.0f / 914400.0f;
            float ctrX2 = (float)Integer.parseInt(((Element)ptList.get(1)).attributeValue("x")) * 96.0f / 914400.0f;
            float ctrY2 = (float)Integer.parseInt(((Element)ptList.get(1)).attributeValue("y")) * 96.0f / 914400.0f;
            p1X = (float)Integer.parseInt(((Element)ptList.get(2)).attributeValue("x")) * 96.0f / 914400.0f;
            p1Y = (float)Integer.parseInt(((Element)ptList.get(2)).attributeValue("y")) * 96.0f / 914400.0f;
            arrowPathAndTail = LineArrowPathBuilder.getCubicBezArrowPath(p0X, p0Y, ctrX1, ctrY1, ctrX2, ctrY2, p1X, p1Y, arrow, lineWidth);
        }
        return arrowPathAndTail;
    }

    public static int getArrowSize(String size) {
        if (size == null || size.equals("med")) {
            return 1;
        }
        if (size.equals("sm")) {
            return 0;
        }
        if (size.equals("lg")) {
            return 2;
        }
        return 1;
    }
}

