/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.widgets.textAnimation;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewTreeObserver;
import androidx.core.view.ViewCompat;
import com.ahmadullahpk.alldocumentreader.widgets.textAnimation.AnimationListener;
import com.ahmadullahpk.alldocumentreader.widgets.textAnimation.HTextView;
import com.ahmadullahpk.alldocumentreader.widgets.textAnimation.IHText;
import java.util.ArrayList;
import java.util.List;

public abstract class HText
implements IHText {
    protected AnimationListener animationListener;
    protected List<Float> gapList = new ArrayList<Float>();
    protected HTextView mHTextView;
    protected int mHeight;
    protected TextPaint mOldPaint;
    protected CharSequence mOldText;
    protected TextPaint mPaint;
    protected CharSequence mText;
    protected float mTextSize;
    protected int mWidth;
    protected List<Float> oldGapList = new ArrayList<Float>();
    protected float oldStartX = 0.0f;
    protected float progress;

    protected abstract void animatePrepare(CharSequence var1);

    protected abstract void animateStart(CharSequence var1);

    protected abstract void drawFrame(Canvas var1);

    protected abstract void initVariables();

    public void setProgress(float f) {
        this.progress = f;
        this.mHTextView.invalidate();
    }

    @Override
    public void init(HTextView hTextView, AttributeSet attributeSet, int i) {
        this.mHTextView = hTextView;
        this.mOldText = "";
        this.mText = hTextView.getText();
        this.progress = 1.0f;
        this.mPaint = new TextPaint(1);
        this.mOldPaint = new TextPaint((Paint)this.mPaint);
        this.mHTextView.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                HText.this.mHTextView.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                HText hText = HText.this;
                hText.mTextSize = hText.mHTextView.getTextSize();
                HText hText2 = HText.this;
                hText2.mWidth = hText2.mHTextView.getWidth();
                HText hText3 = HText.this;
                hText3.mHeight = hText3.mHTextView.getHeight();
                HText.this.oldStartX = 0.0f;
                try {
                    int layoutDirection = ViewCompat.getLayoutDirection((View)HText.this.mHTextView);
                    HText hText4 = HText.this;
                    float f = layoutDirection == 0 ? HText.this.mHTextView.getLayout().getLineLeft(0) : HText.this.mHTextView.getLayout().getLineRight(0);
                    hText4.oldStartX = f;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                HText.this.initVariables();
            }
        });
        this.prepareAnimate();
    }

    private void prepareAnimate() {
        float textSize;
        this.mTextSize = textSize = this.mHTextView.getTextSize();
        this.mPaint.setTextSize(textSize);
        this.mPaint.setColor(this.mHTextView.getCurrentTextColor());
        this.mPaint.setTypeface(this.mHTextView.getTypeface());
        this.gapList.clear();
        for (int i = 0; i < this.mText.length(); ++i) {
            this.gapList.add(Float.valueOf(this.mPaint.measureText(String.valueOf(this.mText.charAt(i)))));
        }
        this.mOldPaint.setTextSize(this.mTextSize);
        this.mOldPaint.setColor(this.mHTextView.getCurrentTextColor());
        this.oldGapList.clear();
        for (int i2 = 0; i2 < this.mOldText.length(); ++i2) {
            this.oldGapList.add(Float.valueOf(this.mOldPaint.measureText(String.valueOf(this.mOldText.charAt(i2)))));
        }
    }

    @Override
    public void animateText(CharSequence charSequence) {
        this.mHTextView.setText(charSequence);
        this.mOldText = this.mText;
        this.mText = charSequence;
        this.prepareAnimate();
        this.animatePrepare(charSequence);
        this.animateStart(charSequence);
    }

    @Override
    public void setAnimationListener(AnimationListener animationListener2) {
        this.animationListener = animationListener2;
    }

    @Override
    public void onDraw(Canvas canvas) {
        this.drawFrame(canvas);
    }
}

