/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.widgets.tableview.listener.itemclick;

import android.view.MotionEvent;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.ahmadullahpk.alldocumentreader.widgets.tableview.ITableView;
import com.ahmadullahpk.alldocumentreader.widgets.tableview.adapter.recyclerview.CellRecyclerView;
import com.ahmadullahpk.alldocumentreader.widgets.tableview.adapter.recyclerview.holder.AbstractViewHolder;
import com.ahmadullahpk.alldocumentreader.widgets.tableview.listener.itemclick.AbstractItemClickListener;

public class RowHeaderRecyclerViewItemClickListener
extends AbstractItemClickListener {
    public RowHeaderRecyclerViewItemClickListener(@NonNull CellRecyclerView recyclerView, @NonNull ITableView tableView) {
        super(recyclerView, tableView);
    }

    @Override
    protected boolean clickAction(@NonNull RecyclerView view, @NonNull MotionEvent e) {
        View childView = view.findChildViewUnder(e.getX(), e.getY());
        if (childView != null) {
            AbstractViewHolder holder = (AbstractViewHolder)this.mRecyclerView.getChildViewHolder(childView);
            int row = holder.getAdapterPosition();
            if (!this.mTableView.isIgnoreSelectionColors()) {
                this.mSelectionHandler.setSelectedRowPosition(holder, row);
            }
            this.getTableViewListener().onRowHeaderClicked(holder, row);
            return true;
        }
        return false;
    }

    @Override
    protected void longPressAction(@NonNull MotionEvent e) {
        if (this.mRecyclerView.getScrollState() != 0) {
            return;
        }
        View child = this.mRecyclerView.findChildViewUnder(e.getX(), e.getY());
        if (child != null) {
            RecyclerView.ViewHolder holder = this.mRecyclerView.getChildViewHolder(child);
            this.getTableViewListener().onRowHeaderLongPressed(holder, holder.getAdapterPosition());
        }
    }

    @Override
    protected boolean doubleClickAction(@NonNull MotionEvent e) {
        View childView = this.mRecyclerView.findChildViewUnder(e.getX(), e.getY());
        if (childView != null) {
            AbstractViewHolder holder = (AbstractViewHolder)this.mRecyclerView.getChildViewHolder(childView);
            int row = holder.getAdapterPosition();
            if (!this.mTableView.isIgnoreSelectionColors()) {
                this.mSelectionHandler.setSelectedRowPosition(holder, row);
            }
            this.getTableViewListener().onRowHeaderDoubleClicked(holder, row);
            return true;
        }
        return false;
    }
}

