/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.widgets.tableview.adapter.recyclerview;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;
import com.ahmadullahpk.alldocumentreader.widgets.tableview.adapter.recyclerview.holder.AbstractViewHolder;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractRecyclerViewAdapter<T>
extends RecyclerView.Adapter<AbstractViewHolder> {
    @NonNull
    protected List<T> mItemList;
    @NonNull
    protected Context mContext;

    public AbstractRecyclerViewAdapter(@NonNull Context context) {
        this(context, null);
    }

    public AbstractRecyclerViewAdapter(@NonNull Context context, @Nullable List<T> itemList) {
        this.mContext = context;
        if (itemList == null) {
            this.mItemList = new ArrayList<T>();
        } else {
            this.setItems(itemList);
        }
    }

    public int getItemCount() {
        return this.mItemList.size();
    }

    @NonNull
    public List<T> getItems() {
        return this.mItemList;
    }

    public void setItems(@NonNull List<T> itemList) {
        this.mItemList = new ArrayList<T>(itemList);
        this.notifyDataSetChanged();
    }

    public void setItems(@NonNull List<T> itemList, boolean notifyDataSet) {
        this.mItemList = new ArrayList<T>(itemList);
        if (notifyDataSet) {
            this.notifyDataSetChanged();
        }
    }

    @Nullable
    public T getItem(int position) {
        if (this.mItemList.isEmpty() || position < 0 || position >= this.mItemList.size()) {
            return null;
        }
        return this.mItemList.get(position);
    }

    public void deleteItem(int position) {
        if (position != -1) {
            this.mItemList.remove(position);
            this.notifyItemRemoved(position);
        }
    }

    public void deleteItemRange(int positionStart, int itemCount) {
        for (int i = positionStart + itemCount - 1; i >= positionStart; --i) {
            if (i == -1) continue;
            this.mItemList.remove(i);
        }
        this.notifyItemRangeRemoved(positionStart, itemCount);
    }

    public void addItem(int position, @Nullable T item) {
        if (position != -1 && item != null) {
            this.mItemList.add(position, item);
            this.notifyItemInserted(position);
        }
    }

    public void addItemRange(int positionStart, @Nullable List<T> items) {
        if (items != null) {
            for (int i = 0; i < items.size(); ++i) {
                this.mItemList.add(i + positionStart, items.get(i));
            }
            this.notifyItemRangeInserted(positionStart, items.size());
        }
    }

    public void changeItem(int position, @Nullable T item) {
        if (position != -1 && item != null) {
            this.mItemList.set(position, item);
            this.notifyItemChanged(position);
        }
    }

    public void changeItemRange(int positionStart, @Nullable List<T> items) {
        if (items != null && this.mItemList.size() > positionStart + items.size()) {
            for (int i = 0; i < items.size(); ++i) {
                this.mItemList.set(i + positionStart, items.get(i));
            }
            this.notifyItemRangeChanged(positionStart, items.size());
        }
    }

    public int getItemViewType(int position) {
        return 1;
    }
}

