/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.widgets.mricheditor;

import android.text.TextUtils;
import android.webkit.JavascriptInterface;
import com.ahmadullahpk.alldocumentreader.widgets.mricheditor.ActionType;
import com.ahmadullahpk.alldocumentreader.widgets.mricheditor.FontStyle;
import com.google.gson.Gson;
import java.util.Arrays;
import java.util.List;

public abstract class RichEditorCallback {
    private Gson gson = new Gson();
    private FontStyle mFontStyle = new FontStyle();
    private String html;
    private OnGetHtmlListener onGetHtmlListener;
    private List<ActionType> mFontBlockGroup = Arrays.asList(ActionType.NORMAL, ActionType.H1, ActionType.H2, ActionType.H3, ActionType.H4, ActionType.H5, ActionType.H6);
    private List<ActionType> mTextAlignGroup = Arrays.asList(ActionType.JUSTIFY_LEFT, ActionType.JUSTIFY_CENTER, ActionType.JUSTIFY_RIGHT, ActionType.JUSTIFY_FULL);
    private List<ActionType> mListStyleGroup = Arrays.asList(ActionType.ORDERED, ActionType.UNORDERED);

    @JavascriptInterface
    public void returnHtml(String html) {
        this.html = html;
        if (this.onGetHtmlListener != null) {
            this.onGetHtmlListener.getHtml(html);
        }
    }

    @JavascriptInterface
    public void updateCurrentStyle(String currentStyle) {
        FontStyle fontStyle = (FontStyle)this.gson.fromJson(currentStyle, FontStyle.class);
        if (fontStyle != null) {
            this.updateStyle(fontStyle);
        }
    }

    private void updateStyle(FontStyle fontStyle) {
        ActionType type;
        int size;
        if (!(this.mFontStyle.getFontFamily() != null && this.mFontStyle.getFontFamily().equals(fontStyle.getFontFamily()) || TextUtils.isEmpty((CharSequence)fontStyle.getFontFamily()))) {
            String font = fontStyle.getFontFamily().split(",")[0].replace("\"", "");
            this.notifyFontStyleChange(ActionType.FAMILY, font);
        }
        if (!(this.mFontStyle.getFontForeColor() != null && this.mFontStyle.getFontForeColor().equals(fontStyle.getFontForeColor()) || TextUtils.isEmpty((CharSequence)fontStyle.getFontForeColor()))) {
            this.notifyFontStyleChange(ActionType.FORE_COLOR, fontStyle.getFontForeColor());
        }
        if (!(this.mFontStyle.getFontBackColor() != null && this.mFontStyle.getFontBackColor().equals(fontStyle.getFontBackColor()) || TextUtils.isEmpty((CharSequence)fontStyle.getFontBackColor()))) {
            this.notifyFontStyleChange(ActionType.BACK_COLOR, fontStyle.getFontBackColor());
        }
        if (this.mFontStyle.getFontSize() != fontStyle.getFontSize()) {
            this.notifyFontStyleChange(ActionType.SIZE, String.valueOf(fontStyle.getFontSize()));
        }
        if (this.mFontStyle.getTextAlign() != fontStyle.getTextAlign()) {
            size = this.mTextAlignGroup.size();
            for (int i = 0; i < size; ++i) {
                this.notifyFontStyleChange(type, String.valueOf((type = this.mTextAlignGroup.get(i)) == fontStyle.getTextAlign()));
            }
        }
        if (this.mFontStyle.getLineHeight() != fontStyle.getLineHeight()) {
            this.notifyFontStyleChange(ActionType.LINE_HEIGHT, String.valueOf(fontStyle.getLineHeight()));
        }
        if (this.mFontStyle.isBold() != fontStyle.isBold()) {
            this.notifyFontStyleChange(ActionType.BOLD, String.valueOf(fontStyle.isBold()));
        }
        if (this.mFontStyle.isItalic() != fontStyle.isItalic()) {
            this.notifyFontStyleChange(ActionType.ITALIC, String.valueOf(fontStyle.isItalic()));
        }
        if (this.mFontStyle.isUnderline() != fontStyle.isUnderline()) {
            this.notifyFontStyleChange(ActionType.UNDERLINE, String.valueOf(fontStyle.isUnderline()));
        }
        if (this.mFontStyle.isSubscript() != fontStyle.isSubscript()) {
            this.notifyFontStyleChange(ActionType.SUBSCRIPT, String.valueOf(fontStyle.isSubscript()));
        }
        if (this.mFontStyle.isSuperscript() != fontStyle.isSuperscript()) {
            this.notifyFontStyleChange(ActionType.SUPERSCRIPT, String.valueOf(fontStyle.isSuperscript()));
        }
        if (this.mFontStyle.isStrikethrough() != fontStyle.isStrikethrough()) {
            this.notifyFontStyleChange(ActionType.STRIKETHROUGH, String.valueOf(fontStyle.isStrikethrough()));
        }
        if (this.mFontStyle.getFontBlock() != fontStyle.getFontBlock()) {
            size = this.mFontBlockGroup.size();
            for (int i = 0; i < size; ++i) {
                this.notifyFontStyleChange(type, String.valueOf((type = this.mFontBlockGroup.get(i)) == fontStyle.getFontBlock()));
            }
        }
        if (this.mFontStyle.getListStyle() != fontStyle.getListStyle()) {
            size = this.mListStyleGroup.size();
            for (int i = 0; i < size; ++i) {
                this.notifyFontStyleChange(type, String.valueOf((type = this.mListStyleGroup.get(i)) == fontStyle.getListStyle()));
            }
        }
        this.mFontStyle = fontStyle;
    }

    public abstract void notifyFontStyleChange(ActionType var1, String var2);

    public OnGetHtmlListener getOnGetHtmlListener() {
        return this.onGetHtmlListener;
    }

    public void setOnGetHtmlListener(OnGetHtmlListener onGetHtmlListener) {
        this.onGetHtmlListener = onGetHtmlListener;
    }

    public static interface OnGetHtmlListener {
        public void getHtml(String var1);
    }
}

