/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.widgets.mricheditor;

import android.os.Build;
import android.webkit.WebView;
import androidx.annotation.NonNull;
import com.ahmadullahpk.alldocumentreader.widgets.mricheditor.RichEditorCallback;

public class RichEditorAction {
    private WebView mWebView;

    public RichEditorAction(WebView webView) {
        this.mWebView = webView;
    }

    public void undo() {
        this.load("javascript:undo()");
    }

    public void redo() {
        this.load("javascript:redo()");
    }

    public void focus() {
        this.load("javascript:focus()");
    }

    public void disable() {
        this.load("javascript:disable()");
    }

    public void enable() {
        this.load("javascript:enable()");
    }

    public void bold() {
        this.load("javascript:bold()");
    }

    public void italic() {
        this.load("javascript:italic()");
    }

    public void underline() {
        this.load("javascript:underline()");
    }

    public void strikethrough() {
        this.load("javascript:strikethrough()");
    }

    public void superscript() {
        this.load("javascript:superscript()");
    }

    public void subscript() {
        this.load("javascript:subscript()");
    }

    public void backColor(String color2) {
        this.load("javascript:backColor('" + color2 + "')");
    }

    public void foreColor(String color2) {
        this.load("javascript:foreColor('" + color2 + "')");
    }

    public void fontName(String fontName) {
        this.load("javascript:fontName('" + fontName + "')");
    }

    public void fontSize(double foreSize) {
        this.load("javascript:fontSize(" + foreSize + ")");
    }

    public void justifyLeft() {
        this.load("javascript:justifyLeft()");
    }

    public void justifyRight() {
        this.load("javascript:justifyRight()");
    }

    public void justifyCenter() {
        this.load("javascript:justifyCenter()");
    }

    public void justifyFull() {
        this.load("javascript:justifyFull()");
    }

    public void insertOrderedList() {
        this.load("javascript:insertOrderedList()");
    }

    public void insertUnorderedList() {
        this.load("javascript:insertUnorderedList()");
    }

    public void indent() {
        this.load("javascript:indent()");
    }

    public void outdent() {
        this.load("javascript:outdent()");
    }

    public void formatPara() {
        this.load("javascript:formatPara()");
    }

    public void formatH1() {
        this.load("javascript:formatH1()");
    }

    public void formatH2() {
        this.load("javascript:formatH2()");
    }

    public void formatH3() {
        this.load("javascript:formatH3()");
    }

    public void formatH4() {
        this.load("javascript:formatH4()");
    }

    public void formatH5() {
        this.load("javascript:formatH5()");
    }

    public void formatH6() {
        this.load("javascript:formatH6()");
    }

    public void lineHeight(double lineHeight) {
        this.load("javascript:lineHeight(" + lineHeight + ")");
    }

    public void insertImageUrl(String imageUrl) {
        this.load("javascript:insertImageUrl('" + imageUrl + "')");
    }

    public void insertImageData(String fileName, String base64Str) {
        String imageUrl = "data:image/" + fileName.split("\\.")[1] + ";base64," + base64Str;
        this.load("javascript:insertImageUrl('" + imageUrl + "')");
    }

    public void insertText(String text) {
        this.load("javascript:insertText('" + text + "')");
    }

    public void createLink(String linkText, String linkUrl) {
        this.load("javascript:createLink('" + linkText + "','" + linkUrl + "')");
    }

    public void unlink() {
        this.load("javascript:unlink()");
    }

    public void codeView() {
        this.load("javascript:codeView()");
    }

    public void insertTable(int colCount, int rowCount) {
        this.load("javascript:insertTable('" + colCount + "x" + rowCount + "')");
    }

    public void insertHorizontalRule() {
        this.load("javascript:insertHorizontalRule()");
    }

    public void formatBlockquote() {
        this.load("javascript:formatBlock('blockquote')");
    }

    public void formatBlockCode() {
        this.load("javascript:formatBlock('pre')");
    }

    public void insertHtml(String html) {
        this.load("javascript:pasteHTML('" + html + "')");
    }

    public void refreshHtml(@NonNull RichEditorCallback callback, @NonNull RichEditorCallback.OnGetHtmlListener onGetHtmlListener) {
        callback.setOnGetHtmlListener(onGetHtmlListener);
        this.load("javascript:refreshHTML()");
    }

    private void load(String trigger) {
        if (Build.VERSION.SDK_INT >= 19) {
            this.mWebView.evaluateJavascript(trigger, null);
        } else {
            this.mWebView.loadUrl(trigger);
        }
    }
}

