/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.widgets.mricheditor;

import android.text.TextUtils;
import com.ahmadullahpk.alldocumentreader.widgets.mricheditor.ActionType;
import com.google.gson.annotations.SerializedName;
import java.util.List;

public class FontStyle {
    @SerializedName(value="font-family")
    private String fontFamily;
    @SerializedName(value="font-size")
    private int fontSize;
    @SerializedName(value="font-backColor")
    private String fontBackColor;
    @SerializedName(value="font-foreColor")
    private String fontForeColor;
    @SerializedName(value="text-align")
    private String textAlign;
    @SerializedName(value="list-style-type")
    private String listStyleType;
    @SerializedName(value="line-height")
    private String lineHeight;
    @SerializedName(value="font-bold")
    private String fontBold;
    @SerializedName(value="font-italic")
    private String fontItalic;
    @SerializedName(value="font-underline")
    private String fontUnderline;
    @SerializedName(value="font-subscript")
    private String fontSubscript;
    @SerializedName(value="font-superscript")
    private String fontSuperscript;
    @SerializedName(value="font-strikethrough")
    private String fontStrikethrough;
    @SerializedName(value="font-block")
    private String fontBlock;
    @SerializedName(value="list-style")
    private String listStyle;
    private boolean anchor;
    private RangeBean range;
    private List<AncestorsBean> ancestors;

    public String getFontFamily() {
        return this.fontFamily;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public ActionType getTextAlign() {
        if (TextUtils.isEmpty((CharSequence)this.textAlign)) {
            return null;
        }
        return switch (this.textAlign) {
            case "left" -> ActionType.JUSTIFY_LEFT;
            case "center" -> ActionType.JUSTIFY_CENTER;
            case "right" -> ActionType.JUSTIFY_RIGHT;
            case "justify" -> ActionType.JUSTIFY_FULL;
            default -> ActionType.JUSTIFY_FULL;
        };
    }

    public String getListStyleType() {
        return this.listStyleType;
    }

    public double getLineHeight() {
        double height = 0.0;
        if (TextUtils.isEmpty((CharSequence)this.lineHeight)) {
            return height;
        }
        try {
            height = Double.parseDouble(this.lineHeight);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return height;
    }

    public ActionType getFontBlock() {
        ActionType type = ActionType.NONE;
        if (TextUtils.isEmpty((CharSequence)this.fontBlock)) {
            return type;
        }
        if ("p".equals(this.fontBlock)) {
            type = ActionType.NORMAL;
        } else if ("h1".equals(this.fontBlock)) {
            type = ActionType.H1;
        } else if ("h2".equals(this.fontBlock)) {
            type = ActionType.H2;
        } else if ("h3".equals(this.fontBlock)) {
            type = ActionType.H3;
        } else if ("h4".equals(this.fontBlock)) {
            type = ActionType.H4;
        } else if ("h5".equals(this.fontBlock)) {
            type = ActionType.H5;
        } else if ("h6".equals(this.fontBlock)) {
            type = ActionType.H6;
        }
        return type;
    }

    public String getFontBackColor() {
        return this.fontBackColor;
    }

    public String getFontForeColor() {
        return this.fontForeColor;
    }

    public boolean isBold() {
        return "bold".equals(this.fontBold);
    }

    public boolean isItalic() {
        return "italic".equals(this.fontItalic);
    }

    public boolean isUnderline() {
        return "underline".equals(this.fontUnderline);
    }

    public boolean isSubscript() {
        return "subscript".equals(this.fontSubscript);
    }

    public boolean isSuperscript() {
        return "superscript".equals(this.fontSuperscript);
    }

    public boolean isStrikethrough() {
        return "strikethrough".equals(this.fontStrikethrough);
    }

    public ActionType getListStyle() {
        if (TextUtils.isEmpty((CharSequence)this.listStyle)) {
            return null;
        }
        ActionType type = "ordered".equals(this.listStyle) ? ActionType.ORDERED : ("unordered".equals(this.listStyle) ? ActionType.UNORDERED : ActionType.NONE);
        return type;
    }

    public boolean isAnchor() {
        return this.anchor;
    }

    public RangeBean getRange() {
        return this.range;
    }

    public List<AncestorsBean> getAncestors() {
        return this.ancestors;
    }

    public static class RangeBean {
        private ScBean sc;
        private int so;
        private EcBean ec;
        private int eo;

        public ScBean getSc() {
            return this.sc;
        }

        public void setSc(ScBean sc) {
            this.sc = sc;
        }

        public int getSo() {
            return this.so;
        }

        public void setSo(int so) {
            this.so = so;
        }

        public EcBean getEc() {
            return this.ec;
        }

        public void setEc(EcBean ec) {
            this.ec = ec;
        }

        public int getEo() {
            return this.eo;
        }

        public void setEo(int eo) {
            this.eo = eo;
        }

        public static class ScBean {
        }

        public static class EcBean {
        }
    }

    public static class AncestorsBean {
    }
}

