/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.util;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Shader;
import android.graphics.Xfermode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007\u00a8\u0006\t"}, d2={"Lcom/ahmadullahpk/alldocumentreader/util/ImageBitmaps;", "", "()V", "setBitmapGradient", "Landroid/graphics/Bitmap;", "bitmap", "startColor", "", "endColor", "documents-reader-lib_release"})
public final class ImageBitmaps {
    @NotNull
    public static final ImageBitmaps INSTANCE = new ImageBitmaps();

    private ImageBitmaps() {
    }

    @NotNull
    public final Bitmap setBitmapGradient(@NotNull Bitmap bitmap, int startColor, int endColor) {
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        Bitmap createBitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(createBitmap);
        canvas.drawBitmap(bitmap, Float.intBitsToFloat(1), Float.intBitsToFloat(1), null);
        Paint paint = new Paint();
        float f = width;
        LinearGradient linearGradient = new LinearGradient(Float.intBitsToFloat(1), Float.intBitsToFloat(1), f, Float.intBitsToFloat(1), startColor, endColor, Shader.TileMode.CLAMP);
        paint.setShader((Shader)linearGradient);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawRect(Float.intBitsToFloat(1), Float.intBitsToFloat(1), f, (float)height, paint);
        Intrinsics.checkNotNullExpressionValue((Object)createBitmap, (String)"createBitmap");
        return createBitmap;
    }
}

