/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.activity;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Parcelable;
import android.print.PrintAttributes;
import android.print.PrintDocumentAdapter;
import android.print.PrintJob;
import android.print.PrintManager;
import android.view.View;
import android.webkit.WebView;
import android.widget.RelativeLayout;
import android.widget.Toast;
import androidx.annotation.RequiresApi;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.app.AppCompatDelegate;
import com.ahmadullahpk.alldocumentreader.R;
import com.ahmadullahpk.alldocumentreader.databinding.ActivityViewRtfBinding;
import com.ahmadullahpk.alldocumentreader.util.RtfHtmlDataType;
import com.ahmadullahpk.alldocumentreader.util.RtfParseException;
import com.ahmadullahpk.alldocumentreader.util.RtfReader;
import com.ahmadullahpk.alldocumentreader.util.Utility;
import java.io.File;

public class ViewRtf_Activity
extends AppCompatActivity {
    ActivityViewRtfBinding binding;
    private String fileName;
    private String filePath;
    Boolean fromConverterApp = false;
    boolean isExit = false;
    boolean isFromAppActivity = false;
    PrintDocumentAdapter printAdapter;
    PrintJob printJob;
    WebView webview;
    private boolean back = false;

    protected void onCreate(Bundle savedInstanceState) {
        WebView webView;
        super.onCreate(savedInstanceState);
        try {
            AppCompatDelegate.setDefaultNightMode((int)1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.binding = ActivityViewRtfBinding.inflate(this.getLayoutInflater());
        RelativeLayout view = this.binding.getRoot();
        this.setContentView((View)view);
        this.binding.imgBack.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ViewRtf_Activity.this.onBackPressed();
            }
        });
        this.binding.imgShare.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ViewRtf_Activity.this.shareFile();
            }
        });
        this.binding.imgPrint.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ViewRtf_Activity.this.printAndShare();
            }
        });
        if (this.getIntent() != null) {
            this.filePath = this.getIntent().getStringExtra("path");
            this.fileName = this.getIntent().getStringExtra("name");
            this.isFromAppActivity = this.getIntent().getBooleanExtra("fromAppActivity", false);
            this.fromConverterApp = this.getIntent().getBooleanExtra("fromConverterApp", false);
            this.binding.headerTitleText.setMaxLines(1);
            this.binding.headerTitleText.setText((CharSequence)this.fileName);
        }
        this.webview = webView = (WebView)this.findViewById(R.id.webView);
        webView.setWebViewClient((android.webkit.WebViewClient)new WebViewClient());
        this.webview.getSettings().setBuiltInZoomControls(true);
        this.webview.getSettings().setDisplayZoomControls(false);
        this.webview.getSettings().setAllowFileAccess(true);
        new loadTextFromRtfFile().execute(new Void[0]);
    }

    @RequiresApi(api=19)
    private void createWebPrintJob(WebView webView) {
        PrintManager printManager = (PrintManager)this.getSystemService("print");
        this.printAdapter = webView.createPrintDocumentAdapter("New_RTF_File.pdf");
        this.printJob = printManager.print(this.getString(R.string.app_name) + " Document", this.printAdapter, new PrintAttributes.Builder().setMediaSize(PrintAttributes.MediaSize.ISO_A4).setResolution(new PrintAttributes.Resolution("id", "print", 200, 200)).setColorMode(2).setMinMargins(PrintAttributes.Margins.NO_MARGINS).build());
    }

    private void shareFile() {
        Intent intent = new Intent("android.intent.action.SEND");
        Uri parse = Uri.parse((String)this.filePath);
        intent.setType("*/*");
        intent.putExtra("android.intent.extra.STREAM", (Parcelable)parse);
        this.startActivity(Intent.createChooser((Intent)intent, (CharSequence)"Share File"));
    }

    private void printAndShare() {
        this.createWebPrintJob(this.webview);
    }

    public void onBackPressed() {
        if (this.back) {
            this.finish();
        } else {
            Toast.makeText((Context)this, (CharSequence)"Please wait while task complete", (int)0).show();
        }
    }

    public class WebViewClient
    extends android.webkit.WebViewClient {
        public void onPageStarted(WebView webView, String str, Bitmap bitmap) {
            super.onPageStarted(webView, str, bitmap);
        }

        public boolean shouldOverrideUrlLoading(WebView webView, String str) {
            webView.loadUrl(str);
            return true;
        }

        public void onPageFinished(WebView webView, String str) {
            super.onPageFinished(webView, str);
            ViewRtf_Activity.this.findViewById(R.id.progressBar).setVisibility(8);
        }
    }

    class loadTextFromRtfFile
    extends AsyncTask<Void, Void, Void> {
        String html;

        loadTextFromRtfFile() {
        }

        protected void onPreExecute() {
            super.onPreExecute();
        }

        @RequiresApi(api=24)
        protected Void doInBackground(Void ... voidArr) {
            ViewRtf_Activity.this.back = false;
            File file = new File(ViewRtf_Activity.this.filePath);
            RtfReader rtfReader = new RtfReader();
            RtfHtmlDataType rtfHtmlDataType = new RtfHtmlDataType();
            try {
                rtfReader.parse(file);
                this.html = rtfHtmlDataType.format(rtfReader.root, true);
                System.out.println();
                return null;
            }
            catch (RtfParseException e) {
                Utility.logCatMsg("RtfParseException " + e.getMessage());
                e.printStackTrace();
                return null;
            }
        }

        protected void onPostExecute(Void voidR) {
            super.onPostExecute((Object)voidR);
            ViewRtf_Activity.this.back = true;
            ViewRtf_Activity.this.webview.loadDataWithBaseURL("", this.html, "text/html", "UTF-8", "");
        }
    }
}

