/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.activity;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import androidx.activity.result.ActivityResult;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.activity.result.contract.ActivityResultContracts;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import com.ahmadullahpk.alldocumentreader.R;
import com.ahmadullahpk.alldocumentreader.manageui.CustomFrameLayout;
import com.ahmadullahpk.alldocumentreader.util.Utility;
import com.ahmadullahpk.alldocumentreader.util.ViewUtils;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0015\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J\u0010\u0010 \u001a\u00020\u001d2\b\u0010!\u001a\u0004\u0018\u00010\u0011J\b\u0010\"\u001a\u00020#H\u0004J\b\u0010$\u001a\u00020\u001dH\u0004J\u0010\u0010%\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020#H\u0016J+\u0010'\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020\f2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010*\u001a\u00020+H\u0016\u00a2\u0006\u0002\u0010,J\b\u0010-\u001a\u00020\u001dH\u0016J\u0018\u0010.\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020#2\u0006\u0010/\u001a\u00020#H\u0016J\u0010\u00100\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020#H\u0002R\"\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\n\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0014\u0010\u000b\u001a\u00020\fX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR(\u0010\u000f\u001a\u0010\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00110\u00110\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u00061"}, d2={"Lcom/ahmadullahpk/alldocumentreader/activity/BaseActivity;", "Landroidx/appcompat/app/AppCompatActivity;", "()V", "PERMISSIONS_LIST", "", "", "getPERMISSIONS_LIST", "()[Ljava/lang/String;", "setPERMISSIONS_LIST", "([Ljava/lang/String;)V", "[Ljava/lang/String;", "REQUEST_CODE", "", "getREQUEST_CODE", "()I", "someActivityResultLauncher", "Landroidx/activity/result/ActivityResultLauncher;", "Landroid/content/Intent;", "kotlin.jvm.PlatformType", "getSomeActivityResultLauncher", "()Landroidx/activity/result/ActivityResultLauncher;", "setSomeActivityResultLauncher", "(Landroidx/activity/result/ActivityResultLauncher;)V", "starterActivity", "getStarterActivity", "()Landroid/content/Intent;", "setStarterActivity", "(Landroid/content/Intent;)V", "adaptFitsSystemWindows", "", "view", "Landroid/view/View;", "checkAndLunchActivity", "intent", "hasReadStoragePermission", "", "hideSystemUI", "isTransparentEnabled", "z", "onRequestPermissionsResult", "requestCode", "permissions", "grantResults", "", "(I[Ljava/lang/String;[I)V", "setStatusBar", "setTransparentForWindow", "z2", "showAndHide", "documents-reader-lib_release"})
public class BaseActivity
extends AppCompatActivity {
    @NotNull
    private String[] PERMISSIONS_LIST;
    private final int REQUEST_CODE;
    @Nullable
    private Intent starterActivity;
    @NotNull
    private ActivityResultLauncher<Intent> someActivityResultLauncher;

    public BaseActivity() {
        String[] stringArray = new String[]{"android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.READ_EXTERNAL_STORAGE"};
        this.PERMISSIONS_LIST = stringArray;
        this.REQUEST_CODE = 112;
        ActivityResultLauncher activityResultLauncher = this.registerForActivityResult((ActivityResultContract)new ActivityResultContracts.StartActivityForResult(), arg_0 -> BaseActivity.someActivityResultLauncher$lambda$1(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)activityResultLauncher, (String)"registerForActivityResul\u2026)\n            }\n        }");
        this.someActivityResultLauncher = activityResultLauncher;
    }

    @NotNull
    public final String[] getPERMISSIONS_LIST() {
        return this.PERMISSIONS_LIST;
    }

    public final void setPERMISSIONS_LIST(@NotNull String[] stringArray) {
        Intrinsics.checkNotNullParameter((Object)stringArray, (String)"<set-?>");
        this.PERMISSIONS_LIST = stringArray;
    }

    public final int getREQUEST_CODE() {
        return this.REQUEST_CODE;
    }

    @Nullable
    public final Intent getStarterActivity() {
        return this.starterActivity;
    }

    public final void setStarterActivity(@Nullable Intent intent) {
        this.starterActivity = intent;
    }

    public void onRequestPermissionsResult(int requestCode, @NotNull String[] permissions, @NotNull int[] grantResults) {
        Intrinsics.checkNotNullParameter((Object)permissions, (String)"permissions");
        Intrinsics.checkNotNullParameter((Object)grantResults, (String)"grantResults");
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (requestCode != this.REQUEST_CODE) {
            return;
        }
        if (!(grantResults.length == 0)) {
            boolean bl;
            int n2 = grantResults[0];
            boolean bl2 = bl = n2 == 0;
            if (bl) {
                if (this.starterActivity != null) {
                    this.finish();
                    return;
                }
                Utility.Toast((Context)this, this.getResources().getString(R.string.permissionGranted));
                return;
            }
            Utility.Toast((Context)this, this.getResources().getString(R.string.permission_denied_message2));
        }
    }

    protected final boolean hasReadStoragePermission() {
        if (Build.VERSION.SDK_INT >= 30) {
            return Environment.isExternalStorageManager();
        }
        if (Build.VERSION.SDK_INT >= 29) {
            int n = ActivityCompat.checkSelfPermission((Context)this.getApplicationContext(), (String)"android.permission.READ_EXTERNAL_STORAGE");
            return n == 0;
        }
        if (Build.VERSION.SDK_INT >= 23) {
            int n = ActivityCompat.checkSelfPermission((Context)this.getApplicationContext(), (String)"android.permission.WRITE_EXTERNAL_STORAGE");
            return n == 0;
        }
        return true;
    }

    protected final void hideSystemUI() {
        View view = this.getWindow().getDecorView();
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"window.decorView");
        View decorView = view;
        decorView.setSystemUiVisibility(3846);
        decorView.setOnSystemUiVisibilityChangeListener(arg_0 -> BaseActivity.hideSystemUI$lambda$0(this, arg_0));
    }

    private final void showAndHide(boolean z) {
        CustomFrameLayout customFrameLayout = (CustomFrameLayout)this.findViewById(R.id.appToolbar);
        if (customFrameLayout == null) {
            return;
        }
        CustomFrameLayout linearLayout = customFrameLayout;
        if (z) {
            linearLayout.setVisibility(0);
        } else {
            linearLayout.setVisibility(8);
        }
    }

    public final void checkAndLunchActivity(@Nullable Intent intent) {
        this.starterActivity = intent;
        if (this.hasReadStoragePermission()) {
            this.startActivity(intent);
            this.finish();
        } else if (Build.VERSION.SDK_INT >= 30) {
            try {
                Intent intent2 = new Intent("android.settings.MANAGE_APP_ALL_FILES_ACCESS_PERMISSION");
                intent2.addCategory("android.intent.category.DEFAULT");
                String string2 = "package:%s";
                Object[] objectArray = new Object[]{this.getApplicationContext().getPackageName()};
                String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
                intent2.setData(Uri.parse((String)string3));
                this.someActivityResultLauncher.launch((Object)intent2);
            }
            catch (Exception unused) {
                Intent intent3 = new Intent();
                intent3.setAction("android.settings.MANAGE_ALL_FILES_ACCESS_PERMISSION");
                this.someActivityResultLauncher.launch((Object)intent3);
            }
        } else {
            ActivityCompat.requestPermissions((Activity)((Activity)this), (String[])this.PERMISSIONS_LIST, (int)112);
        }
    }

    @NotNull
    public final ActivityResultLauncher<Intent> getSomeActivityResultLauncher() {
        return this.someActivityResultLauncher;
    }

    public final void setSomeActivityResultLauncher(@NotNull ActivityResultLauncher<Intent> activityResultLauncher) {
        Intrinsics.checkNotNullParameter(activityResultLauncher, (String)"<set-?>");
        this.someActivityResultLauncher = activityResultLauncher;
    }

    public void setStatusBar() {
        this.isTransparentEnabled(true);
    }

    public void isTransparentEnabled(boolean z) {
        this.setTransparentForWindow(z, false);
    }

    public void setTransparentForWindow(boolean z, boolean z2) {
        Window window = this.getWindow();
        if (Build.VERSION.SDK_INT >= 23) {
            window.getDecorView().setSystemUiVisibility(ViewUtils.setWidth(z, z2));
            window.setNavigationBarColor(ContextCompat.getColor((Context)((Context)this), (int)R.color.black));
        } else if (Build.VERSION.SDK_INT == 21 || Build.VERSION.SDK_INT == 22) {
            window.setStatusBarColor(ContextCompat.getColor((Context)((Context)this), (int)R.color.black));
            window.setNavigationBarColor(ContextCompat.getColor((Context)((Context)this), (int)R.color.black));
        }
    }

    public void adaptFitsSystemWindows(@Nullable View view) {
        if (view != null) {
            view.setFitsSystemWindows(false);
            if (view instanceof ViewGroup) {
                int childCount = ((ViewGroup)view).getChildCount();
                for (int i = 0; i < childCount; ++i) {
                    ((ViewGroup)view).getChildAt(i).setFitsSystemWindows(false);
                }
            }
        }
    }

    private static final void hideSystemUI$lambda$0(BaseActivity this$0, int i) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.showAndHide((i & 4) == 0);
    }

    private static final void someActivityResultLauncher$lambda$1(BaseActivity this$0, ActivityResult activityResult) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)activityResult, (String)"activityResult");
        if (activityResult.getResultCode() == -1) {
            this$0.startActivity(this$0.starterActivity);
            this$0.finish();
        }
    }
}

