/*
 * Decompiled with CFR 0.152.
 */
package cn.addapp.pickers.picker;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.NonNull;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import cn.addapp.pickers.adapter.ArrayWheelAdapter;
import cn.addapp.pickers.entity.City;
import cn.addapp.pickers.entity.County;
import cn.addapp.pickers.entity.Province;
import cn.addapp.pickers.listeners.OnItemPickListener;
import cn.addapp.pickers.listeners.OnLinkageListener;
import cn.addapp.pickers.listeners.OnMoreWheelListener;
import cn.addapp.pickers.picker.LinkagePicker;
import cn.addapp.pickers.util.LogUtils;
import cn.addapp.pickers.widget.WheelListView;
import cn.addapp.pickers.widget.WheelView;
import java.util.ArrayList;
import java.util.List;

public class AddressPicker
extends LinkagePicker {
    private OnLinkageListener onLinkageListener;
    private OnMoreWheelListener onMoreWheelListener;
    private boolean hideProvince = false;
    private boolean hideCounty = false;
    private ArrayList<Province> provinces = new ArrayList();

    public AddressPicker(Activity activity, ArrayList<Province> provinces) {
        super(activity, new AddressProvider(provinces));
        this.provinces = provinces;
    }

    @Override
    public void setSelectedItem(String province, String city, String county) {
        super.setSelectedItem(province, city, county);
    }

    public Province getSelectedProvince() {
        return this.provinces.get(this.selectedFirstIndex);
    }

    public City getSelectedCity() {
        return this.getSelectedProvince().getCities().get(this.selectedSecondIndex);
    }

    public County getSelectedCounty() {
        return this.getSelectedCity().getCounties().get(this.selectedThirdIndex);
    }

    public void setHideProvince(boolean hideProvince) {
        this.hideProvince = hideProvince;
    }

    public void setHideCounty(boolean hideCounty) {
        this.hideCounty = hideCounty;
    }

    @Override
    public void setOnMoreWheelListener(OnMoreWheelListener onMoreWheelListener) {
        this.onMoreWheelListener = onMoreWheelListener;
    }

    public void setOnLinkageListener(OnLinkageListener listener) {
        this.onLinkageListener = listener;
    }

    @Override
    @NonNull
    protected View makeCenterView() {
        if (null == this.provider) {
            throw new IllegalArgumentException("please set address provider before make view");
        }
        if (this.hideCounty) {
            this.hideProvince = false;
        }
        int[] widths = this.getColumnWidths(this.hideProvince || this.hideCounty);
        int provinceWidth = widths[0];
        int cityWidth = widths[1];
        int countyWidth = widths[2];
        if (this.hideProvince) {
            provinceWidth = 0;
            cityWidth = widths[0];
            countyWidth = widths[1];
        }
        LinearLayout layout = new LinearLayout((Context)this.activity);
        layout.setOrientation(0);
        layout.setGravity(17);
        if (this.wheelModeEnable) {
            WheelView provinceView = new WheelView((Context)this.activity);
            provinceView.setCanLoop(this.canLoop);
            provinceView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(provinceWidth, -2));
            provinceView.setTextSize(this.textSize);
            provinceView.setSelectedTextColor(this.textColorFocus);
            provinceView.setUnSelectedTextColor(this.textColorNormal);
            provinceView.setLineConfig(this.lineConfig);
            provinceView.setAdapter(new ArrayWheelAdapter<String>(this.provider.provideFirstData()));
            provinceView.setCurrentItem(this.selectedFirstIndex);
            if (this.hideProvince) {
                provinceView.setVisibility(8);
            }
            layout.addView((View)provinceView);
            final WheelView cityView = new WheelView((Context)this.activity);
            cityView.setCanLoop(this.canLoop);
            cityView.setTextSize(this.textSize);
            cityView.setSelectedTextColor(this.textColorFocus);
            cityView.setUnSelectedTextColor(this.textColorNormal);
            cityView.setLineConfig(this.lineConfig);
            cityView.setAdapter(new ArrayWheelAdapter<String>(this.provider.provideSecondData(this.selectedFirstIndex)));
            cityView.setCurrentItem(this.selectedSecondIndex);
            cityView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(cityWidth, -2));
            layout.addView((View)cityView);
            final WheelView countyView = new WheelView((Context)this.activity);
            countyView.setCanLoop(this.canLoop);
            countyView.setTextSize(this.textSize);
            countyView.setSelectedTextColor(this.textColorFocus);
            countyView.setUnSelectedTextColor(this.textColorNormal);
            countyView.setLineConfig(this.lineConfig);
            countyView.setAdapter(new ArrayWheelAdapter<String>(this.provider.provideThirdData(this.selectedFirstIndex, this.selectedSecondIndex)));
            countyView.setCurrentItem(this.selectedThirdIndex);
            countyView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(countyWidth, -2));
            if (this.hideCounty) {
                countyView.setVisibility(8);
            }
            layout.addView((View)countyView);
            provinceView.setOnItemPickListener(new OnItemPickListener<String>(){

                @Override
                public void onItemPicked(int index, String item) {
                    AddressPicker.this.selectedFirstItem = item;
                    AddressPicker.this.selectedFirstIndex = index;
                    if (AddressPicker.this.onMoreWheelListener != null) {
                        AddressPicker.this.onMoreWheelListener.onFirstWheeled(AddressPicker.this.selectedFirstIndex, AddressPicker.this.selectedFirstItem);
                    }
                    LogUtils.verbose(this, "change cities after province wheeled");
                    AddressPicker.this.selectedSecondIndex = 0;
                    AddressPicker.this.selectedThirdIndex = 0;
                    List<String> cities = AddressPicker.this.provider.provideSecondData(AddressPicker.this.selectedFirstIndex);
                    if (cities.size() > 0) {
                        cityView.setAdapter(new ArrayWheelAdapter<String>(cities));
                        cityView.setCurrentItem(AddressPicker.this.selectedSecondIndex);
                    } else {
                        cityView.setAdapter(new ArrayWheelAdapter(new ArrayList()));
                    }
                    List<String> counties = AddressPicker.this.provider.provideThirdData(AddressPicker.this.selectedFirstIndex, AddressPicker.this.selectedSecondIndex);
                    if (counties.size() > 0) {
                        countyView.setAdapter(new ArrayWheelAdapter<String>(counties));
                        countyView.setCurrentItem(AddressPicker.this.selectedThirdIndex);
                    } else {
                        countyView.setAdapter(new ArrayWheelAdapter(new ArrayList()));
                    }
                }
            });
            cityView.setOnItemPickListener(new OnItemPickListener<String>(){

                @Override
                public void onItemPicked(int index, String item) {
                    AddressPicker.this.selectedSecondItem = item;
                    AddressPicker.this.selectedSecondIndex = index;
                    if (AddressPicker.this.onMoreWheelListener != null) {
                        AddressPicker.this.onMoreWheelListener.onSecondWheeled(AddressPicker.this.selectedSecondIndex, AddressPicker.this.selectedSecondItem);
                    }
                    LogUtils.verbose(this, "change counties after city wheeled");
                    AddressPicker.this.selectedThirdIndex = 0;
                    List<String> counties = AddressPicker.this.provider.provideThirdData(AddressPicker.this.selectedFirstIndex, AddressPicker.this.selectedSecondIndex);
                    if (counties.size() > 0) {
                        countyView.setAdapter(new ArrayWheelAdapter<String>(counties));
                        countyView.setCurrentItem(AddressPicker.this.selectedThirdIndex);
                    } else {
                        countyView.setAdapter(new ArrayWheelAdapter(new ArrayList()));
                    }
                }
            });
            countyView.setOnItemPickListener(new OnItemPickListener<String>(){

                @Override
                public void onItemPicked(int index, String item) {
                    AddressPicker.this.selectedThirdItem = item;
                    AddressPicker.this.selectedThirdIndex = index;
                    if (AddressPicker.this.onMoreWheelListener != null) {
                        AddressPicker.this.onMoreWheelListener.onThirdWheeled(AddressPicker.this.selectedThirdIndex, AddressPicker.this.selectedThirdItem);
                    }
                }
            });
        } else {
            WheelListView provinceView = new WheelListView((Context)this.activity);
            provinceView.setCanLoop(this.canLoop);
            provinceView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(provinceWidth, -2));
            provinceView.setTextSize(this.textSize);
            provinceView.setSelectedTextColor(this.textColorFocus);
            provinceView.setUnSelectedTextColor(this.textColorNormal);
            provinceView.setLineConfig(this.lineConfig);
            provinceView.setOffset(this.offset);
            layout.addView((View)provinceView);
            if (this.hideProvince) {
                provinceView.setVisibility(8);
            }
            final WheelListView cityView = new WheelListView((Context)this.activity);
            cityView.setCanLoop(this.canLoop);
            cityView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(cityWidth, -2));
            cityView.setTextSize(this.textSize);
            cityView.setSelectedTextColor(this.textColorFocus);
            cityView.setUnSelectedTextColor(this.textColorNormal);
            cityView.setLineConfig(this.lineConfig);
            cityView.setOffset(this.offset);
            layout.addView((View)cityView);
            final WheelListView countyView = new WheelListView((Context)this.activity);
            countyView.setCanLoop(this.canLoop);
            countyView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(countyWidth, -2));
            countyView.setTextSize(this.textSize);
            countyView.setSelectedTextColor(this.textColorFocus);
            countyView.setUnSelectedTextColor(this.textColorNormal);
            countyView.setLineConfig(this.lineConfig);
            countyView.setOffset(this.offset);
            layout.addView((View)countyView);
            if (this.hideCounty) {
                countyView.setVisibility(8);
            }
            provinceView.setItems(this.provider.provideFirstData(), this.selectedFirstIndex);
            provinceView.setOnWheelChangeListener(new WheelListView.OnWheelChangeListener(){

                @Override
                public void onItemSelected(int index, String item) {
                    AddressPicker.this.selectedFirstItem = item;
                    AddressPicker.this.selectedFirstIndex = index;
                    if (AddressPicker.this.onMoreWheelListener != null) {
                        AddressPicker.this.onMoreWheelListener.onFirstWheeled(AddressPicker.this.selectedFirstIndex, AddressPicker.this.selectedFirstItem);
                    }
                    LogUtils.verbose(this, "change cities after province wheeled");
                    AddressPicker.this.selectedSecondIndex = 0;
                    AddressPicker.this.selectedThirdIndex = 0;
                    List<String> cities = AddressPicker.this.provider.provideSecondData(AddressPicker.this.selectedFirstIndex);
                    if (cities.size() > 0) {
                        cityView.setItems(cities, AddressPicker.this.selectedSecondIndex);
                    } else {
                        cityView.setItems(new ArrayList<String>());
                    }
                    List<String> counties = AddressPicker.this.provider.provideThirdData(AddressPicker.this.selectedFirstIndex, AddressPicker.this.selectedSecondIndex);
                    if (counties.size() > 0) {
                        countyView.setItems(counties, AddressPicker.this.selectedThirdIndex);
                    } else {
                        countyView.setItems(new ArrayList<String>());
                    }
                }
            });
            cityView.setItems(this.provider.provideSecondData(this.selectedFirstIndex), this.selectedSecondIndex);
            cityView.setOnWheelChangeListener(new WheelListView.OnWheelChangeListener(){

                @Override
                public void onItemSelected(int index, String item) {
                    AddressPicker.this.selectedSecondItem = item;
                    AddressPicker.this.selectedSecondIndex = index;
                    if (AddressPicker.this.onMoreWheelListener != null) {
                        AddressPicker.this.onMoreWheelListener.onSecondWheeled(AddressPicker.this.selectedSecondIndex, AddressPicker.this.selectedSecondItem);
                    }
                    LogUtils.verbose(this, "change counties after city wheeled");
                    AddressPicker.this.selectedThirdIndex = 0;
                    List<String> counties = AddressPicker.this.provider.provideThirdData(AddressPicker.this.selectedFirstIndex, AddressPicker.this.selectedSecondIndex);
                    if (counties.size() > 0) {
                        countyView.setItems(counties, AddressPicker.this.selectedThirdIndex);
                    } else {
                        countyView.setItems(new ArrayList<String>());
                    }
                }
            });
            countyView.setItems(this.provider.provideThirdData(this.selectedFirstIndex, this.selectedSecondIndex), this.selectedThirdIndex);
            countyView.setOnWheelChangeListener(new WheelListView.OnWheelChangeListener(){

                @Override
                public void onItemSelected(int index, String item) {
                    AddressPicker.this.selectedThirdItem = item;
                    AddressPicker.this.selectedThirdIndex = index;
                    if (AddressPicker.this.onMoreWheelListener != null) {
                        AddressPicker.this.onMoreWheelListener.onThirdWheeled(AddressPicker.this.selectedThirdIndex, AddressPicker.this.selectedThirdItem);
                    }
                }
            });
        }
        return layout;
    }

    @Override
    public void onSubmit() {
        if (this.onLinkageListener != null) {
            Province province = this.getSelectedProvince();
            City city = this.getSelectedCity();
            County county = null;
            if (!this.hideCounty) {
                county = this.getSelectedCounty();
            }
            this.onLinkageListener.onAddressPicked(province, city, county);
        }
    }

    public static class AddressProvider
    implements LinkagePicker.DataProvider {
        private List<String> firstList = new ArrayList<String>();
        private List<List<String>> secondList = new ArrayList<List<String>>();
        private List<List<List<String>>> thirdList = new ArrayList<List<List<String>>>();

        public AddressProvider(List<Province> provinces) {
            this.parseData(provinces);
        }

        @Override
        public boolean isOnlyTwo() {
            return this.thirdList.size() == 0;
        }

        @Override
        public List<String> provideFirstData() {
            return this.firstList;
        }

        @Override
        public List<String> provideSecondData(int firstIndex) {
            return this.secondList.get(firstIndex);
        }

        @Override
        public List<String> provideThirdData(int firstIndex, int secondIndex) {
            return this.thirdList.get(firstIndex).get(secondIndex);
        }

        private void parseData(List<Province> data) {
            int provinceSize = data.size();
            for (int x = 0; x < provinceSize; ++x) {
                Province pro = data.get(x);
                this.firstList.add(pro.getAreaName());
                List<City> cities = pro.getCities();
                ArrayList<String> xCities = new ArrayList<String>();
                ArrayList xCounties = new ArrayList();
                int citySize = cities.size();
                for (int y = 0; y < citySize; ++y) {
                    City cit = cities.get(y);
                    cit.setProvinceId(pro.getAreaId());
                    xCities.add(cit.getAreaName());
                    List<County> counties = cit.getCounties();
                    ArrayList<String> yCounties = new ArrayList<String>();
                    int countySize = counties.size();
                    if (countySize == 0) {
                        yCounties.add(cit.getAreaName());
                    } else {
                        for (int z = 0; z < countySize; ++z) {
                            County cou = counties.get(z);
                            cou.setCityId(cit.getAreaId());
                            yCounties.add(cou.getAreaName());
                        }
                    }
                    xCounties.add(yCounties);
                }
                this.secondList.add(xCities);
                this.thirdList.add(xCounties);
            }
        }
    }
}

