/*
 * Decompiled with CFR 0.152.
 */
package com.acsbendi.requestinspectorwebview;

import android.annotation.SuppressLint;
import android.graphics.Bitmap;
import android.util.Log;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.acsbendi.requestinspectorwebview.RequestInspectorJavaScriptInterface;
import com.acsbendi.requestinspectorwebview.RequestInspectorOptions;
import com.acsbendi.requestinspectorwebview.WebViewRequest;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0004J\"\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0018\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0016J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/acsbendi/requestinspectorwebview/RequestInspectorWebViewClient;", "Landroid/webkit/WebViewClient;", "webView", "Landroid/webkit/WebView;", "options", "Lcom/acsbendi/requestinspectorwebview/RequestInspectorOptions;", "(Landroid/webkit/WebView;Lcom/acsbendi/requestinspectorwebview/RequestInspectorOptions;)V", "interceptionJavascriptInterface", "Lcom/acsbendi/requestinspectorwebview/RequestInspectorJavaScriptInterface;", "logWebViewRequest", "", "webViewRequest", "Lcom/acsbendi/requestinspectorwebview/WebViewRequest;", "onPageStarted", "view", "url", "", "favicon", "Landroid/graphics/Bitmap;", "shouldInterceptRequest", "Landroid/webkit/WebResourceResponse;", "request", "Landroid/webkit/WebResourceRequest;", "Companion", "app_release"})
@SuppressLint(value={"SetJavaScriptEnabled"})
public class RequestInspectorWebViewClient
extends WebViewClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RequestInspectorOptions options;
    @NotNull
    private final RequestInspectorJavaScriptInterface interceptionJavascriptInterface;
    @NotNull
    private static final String LOG_TAG = "RequestInspectorWebView";

    @JvmOverloads
    public RequestInspectorWebViewClient(@NotNull WebView webView, @NotNull RequestInspectorOptions options) {
        Intrinsics.checkNotNullParameter((Object)webView, (String)"webView");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.options = options;
        this.interceptionJavascriptInterface = new RequestInspectorJavaScriptInterface(webView);
        WebSettings webSettings = webView.getSettings();
        Intrinsics.checkNotNullExpressionValue((Object)webSettings, (String)"webView.settings");
        WebSettings webSettings2 = webSettings;
        webSettings2.setJavaScriptEnabled(true);
        webSettings2.setDomStorageEnabled(true);
    }

    public /* synthetic */ RequestInspectorWebViewClient(WebView webView, RequestInspectorOptions requestInspectorOptions, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            requestInspectorOptions = new RequestInspectorOptions(null, 1, null);
        }
        this(webView, requestInspectorOptions);
    }

    @Nullable
    public final WebResourceResponse shouldInterceptRequest(@NotNull WebView view, @NotNull WebResourceRequest request) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        String string = request.getUrl().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"request.url.toString()");
        RequestInspectorJavaScriptInterface.RecordedRequest recordedRequest = this.interceptionJavascriptInterface.findRecordedRequestForUrl(string);
        WebViewRequest webViewRequest = WebViewRequest.Companion.create$app_release(request, recordedRequest);
        return this.shouldInterceptRequest(view, webViewRequest);
    }

    @Nullable
    public WebResourceResponse shouldInterceptRequest(@NotNull WebView view, @NotNull WebViewRequest webViewRequest) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)webViewRequest, (String)"webViewRequest");
        this.logWebViewRequest(webViewRequest);
        return null;
    }

    protected final void logWebViewRequest(@NotNull WebViewRequest webViewRequest) {
        Intrinsics.checkNotNullParameter((Object)webViewRequest, (String)"webViewRequest");
        Log.i((String)LOG_TAG, (String)("Sending request from WebView: " + webViewRequest));
    }

    public void onPageStarted(@NotNull WebView view, @NotNull String url, @Nullable Bitmap favicon) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Log.i((String)LOG_TAG, (String)("Page started loading, enabling request inspection. URL: " + url));
        RequestInspectorJavaScriptInterface.Companion.enabledRequestInspection(view, this.options.getExtraJavaScriptToInject());
        super.onPageStarted(view, url, favicon);
    }

    @JvmOverloads
    public RequestInspectorWebViewClient(@NotNull WebView webView) {
        Intrinsics.checkNotNullParameter((Object)webView, (String)"webView");
        this(webView, null, 2, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/acsbendi/requestinspectorwebview/RequestInspectorWebViewClient$Companion;", "", "()V", "LOG_TAG", "", "app_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

