/*
 * Decompiled with CFR 0.152.
 */
package io.unico.unicosdkbase.network.data.remote;

import com.google.gson.Gson;
import io.unico.unicosdkbase.network.data.entities.Call;
import io.unico.unicosdkbase.network.data.entities.Callback;
import io.unico.unicosdkbase.network.data.entities.Path;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0012\u0010\u0012\u001a\u00020\u00042\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u0002J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000eJ\u0010\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001a\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u00042\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u00002\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u001e"}, d2={"Lio/unico/unicosdkbase/network/data/remote/HttpService;", "", "()V", "instanceUrl", "", "getInstanceUrl", "()Ljava/lang/String;", "setInstanceUrl", "(Ljava/lang/String;)V", "buildBody", "", "connection", "Ljava/net/HttpURLConnection;", "call", "Lio/unico/unicosdkbase/network/data/entities/Call;", "buildHeader", "buildUrl", "Ljava/net/URL;", "createJsonBody", "body", "doInBackground", "Lio/unico/unicosdkbase/network/data/entities/Callback;", "callings", "getResponse", "send", "setPath", "url", "path", "Lio/unico/unicosdkbase/network/data/entities/Path;", "setUrl", "network_release"})
public final class HttpService {
    @Nullable
    private String instanceUrl;

    @Nullable
    public final String getInstanceUrl() {
        return this.instanceUrl;
    }

    public final void setInstanceUrl(@Nullable String string) {
        this.instanceUrl = string;
    }

    @NotNull
    public final HttpService setUrl(@Nullable String instanceUrl) {
        this.instanceUrl = instanceUrl;
        return this;
    }

    @NotNull
    public final Callback doInBackground(@NotNull Call callings) {
        Intrinsics.checkNotNullParameter((Object)callings, (String)"callings");
        return this.send(callings);
    }

    private final Callback send(Call call) {
        Callback callback;
        int code = 0;
        String msg = null;
        msg = "";
        String response = null;
        response = "";
        try {
            URL uRL = this.buildUrl(call);
            HttpURLConnection httpURLConnection = (HttpURLConnection)(uRL != null ? uRL.openConnection() : null);
            if (httpURLConnection != null) {
                HttpURLConnection it = httpURLConnection;
                boolean bl = false;
                it.setRequestMethod(call.getMethod());
                this.buildHeader(it, call);
                this.buildBody(it, call);
                code = it.getResponseCode();
                String string = it.getResponseMessage();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.responseMessage");
                msg = string;
                response = this.getResponse(it);
                it.disconnect();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            callback = new Callback(code, msg, new Gson().fromJson(response, call.getResponseType()));
        }
        catch (Exception e) {
            callback = new Callback(code, msg, "");
        }
        return callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void buildBody(HttpURLConnection connection, Call call) {
        try {
            Closeable closeable = connection.getOutputStream();
            Throwable throwable = null;
            try {
                byte[] byArray;
                String string;
                OutputStream os = (OutputStream)closeable;
                boolean bl = false;
                if (call.getStringJson() == null) {
                    string = this.createJsonBody(call.getBody());
                    Charset charset = StandardCharsets.UTF_8;
                    Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                    byte[] byArray2 = string.getBytes(charset);
                    byArray = byArray2;
                    Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"this as java.lang.String).getBytes(charset)");
                } else {
                    string = call.getStringJson();
                    Charset charset = StandardCharsets.UTF_8;
                    Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                    byte[] byArray3 = string.getBytes(charset);
                    byArray = byArray3;
                    Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"this as java.lang.String).getBytes(charset)");
                }
                byte[] input = byArray;
                os.write(input, 0, input.length);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private final String createJsonBody(Object body) {
        Gson gson = new Gson();
        String string = gson.toJson(body);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"gson.toJson(body)");
        return string;
    }

    private final void buildHeader(HttpURLConnection connection, Call call) {
        try {
            Map<String, String> header = call.getHeader();
            if (header != null) {
                for (Map.Entry<String, String> entry : header.entrySet()) {
                    String key = entry.getKey();
                    String value = entry.getValue();
                    connection.setRequestProperty(key, value);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final String getResponse(HttpURLConnection connection) throws IOException {
        String responseLine = null;
        StringBuilder response = new StringBuilder();
        int n = connection.getResponseCode();
        BufferedReader br = (100 <= n ? n < 400 : false) ? new BufferedReader(new InputStreamReader(connection.getInputStream())) : ((400 <= n ? n < 600 : false) ? new BufferedReader(new InputStreamReader(connection.getErrorStream())) : null);
        while (true) {
            String string;
            String string2;
            BufferedReader bufferedReader = br;
            String it = string2 = bufferedReader != null ? bufferedReader.readLine() : null;
            boolean bl = false;
            responseLine = it;
            if (string2 == null) break;
            StringBuilder stringBuilder = response;
            String string3 = responseLine;
            if (string3 != null) {
                void $this$trim$iv;
                it = string3;
                StringBuilder stringBuilder2 = stringBuilder;
                boolean $i$f$trim = false;
                CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
                boolean $i$f$trim2 = false;
                int startIndex$iv$iv = 0;
                int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                boolean startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    boolean match$iv$iv;
                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    char it2 = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl2 = false;
                    boolean bl3 = match$iv$iv = Intrinsics.compare((int)it2, (int)32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                string = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                stringBuilder = stringBuilder2;
            } else {
                string = null;
            }
            stringBuilder.append(string);
        }
        String string = response.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"response.toString()");
        return string;
    }

    private final URL buildUrl(Call call) {
        URL result = null;
        try {
            String url = this.instanceUrl + call.getURL();
            if (call.getPath() != null) {
                url = this.setPath(url, call.getPath());
            }
            result = new URL(url);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return result;
    }

    private final String setPath(String url, Path path) {
        String string;
        Path path2 = path;
        if (path2 != null) {
            Path it = path2;
            boolean bl = false;
            string = StringsKt.replace$default((String)url, (String)('{' + it.getPath() + '}'), (String)it.getValue(), (boolean)false, (int)4, null);
        } else {
            string = null;
        }
        String $this$setPath_u24lambda_u2d5 = string;
        boolean bl = false;
        return url;
    }
}

