/*
 * Decompiled with CFR 0.152.
 */
package com.abdeveloper.library;

import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v7.app.AppCompatDialogFragment;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.SearchView;
import android.view.View;
import android.widget.TextView;
import android.widget.Toast;
import com.abdeveloper.library.MultiSelectModel;
import com.abdeveloper.library.MutliSelectAdapter;
import com.abdeveloper.library.R;
import com.abdeveloper.library.RecyclerViewEmptySupport;
import java.util.ArrayList;

public class MultiSelectDialog
extends AppCompatDialogFragment
implements SearchView.OnQueryTextListener,
View.OnClickListener {
    public static ArrayList<Integer> selectedIdsForCallback = new ArrayList();
    public ArrayList<MultiSelectModel> mainListOfAdapter = new ArrayList();
    private MutliSelectAdapter mutliSelectAdapter;
    private String title;
    private float titleSize = 25.0f;
    private String positiveText = "DONE";
    private String negativeText = "CANCEL";
    private TextView dialogTitle;
    private TextView dialogSubmit;
    private TextView dialogCancel;
    private ArrayList<Integer> previouslySelectedIdsList = new ArrayList();
    private ArrayList<Integer> tempPreviouslySelectedIdsList = new ArrayList();
    private ArrayList<MultiSelectModel> tempMainListOfAdapter = new ArrayList();
    private SubmitCallbackListener submitCallbackListener;

    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Dialog dialog = new Dialog((Context)this.getActivity());
        dialog.getWindow().requestFeature(1);
        dialog.getWindow().setFlags(32, 1024);
        dialog.setContentView(R.layout.custom_multi_select);
        dialog.getWindow().setLayout(-1, -1);
        RecyclerViewEmptySupport mrecyclerView = (RecyclerViewEmptySupport)dialog.findViewById(R.id.recycler_view);
        SearchView searchView = (SearchView)dialog.findViewById(R.id.search_view);
        this.dialogTitle = (TextView)dialog.findViewById(R.id.title);
        this.dialogSubmit = (TextView)dialog.findViewById(R.id.done);
        this.dialogCancel = (TextView)dialog.findViewById(R.id.cancel);
        mrecyclerView.setEmptyView(dialog.findViewById(R.id.list_empty1));
        LinearLayoutManager layoutManager = new LinearLayoutManager((Context)this.getActivity(), 1, false);
        mrecyclerView.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        this.dialogSubmit.setOnClickListener((View.OnClickListener)this);
        this.dialogCancel.setOnClickListener((View.OnClickListener)this);
        this.settingValues();
        this.mainListOfAdapter = this.setCheckedIDS(this.mainListOfAdapter, this.previouslySelectedIdsList);
        this.mutliSelectAdapter = new MutliSelectAdapter(this.mainListOfAdapter, this.getContext());
        mrecyclerView.setAdapter(this.mutliSelectAdapter);
        searchView.setOnQueryTextListener((SearchView.OnQueryTextListener)this);
        searchView.onActionViewExpanded();
        searchView.clearFocus();
        return dialog;
    }

    public MultiSelectDialog title(String title) {
        this.title = title;
        return this;
    }

    public MultiSelectDialog titleSize(float titleSize) {
        this.titleSize = titleSize;
        return this;
    }

    public MultiSelectDialog positiveText(@NonNull String message) {
        this.positiveText = message;
        return this;
    }

    public MultiSelectDialog negativeText(@NonNull String message) {
        this.negativeText = message;
        return this;
    }

    public MultiSelectDialog preSelectIDsList(ArrayList<Integer> list) {
        this.previouslySelectedIdsList = list;
        this.tempPreviouslySelectedIdsList = new ArrayList<Integer>(this.previouslySelectedIdsList);
        return this;
    }

    public MultiSelectDialog multiSelectList(ArrayList<MultiSelectModel> list) {
        this.mainListOfAdapter = list;
        this.tempMainListOfAdapter = new ArrayList<MultiSelectModel>(this.mainListOfAdapter);
        return this;
    }

    public MultiSelectDialog onSubmit(@NonNull SubmitCallbackListener callback) {
        this.submitCallbackListener = callback;
        return this;
    }

    private void settingValues() {
        this.dialogTitle.setText((CharSequence)this.title);
        this.dialogTitle.setTextSize(2, this.titleSize);
        this.dialogSubmit.setText((CharSequence)this.positiveText.toUpperCase());
        this.dialogCancel.setText((CharSequence)this.negativeText.toUpperCase());
    }

    private ArrayList<MultiSelectModel> setCheckedIDS(ArrayList<MultiSelectModel> multiselectdata, ArrayList<Integer> listOfIdsSelected) {
        for (int i = 0; i < multiselectdata.size(); ++i) {
            multiselectdata.get(i).setSelected(false);
            for (int j = 0; j < listOfIdsSelected.size(); ++j) {
                if (listOfIdsSelected.get(j).intValue() != multiselectdata.get(i).getId()) continue;
                multiselectdata.get(i).setSelected(true);
            }
        }
        return multiselectdata;
    }

    private ArrayList<MultiSelectModel> filter(ArrayList<MultiSelectModel> models, String query) {
        query = query.toLowerCase();
        ArrayList<MultiSelectModel> filteredModelList = new ArrayList<MultiSelectModel>();
        if (query.equals("") | query.isEmpty()) {
            filteredModelList.addAll(models);
            return filteredModelList;
        }
        for (MultiSelectModel model : models) {
            String name = model.getName().toLowerCase();
            if (!name.contains(query)) continue;
            filteredModelList.add(model);
        }
        return filteredModelList;
    }

    public boolean onQueryTextSubmit(String query) {
        return false;
    }

    public boolean onQueryTextChange(String newText) {
        selectedIdsForCallback = this.previouslySelectedIdsList;
        this.mainListOfAdapter = this.setCheckedIDS(this.mainListOfAdapter, selectedIdsForCallback);
        ArrayList<MultiSelectModel> filteredlist = this.filter(this.mainListOfAdapter, newText);
        this.mutliSelectAdapter.setData(filteredlist, newText.toLowerCase(), this.mutliSelectAdapter);
        return false;
    }

    public void onClick(View view) {
        if (view.getId() == R.id.done) {
            ArrayList<Integer> callBackListOfIds = selectedIdsForCallback;
            if (callBackListOfIds.size() > 0) {
                this.tempPreviouslySelectedIdsList = new ArrayList<Integer>(callBackListOfIds);
                if (this.submitCallbackListener != null) {
                    this.submitCallbackListener.onSelected(callBackListOfIds, this.getSelectNameList(), this.getSelectedDataString());
                }
                this.dismiss();
            } else {
                Toast.makeText((Context)this.getActivity(), (int)R.string.validation_text, (int)1).show();
            }
        }
        if (view.getId() == R.id.cancel) {
            if (this.submitCallbackListener != null) {
                selectedIdsForCallback.clear();
                selectedIdsForCallback.addAll(this.tempPreviouslySelectedIdsList);
                this.submitCallbackListener.onCancel();
            }
            this.dismiss();
        }
    }

    private String getSelectedDataString() {
        String data = "";
        for (int i = 0; i < this.tempMainListOfAdapter.size(); ++i) {
            if (!this.checkForSelection(this.tempMainListOfAdapter.get(i).getId())) continue;
            data = data + ", " + this.tempMainListOfAdapter.get(i).getName();
        }
        if (data.length() > 0) {
            return data.substring(1);
        }
        return "";
    }

    private ArrayList<String> getSelectNameList() {
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 0; i < this.tempMainListOfAdapter.size(); ++i) {
            if (!this.checkForSelection(this.tempMainListOfAdapter.get(i).getId())) continue;
            names.add(this.tempMainListOfAdapter.get(i).getName());
        }
        return names;
    }

    private boolean checkForSelection(Integer id2) {
        for (int i = 0; i < selectedIdsForCallback.size(); ++i) {
            if (!id2.equals(selectedIdsForCallback.get(i))) continue;
            return true;
        }
        return false;
    }

    public static interface SubmitCallbackListener {
        public void onSelected(ArrayList<Integer> var1, ArrayList<String> var2, String var3);

        public void onCancel();
    }
}

