/*
 * Decompiled with CFR 0.152.
 */
package abhishekti7.unicorn.filepicker.ui;

import abhishekti7.unicorn.filepicker.R;
import abhishekti7.unicorn.filepicker.adapters.DirectoryAdapter;
import abhishekti7.unicorn.filepicker.adapters.DirectoryStackAdapter;
import abhishekti7.unicorn.filepicker.databinding.UnicornActivityFilePickerBinding;
import abhishekti7.unicorn.filepicker.models.Config;
import abhishekti7.unicorn.filepicker.models.DirectoryModel;
import abhishekti7.unicorn.filepicker.utils.UnicornSimpleItemDecoration;
import android.content.Context;
import android.content.Intent;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.os.Bundle;
import android.os.Environment;
import android.util.Log;
import android.util.TypedValue;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.SearchView;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class FilePickerActivity
extends AppCompatActivity {
    private static final String TAG = "FilePickerActivity";
    private UnicornActivityFilePickerBinding filePickerBinding;
    private File root_dir;
    private ArrayList<String> selected_files;
    private ArrayList<DirectoryModel> arr_dir_stack;
    private ArrayList<DirectoryModel> arr_files;
    private DirectoryStackAdapter stackAdapter;
    private DirectoryAdapter directoryAdapter;
    private final String[] REQUIRED_PERMISSIONS = new String[]{"android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.READ_EXTERNAL_STORAGE"};
    private Config config;
    private ArrayList<String> filters;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.config = Config.getInstance();
        this.setTheme(this.config.getThemeId());
        this.filePickerBinding = UnicornActivityFilePickerBinding.inflate(this.getLayoutInflater());
        CoordinatorLayout view = this.filePickerBinding.getRoot();
        this.setContentView((View)view);
        this.initConfig();
    }

    private void initConfig() {
        this.filters = this.config.getExtensionFilters();
        this.setSupportActionBar(this.filePickerBinding.toolbar);
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        this.getSupportActionBar().setDisplayShowTitleEnabled(false);
        this.root_dir = this.config.getRootDir() != null ? new File(this.config.getRootDir()) : Environment.getExternalStorageDirectory();
        this.selected_files = new ArrayList();
        this.arr_dir_stack = new ArrayList();
        this.arr_files = new ArrayList();
        this.setUpDirectoryStackView();
        this.setUpFilesView();
        if (this.allPermissionsGranted()) {
            this.fetchDirectory(new DirectoryModel(true, this.root_dir.getAbsolutePath(), this.root_dir.getName(), this.root_dir.lastModified(), this.root_dir.listFiles() == null ? 0 : this.root_dir.listFiles().length));
        } else {
            Log.e((String)TAG, (String)"Storage permissions not granted. You have to implement it before starting the file picker");
            this.finish();
        }
        this.filePickerBinding.fabSelect.setOnClickListener(v -> {
            Intent intent = new Intent();
            if (this.config.showOnlyDirectory()) {
                this.selected_files.clear();
                this.selected_files.add(this.arr_dir_stack.get(this.arr_dir_stack.size() - 1).getPath());
            }
            intent.putStringArrayListExtra("filePaths", this.selected_files);
            this.setResult(this.config.getReqCode(), intent);
            this.setResult(-1, intent);
            this.finish();
        });
        TypedValue typedValue = new TypedValue();
        Resources.Theme theme = this.getTheme();
        theme.resolveAttribute(R.attr.unicorn_fabColor, typedValue, true);
        if (typedValue.data != 0) {
            this.filePickerBinding.fabSelect.setBackgroundTintList(ColorStateList.valueOf((int)typedValue.data));
        } else {
            this.filePickerBinding.fabSelect.setBackgroundTintList(ColorStateList.valueOf((int)this.getResources().getColor(R.color.unicorn_colorAccent)));
        }
    }

    private void setUpFilesView() {
        LinearLayoutManager layoutManager = new LinearLayoutManager((Context)this);
        this.filePickerBinding.rvFiles.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        this.directoryAdapter = new DirectoryAdapter((Context)this, this.arr_files, false, new DirectoryAdapter.onFilesClickListener(){

            @Override
            public void onClicked(DirectoryModel model) {
                FilePickerActivity.this.fetchDirectory(model);
            }

            @Override
            public void onFileSelected(DirectoryModel fileModel) {
                if (FilePickerActivity.this.config.isSelectMultiple()) {
                    if (FilePickerActivity.this.selected_files.contains(fileModel.getPath())) {
                        FilePickerActivity.this.selected_files.remove(fileModel.getPath());
                    } else {
                        FilePickerActivity.this.selected_files.add(fileModel.getPath());
                    }
                } else {
                    FilePickerActivity.this.selected_files.clear();
                    FilePickerActivity.this.selected_files.add(fileModel.getPath());
                }
            }
        });
        this.filePickerBinding.rvFiles.setAdapter((RecyclerView.Adapter)this.directoryAdapter);
        this.directoryAdapter.notifyDataSetChanged();
        if (this.config.addItemDivider()) {
            this.filePickerBinding.rvFiles.addItemDecoration((RecyclerView.ItemDecoration)new UnicornSimpleItemDecoration((Context)this));
        }
    }

    private void setUpDirectoryStackView() {
        LinearLayoutManager layoutManager = new LinearLayoutManager((Context)this, 0, false);
        this.filePickerBinding.rvDirPath.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        this.stackAdapter = new DirectoryStackAdapter((Context)this, this.arr_dir_stack, model -> {
            Log.e((String)TAG, (String)model.toString());
            this.arr_dir_stack = new ArrayList<DirectoryModel>(this.arr_dir_stack.subList(0, this.arr_dir_stack.indexOf(model) + 1));
            this.setUpDirectoryStackView();
            this.fetchDirectory(this.arr_dir_stack.remove(this.arr_dir_stack.size() - 1));
        });
        this.filePickerBinding.rvDirPath.setAdapter((RecyclerView.Adapter)this.stackAdapter);
        this.stackAdapter.notifyDataSetChanged();
    }

    private void fetchDirectory(DirectoryModel model) {
        this.filePickerBinding.rlProgress.setVisibility(0);
        this.selected_files.clear();
        this.arr_files.clear();
        File dir = new File(model.getPath());
        File[] files_list = dir.listFiles();
        if (files_list != null) {
            for (File file : files_list) {
                DirectoryModel directoryModel = new DirectoryModel();
                directoryModel.setDirectory(file.isDirectory());
                directoryModel.setName(file.getName());
                directoryModel.setPath(file.getAbsolutePath());
                directoryModel.setLast_modif_time(file.lastModified());
                if (!this.config.showHidden() && (this.config.showHidden() || file.isHidden())) continue;
                if (file.isDirectory()) {
                    if (file.listFiles() != null) {
                        directoryModel.setNum_files(file.listFiles().length);
                    }
                    this.arr_files.add(directoryModel);
                    continue;
                }
                if (this.config.showOnlyDirectory()) continue;
                if (this.filters != null) {
                    try {
                        String fileName = file.getName();
                        String extension = fileName.substring(fileName.lastIndexOf("."));
                        for (String filter : this.filters) {
                            if (!extension.toLowerCase().contains(filter)) continue;
                            this.arr_files.add(directoryModel);
                        }
                        continue;
                    }
                    catch (Exception exception) {
                        continue;
                    }
                }
                this.arr_files.add(directoryModel);
            }
            Collections.sort(this.arr_files, new CustomFileComparator());
            this.arr_dir_stack.add(model);
            this.filePickerBinding.rvDirPath.scrollToPosition(this.arr_dir_stack.size() - 1);
            this.filePickerBinding.toolbar.setTitle((CharSequence)model.getName());
        }
        if (this.arr_files.size() == 0) {
            this.filePickerBinding.rlNoFiles.setVisibility(0);
        } else {
            this.filePickerBinding.rlNoFiles.setVisibility(8);
        }
        this.filePickerBinding.rlProgress.setVisibility(8);
        this.stackAdapter.notifyDataSetChanged();
        this.directoryAdapter.notifyDataSetChanged();
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        MenuInflater menuInflater = this.getMenuInflater();
        menuInflater.inflate(R.menu.unicorn_menu_file_picker, menu2);
        MenuItem item_search = menu2.findItem(R.id.action_search);
        SearchView searchView = (SearchView)item_search.getActionView();
        searchView.setImeOptions(6);
        searchView.setOnQueryTextListener(new SearchView.OnQueryTextListener(){

            public boolean onQueryTextSubmit(String query) {
                return false;
            }

            public boolean onQueryTextChange(String newText) {
                FilePickerActivity.this.directoryAdapter.getFilter().filter((CharSequence)newText);
                return false;
            }
        });
        return true;
    }

    private boolean allPermissionsGranted() {
        for (String permission : this.REQUIRED_PERMISSIONS) {
            if (ContextCompat.checkSelfPermission((Context)this, (String)permission) == 0) continue;
            return false;
        }
        return true;
    }

    public void onBackPressed() {
        if (this.arr_dir_stack.size() > 1) {
            this.arr_dir_stack.remove(this.arr_dir_stack.size() - 1);
            DirectoryModel model = this.arr_dir_stack.remove(this.arr_dir_stack.size() - 1);
            this.fetchDirectory(model);
        } else {
            Intent intent = new Intent();
            this.setResult(this.config.getReqCode(), intent);
            this.setResult(0, intent);
            this.finish();
        }
    }

    public boolean onOptionsItemSelected(@NonNull MenuItem item) {
        int id2 = item.getItemId();
        if (id2 == 16908332) {
            this.onBackPressed();
        }
        return true;
    }

    public static class CustomFileComparator
    implements Comparator<DirectoryModel> {
        @Override
        public int compare(DirectoryModel o1, DirectoryModel o2) {
            if (o1.isDirectory() && o2.isDirectory()) {
                return o1.getName().toLowerCase().compareTo(o2.getName().toLowerCase());
            }
            if (o1.isDirectory() && !o2.isDirectory()) {
                return -1;
            }
            if (!o1.isDirectory() && o2.isDirectory()) {
                return 1;
            }
            return o1.getName().toLowerCase().compareTo(o2.getName().toLowerCase());
        }
    }
}

