/*
 * Decompiled with CFR 0.152.
 */
package abhishekti7.unicorn.filepicker.adapters;

import abhishekti7.unicorn.filepicker.R;
import abhishekti7.unicorn.filepicker.models.DirectoryModel;
import android.content.Context;
import android.content.res.Resources;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import java.util.ArrayList;

public class DirectoryStackAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private Context context;
    private ArrayList<DirectoryModel> directoryList;
    private onDirectoryStackListener onDirectoryStackListener;
    private TypedValue typedValue;
    @ColorInt
    private int textColor;
    @ColorInt
    private int selectedTextColor;

    public DirectoryStackAdapter(Context context, ArrayList<DirectoryModel> directoryList, onDirectoryStackListener listener) {
        this.context = context;
        this.directoryList = directoryList;
        this.onDirectoryStackListener = listener;
        this.typedValue = new TypedValue();
        Resources.Theme theme = context.getTheme();
        theme.resolveAttribute(R.attr.unicorn_primaryTextColor, this.typedValue, true);
        this.textColor = this.typedValue.data;
        theme.resolveAttribute(R.attr.unicorn_colorAccent, this.typedValue, true);
        this.selectedTextColor = this.typedValue.data;
    }

    @NonNull
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = LayoutInflater.from((Context)this.context).inflate(R.layout.unicorn_item_layout_directory_stack, parent, false);
        return new ViewHolder(view);
    }

    public void onBindViewHolder(@NonNull ViewHolder holder, int position) {
        holder.tv_dir_name.setText((CharSequence)this.directoryList.get(position).getName());
        if (position == this.getItemCount() - 1) {
            holder.tv_dir_name.setTextColor(this.selectedTextColor);
        } else {
            holder.tv_dir_name.setTextColor(this.textColor);
        }
        holder.itemView.setOnClickListener(v -> this.onDirectoryStackListener.onDirClicked(this.directoryList.get(position)));
    }

    public int getItemCount() {
        return this.directoryList.size();
    }

    public class ViewHolder
    extends RecyclerView.ViewHolder {
        private TextView tv_dir_name;

        public ViewHolder(View itemView) {
            super(itemView);
            this.tv_dir_name = (TextView)itemView.findViewById(R.id.tv_dir_name);
        }
    }

    public static interface onDirectoryStackListener {
        public void onDirClicked(DirectoryModel var1);
    }
}

