/*
 * Decompiled with CFR 0.152.
 */
package abhishekti7.unicorn.filepicker;

import abhishekti7.unicorn.filepicker.ConfigBuilder;
import abhishekti7.unicorn.filepicker.models.Config;
import abhishekti7.unicorn.filepicker.ui.FilePickerActivity;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import java.lang.ref.WeakReference;

public final class UnicornFilePicker {
    private final WeakReference<Activity> mActivity;
    private final WeakReference<Fragment> mContext;

    private UnicornFilePicker(Activity activity) {
        this(activity, null);
    }

    private UnicornFilePicker(Fragment fragment) {
        this((Activity)fragment.getActivity(), fragment);
    }

    public UnicornFilePicker(Activity activity, Fragment fragment) {
        this.mActivity = new WeakReference<Activity>(activity);
        this.mContext = new WeakReference<Fragment>(fragment);
    }

    public static UnicornFilePicker from(Activity activity) {
        return new UnicornFilePicker(activity);
    }

    public static UnicornFilePicker from(Fragment fragment) {
        return new UnicornFilePicker(fragment);
    }

    public void forResult(int requestCode) {
        Config.getInstance().setReqCode(requestCode);
        Activity activity = this.getActivity();
        if (activity == null) {
            return;
        }
        Intent intent = new Intent((Context)activity, FilePickerActivity.class);
        Fragment fragment = this.getFragment();
        if (fragment == null) {
            activity.startActivityForResult(intent, requestCode);
        } else {
            fragment.startActivityForResult(intent, requestCode);
        }
    }

    public ConfigBuilder addConfigBuilder() {
        return new ConfigBuilder(this);
    }

    @Nullable
    Activity getActivity() {
        return (Activity)this.mActivity.get();
    }

    @Nullable
    Fragment getFragment() {
        return (Fragment)this.mContext.get();
    }
}

