/*
 * Decompiled with CFR 0.152.
 */
package abhishekti7.unicorn.filepicker;

import abhishekti7.unicorn.filepicker.R;
import abhishekti7.unicorn.filepicker.UnicornFilePicker;
import abhishekti7.unicorn.filepicker.models.Config;
import androidx.annotation.StyleRes;
import java.util.ArrayList;
import java.util.Arrays;

public final class ConfigBuilder {
    private String rootDir;
    private boolean showHidden = false;
    private boolean selectMultiple = false;
    private boolean addDivider = false;
    private boolean showOnlyDir = false;
    @StyleRes
    private int themeId = R.style.UnicornFilePicker_Default;
    private final UnicornFilePicker unicornFilePicker;
    private ArrayList<String> extensionFilters;
    private Config config;

    public ConfigBuilder(UnicornFilePicker unicornFilePicker) {
        this.unicornFilePicker = unicornFilePicker;
        this.config = Config.getCleanInstance();
    }

    public ConfigBuilder setRootDirectory(String dirPath) {
        this.rootDir = dirPath;
        return this;
    }

    public ConfigBuilder showHiddenFiles(boolean value) {
        this.showHidden = value;
        return this;
    }

    public ConfigBuilder selectMultipleFiles(boolean value) {
        this.selectMultiple = value;
        return this;
    }

    public ConfigBuilder setFilters(String[] filters) {
        this.extensionFilters = new ArrayList<String>(Arrays.asList(filters));
        return this;
    }

    public ConfigBuilder addItemDivider(boolean value) {
        this.addDivider = value;
        return this;
    }

    public ConfigBuilder theme(@StyleRes int theme) {
        this.themeId = theme;
        return this;
    }

    public ConfigBuilder showOnlyDirectory(boolean value) {
        this.showOnlyDir = value;
        return this;
    }

    public UnicornFilePicker build() {
        this.config.setRootDir(this.rootDir);
        this.config.setSelectMultiple(this.selectMultiple);
        this.config.setShowHidden(this.showHidden);
        this.config.setExtensionFilters(this.extensionFilters);
        this.config.setAddItemDivider(this.addDivider);
        this.config.setThemeId(this.themeId);
        this.config.setShowOnlyDirectory(this.showOnlyDir);
        return this.unicornFilePicker;
    }
}

