/*
 * Decompiled with CFR 0.152.
 */
package com.xtivia.sgdxp.filter;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.xtivia.sgdxp.annotation.OrgRole;
import com.xtivia.sgdxp.core.SgDxpApplication;
import com.xtivia.sgdxp.filter.AbstractSecurityFilter;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@OrgRole
public class OrgRoleFilter
extends AbstractSecurityFilter {
    private static Logger _logger = LoggerFactory.getLogger(OrgRoleFilter.class);

    public OrgRoleFilter(SgDxpApplication xsfApplication) {
        super(xsfApplication);
    }

    @Override
    public void filter(ContainerRequestContext requestContext) {
        ResourceInfo resourceInfo;
        if (_logger.isDebugEnabled()) {
            resourceInfo = super.getResourceInfo();
            _logger.debug(String.format("Org role filter executes for class=%s, method=%s", resourceInfo.getResourceClass().getName(), resourceInfo.getResourceMethod().getName()));
        }
        if (!this.checkUserInOrgRole()) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        if (_logger.isDebugEnabled()) {
            resourceInfo = super.getResourceInfo();
            _logger.debug(String.format("Org role filter succeeds for class=%s, method=%s", resourceInfo.getResourceClass().getName(), resourceInfo.getResourceMethod().getName()));
        }
    }

    private boolean checkUserInOrgRole() {
        boolean result;
        block8: {
            result = true;
            OrgRole annotation = (OrgRole)this.getAnnotation(OrgRole.class);
            if (annotation != null) {
                User user = this.getUser();
                if (user != null && !user.isDefaultUser()) {
                    Organization foundOrg = null;
                    try {
                        String orgname = annotation.org();
                        String rolename = annotation.role();
                        List organizations = user.getOrganizations();
                        for (Organization organization : organizations) {
                            if (!organization.getName().equals(orgname)) continue;
                            foundOrg = organization;
                            break;
                        }
                        if (foundOrg != null) {
                            RoleLocalService roleLocalService = this.getSgDxpApplication().getRoleLocalService();
                            List roles = roleLocalService.getUserGroupRoles(user.getUserId(), foundOrg.getGroupId());
                            result = false;
                            for (Role role : roles) {
                                if (!role.getName().equals(rolename)) continue;
                                result = true;
                            }
                            break block8;
                        }
                        result = false;
                    }
                    catch (PortalException | SystemException e) {
                        _logger.error("Error accessing DXP role service", e);
                        result = false;
                    }
                } else {
                    result = false;
                }
            }
        }
        return result;
    }
}

