/*
 * Decompiled with CFR 0.152.
 */
package in.aabhasjindal.otptextview;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import androidx.core.content.res.ResourcesCompat;
import in.aabhasjindal.otptextview.R;
import in.aabhasjindal.otptextview.Utils;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 %2\u00020\u0001:\u0001%B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0012\u0010\u001f\u001a\u00020\u001c2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0003J\u000e\u0010 \u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"J\u000e\u0010#\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020\tR\u000e\u0010\u000b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lin/aabhasjindal/otptextview/ItemView;", "Landroid/widget/FrameLayout;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "barActiveColor", "barErrorColor", "barInactiveColor", "barSuccessColor", "boxBackgroundColorActive", "boxBackgroundColorError", "boxBackgroundColorInactive", "boxBackgroundColorSuccess", "defaultOTPDrawable", "hideOTP", "", "hideOTPDrawable", "textView", "Landroid/widget/TextView;", "view", "Landroid/view/View;", "generateViews", "", "styles", "Landroid/content/res/TypedArray;", "init", "setText", "value", "", "setViewState", "state", "Companion", "otptextview_release"})
public final class ItemView
extends FrameLayout {
    private TextView textView;
    private View view;
    private int barActiveColor;
    private int barInactiveColor;
    private int barErrorColor;
    private int barSuccessColor;
    private int boxBackgroundColorActive;
    private int boxBackgroundColorInactive;
    private int boxBackgroundColorSuccess;
    private int boxBackgroundColorError;
    private int hideOTPDrawable;
    private int defaultOTPDrawable;
    private boolean hideOTP;
    public static final int ACTIVE = 1;
    public static final int INACTIVE = 0;
    public static final int ERROR = -1;
    public static final int SUCCESS = 2;
    private static final float DEFAULT_BAR_HEIGHT = 2.0f;
    private static final float DEFAULT_OTP_TEXT_SIZE = 24.0f;
    private static final int DEFAULT_BAR_MARGIN = 2;
    public static final Companion Companion = new Companion(null);
    private HashMap _$_findViewCache;

    @SuppressLint(value={"CustomViewStyleable"})
    private final void init(AttributeSet attrs) {
        TypedArray styles;
        TypedArray typedArray = styles = this.getContext().obtainStyledAttributes(attrs, R.styleable.OtpTextView);
        Intrinsics.checkExpressionValueIsNotNull((Object)typedArray, (String)"styles");
        this.generateViews(typedArray);
        styles.recycle();
    }

    private final void generateViews(TypedArray styles) {
        Context context = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
        float defaultHeight = Utils.INSTANCE.getPixels$otptextview_release(context, 2.0f);
        Context context2 = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"context");
        float defaultOtpTextSize = Utils.INSTANCE.getPixels$otptextview_release(context2, 24.0f);
        Context context3 = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context3, (String)"context");
        int textColor = styles.getColor(R.styleable.OtpTextView_android_textColor, ResourcesCompat.getColor((Resources)context3.getResources(), (int)R.color.black, null));
        float barHeight = styles.getDimension(R.styleable.OtpTextView_bar_height, defaultHeight);
        Context context4 = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context4, (String)"context");
        float barMargin = styles.getDimension(R.styleable.OtpTextView_bar_margin, (float)Utils.INSTANCE.getPixels$otptextview_release(context4, 0));
        float barMarginBottom = styles.getDimension(R.styleable.OtpTextView_bar_margin_bottom, (float)2);
        float barMarginRight = styles.getDimension(R.styleable.OtpTextView_bar_margin_right, (float)2);
        float barMarginLeft = styles.getDimension(R.styleable.OtpTextView_bar_margin_left, (float)2);
        float barMarginTop = styles.getDimension(R.styleable.OtpTextView_bar_margin_top, (float)2);
        this.hideOTP = styles.getBoolean(R.styleable.OtpTextView_hide_otp, false);
        this.hideOTPDrawable = styles.getResourceId(R.styleable.OtpTextView_hide_otp_drawable, R.drawable.bg_pin);
        Context context5 = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context5, (String)"context");
        this.defaultOTPDrawable = ResourcesCompat.getColor((Resources)context5.getResources(), (int)R.color.transparent, null);
        boolean barEnabled = styles.getBoolean(R.styleable.OtpTextView_bar_enabled, false);
        float otpTextSize = styles.getDimension(R.styleable.OtpTextView_otp_text_size, defaultOtpTextSize);
        String otpTextTypeFace = styles.getString(R.styleable.OtpTextView_text_typeface);
        Context context6 = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context6, (String)"context");
        int boxBackgroundColor = styles.getResourceId(R.styleable.OtpTextView_otp_box_background, ResourcesCompat.getColor((Resources)context6.getResources(), (int)R.color.transparent, null));
        this.boxBackgroundColorActive = styles.getResourceId(R.styleable.OtpTextView_otp_box_background_active, boxBackgroundColor);
        this.boxBackgroundColorInactive = styles.getResourceId(R.styleable.OtpTextView_otp_box_background_inactive, boxBackgroundColor);
        this.boxBackgroundColorSuccess = styles.getResourceId(R.styleable.OtpTextView_otp_box_background_success, boxBackgroundColor);
        this.boxBackgroundColorError = styles.getResourceId(R.styleable.OtpTextView_otp_box_background_error, boxBackgroundColor);
        Context context7 = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context7, (String)"context");
        this.barActiveColor = styles.getColor(R.styleable.OtpTextView_bar_active_color, ResourcesCompat.getColor((Resources)context7.getResources(), (int)R.color.black, null));
        Context context8 = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context8, (String)"context");
        this.barInactiveColor = styles.getColor(R.styleable.OtpTextView_bar_inactive_color, ResourcesCompat.getColor((Resources)context8.getResources(), (int)R.color.grey, null));
        Context context9 = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context9, (String)"context");
        this.barErrorColor = styles.getColor(R.styleable.OtpTextView_bar_error_color, ResourcesCompat.getColor((Resources)context9.getResources(), (int)R.color.red, null));
        Context context10 = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context10, (String)"context");
        this.barSuccessColor = styles.getColor(R.styleable.OtpTextView_bar_success_color, ResourcesCompat.getColor((Resources)context10.getResources(), (int)R.color.black, null));
        this.setBackgroundResource(boxBackgroundColor);
        FrameLayout.LayoutParams textViewParams = new FrameLayout.LayoutParams(-1, -1);
        textViewParams.gravity = 17;
        TextView textView = this.textView = new TextView(this.getContext());
        if (textView != null) {
            textView.setGravity(17);
        }
        if (otpTextTypeFace != null) {
            try {
                Context context11 = this.getContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)context11, (String)"context");
                Typeface tf = Typeface.createFromAsset((AssetManager)context11.getAssets(), (String)otpTextTypeFace);
                TextView textView2 = this.textView;
                if (textView2 != null) {
                    textView2.setTypeface(tf);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        TextView textView3 = this.textView;
        if (textView3 != null) {
            textView3.setTextColor(textColor);
        }
        TextView textView4 = this.textView;
        if (textView4 != null) {
            textView4.setTextSize(0, otpTextSize);
        }
        this.addView((View)this.textView, (ViewGroup.LayoutParams)textViewParams);
        if (barEnabled) {
            FrameLayout.LayoutParams barViewParams = new FrameLayout.LayoutParams(-1, (int)barHeight);
            barViewParams.gravity = 80;
            if (barMargin != 0.0f) {
                barMarginLeft = barMargin;
                barMarginRight = barMargin;
                barMarginBottom = barMargin;
                barMarginTop = barMargin;
            }
            barViewParams.leftMargin = (int)barMarginLeft;
            barViewParams.rightMargin = (int)barMarginRight;
            barViewParams.bottomMargin = (int)barMarginBottom;
            barViewParams.topMargin = (int)barMarginTop;
            this.view = new View(this.getContext());
            this.addView(this.view, (ViewGroup.LayoutParams)barViewParams);
        }
    }

    public final void setText(@NotNull String value) {
        block3: {
            block4: {
                block2: {
                    Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                    if (this.hideOTP) break block2;
                    if (this.textView == null) break block3;
                    TextView textView = this.textView;
                    if (textView != null) {
                        textView.setText((CharSequence)value);
                    }
                    break block3;
                }
                TextView textView = this.textView;
                if (textView != null) {
                    textView.setText((CharSequence)"");
                }
                if (!Intrinsics.areEqual((Object)value, (Object)"")) break block4;
                TextView textView2 = this.textView;
                if (textView2 == null) break block3;
                textView2.setBackgroundResource(this.defaultOTPDrawable);
                break block3;
            }
            TextView textView = this.textView;
            if (textView == null) break block3;
            textView.setBackgroundResource(this.hideOTPDrawable);
        }
    }

    public final void setViewState(int state) {
        switch (state) {
            case 1: {
                View view = this.view;
                if (view != null) {
                    view.setBackgroundColor(this.barActiveColor);
                }
                this.setBackgroundResource(this.boxBackgroundColorActive);
                break;
            }
            case 0: {
                View view = this.view;
                if (view != null) {
                    view.setBackgroundColor(this.barInactiveColor);
                }
                this.setBackgroundResource(this.boxBackgroundColorInactive);
                break;
            }
            case -1: {
                View view = this.view;
                if (view != null) {
                    view.setBackgroundColor(this.barErrorColor);
                }
                this.setBackgroundResource(this.boxBackgroundColorError);
                break;
            }
            case 2: {
                View view = this.view;
                if (view != null) {
                    view.setBackgroundColor(this.barSuccessColor);
                }
                this.setBackgroundResource(this.boxBackgroundColorSuccess);
            }
        }
    }

    public ItemView(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context);
        this.init(null);
    }

    public ItemView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs);
        this.init(attrs);
    }

    public ItemView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lin/aabhasjindal/otptextview/ItemView$Companion;", "", "()V", "ACTIVE", "", "DEFAULT_BAR_HEIGHT", "", "DEFAULT_BAR_MARGIN", "DEFAULT_OTP_TEXT_SIZE", "ERROR", "INACTIVE", "SUCCESS", "otptextview_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

