/*
 * Decompiled with CFR 0.152.
 */
package com.gowtham.library.ui.seekbar.widgets;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import androidx.core.content.ContextCompat;
import com.gowtham.library.R;
import com.gowtham.library.ui.seekbar.interfaces.OnSeekbarChangeListener;
import com.gowtham.library.ui.seekbar.interfaces.OnSeekbarFinalValueListener;

public class CrystalSeekbar
extends View {
    private static final int INVALID_POINTER_ID = 255;
    private final float NO_STEP = -1.0f;
    private OnSeekbarChangeListener onSeekbarChangeListener;
    private OnSeekbarFinalValueListener onSeekbarFinalValueListener;
    private float absoluteMinValue;
    private float absoluteMaxValue;
    private float minValue;
    private float maxValue;
    private float minStartValue;
    private float steps;
    private int mActivePointerId = 255;
    private int position;
    private int nextPosition;
    private int dataType;
    private float cornerRadius;
    private int barColorMode;
    private int barColor;
    private int barGradientStart;
    private int barGradientEnd;
    private int barHighlightColorMode;
    private int barHighlightColor;
    private int barHighlightGradientStart;
    private int barHighlightGradientEnd;
    private int thumbColor;
    private int thumbColorNormal;
    private int thumbColorPressed;
    private boolean seekBarTouchEnabled;
    private float barPadding;
    private float _barHeight;
    private float barHeight;
    private float thumbWidth;
    private float thumbHeight;
    private float thumbDiameter;
    private Drawable thumbDrawable;
    private Drawable thumbDrawablePressed;
    private Bitmap thumb;
    private Bitmap thumbPressed;
    private Thumb pressedThumb;
    private double normalizedMinValue = 0.0;
    private double normalizedMaxValue = 100.0;
    private int pointerIndex;
    private RectF _rect;
    private Paint _paint;
    private RectF rectThumb;
    private boolean mIsDragging;

    public CrystalSeekbar(Context context) {
        this(context, null);
    }

    public CrystalSeekbar(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CrystalSeekbar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        if (this.isInEditMode()) {
            return;
        }
        TypedArray array = context.obtainStyledAttributes(attrs, R.styleable.CrystalSeekbar);
        try {
            this.cornerRadius = this.getCornerRadius(array);
            this.minValue = this.getMinValue(array);
            this.maxValue = this.getMaxValue(array);
            this.minStartValue = this.getMinStartValue(array);
            this.steps = this.getSteps(array);
            this._barHeight = this.getBarHeight(array);
            this.barColorMode = this.getBarColorMode(array);
            this.barColor = this.getBarColor(array);
            this.barGradientStart = this.getBarGradientStart(array);
            this.barGradientEnd = this.getBarGradientEnd(array);
            this.barHighlightColorMode = this.getBarHighlightColorMode(array);
            this.barHighlightColor = this.getBarHighlightColor(array);
            this.barHighlightGradientStart = this.getBarHighlightGradientStart(array);
            this.barHighlightGradientEnd = this.getBarHighlightGradientEnd(array);
            this.thumbColorNormal = this.getThumbColor(array);
            this.thumbColorPressed = this.getThumbColorPressed(array);
            this.thumbDrawable = this.getThumbDrawable(array);
            this.thumbDrawablePressed = this.getThumbDrawablePressed(array);
            this.dataType = this.getDataType(array);
            this.nextPosition = this.position = this.getPosition(array);
            this.thumbDiameter = this.getDiameter(array);
            this.seekBarTouchEnabled = this.isSeekBarTouchEnabled(array);
        }
        finally {
            array.recycle();
        }
        this.init();
    }

    protected void init() {
        this.absoluteMinValue = this.minValue;
        this.absoluteMaxValue = this.maxValue;
        this.thumbColor = this.thumbColorNormal;
        this.thumb = this.getBitmap(this.thumbDrawable);
        this.thumbPressed = this.getBitmap(this.thumbDrawablePressed);
        this.thumbPressed = this.thumbPressed == null ? this.thumb : this.thumbPressed;
        this.thumbWidth = this.getThumbWidth();
        this.thumbHeight = this.getThumbHeight();
        this.barHeight = this.getBarHeight();
        this.barPadding = this.getBarPadding();
        this._paint = new Paint(1);
        this._rect = new RectF();
        this.rectThumb = new RectF();
        this.pressedThumb = null;
        this.setMinStartValue();
        this.setWillNotDraw(false);
    }

    public CrystalSeekbar setCornerRadius(float cornerRadius) {
        this.cornerRadius = cornerRadius;
        return this;
    }

    public CrystalSeekbar setMinValue(float minValue) {
        this.minValue = minValue;
        this.absoluteMinValue = minValue;
        return this;
    }

    public CrystalSeekbar setMaxValue(float maxValue) {
        this.maxValue = maxValue;
        this.absoluteMaxValue = maxValue;
        return this;
    }

    public CrystalSeekbar setMinStartValue(float minStartValue) {
        this.minStartValue = minStartValue;
        return this;
    }

    public CrystalSeekbar setSteps(float steps) {
        this.steps = steps;
        return this;
    }

    public CrystalSeekbar setBarHeight(float barHeight) {
        this._barHeight = barHeight;
        return this;
    }

    public CrystalSeekbar setBarColorMode(int barColorMode) {
        this.barColorMode = barColorMode;
        return this;
    }

    public CrystalSeekbar setBarColor(int barColor) {
        this.barColor = barColor;
        return this;
    }

    public CrystalSeekbar setBarGradientStart(int barGradientStart) {
        this.barGradientStart = barGradientStart;
        return this;
    }

    public CrystalSeekbar setBarGradientEnd(int barGradientEnd) {
        this.barGradientEnd = barGradientEnd;
        return this;
    }

    public CrystalSeekbar setBarHighlightColorMode(int barHighlightColorMode) {
        this.barHighlightColorMode = barHighlightColorMode;
        return this;
    }

    public CrystalSeekbar setBarHighlightColor(int barHighlightColor) {
        this.barHighlightColor = barHighlightColor;
        return this;
    }

    public CrystalSeekbar setBarHighlightGradientStart(int barHighlightGradientStart) {
        this.barHighlightGradientStart = barHighlightGradientStart;
        return this;
    }

    public CrystalSeekbar setBarHighlightGradientEnd(int barHighlightGradientEnd) {
        this.barHighlightGradientEnd = barHighlightGradientEnd;
        return this;
    }

    public CrystalSeekbar setThumbColor(int leftThumbColorNormal) {
        this.thumbColorNormal = leftThumbColorNormal;
        return this;
    }

    public CrystalSeekbar setThumbHighlightColor(int leftThumbColorPressed) {
        this.thumbColorPressed = leftThumbColorPressed;
        return this;
    }

    public CrystalSeekbar setThumbDrawable(int resId) {
        this.setThumbDrawable(ContextCompat.getDrawable((Context)this.getContext(), (int)resId));
        return this;
    }

    public CrystalSeekbar setThumbDrawable(Drawable drawable) {
        this.setThumbBitmap(this.getBitmap(drawable));
        return this;
    }

    public CrystalSeekbar setThumbBitmap(Bitmap bitmap) {
        this.thumb = bitmap;
        return this;
    }

    public CrystalSeekbar setThumbHighlightDrawable(int resId) {
        this.setThumbHighlightDrawable(ContextCompat.getDrawable((Context)this.getContext(), (int)resId));
        return this;
    }

    public CrystalSeekbar setThumbHighlightDrawable(Drawable drawable) {
        this.setThumbHighlightBitmap(this.getBitmap(drawable));
        return this;
    }

    public CrystalSeekbar setThumbHighlightBitmap(Bitmap bitmap) {
        this.thumbPressed = bitmap;
        return this;
    }

    public CrystalSeekbar setDataType(int dataType) {
        this.dataType = dataType;
        return this;
    }

    public CrystalSeekbar setPosition(int pos) {
        this.nextPosition = pos;
        return this;
    }

    public void setOnSeekbarChangeListener(OnSeekbarChangeListener onSeekbarChangeListener) {
        this.onSeekbarChangeListener = onSeekbarChangeListener;
        if (this.onSeekbarChangeListener != null) {
            this.onSeekbarChangeListener.valueChanged(this.getSelectedMinValue());
        }
    }

    public void setOnSeekbarFinalValueListener(OnSeekbarFinalValueListener onSeekbarFinalValueListener) {
        this.onSeekbarFinalValueListener = onSeekbarFinalValueListener;
    }

    public Thumb getPressedThumb() {
        return this.pressedThumb;
    }

    public RectF getThumbRect() {
        return this.rectThumb;
    }

    public float getCornerRadius() {
        return this.cornerRadius;
    }

    public float getMinValue() {
        return this.minValue;
    }

    public float getMaxValue() {
        return this.maxValue;
    }

    public float getMinStartValue() {
        return this.minStartValue;
    }

    public float getSteps() {
        return this.steps;
    }

    public int getBarColor() {
        return this.barColor;
    }

    public int getBarHighlightColor() {
        return this.barHighlightColor;
    }

    public int getLeftThumbColor() {
        return this.thumbColor;
    }

    public int getLeftThumbColorPressed() {
        return this.thumbColorPressed;
    }

    public Drawable getLeftDrawable() {
        return this.thumbDrawable;
    }

    public Drawable getLeftDrawablePressed() {
        return this.thumbDrawablePressed;
    }

    public int getDataType() {
        return this.dataType;
    }

    public int getPosition() {
        return this.position;
    }

    public float getThumbWidth() {
        return this.thumb != null ? (float)this.thumb.getWidth() : this.getThumbDiameter();
    }

    public float getThumbHeight() {
        return this.thumb != null ? (float)this.thumb.getHeight() : this.getThumbDiameter();
    }

    protected float getThumbDiameter() {
        return this.thumbDiameter > 0.0f ? this.thumbDiameter : this.getResources().getDimension(R.dimen.thumb_width);
    }

    public float getBarHeight() {
        return this._barHeight > 0.0f ? this._barHeight : this.thumbHeight * 0.5f * 0.3f;
    }

    public float getDiameter(TypedArray typedArray) {
        return typedArray.getDimensionPixelSize(R.styleable.CrystalSeekbar_thumb_diameter, this.getResources().getDimensionPixelSize(R.dimen.thumb_height));
    }

    protected boolean isSeekBarTouchEnabled(TypedArray typedArray) {
        return typedArray.getBoolean(R.styleable.CrystalSeekbar_seek_bar_touch_enabled, false);
    }

    public float getBarPadding() {
        return this.thumbWidth * 0.5f;
    }

    public Number getSelectedMinValue() {
        double nv = this.normalizedMinValue;
        if (this.steps > 0.0f && this.steps <= this.absoluteMaxValue / 2.0f) {
            float stp = this.steps / (this.absoluteMaxValue - this.absoluteMinValue) * 100.0f;
            double mod = nv % (double)stp;
            double half_step = stp / 2.0f;
            if (mod > half_step) {
                nv -= mod;
                nv += (double)stp;
            } else {
                nv -= mod;
            }
        } else if (this.steps != -1.0f) {
            throw new IllegalStateException("steps out of range " + this.steps);
        }
        nv = this.position == 0 ? nv : Math.abs(nv - (double)this.maxValue);
        return this.formatValue(this.normalizedToValue(nv));
    }

    public Number getSelectedMaxValue() {
        double nv = this.normalizedMaxValue;
        if (this.steps > 0.0f && this.steps <= this.absoluteMaxValue / 2.0f) {
            float stp = this.steps / (this.absoluteMaxValue - this.absoluteMinValue) * 100.0f;
            double mod = nv % (double)stp;
            double half_step = stp / 2.0f;
            if (mod > half_step) {
                nv -= mod;
                nv += (double)stp;
            } else {
                nv -= mod;
            }
        } else if (this.steps != -1.0f) {
            throw new IllegalStateException("steps out of range " + this.steps);
        }
        return this.formatValue(this.normalizedToValue(nv));
    }

    public void apply() {
        this.thumbWidth = this.thumb != null ? (float)this.thumb.getWidth() : this.getResources().getDimension(R.dimen.thumb_width);
        this.thumbHeight = this.thumb != null ? (float)this.thumb.getHeight() : this.getResources().getDimension(R.dimen.thumb_height);
        this.barHeight = this.thumbHeight * 0.5f * 0.3f;
        this.barPadding = this.thumbWidth * 0.5f;
        if (this.minStartValue <= this.minValue) {
            this.minStartValue = 0.0f;
            this.setNormalizedMinValue(this.minStartValue);
        } else if (this.minStartValue > this.maxValue) {
            this.minStartValue = this.maxValue;
            this.setNormalizedMinValue(this.minStartValue);
        } else {
            if (this.nextPosition != this.position) {
                this.minStartValue = (float)Math.abs(this.normalizedMaxValue - this.normalizedMinValue);
            }
            if (this.minStartValue > this.minValue) {
                this.minStartValue = Math.min(this.minStartValue, this.absoluteMaxValue);
                this.minStartValue -= this.absoluteMinValue;
                this.minStartValue = this.minStartValue / (this.absoluteMaxValue - this.absoluteMinValue) * 100.0f;
            }
            this.setNormalizedMinValue(this.minStartValue);
            this.position = this.nextPosition;
        }
        this.invalidate();
        if (this.onSeekbarChangeListener != null) {
            this.onSeekbarChangeListener.valueChanged(this.getSelectedMinValue());
        }
    }

    protected Bitmap getBitmap(Drawable drawable) {
        return drawable != null ? ((BitmapDrawable)drawable).getBitmap() : null;
    }

    protected float getCornerRadius(TypedArray typedArray) {
        return typedArray.getFloat(R.styleable.CrystalSeekbar_corner_radius, 0.0f);
    }

    protected float getMinValue(TypedArray typedArray) {
        return typedArray.getFloat(R.styleable.CrystalSeekbar_min_value, 0.0f);
    }

    protected float getMaxValue(TypedArray typedArray) {
        return typedArray.getFloat(R.styleable.CrystalSeekbar_max_value, 100.0f);
    }

    protected float getMinStartValue(TypedArray typedArray) {
        return typedArray.getFloat(R.styleable.CrystalSeekbar_min_start_value, this.minValue);
    }

    protected float getSteps(TypedArray typedArray) {
        return typedArray.getFloat(R.styleable.CrystalSeekbar_steps, -1.0f);
    }

    protected float getBarHeight(TypedArray typedArray) {
        return typedArray.getDimensionPixelSize(R.styleable.CrystalSeekbar_bar_height, 0);
    }

    protected int getBarColorMode(TypedArray typedArray) {
        return typedArray.getInt(R.styleable.CrystalSeekbar_bar_color_mode, 0);
    }

    protected int getBarColor(TypedArray typedArray) {
        return typedArray.getColor(R.styleable.CrystalSeekbar_bar_color, -7829368);
    }

    protected int getBarGradientStart(TypedArray typedArray) {
        return typedArray.getColor(R.styleable.CrystalSeekbar_bar_gradient_start, -7829368);
    }

    protected int getBarGradientEnd(TypedArray typedArray) {
        return typedArray.getColor(R.styleable.CrystalSeekbar_bar_gradient_end, -12303292);
    }

    protected int getBarHighlightColorMode(TypedArray typedArray) {
        return typedArray.getInt(R.styleable.CrystalSeekbar_bar_highlight_color_mode, 0);
    }

    protected int getBarHighlightColor(TypedArray typedArray) {
        return typedArray.getColor(R.styleable.CrystalSeekbar_bar_highlight_color, -16777216);
    }

    protected int getBarHighlightGradientStart(TypedArray typedArray) {
        return typedArray.getColor(R.styleable.CrystalSeekbar_bar_highlight_gradient_start, -12303292);
    }

    protected int getBarHighlightGradientEnd(TypedArray typedArray) {
        return typedArray.getColor(R.styleable.CrystalSeekbar_bar_highlight_gradient_end, -16777216);
    }

    protected int getThumbColor(TypedArray typedArray) {
        return typedArray.getColor(R.styleable.CrystalSeekbar_thumb_color, -16777216);
    }

    protected int getThumbColorPressed(TypedArray typedArray) {
        return typedArray.getColor(R.styleable.CrystalSeekbar_thumb_color_pressed, -12303292);
    }

    protected Drawable getThumbDrawable(TypedArray typedArray) {
        return typedArray.getDrawable(R.styleable.CrystalSeekbar_thumb_image);
    }

    protected Drawable getThumbDrawablePressed(TypedArray typedArray) {
        return typedArray.getDrawable(R.styleable.CrystalSeekbar_thumb_image_pressed);
    }

    protected int getDataType(TypedArray typedArray) {
        return typedArray.getInt(R.styleable.CrystalSeekbar_data_type, 2);
    }

    protected final int getPosition(TypedArray typedArray) {
        int pos = typedArray.getInt(R.styleable.CrystalSeekbar_position, 0);
        this.normalizedMinValue = pos == 0 ? this.normalizedMinValue : this.normalizedMaxValue;
        return pos;
    }

    protected void setupBar(Canvas canvas, Paint paint, RectF rect) {
        rect.left = this.barPadding;
        rect.top = 0.5f * ((float)this.getHeight() - this.barHeight);
        rect.right = (float)this.getWidth() - this.barPadding;
        rect.bottom = 0.5f * ((float)this.getHeight() + this.barHeight);
        paint.setStyle(Paint.Style.FILL);
        paint.setAntiAlias(true);
        if (this.barColorMode == 0) {
            paint.setColor(this.barColor);
            this.drawBar(canvas, paint, rect);
        } else {
            paint.setShader((Shader)new LinearGradient(rect.left, rect.bottom, rect.right, rect.top, this.barGradientStart, this.barGradientEnd, Shader.TileMode.MIRROR));
            this.drawBar(canvas, paint, rect);
            paint.setShader(null);
        }
    }

    protected void drawBar(Canvas canvas, Paint paint, RectF rect) {
        canvas.drawRoundRect(rect, this.cornerRadius, this.cornerRadius, paint);
    }

    protected void setupHighlightBar(Canvas canvas, Paint paint, RectF rect) {
        if (this.position == 1) {
            rect.left = this.normalizedToScreen(this.normalizedMinValue) + this.getThumbWidth() / 2.0f;
            rect.right = (float)this.getWidth() - this.getThumbWidth() / 2.0f;
        } else {
            rect.left = this.getThumbWidth() / 2.0f;
            rect.right = this.normalizedToScreen(this.normalizedMinValue) + this.getThumbWidth() / 2.0f;
        }
        paint.setStyle(Paint.Style.FILL);
        paint.setAntiAlias(true);
        if (this.barHighlightColorMode == 0) {
            paint.setColor(this.barHighlightColor);
            this.drawHighlightBar(canvas, paint, rect);
        } else {
            paint.setShader((Shader)new LinearGradient(rect.left, rect.bottom, rect.right, rect.top, this.barHighlightGradientStart, this.barHighlightGradientEnd, Shader.TileMode.MIRROR));
            this.drawHighlightBar(canvas, paint, rect);
            paint.setShader(null);
        }
    }

    protected void drawHighlightBar(Canvas canvas, Paint paint, RectF rect) {
        canvas.drawRoundRect(rect, this.cornerRadius, this.cornerRadius, paint);
    }

    protected void setupLeftThumb(Canvas canvas, Paint paint, RectF rect) {
        this.thumbColor = Thumb.MIN.equals((Object)this.pressedThumb) ? this.thumbColorPressed : this.thumbColorNormal;
        paint.setColor(this.thumbColor);
        this.rectThumb.left = this.normalizedToScreen(this.normalizedMinValue);
        this.rectThumb.right = Math.min(this.rectThumb.left + this.getThumbWidth() / 2.0f + this.barPadding, (float)this.getWidth());
        this.rectThumb.top = 0.0f;
        this.rectThumb.bottom = this.thumbHeight;
        if (this.thumb != null) {
            Bitmap lThumb = Thumb.MIN.equals((Object)this.pressedThumb) ? this.thumbPressed : this.thumb;
            this.drawLeftThumbWithImage(canvas, paint, this.rectThumb, lThumb);
        } else {
            this.drawLeftThumbWithColor(canvas, paint, this.rectThumb);
        }
    }

    protected void drawLeftThumbWithColor(Canvas canvas, Paint paint, RectF rect) {
        canvas.drawOval(rect, paint);
    }

    protected void drawLeftThumbWithImage(Canvas canvas, Paint paint, RectF rect, Bitmap image) {
        canvas.drawBitmap(image, rect.left, rect.top, paint);
    }

    protected void trackTouchEvent(MotionEvent event) {
        int pointerIndex = event.findPointerIndex(this.mActivePointerId);
        try {
            float x = event.getX(pointerIndex);
            if (Thumb.MIN.equals((Object)this.pressedThumb)) {
                this.setNormalizedMinValue(this.screenToNormalized(x));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void touchDown(float x, float y) {
    }

    protected void touchMove(float x, float y) {
    }

    protected void touchUp(float x, float y) {
    }

    protected int getMeasureSpecWith(int widthMeasureSpec) {
        int width = 200;
        if (0 != View.MeasureSpec.getMode((int)widthMeasureSpec)) {
            width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        }
        return width;
    }

    protected int getMeasureSpecHeight(int heightMeasureSpec) {
        int height = Math.round(this.thumbHeight);
        if (0 != View.MeasureSpec.getMode((int)heightMeasureSpec)) {
            height = Math.min(height, View.MeasureSpec.getSize((int)heightMeasureSpec));
        }
        return height;
    }

    protected final void log(Object object) {
        Log.d((String)"CRS=>", (String)String.valueOf(object));
    }

    private void setMinStartValue() {
        if (this.minStartValue > this.minValue && this.minStartValue < this.maxValue) {
            this.minStartValue = Math.min(this.minStartValue, this.absoluteMaxValue);
            this.minStartValue -= this.absoluteMinValue;
            this.minStartValue = this.minStartValue / (this.absoluteMaxValue - this.absoluteMinValue) * 100.0f;
            this.setNormalizedMinValue(this.minStartValue);
        }
    }

    private Thumb evalPressedThumb(float touchX) {
        Thumb result = null;
        boolean minThumbPressed = this.isInThumbRange(touchX, this.normalizedMinValue);
        if (this.seekBarTouchEnabled || minThumbPressed) {
            result = Thumb.MIN;
        }
        return result;
    }

    private boolean isInThumbRange(float touchX, double normalizedThumbValue) {
        float thumbPos = this.normalizedToScreen(normalizedThumbValue);
        float left = thumbPos - this.getThumbWidth() / 2.0f;
        float right = thumbPos + this.getThumbWidth() / 2.0f;
        float x = touchX - this.getThumbWidth() / 2.0f;
        if (thumbPos > (float)this.getWidth() - this.thumbWidth) {
            x = touchX;
        }
        return x >= left && x <= right;
    }

    private void onStartTrackingTouch() {
        this.mIsDragging = true;
    }

    private void onStopTrackingTouch() {
        this.mIsDragging = false;
    }

    private float normalizedToScreen(double normalizedCoord) {
        float width = (float)this.getWidth() - this.barPadding * 2.0f;
        return (float)normalizedCoord / 100.0f * width;
    }

    private double screenToNormalized(float screenCoord) {
        double width = this.getWidth();
        if (width <= (double)(2.0f * this.barPadding)) {
            return 0.0;
        }
        double result = (double)screenCoord / (width -= (double)(this.barPadding * 2.0f)) * 100.0;
        result -= (double)this.barPadding / width * 100.0;
        result = Math.min(100.0, Math.max(0.0, result));
        return result;
    }

    private void setNormalizedMinValue(double value) {
        this.normalizedMinValue = Math.max(0.0, Math.min(100.0, Math.min(value, this.normalizedMaxValue)));
        this.invalidate();
    }

    private void setNormalizedMaxValue(double value) {
        this.normalizedMaxValue = Math.max(0.0, Math.min(100.0, Math.max(value, this.normalizedMinValue)));
        this.invalidate();
    }

    private double normalizedToValue(double normalized) {
        double val = normalized / 100.0 * (double)(this.maxValue - this.minValue);
        val = this.position == 0 ? val + (double)this.minValue : val;
        return val;
    }

    private void attemptClaimDrag() {
        if (this.getParent() != null) {
            this.getParent().requestDisallowInterceptTouchEvent(true);
        }
    }

    private <T extends Number> Number formatValue(T value) throws IllegalArgumentException {
        Double v = (Double)value;
        if (this.dataType == 0) {
            return v.longValue();
        }
        if (this.dataType == 1) {
            return v;
        }
        if (this.dataType == 2) {
            return Math.round(v);
        }
        if (this.dataType == 3) {
            return Float.valueOf(v.floatValue());
        }
        if (this.dataType == 4) {
            return v.shortValue();
        }
        if (this.dataType == 5) {
            return v.byteValue();
        }
        throw new IllegalArgumentException("Number class '" + value.getClass().getName() + "' is not supported");
    }

    protected synchronized void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.isInEditMode()) {
            return;
        }
        this.setupBar(canvas, this._paint, this._rect);
        this.setupHighlightBar(canvas, this._paint, this._rect);
        this.setupLeftThumb(canvas, this._paint, this._rect);
    }

    protected synchronized void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(this.getMeasureSpecWith(widthMeasureSpec), this.getMeasureSpecHeight(heightMeasureSpec));
    }

    public synchronized boolean onTouchEvent(MotionEvent event) {
        if (!this.isEnabled()) {
            return false;
        }
        int action = event.getAction();
        switch (action & 0xFF) {
            case 0: {
                this.mActivePointerId = event.getPointerId(event.getPointerCount() - 1);
                this.pointerIndex = event.findPointerIndex(this.mActivePointerId);
                float mDownMotionX = event.getX(this.pointerIndex);
                this.pressedThumb = this.evalPressedThumb(mDownMotionX);
                if (this.pressedThumb == null) {
                    return super.onTouchEvent(event);
                }
                this.touchDown(event.getX(this.pointerIndex), event.getY(this.pointerIndex));
                this.setPressed(true);
                this.invalidate();
                this.onStartTrackingTouch();
                this.trackTouchEvent(event);
                this.attemptClaimDrag();
                break;
            }
            case 2: {
                if (this.pressedThumb == null) break;
                if (this.mIsDragging) {
                    this.touchMove(event.getX(this.pointerIndex), event.getY(this.pointerIndex));
                    this.trackTouchEvent(event);
                }
                if (this.onSeekbarChangeListener == null) break;
                this.onSeekbarChangeListener.valueChanged(this.getSelectedMinValue());
                break;
            }
            case 1: {
                if (this.mIsDragging) {
                    this.trackTouchEvent(event);
                    this.onStopTrackingTouch();
                    this.setPressed(false);
                    this.touchUp(event.getX(this.pointerIndex), event.getY(this.pointerIndex));
                    if (this.onSeekbarFinalValueListener != null) {
                        this.onSeekbarFinalValueListener.finalValue(this.getSelectedMinValue());
                    }
                } else {
                    this.onStartTrackingTouch();
                    this.trackTouchEvent(event);
                    this.onStopTrackingTouch();
                }
                this.pressedThumb = null;
                this.invalidate();
                if (this.onSeekbarChangeListener == null) break;
                this.onSeekbarChangeListener.valueChanged(this.getSelectedMinValue());
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                this.invalidate();
                break;
            }
            case 3: {
                if (this.mIsDragging) {
                    this.onStopTrackingTouch();
                    this.setPressed(false);
                    this.touchUp(event.getX(this.pointerIndex), event.getY(this.pointerIndex));
                }
                this.invalidate();
            }
        }
        return true;
    }

    protected static enum Thumb {
        MIN;

    }

    public static final class ColorMode {
        public static final int SOLID = 0;
        public static final int GRADIENT = 1;
    }

    public static final class Position {
        public static final int LEFT = 0;
        public static final int RIGHT = 1;
    }

    public static final class DataType {
        public static final int LONG = 0;
        public static final int DOUBLE = 1;
        public static final int INTEGER = 2;
        public static final int FLOAT = 3;
        public static final int SHORT = 4;
        public static final int BYTE = 5;
    }
}

