/*
 * Decompiled with CFR 0.152.
 */
package com.gowtham.library.ui.seekbar.widgets;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import androidx.core.content.ContextCompat;
import com.gowtham.library.R;
import com.gowtham.library.ui.seekbar.interfaces.OnRangeSeekbarChangeListener;
import com.gowtham.library.ui.seekbar.interfaces.OnRangeSeekbarFinalValueListener;

public class CrystalRangeSeekbar
extends View {
    private static final int INVALID_POINTER_ID = 255;
    private final float NO_STEP = -1.0f;
    private final float NO_FIXED_GAP = -1.0f;
    private OnRangeSeekbarChangeListener onRangeSeekbarChangeListener;
    private OnRangeSeekbarFinalValueListener onRangeSeekbarFinalValueListener;
    private float absoluteMinValue;
    private float absoluteMaxValue;
    private float absoluteMinStartValue;
    private float absoluteMaxStartValue;
    private float minValue;
    private float maxValue;
    private float minStartValue;
    private float maxStartValue;
    private float steps;
    private float gap;
    private float fixGap;
    private int mActivePointerId = 255;
    private int dataType;
    private float cornerRadius;
    private int barColorMode;
    private int barColor;
    private int barGradientStart;
    private int barGradientEnd;
    private int barHighlightColorMode;
    private int barHighlightColor;
    private int barHighlightGradientStart;
    private int barHighlightGradientEnd;
    private int leftThumbColor;
    private int rightThumbColor;
    private int leftThumbColorNormal;
    private int leftThumbColorPressed;
    private int rightThumbColorNormal;
    private int rightThumbColorPressed;
    private boolean seekBarTouchEnabled;
    private float barPadding;
    private float barHeight;
    private float _barHeight;
    private float thumbWidth;
    private float thumbDiameter;
    private float thumbHeight;
    private Drawable leftDrawable;
    private Drawable rightDrawable;
    private Drawable leftDrawablePressed;
    private Drawable rightDrawablePressed;
    private Bitmap leftThumb;
    private Bitmap leftThumbPressed;
    private Bitmap rightThumb;
    private Bitmap rightThumbPressed;
    private Thumb pressedThumb;
    private double normalizedMinValue = 0.0;
    private double normalizedMaxValue = 100.0;
    private int pointerIndex;
    private RectF _rect;
    private Paint _paint;
    private RectF rectLeftThumb;
    private RectF rectRightThumb;
    private boolean mIsDragging;

    public CrystalRangeSeekbar(Context context) {
        this(context, null);
    }

    public CrystalRangeSeekbar(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CrystalRangeSeekbar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        if (this.isInEditMode()) {
            return;
        }
        TypedArray array = context.obtainStyledAttributes(attrs, R.styleable.CrystalRangeSeekbar);
        try {
            this.cornerRadius = this.getCornerRadius(array);
            this.minValue = this.getMinValue(array);
            this.maxValue = this.getMaxValue(array);
            this.minStartValue = this.getMinStartValue(array);
            this.maxStartValue = this.getMaxStartValue(array);
            this.steps = this.getSteps(array);
            this.gap = this.getGap(array);
            this.fixGap = this.getFixedGap(array);
            this._barHeight = this.getBarHeight(array);
            this.barColorMode = this.getBarColorMode(array);
            this.barColor = this.getBarColor(array);
            this.barGradientStart = this.getBarGradientStart(array);
            this.barGradientEnd = this.getBarGradientEnd(array);
            this.barHighlightColorMode = this.getBarHighlightColorMode(array);
            this.barHighlightColor = this.getBarHighlightColor(array);
            this.barHighlightGradientStart = this.getBarHighlightGradientStart(array);
            this.barHighlightGradientEnd = this.getBarHighlightGradientEnd(array);
            this.leftThumbColorNormal = this.getLeftThumbColor(array);
            this.rightThumbColorNormal = this.getRightThumbColor(array);
            this.leftThumbColorPressed = this.getLeftThumbColorPressed(array);
            this.rightThumbColorPressed = this.getRightThumbColorPressed(array);
            this.leftDrawable = this.getLeftDrawable(array);
            this.rightDrawable = this.getRightDrawable(array);
            this.leftDrawablePressed = this.getLeftDrawablePressed(array);
            this.rightDrawablePressed = this.getRightDrawablePressed(array);
            this.thumbDiameter = this.getDiameter(array);
            this.dataType = this.getDataType(array);
            this.seekBarTouchEnabled = this.isSeekBarTouchEnabled(array);
        }
        finally {
            array.recycle();
        }
        this.init();
    }

    protected void init() {
        this.absoluteMinValue = this.minValue;
        this.absoluteMaxValue = this.maxValue;
        this.leftThumbColor = this.leftThumbColorNormal;
        this.rightThumbColor = this.rightThumbColorNormal;
        this.leftThumb = this.getBitmap(this.leftDrawable);
        this.rightThumb = this.getBitmap(this.rightDrawable);
        this.leftThumbPressed = this.getBitmap(this.leftDrawablePressed);
        this.rightThumbPressed = this.getBitmap(this.rightDrawablePressed);
        this.leftThumbPressed = this.leftThumbPressed == null ? this.leftThumb : this.leftThumbPressed;
        this.rightThumbPressed = this.rightThumbPressed == null ? this.rightThumb : this.rightThumbPressed;
        this.gap = Math.max(0.0f, Math.min(this.gap, this.absoluteMaxValue - this.absoluteMinValue));
        this.gap = this.gap / (this.absoluteMaxValue - this.absoluteMinValue) * 100.0f;
        if (this.fixGap != -1.0f) {
            this.fixGap = Math.min(this.fixGap, this.absoluteMaxValue);
            this.fixGap = this.fixGap / (this.absoluteMaxValue - this.absoluteMinValue) * 100.0f;
            this.addFixGap(true);
        }
        this.thumbWidth = this.getThumbWidth();
        this.thumbHeight = this.getThumbHeight();
        this.barHeight = this.getBarHeight();
        this.barPadding = this.getBarPadding();
        this._paint = new Paint(1);
        this._rect = new RectF();
        this.rectLeftThumb = new RectF();
        this.rectRightThumb = new RectF();
        this.pressedThumb = null;
        this.setMinStartValue();
        this.setMaxStartValue();
        this.setWillNotDraw(false);
    }

    public CrystalRangeSeekbar setCornerRadius(float cornerRadius) {
        this.cornerRadius = cornerRadius;
        return this;
    }

    public CrystalRangeSeekbar setMinValue(float minValue) {
        this.minValue = minValue;
        this.absoluteMinValue = minValue;
        return this;
    }

    public CrystalRangeSeekbar setMaxValue(float maxValue) {
        this.maxValue = maxValue;
        this.absoluteMaxValue = maxValue;
        return this;
    }

    public CrystalRangeSeekbar setMinStartValue(float minStartValue) {
        this.minStartValue = minStartValue;
        this.absoluteMinStartValue = minStartValue;
        return this;
    }

    public CrystalRangeSeekbar setMaxStartValue(float maxStartValue) {
        this.maxStartValue = maxStartValue;
        this.absoluteMaxStartValue = maxStartValue;
        return this;
    }

    public CrystalRangeSeekbar setSteps(float steps) {
        this.steps = steps;
        return this;
    }

    public CrystalRangeSeekbar setGap(float gap) {
        this.gap = gap;
        return this;
    }

    public CrystalRangeSeekbar setFixGap(float fixGap) {
        this.fixGap = fixGap;
        return this;
    }

    public CrystalRangeSeekbar setBarHeight(float height) {
        this._barHeight = height;
        return this;
    }

    public CrystalRangeSeekbar setBarColorMode(int barColorMode) {
        this.barColorMode = barColorMode;
        return this;
    }

    public CrystalRangeSeekbar setBarColor(int barColor) {
        this.barColor = barColor;
        return this;
    }

    public CrystalRangeSeekbar setBarGradientStart(int barGradientStart) {
        this.barGradientStart = barGradientStart;
        return this;
    }

    public CrystalRangeSeekbar setBarGradientEnd(int barGradientEnd) {
        this.barGradientEnd = barGradientEnd;
        return this;
    }

    public CrystalRangeSeekbar setBarHighlightColorMode(int barHighlightColorMode) {
        this.barHighlightColorMode = barHighlightColorMode;
        return this;
    }

    public CrystalRangeSeekbar setBarHighlightColor(int barHighlightColor) {
        this.barHighlightColor = barHighlightColor;
        return this;
    }

    public CrystalRangeSeekbar setBarHighlightGradientStart(int barHighlightGradientStart) {
        this.barHighlightGradientStart = barHighlightGradientStart;
        return this;
    }

    public CrystalRangeSeekbar setBarHighlightGradientEnd(int barHighlightGradientEnd) {
        this.barHighlightGradientEnd = barHighlightGradientEnd;
        return this;
    }

    public CrystalRangeSeekbar setLeftThumbColor(int leftThumbColorNormal) {
        this.leftThumbColorNormal = leftThumbColorNormal;
        return this;
    }

    public CrystalRangeSeekbar setLeftThumbHighlightColor(int leftThumbColorPressed) {
        this.leftThumbColorPressed = leftThumbColorPressed;
        return this;
    }

    public CrystalRangeSeekbar setLeftThumbDrawable(int resId) {
        this.setLeftThumbDrawable(ContextCompat.getDrawable((Context)this.getContext(), (int)resId));
        return this;
    }

    public CrystalRangeSeekbar setLeftThumbDrawable(Drawable drawable) {
        this.setLeftThumbBitmap(this.getBitmap(drawable));
        return this;
    }

    public CrystalRangeSeekbar setLeftThumbBitmap(Bitmap bitmap) {
        this.leftThumb = bitmap;
        return this;
    }

    public CrystalRangeSeekbar setLeftThumbHighlightDrawable(int resId) {
        this.setLeftThumbHighlightDrawable(ContextCompat.getDrawable((Context)this.getContext(), (int)resId));
        return this;
    }

    public CrystalRangeSeekbar setLeftThumbHighlightDrawable(Drawable drawable) {
        this.setLeftThumbHighlightBitmap(this.getBitmap(drawable));
        return this;
    }

    public CrystalRangeSeekbar setLeftThumbHighlightBitmap(Bitmap bitmap) {
        this.leftThumbPressed = bitmap;
        return this;
    }

    public CrystalRangeSeekbar setRightThumbColor(int rightThumbColorNormal) {
        this.rightThumbColorNormal = rightThumbColorNormal;
        return this;
    }

    public CrystalRangeSeekbar setRightThumbHighlightColor(int rightThumbColorPressed) {
        this.rightThumbColorPressed = rightThumbColorPressed;
        return this;
    }

    public CrystalRangeSeekbar setRightThumbDrawable(int resId) {
        this.setRightThumbDrawable(ContextCompat.getDrawable((Context)this.getContext(), (int)resId));
        return this;
    }

    public CrystalRangeSeekbar setRightThumbDrawable(Drawable drawable) {
        this.setRightThumbBitmap(this.getBitmap(drawable));
        return this;
    }

    public CrystalRangeSeekbar setRightThumbBitmap(Bitmap bitmap) {
        this.rightThumb = bitmap;
        return this;
    }

    public CrystalRangeSeekbar setRightThumbHighlightDrawable(int resId) {
        this.setRightThumbHighlightDrawable(ContextCompat.getDrawable((Context)this.getContext(), (int)resId));
        return this;
    }

    public CrystalRangeSeekbar setRightThumbHighlightDrawable(Drawable drawable) {
        this.setRightThumbHighlightBitmap(this.getBitmap(drawable));
        return this;
    }

    public CrystalRangeSeekbar setRightThumbHighlightBitmap(Bitmap bitmap) {
        this.rightThumbPressed = bitmap;
        return this;
    }

    public CrystalRangeSeekbar setDataType(int dataType) {
        this.dataType = dataType;
        return this;
    }

    public void setOnRangeSeekbarChangeListener(OnRangeSeekbarChangeListener onRangeSeekbarChangeListener) {
        this.onRangeSeekbarChangeListener = onRangeSeekbarChangeListener;
        if (this.onRangeSeekbarChangeListener != null) {
            this.onRangeSeekbarChangeListener.valueChanged(this.getSelectedMinValue(), this.getSelectedMaxValue());
        }
    }

    public void setOnRangeSeekbarFinalValueListener(OnRangeSeekbarFinalValueListener onRangeSeekbarFinalValueListener) {
        this.onRangeSeekbarFinalValueListener = onRangeSeekbarFinalValueListener;
    }

    public Number getSelectedMinValue() {
        double nv = this.normalizedMinValue;
        if (this.steps > 0.0f && this.steps <= Math.abs(this.absoluteMaxValue) / 2.0f) {
            float stp = this.steps / (this.absoluteMaxValue - this.absoluteMinValue) * 100.0f;
            double mod = nv % (double)stp;
            double half_step = stp / 2.0f;
            if (mod > half_step) {
                nv -= mod;
                nv += (double)stp;
            } else {
                nv -= mod;
            }
        } else if (this.steps != -1.0f) {
            throw new IllegalStateException("steps out of range " + this.steps);
        }
        return this.formatValue(this.normalizedToValue(nv));
    }

    public Number getSelectedMaxValue() {
        double nv = this.normalizedMaxValue;
        if (this.steps > 0.0f && this.steps <= Math.abs(this.absoluteMaxValue) / 2.0f) {
            float stp = this.steps / (this.absoluteMaxValue - this.absoluteMinValue) * 100.0f;
            double mod = nv % (double)stp;
            double half_step = stp / 2.0f;
            if (mod > half_step) {
                nv -= mod;
                nv += (double)stp;
            } else {
                nv -= mod;
            }
        } else if (this.steps != -1.0f) {
            throw new IllegalStateException("steps out of range " + this.steps);
        }
        return this.formatValue(this.normalizedToValue(nv));
    }

    public void apply() {
        this.normalizedMinValue = 0.0;
        this.normalizedMaxValue = 100.0;
        this.gap = Math.max(0.0f, Math.min(this.gap, this.absoluteMaxValue - this.absoluteMinValue));
        this.gap = this.gap / (this.absoluteMaxValue - this.absoluteMinValue) * 100.0f;
        if (this.fixGap != -1.0f) {
            this.fixGap = Math.min(this.fixGap, this.absoluteMaxValue);
            this.fixGap = this.fixGap / (this.absoluteMaxValue - this.absoluteMinValue) * 100.0f;
            this.addFixGap(true);
        }
        this.thumbWidth = this.getThumbWidth();
        this.thumbHeight = this.getThumbHeight();
        this.barHeight = this.getBarHeight();
        this.barPadding = this.thumbWidth * 0.5f;
        if (this.minStartValue <= this.absoluteMinValue) {
            this.minStartValue = 0.0f;
            this.setNormalizedMinValue(this.minStartValue);
        } else if (this.minStartValue >= this.absoluteMaxValue) {
            this.minStartValue = this.absoluteMaxValue;
            this.setMinStartValue();
        } else {
            this.setMinStartValue();
        }
        if (this.maxStartValue < this.absoluteMinStartValue || this.maxStartValue <= this.absoluteMinValue) {
            this.maxStartValue = 0.0f;
            this.setNormalizedMaxValue(this.maxStartValue);
        } else if (this.maxStartValue >= this.absoluteMaxValue) {
            this.maxStartValue = this.absoluteMaxValue;
            this.setMaxStartValue();
        } else {
            this.setMaxStartValue();
        }
        this.invalidate();
        if (this.onRangeSeekbarChangeListener != null) {
            this.onRangeSeekbarChangeListener.valueChanged(this.getSelectedMinValue(), this.getSelectedMaxValue());
        }
    }

    protected Thumb getPressedThumb() {
        return this.pressedThumb;
    }

    protected float getThumbWidth() {
        return this.leftThumb != null ? (float)this.leftThumb.getWidth() : this.getThumbDiameter();
    }

    protected float getThumbHeight() {
        return this.leftThumb != null ? (float)this.leftThumb.getHeight() : this.getThumbDiameter();
    }

    protected float getThumbDiameter() {
        return this.thumbDiameter > 0.0f ? this.thumbDiameter : this.getResources().getDimension(R.dimen.thumb_width);
    }

    protected float getBarHeight() {
        return this._barHeight > 0.0f ? this._barHeight : this.thumbHeight * 0.5f * 0.3f;
    }

    protected float getBarPadding() {
        return this.thumbWidth * 0.5f;
    }

    protected Bitmap getBitmap(Drawable drawable) {
        return drawable != null ? ((BitmapDrawable)drawable).getBitmap() : null;
    }

    protected float getCornerRadius(TypedArray typedArray) {
        return typedArray.getFloat(R.styleable.CrystalRangeSeekbar_corner_radius, 0.0f);
    }

    protected float getMinValue(TypedArray typedArray) {
        return typedArray.getFloat(R.styleable.CrystalRangeSeekbar_min_value, 0.0f);
    }

    protected float getMaxValue(TypedArray typedArray) {
        return typedArray.getFloat(R.styleable.CrystalRangeSeekbar_max_value, 100.0f);
    }

    protected float getMinStartValue(TypedArray typedArray) {
        return typedArray.getFloat(R.styleable.CrystalRangeSeekbar_min_start_value, this.minValue);
    }

    protected float getMaxStartValue(TypedArray typedArray) {
        return typedArray.getFloat(R.styleable.CrystalRangeSeekbar_max_start_value, this.maxValue);
    }

    protected float getSteps(TypedArray typedArray) {
        return typedArray.getFloat(R.styleable.CrystalRangeSeekbar_steps, -1.0f);
    }

    protected float getGap(TypedArray typedArray) {
        return typedArray.getFloat(R.styleable.CrystalRangeSeekbar_gap, 0.0f);
    }

    protected float getFixedGap(TypedArray typedArray) {
        return typedArray.getFloat(R.styleable.CrystalRangeSeekbar_fix_gap, -1.0f);
    }

    protected int getBarColorMode(TypedArray typedArray) {
        return typedArray.getInt(R.styleable.CrystalRangeSeekbar_bar_color_mode, 0);
    }

    protected float getBarHeight(TypedArray typedArray) {
        return typedArray.getDimensionPixelSize(R.styleable.CrystalRangeSeekbar_bar_height, 0);
    }

    protected int getBarColor(TypedArray typedArray) {
        return typedArray.getColor(R.styleable.CrystalRangeSeekbar_bar_color, -7829368);
    }

    protected int getBarGradientStart(TypedArray typedArray) {
        return typedArray.getColor(R.styleable.CrystalRangeSeekbar_bar_gradient_start, -7829368);
    }

    protected int getBarGradientEnd(TypedArray typedArray) {
        return typedArray.getColor(R.styleable.CrystalRangeSeekbar_bar_gradient_end, -12303292);
    }

    protected int getBarHighlightColorMode(TypedArray typedArray) {
        return typedArray.getInt(R.styleable.CrystalRangeSeekbar_bar_highlight_color_mode, 0);
    }

    protected int getBarHighlightColor(TypedArray typedArray) {
        return typedArray.getColor(R.styleable.CrystalRangeSeekbar_bar_highlight_color, -16777216);
    }

    protected int getBarHighlightGradientStart(TypedArray typedArray) {
        return typedArray.getColor(R.styleable.CrystalRangeSeekbar_bar_highlight_gradient_start, -12303292);
    }

    protected int getBarHighlightGradientEnd(TypedArray typedArray) {
        return typedArray.getColor(R.styleable.CrystalRangeSeekbar_bar_highlight_gradient_end, -16777216);
    }

    protected int getLeftThumbColor(TypedArray typedArray) {
        return typedArray.getColor(R.styleable.CrystalRangeSeekbar_left_thumb_color, -16777216);
    }

    protected int getRightThumbColor(TypedArray typedArray) {
        return typedArray.getColor(R.styleable.CrystalRangeSeekbar_right_thumb_color, -16777216);
    }

    protected int getLeftThumbColorPressed(TypedArray typedArray) {
        return typedArray.getColor(R.styleable.CrystalRangeSeekbar_left_thumb_color_pressed, -12303292);
    }

    protected int getRightThumbColorPressed(TypedArray typedArray) {
        return typedArray.getColor(R.styleable.CrystalRangeSeekbar_right_thumb_color_pressed, -12303292);
    }

    protected Drawable getLeftDrawable(TypedArray typedArray) {
        return typedArray.getDrawable(R.styleable.CrystalRangeSeekbar_left_thumb_image);
    }

    protected Drawable getRightDrawable(TypedArray typedArray) {
        return typedArray.getDrawable(R.styleable.CrystalRangeSeekbar_right_thumb_image);
    }

    protected Drawable getLeftDrawablePressed(TypedArray typedArray) {
        return typedArray.getDrawable(R.styleable.CrystalRangeSeekbar_left_thumb_image_pressed);
    }

    protected Drawable getRightDrawablePressed(TypedArray typedArray) {
        return typedArray.getDrawable(R.styleable.CrystalRangeSeekbar_right_thumb_image_pressed);
    }

    protected int getDataType(TypedArray typedArray) {
        return typedArray.getInt(R.styleable.CrystalRangeSeekbar_data_type, 2);
    }

    protected boolean isSeekBarTouchEnabled(TypedArray typedArray) {
        return typedArray.getBoolean(R.styleable.CrystalRangeSeekbar_seek_bar_touch_enabled, false);
    }

    protected float getDiameter(TypedArray typedArray) {
        return typedArray.getDimensionPixelSize(R.styleable.CrystalRangeSeekbar_thumb_diameter, this.getResources().getDimensionPixelSize(R.dimen.thumb_height));
    }

    protected RectF getLeftThumbRect() {
        return this.rectLeftThumb;
    }

    protected RectF getRightThumbRect() {
        return this.rectRightThumb;
    }

    protected void setupBar(Canvas canvas, Paint paint, RectF rect) {
        rect.left = this.barPadding;
        rect.top = 0.5f * ((float)this.getHeight() - this.barHeight);
        rect.right = (float)this.getWidth() - this.barPadding;
        rect.bottom = 0.5f * ((float)this.getHeight() + this.barHeight);
        paint.setStyle(Paint.Style.FILL);
        paint.setAntiAlias(true);
        if (this.barColorMode == 0) {
            paint.setColor(this.barColor);
            this.drawBar(canvas, paint, rect);
        } else {
            paint.setShader((Shader)new LinearGradient(rect.left, rect.bottom, rect.right, rect.top, this.barGradientStart, this.barGradientEnd, Shader.TileMode.MIRROR));
            this.drawBar(canvas, paint, rect);
            paint.setShader(null);
        }
    }

    protected void drawBar(Canvas canvas, Paint paint, RectF rect) {
        canvas.drawRoundRect(rect, this.cornerRadius, this.cornerRadius, paint);
    }

    protected void setupHighlightBar(Canvas canvas, Paint paint, RectF rect) {
        rect.left = this.normalizedToScreen(this.normalizedMinValue) + this.getThumbWidth() / 2.0f;
        rect.right = this.normalizedToScreen(this.normalizedMaxValue) + this.getThumbWidth() / 2.0f;
        paint.setStyle(Paint.Style.FILL);
        paint.setAntiAlias(true);
        if (this.barHighlightColorMode == 0) {
            paint.setColor(this.barHighlightColor);
            this.drawHighlightBar(canvas, paint, rect);
        } else {
            paint.setShader((Shader)new LinearGradient(rect.left, rect.bottom, rect.right, rect.top, this.barHighlightGradientStart, this.barHighlightGradientEnd, Shader.TileMode.MIRROR));
            this.drawHighlightBar(canvas, paint, rect);
            paint.setShader(null);
        }
    }

    protected void drawHighlightBar(Canvas canvas, Paint paint, RectF rect) {
        canvas.drawRoundRect(rect, this.cornerRadius, this.cornerRadius, paint);
    }

    protected void setupLeftThumb(Canvas canvas, Paint paint, RectF rect) {
        this.leftThumbColor = Thumb.MIN.equals((Object)this.pressedThumb) ? this.leftThumbColorPressed : this.leftThumbColorNormal;
        paint.setColor(this.leftThumbColor);
        this.rectLeftThumb.left = this.normalizedToScreen(this.normalizedMinValue);
        this.rectLeftThumb.right = Math.min(this.rectLeftThumb.left + this.getThumbWidth() / 2.0f + this.barPadding, (float)this.getWidth());
        this.rectLeftThumb.top = 0.0f;
        this.rectLeftThumb.bottom = this.thumbHeight;
        if (this.leftThumb != null) {
            Bitmap lThumb = Thumb.MIN.equals((Object)this.pressedThumb) ? this.leftThumbPressed : this.leftThumb;
            this.drawLeftThumbWithImage(canvas, paint, this.rectLeftThumb, lThumb);
        } else {
            this.drawLeftThumbWithColor(canvas, paint, this.rectLeftThumb);
        }
    }

    protected void drawLeftThumbWithColor(Canvas canvas, Paint paint, RectF rect) {
        canvas.drawOval(rect, paint);
    }

    protected void drawLeftThumbWithImage(Canvas canvas, Paint paint, RectF rect, Bitmap image) {
        canvas.drawBitmap(image, rect.left, rect.top, paint);
    }

    protected void setupRightThumb(Canvas canvas, Paint paint, RectF rect) {
        this.rightThumbColor = Thumb.MAX.equals((Object)this.pressedThumb) ? this.rightThumbColorPressed : this.rightThumbColorNormal;
        paint.setColor(this.rightThumbColor);
        this.rectRightThumb.left = this.normalizedToScreen(this.normalizedMaxValue);
        this.rectRightThumb.right = Math.min(this.rectRightThumb.left + this.getThumbWidth() / 2.0f + this.barPadding, (float)this.getWidth());
        this.rectRightThumb.top = 0.0f;
        this.rectRightThumb.bottom = this.thumbHeight;
        if (this.rightThumb != null) {
            Bitmap rThumb = Thumb.MAX.equals((Object)this.pressedThumb) ? this.rightThumbPressed : this.rightThumb;
            this.drawRightThumbWithImage(canvas, paint, this.rectRightThumb, rThumb);
        } else {
            this.drawRightThumbWithColor(canvas, paint, this.rectRightThumb);
        }
    }

    protected void drawRightThumbWithColor(Canvas canvas, Paint paint, RectF rect) {
        canvas.drawOval(rect, paint);
    }

    protected void drawRightThumbWithImage(Canvas canvas, Paint paint, RectF rect, Bitmap image) {
        canvas.drawBitmap(image, rect.left, rect.top, paint);
    }

    protected void trackTouchEvent(MotionEvent event) {
        int pointerIndex = event.findPointerIndex(this.mActivePointerId);
        try {
            float x = event.getX(pointerIndex);
            if (Thumb.MIN.equals((Object)this.pressedThumb)) {
                this.setNormalizedMinValue(this.screenToNormalized(x));
            } else if (Thumb.MAX.equals((Object)this.pressedThumb)) {
                this.setNormalizedMaxValue(this.screenToNormalized(x));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void touchDown(float x, float y) {
    }

    protected void touchMove(float x, float y) {
    }

    protected void touchUp(float x, float y) {
    }

    protected int getMeasureSpecWith(int widthMeasureSpec) {
        int width = 200;
        if (0 != View.MeasureSpec.getMode((int)widthMeasureSpec)) {
            width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        }
        return width;
    }

    protected int getMeasureSpecHeight(int heightMeasureSpec) {
        int height = Math.round(this.thumbHeight);
        if (0 != View.MeasureSpec.getMode((int)heightMeasureSpec)) {
            height = Math.min(height, View.MeasureSpec.getSize((int)heightMeasureSpec));
        }
        return height;
    }

    protected final void log(Object object) {
        Log.d((String)"CRS=>", (String)String.valueOf(object));
    }

    private void setMinStartValue() {
        if (this.minStartValue > this.minValue && this.minStartValue <= this.maxValue) {
            this.minStartValue = Math.min(this.minStartValue, this.absoluteMaxValue);
            this.minStartValue -= this.absoluteMinValue;
            this.minStartValue = this.minStartValue / (this.absoluteMaxValue - this.absoluteMinValue) * 100.0f;
            this.setNormalizedMinValue(this.minStartValue);
        }
    }

    private void setMaxStartValue() {
        if (this.maxStartValue <= this.absoluteMaxValue && this.maxStartValue > this.absoluteMinValue && this.maxStartValue >= this.absoluteMinStartValue) {
            this.maxStartValue = Math.max(this.absoluteMaxStartValue, this.absoluteMinValue);
            this.maxStartValue -= this.absoluteMinValue;
            this.maxStartValue = this.maxStartValue / (this.absoluteMaxValue - this.absoluteMinValue) * 100.0f;
            this.setNormalizedMaxValue(this.maxStartValue);
        }
    }

    private Thumb evalPressedThumb(float touchX) {
        Thumb result = null;
        boolean minThumbPressed = this.isInThumbRange(touchX, this.normalizedMinValue);
        boolean maxThumbPressed = this.isInThumbRange(touchX, this.normalizedMaxValue);
        if (minThumbPressed && maxThumbPressed) {
            result = touchX / (float)this.getWidth() > 0.5f ? Thumb.MIN : Thumb.MAX;
        } else if (minThumbPressed) {
            result = Thumb.MIN;
        } else if (maxThumbPressed) {
            result = Thumb.MAX;
        }
        if (this.seekBarTouchEnabled && result == null) {
            result = this.findClosestThumb(touchX);
        }
        return result;
    }

    private boolean isInThumbRange(float touchX, double normalizedThumbValue) {
        float thumbPos = this.normalizedToScreen(normalizedThumbValue);
        float left = thumbPos - this.getThumbWidth() / 2.0f;
        float right = thumbPos + this.getThumbWidth() / 2.0f;
        float x = touchX - this.getThumbWidth() / 2.0f;
        if (thumbPos > (float)this.getWidth() - this.thumbWidth) {
            x = touchX;
        }
        return x >= left && x <= right;
    }

    private Thumb findClosestThumb(float touchX) {
        double maxDiff;
        float screenMinX = this.normalizedToScreen(this.normalizedMinValue);
        float screenMaxX = this.normalizedToScreen(this.normalizedMaxValue);
        if (touchX >= screenMaxX) {
            return Thumb.MAX;
        }
        if (touchX <= screenMinX) {
            return Thumb.MIN;
        }
        double minDiff = Math.abs(screenMinX - touchX);
        return minDiff < (maxDiff = (double)Math.abs(screenMaxX - touchX)) ? Thumb.MIN : Thumb.MAX;
    }

    private void onStartTrackingTouch() {
        this.mIsDragging = true;
    }

    private void onStopTrackingTouch() {
        this.mIsDragging = false;
    }

    private float normalizedToScreen(double normalizedCoord) {
        float width = (float)this.getWidth() - this.barPadding * 2.0f;
        return (float)normalizedCoord / 100.0f * width;
    }

    private double screenToNormalized(float screenCoord) {
        double width = this.getWidth();
        if (width <= (double)(2.0f * this.barPadding)) {
            return 0.0;
        }
        double result = (double)screenCoord / (width -= (double)(this.barPadding * 2.0f)) * 100.0;
        result -= (double)this.barPadding / width * 100.0;
        result = Math.min(100.0, Math.max(0.0, result));
        return result;
    }

    private void setNormalizedMinValue(double value) {
        this.normalizedMinValue = Math.max(0.0, Math.min(100.0, Math.min(value, this.normalizedMaxValue)));
        if (this.fixGap != -1.0f && this.fixGap > 0.0f) {
            this.addFixGap(true);
        } else {
            this.addMinGap();
        }
        this.invalidate();
    }

    private void setNormalizedMaxValue(double value) {
        this.normalizedMaxValue = Math.max(0.0, Math.min(100.0, Math.max(value, this.normalizedMinValue)));
        if (this.fixGap != -1.0f && this.fixGap > 0.0f) {
            this.addFixGap(false);
        } else {
            this.addMaxGap();
        }
        this.invalidate();
    }

    private void addFixGap(boolean leftThumb) {
        if (leftThumb) {
            this.normalizedMaxValue = this.normalizedMinValue + (double)this.fixGap;
            if (this.normalizedMaxValue >= 100.0) {
                this.normalizedMaxValue = 100.0;
                this.normalizedMinValue = this.normalizedMaxValue - (double)this.fixGap;
            }
        } else {
            this.normalizedMinValue = this.normalizedMaxValue - (double)this.fixGap;
            if (this.normalizedMinValue <= 0.0) {
                this.normalizedMinValue = 0.0;
                this.normalizedMaxValue = this.normalizedMinValue + (double)this.fixGap;
            }
        }
    }

    private void addMinGap() {
        if (this.normalizedMinValue + (double)this.gap > this.normalizedMaxValue) {
            double g;
            this.normalizedMaxValue = g = this.normalizedMinValue + (double)this.gap;
            this.normalizedMaxValue = Math.max(0.0, Math.min(100.0, Math.max(g, this.normalizedMinValue)));
            if (this.normalizedMinValue >= this.normalizedMaxValue - (double)this.gap) {
                this.normalizedMinValue = this.normalizedMaxValue - (double)this.gap;
            }
        }
    }

    private void addMaxGap() {
        if (this.normalizedMaxValue - (double)this.gap < this.normalizedMinValue) {
            double g;
            this.normalizedMinValue = g = this.normalizedMaxValue - (double)this.gap;
            this.normalizedMinValue = Math.max(0.0, Math.min(100.0, Math.min(g, this.normalizedMaxValue)));
            if (this.normalizedMaxValue <= this.normalizedMinValue + (double)this.gap) {
                this.normalizedMaxValue = this.normalizedMinValue + (double)this.gap;
            }
        }
    }

    private double normalizedToValue(double normalized) {
        double val = normalized / 100.0 * (double)(this.maxValue - this.minValue);
        return val += (double)this.minValue;
    }

    private void attemptClaimDrag() {
        if (this.getParent() != null) {
            this.getParent().requestDisallowInterceptTouchEvent(true);
        }
    }

    private <T extends Number> Number formatValue(T value) throws IllegalArgumentException {
        Double v = (Double)value;
        if (this.dataType == 0) {
            return v.longValue();
        }
        if (this.dataType == 1) {
            return v;
        }
        if (this.dataType == 2) {
            return Math.round(v);
        }
        if (this.dataType == 3) {
            return Float.valueOf(v.floatValue());
        }
        if (this.dataType == 4) {
            return v.shortValue();
        }
        if (this.dataType == 5) {
            return v.byteValue();
        }
        throw new IllegalArgumentException("Number class '" + value.getClass().getName() + "' is not supported");
    }

    protected synchronized void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.isInEditMode()) {
            return;
        }
        this.setupBar(canvas, this._paint, this._rect);
        this.setupHighlightBar(canvas, this._paint, this._rect);
        this.setupLeftThumb(canvas, this._paint, this._rect);
        this.setupRightThumb(canvas, this._paint, this._rect);
    }

    protected synchronized void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(this.getMeasureSpecWith(widthMeasureSpec), this.getMeasureSpecHeight(heightMeasureSpec));
    }

    public synchronized boolean onTouchEvent(MotionEvent event) {
        if (!this.isEnabled()) {
            return false;
        }
        int action = event.getAction();
        switch (action & 0xFF) {
            case 0: {
                this.mActivePointerId = event.getPointerId(event.getPointerCount() - 1);
                this.pointerIndex = event.findPointerIndex(this.mActivePointerId);
                float mDownMotionX = event.getX(this.pointerIndex);
                this.pressedThumb = this.evalPressedThumb(mDownMotionX);
                if (this.pressedThumb == null) {
                    return super.onTouchEvent(event);
                }
                this.touchDown(event.getX(this.pointerIndex), event.getY(this.pointerIndex));
                this.setPressed(true);
                this.invalidate();
                this.onStartTrackingTouch();
                this.trackTouchEvent(event);
                this.attemptClaimDrag();
                break;
            }
            case 2: {
                if (this.pressedThumb == null) break;
                if (this.mIsDragging) {
                    this.touchMove(event.getX(this.pointerIndex), event.getY(this.pointerIndex));
                    this.trackTouchEvent(event);
                }
                if (this.onRangeSeekbarChangeListener == null) break;
                this.onRangeSeekbarChangeListener.valueChanged(this.getSelectedMinValue(), this.getSelectedMaxValue());
                break;
            }
            case 1: {
                if (this.mIsDragging) {
                    this.trackTouchEvent(event);
                    this.onStopTrackingTouch();
                    this.setPressed(false);
                    this.touchUp(event.getX(this.pointerIndex), event.getY(this.pointerIndex));
                    if (this.onRangeSeekbarFinalValueListener != null) {
                        this.onRangeSeekbarFinalValueListener.finalValue(this.getSelectedMinValue(), this.getSelectedMaxValue());
                    }
                } else {
                    this.onStartTrackingTouch();
                    this.trackTouchEvent(event);
                    this.onStopTrackingTouch();
                }
                this.pressedThumb = null;
                this.invalidate();
                if (this.onRangeSeekbarChangeListener == null) break;
                this.onRangeSeekbarChangeListener.valueChanged(this.getSelectedMinValue(), this.getSelectedMaxValue());
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                this.invalidate();
                break;
            }
            case 3: {
                if (this.mIsDragging) {
                    this.onStopTrackingTouch();
                    this.setPressed(false);
                    this.touchUp(event.getX(this.pointerIndex), event.getY(this.pointerIndex));
                }
                this.invalidate();
            }
        }
        return true;
    }

    protected static enum Thumb {
        MIN,
        MAX;

    }

    public static final class DataType {
        public static final int LONG = 0;
        public static final int DOUBLE = 1;
        public static final int INTEGER = 2;
        public static final int FLOAT = 3;
        public static final int SHORT = 4;
        public static final int BYTE = 5;
    }

    public static final class ColorMode {
        public static final int SOLID = 0;
        public static final int GRADIENT = 1;
    }
}

