/*
 * Decompiled with CFR 0.152.
 */
package com.zlylib.upperdialog.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.zlylib.upperdialog.common.ViewDragHelper;
import com.zlylib.upperdialog.manager.DragCompat;
import java.util.List;

public class DragLayout
extends FrameLayout {
    private final ViewDragHelper mDragHelper;
    private DragStyle mDragStyle = DragStyle.None;
    private OnDragListener mOnDragListener = null;
    private List<View> mInnerScrollViews;
    private boolean mHandleDragEvent = false;
    private float mDownX;
    private float mDownY;
    private int mLeft;
    private int mTop;
    private float mDragFraction = 0.0f;

    public DragLayout(Context context) {
        this(context, null);
    }

    public DragLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public DragLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mDragHelper = ViewDragHelper.create((ViewGroup)this, new DragCallback());
    }

    public void setOnDragListener(OnDragListener onDragListener) {
        this.mOnDragListener = onDragListener;
    }

    public void setDragStyle(DragStyle dragStyle) {
        this.mDragStyle = dragStyle;
    }

    private boolean isEnable() {
        return this.mDragStyle != DragStyle.None;
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        switch (ev.getAction() & 0xFF) {
            case 0: {
                break;
            }
            case 2: {
                float offY;
                boolean dragged;
                if (this.mHandleDragEvent) break;
                float offX = ev.getRawX() - this.mDownX;
                boolean bl = dragged = offX * offX + (offY = ev.getRawY() - this.mDownY) * offY > (float)this.mDragHelper.getTouchSlop();
                if (dragged) {
                    switch (this.mDragStyle) {
                        case Top: {
                            if (!(offY < 0.0f) || DragCompat.canViewScrollDown(this.mInnerScrollViews, this.mDownX, this.mDownY, false)) break;
                            this.mHandleDragEvent = false;
                            this.requestDisallowInterceptTouchEvent(false);
                            break;
                        }
                        case Bottom: {
                            if (!(offY > 0.0f) || DragCompat.canViewScrollUp(this.mInnerScrollViews, this.mDownX, this.mDownY, false)) break;
                            this.mHandleDragEvent = false;
                            this.requestDisallowInterceptTouchEvent(false);
                            break;
                        }
                        case Left: {
                            if (!(offX < 0.0f) || DragCompat.canViewScrollRight(this.mInnerScrollViews, this.mDownX, this.mDownY, false)) break;
                            this.mHandleDragEvent = false;
                            this.requestDisallowInterceptTouchEvent(false);
                            break;
                        }
                        case Right: {
                            if (!(offX > 0.0f) || DragCompat.canViewScrollLeft(this.mInnerScrollViews, this.mDownX, this.mDownY, false)) break;
                            this.mHandleDragEvent = false;
                            this.requestDisallowInterceptTouchEvent(false);
                            break;
                        }
                    }
                }
                break;
            }
        }
        return super.dispatchTouchEvent(ev);
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (!this.isEnable()) {
            this.mHandleDragEvent = false;
            return super.onInterceptTouchEvent(ev);
        }
        this.mHandleDragEvent = this.mDragHelper.shouldInterceptTouchEvent(ev);
        switch (ev.getAction() & 0xFF) {
            case 0: {
                this.mDownX = ev.getRawX();
                this.mDownY = ev.getRawY();
                break;
            }
        }
        return this.mHandleDragEvent || super.onInterceptTouchEvent(ev);
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(MotionEvent ev) {
        if (this.isEnable()) {
            this.mDragHelper.processTouchEvent(ev);
        }
        return this.mHandleDragEvent;
    }

    public void computeScroll() {
        if (!this.isEnable()) {
            return;
        }
        if (this.mDragHelper.continueSettling(true)) {
            this.invalidate();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.mInnerScrollViews = DragCompat.findAllScrollViews((ViewGroup)this);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (changed && this.getChildCount() > 0) {
            this.mLeft = this.getChildAt(0).getLeft();
            this.mTop = this.getChildAt(0).getTop();
        }
    }

    public static interface OnDragListener {
        public void onDragStart();

        public void onDragging(float var1);

        public void onDragEnd();
    }

    public static enum DragStyle {
        None,
        Left,
        Top,
        Right,
        Bottom;

    }

    private class DragCallback
    extends ViewDragHelper.Callback {
        private DragCallback() {
        }

        @Override
        public boolean tryCaptureView(View child, int pointerId) {
            return DragLayout.this.isEnable();
        }

        @Override
        public int getViewHorizontalDragRange(View child) {
            switch (DragLayout.this.mDragStyle) {
                case Left: {
                    return DragLayout.this.mLeft + child.getWidth();
                }
                case Right: {
                    return DragLayout.this.getWidth() - DragLayout.this.mLeft;
                }
            }
            return 0;
        }

        @Override
        public int getViewVerticalDragRange(View child) {
            switch (DragLayout.this.mDragStyle) {
                case Top: {
                    return DragLayout.this.mTop + child.getHeight();
                }
                case Bottom: {
                    return DragLayout.this.getHeight() - DragLayout.this.mTop;
                }
            }
            return 0;
        }

        @Override
        public void onViewCaptured(View capturedChild, int activePointerId) {
            super.onViewCaptured(capturedChild, activePointerId);
            DragLayout.this.mDragFraction = 0.0f;
            if (DragLayout.this.mOnDragListener != null) {
                DragLayout.this.mOnDragListener.onDragStart();
            }
        }

        @Override
        public int clampViewPositionHorizontal(View child, int left, int dx) {
            switch (DragLayout.this.mDragStyle) {
                case Left: {
                    if (DragCompat.canViewScrollRight(DragLayout.this.mInnerScrollViews, DragLayout.this.mDownX, DragLayout.this.mDownY, false)) {
                        return DragLayout.this.mLeft;
                    }
                    if (left > DragLayout.this.mLeft) {
                        return DragLayout.this.mLeft;
                    }
                    int l = DragLayout.this.mLeft + child.getWidth();
                    if (left < -l) {
                        return -l;
                    }
                    return left;
                }
                case Right: {
                    if (DragCompat.canViewScrollLeft(DragLayout.this.mInnerScrollViews, DragLayout.this.mDownX, DragLayout.this.mDownY, false)) {
                        return DragLayout.this.mLeft;
                    }
                    if (left > DragLayout.this.getWidth()) {
                        return DragLayout.this.getWidth();
                    }
                    if (left < DragLayout.this.mLeft) {
                        return DragLayout.this.mLeft;
                    }
                    return left;
                }
            }
            return DragLayout.this.mLeft;
        }

        @Override
        public int clampViewPositionVertical(View child, int top, int dy) {
            switch (DragLayout.this.mDragStyle) {
                case Top: {
                    if (DragCompat.canViewScrollDown(DragLayout.this.mInnerScrollViews, DragLayout.this.mDownX, DragLayout.this.mDownY, false)) {
                        return DragLayout.this.mTop;
                    }
                    if (top > DragLayout.this.mTop) {
                        return DragLayout.this.mTop;
                    }
                    int t = DragLayout.this.mTop + child.getHeight();
                    if (top < -t) {
                        return -t;
                    }
                    return top;
                }
                case Bottom: {
                    if (DragCompat.canViewScrollUp(DragLayout.this.mInnerScrollViews, DragLayout.this.mDownX, DragLayout.this.mDownY, false)) {
                        return DragLayout.this.mTop;
                    }
                    if (top > DragLayout.this.getHeight()) {
                        return DragLayout.this.getHeight();
                    }
                    if (top < DragLayout.this.mTop) {
                        return DragLayout.this.mTop;
                    }
                    return top;
                }
            }
            return DragLayout.this.mTop;
        }

        @Override
        public void onViewPositionChanged(View changedView, int left, int top, int dx, int dy) {
            super.onViewPositionChanged(changedView, left, top, dx, dy);
            switch (DragLayout.this.mDragStyle) {
                case Left: 
                case Right: {
                    float xoff = Math.abs(left - DragLayout.this.mLeft);
                    float xmax = this.getViewHorizontalDragRange(changedView);
                    DragLayout.this.mDragFraction = xoff / xmax;
                    break;
                }
                case Top: 
                case Bottom: {
                    float yoff = Math.abs(top - DragLayout.this.mTop);
                    float ymax = this.getViewVerticalDragRange(changedView);
                    DragLayout.this.mDragFraction = yoff / ymax;
                    break;
                }
            }
            if (DragLayout.this.mDragFraction < 0.0f) {
                DragLayout.this.mDragFraction = 0.0f;
            } else if (DragLayout.this.mDragFraction > 1.0f) {
                DragLayout.this.mDragFraction = 1.0f;
            }
            if (DragLayout.this.mOnDragListener != null) {
                DragLayout.this.mOnDragListener.onDragging(DragLayout.this.mDragFraction);
                if (DragLayout.this.mDragFraction == 1.0f) {
                    DragLayout.this.mOnDragListener.onDragEnd();
                }
            }
        }

        @Override
        public void onViewReleased(View releasedChild, float xvel, float yvel) {
            super.onViewReleased(releasedChild, xvel, yvel);
            float dismissFactor = 0.5f;
            boolean isDismiss = this.judgeDismissBySpeed(xvel, yvel) || DragLayout.this.mDragFraction >= dismissFactor;
            int l = DragLayout.this.mLeft;
            int t = DragLayout.this.mTop;
            if (isDismiss) {
                switch (DragLayout.this.mDragStyle) {
                    case Left: {
                        l = -(DragLayout.this.mLeft + releasedChild.getWidth());
                        break;
                    }
                    case Right: {
                        l = DragLayout.this.getWidth();
                        break;
                    }
                    case Top: {
                        t = -(DragLayout.this.mTop + releasedChild.getHeight());
                        break;
                    }
                    case Bottom: {
                        t = DragLayout.this.getHeight();
                        break;
                    }
                }
            }
            DragLayout.this.mDragHelper.settleCapturedViewAt(l, t);
            DragLayout.this.invalidate();
        }

        private boolean judgeDismissBySpeed(float xvel, float yvel) {
            float velocityLimit = 2000.0f;
            switch (DragLayout.this.mDragStyle) {
                case Left: {
                    return xvel < -velocityLimit;
                }
                case Right: {
                    return xvel > velocityLimit;
                }
                case Top: {
                    return yvel < -velocityLimit;
                }
                case Bottom: {
                    return yvel > velocityLimit;
                }
            }
            return false;
        }
    }
}

