/*
 * Decompiled with CFR 0.152.
 */
package com.zlylib.titlebarlib;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.StringRes;
import androidx.core.content.ContextCompat;
import com.zlylib.titlebarlib.ActionIconView;
import com.zlylib.titlebarlib.ActionTextView;
import com.zlylib.titlebarlib.R;

public final class ActionView
extends FrameLayout {
    private String text;
    private float textSize;
    private int textColor;
    private int[] textPadding = new int[]{0, 0, 0, 0};
    private int[] textMargin = new int[]{0, 0, 0, 0};
    private int iconRes;
    private int iconColor;
    private int[] iconPadding = new int[]{0, 0, 0, 0};
    private int[] iconMargin = new int[]{0, 0, 0, 0};
    private ActionIconView iconView;
    private ActionTextView textView;

    public ActionView(Context context) {
        this(context, null);
    }

    public ActionView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ActionView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initAttrs(attrs);
        this.initView();
    }

    private void initAttrs(AttributeSet attrs) {
        float textSizeDef = this.getContext().getResources().getDimension(R.dimen.actionbarex_common_title_bar_text_size_def);
        int textColorDef = ContextCompat.getColor((Context)this.getContext(), (int)R.color.actionbarex_common_title_bar_text_color_def);
        float textPaddingLeftDef = this.getContext().getResources().getDimension(R.dimen.actionbarex_common_title_bar_text_padding_left_def);
        float textPaddingRightDef = this.getContext().getResources().getDimension(R.dimen.actionbarex_common_title_bar_text_padding_right_def);
        int iconColorDef = ContextCompat.getColor((Context)this.getContext(), (int)R.color.actionbarex_common_title_bar_icon_color_def);
        float iconPaddingDef = this.getContext().getResources().getDimension(R.dimen.actionbarex_common_title_bar_icon_padding_def);
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.ActionView);
        this.text = typedArray.getString(R.styleable.ActionView_av_text);
        this.textSize = typedArray.getDimension(R.styleable.ActionView_av_textSize, textSizeDef);
        this.textColor = typedArray.getColor(R.styleable.ActionView_av_textSize, textColorDef);
        int textPaddingTemp = (int)typedArray.getDimension(R.styleable.ActionView_av_textPadding, -1.0f);
        this.textPadding[0] = (int)typedArray.getDimension(R.styleable.ActionView_av_textPaddingLeft, textPaddingTemp >= 0 ? (float)textPaddingTemp : textPaddingLeftDef);
        this.textPadding[1] = (int)typedArray.getDimension(R.styleable.ActionView_av_textPaddingTop, textPaddingTemp >= 0 ? (float)textPaddingTemp : 0.0f);
        this.textPadding[2] = (int)typedArray.getDimension(R.styleable.ActionView_av_textPaddingRight, textPaddingTemp >= 0 ? (float)textPaddingTemp : textPaddingRightDef);
        this.textPadding[3] = (int)typedArray.getDimension(R.styleable.ActionView_av_textPaddingBottom, textPaddingTemp >= 0 ? (float)textPaddingTemp : 0.0f);
        int textMarginTemp = (int)typedArray.getDimension(R.styleable.ActionView_av_textMargin, -1.0f);
        this.textMargin[0] = (int)typedArray.getDimension(R.styleable.ActionView_av_textMarginLeft, textMarginTemp >= 0 ? (float)textMarginTemp : 0.0f);
        this.textMargin[1] = (int)typedArray.getDimension(R.styleable.ActionView_av_textMarginTop, textMarginTemp >= 0 ? (float)textMarginTemp : 0.0f);
        this.textMargin[2] = (int)typedArray.getDimension(R.styleable.ActionView_av_textMarginRight, textMarginTemp >= 0 ? (float)textMarginTemp : 0.0f);
        this.textMargin[3] = (int)typedArray.getDimension(R.styleable.ActionView_av_textMarginBottom, textMarginTemp >= 0 ? (float)textMarginTemp : 0.0f);
        this.iconRes = typedArray.getResourceId(R.styleable.ActionView_av_icon, 0);
        this.iconColor = typedArray.getColor(R.styleable.ActionView_av_iconColor, iconColorDef);
        int iconPaddingTemp = (int)typedArray.getDimension(R.styleable.ActionView_av_iconPadding, -1.0f);
        this.iconPadding[0] = (int)typedArray.getDimension(R.styleable.ActionView_av_iconPaddingLeft, iconPaddingTemp >= 0 ? (float)iconPaddingTemp : iconPaddingDef);
        this.iconPadding[1] = (int)typedArray.getDimension(R.styleable.ActionView_av_iconPaddingTop, iconPaddingTemp >= 0 ? (float)iconPaddingTemp : iconPaddingDef);
        this.iconPadding[2] = (int)typedArray.getDimension(R.styleable.ActionView_av_iconPaddingRight, iconPaddingTemp >= 0 ? (float)iconPaddingTemp : iconPaddingDef);
        this.iconPadding[3] = (int)typedArray.getDimension(R.styleable.ActionView_av_iconPaddingBottom, iconPaddingTemp >= 0 ? (float)iconPaddingTemp : iconPaddingDef);
        int iconMarginTemp = (int)typedArray.getDimension(R.styleable.ActionView_av_iconMargin, -1.0f);
        this.iconMargin[0] = (int)typedArray.getDimension(R.styleable.ActionView_av_iconMarginLeft, iconMarginTemp >= 0 ? (float)iconMarginTemp : 0.0f);
        this.iconMargin[1] = (int)typedArray.getDimension(R.styleable.ActionView_av_iconMarginTop, iconMarginTemp >= 0 ? (float)iconMarginTemp : 0.0f);
        this.iconMargin[2] = (int)typedArray.getDimension(R.styleable.ActionView_av_iconMarginRight, iconMarginTemp >= 0 ? (float)iconMarginTemp : 0.0f);
        this.iconMargin[3] = (int)typedArray.getDimension(R.styleable.ActionView_av_iconMarginBottom, iconMarginTemp >= 0 ? (float)iconMarginTemp : 0.0f);
        typedArray.recycle();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    private void initView() {
        this.iconView = this.createIconView();
        this.textView = this.createTextView();
        this.addViewInLayout((View)this.iconView, this.getChildCount(), this.iconView.getLayoutParams());
        this.addViewInLayout((View)this.textView, this.getChildCount(), this.textView.getLayoutParams());
        this.setTextColor(this.textColor);
        this.setTextSizePx(this.textSize);
        this.setIconColorInt(this.iconColor);
        if (this.iconRes > 0) {
            this.setIcon(this.iconRes);
        } else if (!TextUtils.isEmpty((CharSequence)this.text)) {
            this.setText(this.text);
        } else {
            this.toggleToGone();
        }
    }

    private ActionIconView createIconView() {
        ActionIconView iconView = new ActionIconView(this.getContext());
        iconView.setScaleType(ImageView.ScaleType.FIT_CENTER);
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(0, -1);
        layoutParams.leftMargin = this.iconMargin[0];
        layoutParams.topMargin = this.iconMargin[1];
        layoutParams.rightMargin = this.iconMargin[2];
        layoutParams.bottomMargin = this.iconMargin[3];
        iconView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        iconView.setPadding(this.iconPadding[0], this.iconPadding[1], this.iconPadding[2], this.iconPadding[3]);
        iconView.setVisibility(8);
        return iconView;
    }

    private ActionTextView createTextView() {
        ActionTextView textView = new ActionTextView(this.getContext());
        textView.setGravity(17);
        textView.setSingleLine(true);
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-2, -1);
        layoutParams.leftMargin = this.textMargin[0];
        layoutParams.topMargin = this.textMargin[1];
        layoutParams.rightMargin = this.textMargin[2];
        layoutParams.bottomMargin = this.textMargin[3];
        textView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        textView.setPadding(this.textPadding[0], this.textPadding[1], this.textPadding[2], this.textPadding[3]);
        textView.setVisibility(8);
        return textView;
    }

    public ActionTextView getTextView() {
        return this.textView;
    }

    public ActionIconView getIconView() {
        return this.iconView;
    }

    public void toggleToText() {
        this.iconView.setVisibility(8);
        this.textView.setVisibility(0);
        this.setVisibility(0);
    }

    public void toggleToIcon() {
        this.textView.setVisibility(8);
        this.iconView.setVisibility(0);
        this.setVisibility(0);
    }

    public void toggleToGone() {
        this.textView.setVisibility(8);
        this.iconView.setVisibility(8);
        this.setVisibility(8);
    }

    public void setText(@NonNull CharSequence text) {
        this.textView.setText(text);
        this.toggleToText();
    }

    public void setText(@StringRes int textId) {
        this.textView.setText(textId);
        this.toggleToText();
    }

    public void setTextSize(float sp) {
        this.textView.setTextSize(sp);
    }

    public void setTextSizePx(float px) {
        this.textView.setTextSize(0, px);
    }

    public void setTextColor(@ColorInt int colorInt) {
        this.textView.setTextColor(colorInt);
    }

    public void setTextColorRes(@ColorRes int colorRes) {
        this.textView.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)colorRes));
    }

    public void setTextPadding(int left, int top, int right, int bottom) {
        this.textView.setPadding(left, top, right, bottom);
    }

    public void setTextMargin(int left, int top, int right, int bottom) {
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)this.textView.getLayoutParams();
        layoutParams.leftMargin = left;
        layoutParams.topMargin = top;
        layoutParams.rightMargin = right;
        layoutParams.bottomMargin = bottom;
        this.textView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    public void setIcon(@DrawableRes int iconId) {
        this.iconView.setImageResource(iconId);
        this.toggleToIcon();
    }

    public void setIcon(Drawable icon) {
        this.iconView.setImageDrawable(icon);
        this.toggleToIcon();
    }

    public void setIcon(Bitmap icon) {
        this.iconView.setImageBitmap(icon);
        this.toggleToIcon();
    }

    public void setIconColorInt(@ColorInt int colorInt) {
        this.iconView.setColorFilter(colorInt);
    }

    public void setIconColorRes(@ColorRes int colorRes) {
        this.iconView.setColorFilter(ContextCompat.getColor((Context)this.getContext(), (int)colorRes));
    }

    public void setIconPadding(int left, int top, int right, int bottom) {
        this.iconView.setPadding(left, top, right, bottom);
    }

    public void setIconMargin(int left, int top, int right, int bottom) {
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)this.iconView.getLayoutParams();
        layoutParams.leftMargin = left;
        layoutParams.topMargin = top;
        layoutParams.rightMargin = right;
        layoutParams.bottomMargin = bottom;
        this.iconView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }
}

