/*
 * Decompiled with CFR 0.152.
 */
package com.github.yvescheung.whisperlint;

import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.AnnotationUsageType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.github.yvescheung.whisperlint.WhisperImmutableDetector;
import com.github.yvescheung.whisperlint.ast.DataFlowVisitor;
import com.github.yvescheung.whisperlint.ast.UtilsKt;
import com.github.yvescheung.whisperlint.support.api2.AnnotationUsageTypeCompat;
import com.intellij.lang.jvm.JvmParameter;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0003\u0018\u0000 H2\u00020\u00012\u00020\u0002:\u0001HB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0016\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0012H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\bH\u0002J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u000f\u001a\u00020\u001cH\u0016JP\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\b2\u000e\b\u0002\u0010!\u001a\b\u0012\u0004\u0012\u00020\b0\u00122\u000e\b\u0002\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00070\u00122\u000e\b\u0002\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J\u0016\u0010$\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020&0%0\u0012H\u0016J\u0010\u0010'\u001a\u00020\u00162\u0006\u0010(\u001a\u00020)H\u0016J\u0018\u0010*\u001a\u00020\u00162\u0006\u0010+\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u001cH\u0002J\u0018\u0010,\u001a\u00020\u00162\u0006\u0010+\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u001cH\u0002J\u0018\u0010-\u001a\u00020\u00162\u0006\u0010+\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u001cH\u0002J\u0018\u0010.\u001a\u00020\u00162\u0006\u0010+\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u001cH\u0002J\u0018\u0010/\u001a\u00020\u00162\u0006\u0010+\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u001cH\u0002J\u0018\u00100\u001a\u00020\u00162\u0006\u0010+\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u001cH\u0002J\u0018\u00101\u001a\u00020\u00162\u0006\u0010+\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u001cH\u0002J \u00102\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u001c2\u0006\u0010+\u001a\u00020\n2\u0006\u00103\u001a\u00020\bH\u0002J \u00104\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u001c2\u0006\u00105\u001a\u00020\b2\u0006\u00106\u001a\u00020\fH\u0002Jr\u00107\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\b2\u0006\u0010(\u001a\u00020)2\u0006\u00108\u001a\u00020\u00192\u0006\u00109\u001a\u00020\u00132\b\u0010:\u001a\u0004\u0018\u00010;2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00190\u00122\f\u0010=\u001a\b\u0012\u0004\u0012\u00020\u00190\u00122\f\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00190\u00122\f\u0010?\u001a\b\u0012\u0004\u0012\u00020\u00190\u0012H\u0016J\u0014\u0010@\u001a\u00020\u0016*\u00020\u001c2\u0006\u0010A\u001a\u00020BH\u0002J\f\u0010C\u001a\u00020\u0013*\u00020;H\u0002J*\u0010D\u001a\u00020\u0016*\u00020\n2\u0006\u0010\u000f\u001a\u00020\u001c2\f\u0010E\u001a\b\u0012\u0004\u0012\u00020\u00130F2\u0006\u0010G\u001a\u00020\u0013H\u0002R \u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\n0\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\b0\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006I"}, d2={"Lcom/github/yvescheung/whisperlint/WhisperImmutableDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/Detector$UastScanner;", "()V", "checkFieldsToScope", "", "Lkotlin/Pair;", "Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/uast/UElement;", "reportArgumentToFunction", "Lorg/jetbrains/uast/UCallExpression;", "reportFieldsToAssignment", "Lcom/intellij/psi/PsiField;", "afterCheckFile", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "applicableAnnotations", "", "", "beforeCheckFile", "checkIsImmutable", "", "element", "Lcom/intellij/psi/PsiModifierListOwner;", "Lorg/jetbrains/uast/UAnnotation;", "createUastHandler", "Lcom/android/tools/lint/client/api/UElementHandler;", "Lcom/android/tools/lint/detector/api/JavaContext;", "deepSearchUsage", "usage", "Lcom/android/tools/lint/detector/api/Location;", "scope", "instances", "references", "properties", "getApplicableUastTypes", "Ljava/lang/Class;", "Lorg/jetbrains/uast/UAnnotated;", "isApplicableAnnotationUsage", "type", "Lcom/android/tools/lint/detector/api/AnnotationUsageType;", "isCollectionMethod", "call", "isEntryMethod", "isIteratorMethod", "isListMethod", "isMapMethod", "isQueueMethod", "isVectorOrStackMethod", "reportArgument", "reference", "reportField", "assignment", "field", "visitAnnotationUsage", "annotation", "qualifiedName", "method", "Lcom/intellij/psi/PsiMethod;", "annotations", "allMemberAnnotations", "allClassAnnotations", "allPackageAnnotations", "checkIsAimClass", "cls", "Lcom/intellij/psi/PsiClass;", "getSign", "isMethodOf", "names", "", "clsName", "Companion", "whisperLint"})
public final class WhisperImmutableDetector
extends Detector
implements Detector.UastScanner {
    private final Set<Pair<PsiElement, UElement>> checkFieldsToScope;
    private final Set<Pair<PsiField, UElement>> reportFieldsToAssignment;
    private final Set<Pair<UElement, UCallExpression>> reportArgumentToFunction;
    private static final String immutableAnnotation = "com.github.yvescheung.whisper.Immutable";
    private static final Set<String> checkReturnMethods;
    private static final String collectionCls = "java.util.Collection";
    private static final Set<String> collectionMethods;
    private static final String listCls = "java.util.List";
    private static final Set<String> listMethods;
    private static final String queCls = "java.util.Queue";
    private static final Set<String> queMethods;
    private static final String vectorCls = "java.util.Vector";
    private static final Set<String> vectorAndStackMethods;
    private static final String mapCls = "java.util.Map";
    private static final Set<String> mapMathods;
    private static final String iteratorCls = "java.util.Iterator";
    private static final Set<String> iteratorMethods;
    private static final String entryCls = "java.util.Map.Entry";
    private static final Set<String> entryMethods;
    private static final List<String> aimCls;
    @NotNull
    private static final Issue ISSUE_WHISPER_IMMUTABLE;
    @NotNull
    private static final Issue ISSUE_WHISPER_MISSING_IMMUTABLE;
    @NotNull
    private static final Issue ISSUE_WHISPER_OVERRIDE_IMMUTABLE;
    @NotNull
    private static final Issue ISSUE_WHISPER_IMMUTABLE_TARGET;
    public static final Companion Companion;

    @NotNull
    public List<Class<? extends UAnnotated>> getApplicableUastTypes() {
        return CollectionsKt.listOf((Object[])new Class[]{UField.class, UCallExpression.class, USimpleNameReferenceExpression.class, UParameter.class, UVariable.class, UMethod.class});
    }

    @Nullable
    public UElementHandler createUastHandler(@NotNull JavaContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return new UElementHandler(this, context){
            final /* synthetic */ WhisperImmutableDetector this$0;
            final /* synthetic */ JavaContext $context;

            public void visitField(@NotNull UField node) {
                Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                UExpression initializer = node.getUastInitializer();
                if (initializer == null && WhisperImmutableDetector.access$checkIsImmutable(this.this$0, node.getAnnotations())) {
                    UClass uClass = UastUtils.getContainingUClass((UElement)((UElement)node));
                    if (uClass == null) {
                        return;
                    }
                    UClass scope = uClass;
                    List instances = CollectionsKt.listOf((Object)node);
                    List references = CollectionsKt.listOfNotNull((Object)node.getPsi());
                    List properties = CollectionsKt.listOfNotNull((Object)node.getText());
                    WhisperImmutableDetector.access$deepSearchUsage(this.this$0, this.$context, this.$context.getLocation(node), (UElement)scope, instances, references, properties);
                } else if (initializer != null && !WhisperImmutableDetector.access$checkIsImmutable(this.this$0, node.getAnnotations()) && WhisperImmutableDetector.access$checkIsImmutable(this.this$0, (UElement)initializer)) {
                    WhisperImmutableDetector.access$getReportFieldsToAssignment$p(this.this$0).add(TuplesKt.to((Object)node, (Object)initializer));
                }
            }

            /*
             * WARNING - void declaration
             */
            public void visitCallExpression(@NotNull UCallExpression node) {
                void $this$mapNotNullTo$iv$iv;
                Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                UMethod uMethod = UastUtils.getContainingUMethod((UElement)((UElement)node));
                if (uMethod == null) {
                    return;
                }
                UMethod scope = uMethod;
                Iterable $this$mapNotNull$iv = UtilsKt.getAvailableCaller(node);
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    PsiField psiField;
                    String psiName;
                    T element$iv$iv$iv;
                    T element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    UElement receiver = (UElement)element$iv$iv;
                    boolean bl2 = false;
                    PsiElement psiElement = UastUtils.tryResolve((UElement)receiver);
                    if (!(psiElement instanceof PsiField)) {
                        psiElement = null;
                    }
                    PsiField psiVar = (PsiField)psiElement;
                    UClass uClass = UastUtils.getContainingUClass((UElement)receiver);
                    String currentName = uClass != null ? uClass.getQualifiedName() : null;
                    PsiClass psiClass = UastUtils.getContainingClass((PsiElement)((PsiElement)psiVar));
                    String string = psiName = psiClass != null ? psiClass.getQualifiedName() : null;
                    if ((psiVar != null && Intrinsics.areEqual((Object)psiName, (Object)currentName) ^ true && WhisperImmutableDetector.access$checkIsImmutable(this.this$0, (PsiModifierListOwner)psiVar) ? psiVar : null) == null) continue;
                    psiField = psiField;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    PsiField it$iv$iv = psiField;
                    boolean bl5 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                Iterable $this$forEach$iv = (List)destination$iv$iv;
                boolean $i$f$forEach2 = false;
                for (E element$iv : $this$forEach$iv) {
                    PsiField field = (PsiField)element$iv;
                    boolean bl = false;
                    WhisperImmutableDetector.access$getCheckFieldsToScope$p(this.this$0).add(TuplesKt.to((Object)field, (Object)scope));
                }
            }

            public void visitSimpleNameReferenceExpression(@NotNull USimpleNameReferenceExpression node) {
                String psiName;
                Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                UMethod uMethod = UastUtils.getContainingUMethod((UElement)((UElement)node));
                if (uMethod == null) {
                    return;
                }
                UMethod scope = uMethod;
                PsiElement psiElement = node.resolve();
                if (!(psiElement instanceof PsiField)) {
                    psiElement = null;
                }
                PsiField psiField = (PsiField)psiElement;
                if (psiField == null) {
                    return;
                }
                PsiField psiRef = psiField;
                UClass uClass = UastUtils.getContainingUClass((UElement)((UElement)node));
                String currentName = uClass != null ? uClass.getQualifiedName() : null;
                PsiClass psiClass = psiRef.getContainingClass();
                String string = psiName = psiClass != null ? psiClass.getQualifiedName() : null;
                if (Intrinsics.areEqual((Object)psiName, (Object)currentName) ^ true && WhisperImmutableDetector.access$checkIsImmutable(this.this$0, (PsiModifierListOwner)psiRef)) {
                    WhisperImmutableDetector.access$getCheckFieldsToScope$p(this.this$0).add(TuplesKt.to((Object)psiRef, (Object)scope));
                }
            }

            public void visitParameter(@NotNull UParameter node) {
                Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                if (WhisperImmutableDetector.access$checkIsImmutable(this.this$0, node.getAnnotations())) {
                    UMethod uMethod = UastUtils.getContainingUMethod((UElement)((UElement)node));
                    if (uMethod == null) {
                        return;
                    }
                    UMethod scope = uMethod;
                    PsiParameter psiParameter = node.getPsi();
                    boolean bl = false;
                    boolean bl2 = false;
                    PsiParameter it = psiParameter;
                    boolean bl3 = false;
                    WhisperImmutableDetector.access$getCheckFieldsToScope$p(this.this$0).add(TuplesKt.to((Object)it, (Object)scope));
                }
            }

            public void visitVariable(@NotNull UVariable node) {
                Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                if (WhisperImmutableDetector.access$checkIsImmutable(this.this$0, node.getAnnotations())) {
                    PsiType psiType = node.getType();
                    if (!(psiType instanceof PsiClassType)) {
                        psiType = null;
                    }
                    PsiClassType psiClassType = (PsiClassType)psiType;
                    PsiClass cls = psiClassType != null ? psiClassType.resolve() : null;
                    this.checkType(cls, (UElement)node, node.getType().getCanonicalText());
                }
            }

            /*
             * WARNING - void declaration
             */
            public void visitMethod(@NotNull UMethod node) {
                boolean bl;
                boolean bl2;
                Object[] objectArray;
                int $i$f$all;
                boolean[] currentFlag;
                boolean[] lintFlag;
                int n;
                PsiMethod[] methods;
                block13: {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    PsiMethod[] psiMethodArray = node.findSuperMethods();
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiMethodArray, (String)"node.findSuperMethods()");
                    methods = psiMethodArray;
                    boolean currentIsImmutable = WhisperImmutableDetector.access$checkIsImmutable(this.this$0, node.getAnnotations());
                    if (!currentIsImmutable) {
                        boolean superIsImmutable;
                        block12: {
                            boolean bl3;
                            PsiMethod[] $this$any$iv = methods;
                            boolean $i$f$any = false;
                            PsiMethod[] psiMethodArray2 = $this$any$iv;
                            int n2 = psiMethodArray2.length;
                            for (n = 0; n < n2; ++n) {
                                PsiMethod element$iv;
                                PsiMethod it = element$iv = psiMethodArray2[n];
                                boolean bl4 = false;
                                PsiMethod psiMethod = it;
                                Intrinsics.checkExpressionValueIsNotNull((Object)psiMethod, (String)"it");
                                if (!WhisperImmutableDetector.access$checkIsImmutable(this.this$0, (PsiModifierListOwner)psiMethod)) continue;
                                bl3 = true;
                                break block12;
                            }
                            bl3 = superIsImmutable = false;
                        }
                        if (superIsImmutable) {
                            String msg = "The method [" + WhisperImmutableDetector.access$getSign(this.this$0, (PsiMethod)node) + "] without @Immutable cannot override " + "@Immutable method.";
                            LintFix quickFix = LintFix.create().replace().name("add @Immutable annotation").range(this.$context.getLocation(node)).with("@com.github.yvescheung.whisper.Immutable " + node.asSourceString()).shortenNames().reformat(true).build();
                            this.$context.report(WhisperImmutableDetector.Companion.getISSUE_WHISPER_OVERRIDE_IMMUTABLE(), node, this.$context.getNameLocation(node), msg, quickFix);
                        }
                    } else {
                        PsiType psiType = node.getReturnType();
                        if (!(psiType instanceof PsiClassType)) {
                            psiType = null;
                        }
                        PsiClassType psiClassType = (PsiClassType)psiType;
                        PsiClass cls = psiClassType != null ? psiClassType.resolve() : null;
                        PsiType psiType2 = node.getReturnType();
                        this.checkType(cls, (UElement)node, psiType2 != null ? psiType2.getCanonicalText() : null);
                    }
                    lintFlag = new boolean[node.getParameters().length];
                    boolean[] $this$all$iv = currentFlag = this.obtainIdxForImmutable((PsiMethod)node);
                    $i$f$all = 0;
                    objectArray = $this$all$iv;
                    n = objectArray.length;
                    for (int element$iv = 0; element$iv < n; ++element$iv) {
                        boolean element$iv2;
                        boolean it = element$iv2 = objectArray[element$iv];
                        bl2 = false;
                        if (it) continue;
                        bl = false;
                        break block13;
                    }
                    bl = true;
                }
                if (bl) {
                    return;
                }
                objectArray = methods;
                n = objectArray.length;
                for ($i$f$all = 0; $i$f$all < n; ++$i$f$all) {
                    JvmParameter[] $this$forEachIndexed$iv;
                    boolean method;
                    boolean bl5 = method = objectArray[$i$f$all];
                    Intrinsics.checkExpressionValueIsNotNull((Object)bl5, (String)"method");
                    Intrinsics.checkExpressionValueIsNotNull((Object)bl5.getParameters(), (String)"method.parameters");
                    boolean $i$f$forEachIndexed = false;
                    int index$iv = 0;
                    for (JvmParameter item$iv : $this$forEachIndexed$iv) {
                        void parameter;
                        int n3 = index$iv++;
                        JvmParameter jvmParameter = item$iv;
                        int index = n3;
                        boolean bl6 = false;
                        if (currentFlag[index] || !(parameter instanceof PsiParameter) || !WhisperImmutableDetector.access$checkIsImmutable(this.this$0, (PsiModifierListOwner)parameter)) continue;
                        currentFlag[index] = true;
                        lintFlag[index] = true;
                    }
                }
                boolean[] $this$forEachIndexed$iv = lintFlag;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (boolean item$iv : $this$forEachIndexed$iv) {
                    PsiParameter param;
                    void b;
                    int n4 = index$iv++;
                    bl2 = item$iv;
                    int index = n4;
                    boolean bl7 = false;
                    if (b == false) continue;
                    JvmParameter jvmParameter = node.getParameters()[index];
                    if (!(jvmParameter instanceof PsiParameter)) {
                        jvmParameter = null;
                    }
                    if ((PsiParameter)jvmParameter == null) {
                        return;
                    }
                    String msg = "The parameter [" + param.getText() + "] without @Immutable cannot override " + "@Immutable parameter.";
                    LintFix quickFix = LintFix.create().replace().name("add @Immutable annotation").range(this.$context.getLocation((PsiElement)param)).with("@com.github.yvescheung.whisper.Immutable " + param.getText()).build();
                    this.$context.report(WhisperImmutableDetector.Companion.getISSUE_WHISPER_OVERRIDE_IMMUTABLE(), (PsiElement)param, this.$context.getNameLocation((PsiElement)param), msg, quickFix);
                }
            }

            /*
             * WARNING - void declaration
             */
            private final boolean[] obtainIdxForImmutable(PsiMethod method) {
                boolean[] flagArray = new boolean[method.getParameters().length];
                JvmParameter[] jvmParameterArray = method.getParameters();
                Intrinsics.checkExpressionValueIsNotNull((Object)jvmParameterArray, (String)"method.parameters");
                JvmParameter[] $this$forEachIndexed$iv = jvmParameterArray;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (JvmParameter item$iv : $this$forEachIndexed$iv) {
                    void parameter;
                    int n = index$iv++;
                    JvmParameter jvmParameter = item$iv;
                    int index = n;
                    boolean bl = false;
                    flagArray[index] = parameter instanceof PsiParameter && WhisperImmutableDetector.access$checkIsImmutable(this.this$0, (PsiModifierListOwner)parameter);
                }
                return flagArray;
            }

            private final void checkType(PsiClass cls, UElement node, String currentMsg) {
                block9: {
                    block8: {
                        boolean bl;
                        block7: {
                            JavaEvaluator evaluator = this.$context.getEvaluator();
                            Function1<String, Boolean> $fun$clsExtendIt$1 = new Function1<String, Boolean>(evaluator, cls){
                                final /* synthetic */ JavaEvaluator $evaluator;
                                final /* synthetic */ PsiClass $cls;

                                public final boolean invoke(@NotNull String superCls) {
                                    Intrinsics.checkParameterIsNotNull((Object)superCls, (String)"superCls");
                                    return this.$evaluator.extendsClass(this.$cls, superCls, false);
                                }
                                {
                                    this.$evaluator = javaEvaluator;
                                    this.$cls = psiClass;
                                    super(1);
                                }
                            };
                            if (cls == null) break block8;
                            Iterable $this$any$iv = WhisperImmutableDetector.access$getAimCls$cp();
                            boolean $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl = false;
                            } else {
                                for (T element$iv : $this$any$iv) {
                                    String p1 = (String)element$iv;
                                    boolean bl2 = false;
                                    if (!$fun$clsExtendIt$1.invoke(p1)) continue;
                                    bl = true;
                                    break block7;
                                }
                                bl = false;
                            }
                        }
                        if (bl) break block9;
                    }
                    String msg = "Only class " + WhisperImmutableDetector.access$getAimCls$cp() + " or their subclass can be annotated by @Immutable. " + "\nbut current is [" + currentMsg + ']';
                    JavaContext.report$default((JavaContext)this.$context, (Issue)WhisperImmutableDetector.Companion.getISSUE_WHISPER_IMMUTABLE_TARGET(), (UElement)node, (Location)this.$context.getNameLocation(node), (String)msg, null, (int)16, null);
                }
            }
            {
                this.this$0 = $outer;
                this.$context = $captured_local_variable$1;
            }
        };
    }

    public void beforeCheckFile(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.checkFieldsToScope.clear();
        this.reportFieldsToAssignment.clear();
        this.reportArgumentToFunction.clear();
    }

    /*
     * WARNING - void declaration
     */
    public void afterCheckFile(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (context instanceof JavaContext) {
            UElement field;
            for (Pair<PsiElement, UElement> pair : this.checkFieldsToScope) {
                void field2;
                PsiElement psiElement = (PsiElement)pair.component1();
                UElement scope = (UElement)pair.component2();
                WhisperImmutableDetector.deepSearchUsage$default(this, (JavaContext)context, ((JavaContext)context).getLocation((PsiElement)field2), scope, null, CollectionsKt.listOf((Object)field2), null, 40, null);
            }
            Iterable $this$forEach$iv = this.reportFieldsToAssignment;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Pair $dstr$field$assignment = (Pair)element$iv;
                boolean bl = false;
                PsiField psiField = (PsiField)$dstr$field$assignment.component1();
                UElement assignment = (UElement)$dstr$field$assignment.component2();
                this.reportField((JavaContext)context, assignment, (PsiField)field);
            }
            $this$forEach$iv = this.reportArgumentToFunction;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void argument;
                Pair $dstr$argument$function = (Pair)element$iv;
                boolean bl = false;
                field = (UElement)$dstr$argument$function.component1();
                UCallExpression function = (UCallExpression)$dstr$argument$function.component2();
                this.reportArgument((JavaContext)context, function, (UElement)argument);
            }
        }
    }

    @NotNull
    public List<String> applicableAnnotations() {
        return CollectionsKt.listOf((Object)immutableAnnotation);
    }

    public boolean isApplicableAnnotationUsage(@NotNull AnnotationUsageType type) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        return AnnotationUsageTypeCompat.Companion.setOf(AnnotationUsageTypeCompat.ASSIGNMENT, AnnotationUsageTypeCompat.METHOD_CALL).contains(type);
    }

    /*
     * WARNING - void declaration
     */
    public void visitAnnotationUsage(@NotNull JavaContext context, @NotNull UElement usage, @NotNull AnnotationUsageType type, @NotNull UAnnotation annotation, @NotNull String qualifiedName, @Nullable PsiMethod method, @NotNull List<? extends UAnnotation> annotations, @NotNull List<? extends UAnnotation> allMemberAnnotations, @NotNull List<? extends UAnnotation> allClassAnnotations, @NotNull List<? extends UAnnotation> allPackageAnnotations) {
        void references;
        void instances;
        UElement uElement;
        UElement uElement2;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)usage, (String)"usage");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)annotation, (String)"annotation");
        Intrinsics.checkParameterIsNotNull((Object)qualifiedName, (String)"qualifiedName");
        Intrinsics.checkParameterIsNotNull(annotations, (String)"annotations");
        Intrinsics.checkParameterIsNotNull(allMemberAnnotations, (String)"allMemberAnnotations");
        Intrinsics.checkParameterIsNotNull(allClassAnnotations, (String)"allClassAnnotations");
        Intrinsics.checkParameterIsNotNull(allPackageAnnotations, (String)"allPackageAnnotations");
        if (!(usage instanceof UExpression)) {
            return;
        }
        UMethod uMethod = UastUtils.getContainingUMethod((UElement)usage);
        if (!(uMethod instanceof UElement)) {
            uMethod = null;
        }
        if ((uElement2 = (UElement)uMethod) == null) {
            uElement2 = uElement = (UElement)UastUtils.getContainingUClass((UElement)usage);
        }
        if (uElement2 == null) {
            uElement = (UElement)UastUtils.getContainingUFile((UElement)usage);
        }
        if (uElement == null) {
            return;
        }
        UElement scope = uElement;
        Triple<List<UElement>, List<PsiElement>, List<String>> triple = UtilsKt.getAvailableReturnValue((UExpression)usage);
        List list = (List)triple.component1();
        List list2 = (List)triple.component2();
        List properties = (List)triple.component3();
        this.deepSearchUsage(context, context.getLocation(usage), scope, (List<? extends UElement>)instances, (List<? extends PsiElement>)references, properties);
    }

    private final void deepSearchUsage(JavaContext context, Location usage, UElement scope, List<? extends UElement> instances, List<? extends PsiElement> references, List<String> properties) {
        scope.accept((UastVisitor)new DataFlowVisitor(this, context, usage, instances, references, properties, instances, references, properties){
            private boolean abort;
            final /* synthetic */ WhisperImmutableDetector this$0;
            final /* synthetic */ JavaContext $context;
            final /* synthetic */ Location $usage;
            final /* synthetic */ List $instances;
            final /* synthetic */ List $references;
            final /* synthetic */ List $properties;

            public boolean visitElement(@NotNull UElement node) {
                Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                return this.abort || super.visitElement(node);
            }

            /*
             * WARNING - void declaration
             */
            public void receiver(@NotNull UCallExpression call) {
                Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                if (CollectionsKt.contains((Iterable)WhisperImmutableDetector.access$getCheckReturnMethods$cp(), (Object)LintUtils.getMethodName((UCallExpression)call))) {
                    void iteRef;
                    void iteIns;
                    Triple<List<UElement>, List<PsiElement>, List<String>> triple = UtilsKt.getAvailableReturnValue((UExpression)call);
                    List list = (List)triple.component1();
                    List list2 = (List)triple.component2();
                    List iteProp = (List)triple.component3();
                    this.getInstances().addAll((Collection)iteIns);
                    this.getReferences().addAll((Collection)iteRef);
                    this.getProperties().addAll(iteProp);
                } else if (WhisperImmutableDetector.access$isCollectionMethod(this.this$0, call, this.$context) || WhisperImmutableDetector.access$isIteratorMethod(this.this$0, call, this.$context) || WhisperImmutableDetector.access$isEntryMethod(this.this$0, call, this.$context) || WhisperImmutableDetector.access$isListMethod(this.this$0, call, this.$context) || WhisperImmutableDetector.access$isMapMethod(this.this$0, call, this.$context) || WhisperImmutableDetector.access$isQueueMethod(this.this$0, call, this.$context) || WhisperImmutableDetector.access$isVectorOrStackMethod(this.this$0, call, this.$context)) {
                    String mainMsg = "you cannot invoke the [" + call + "] method on an immutable object.";
                    String referenceMsg = "This reference is annotated by @Immutable";
                    JavaContext.report$default((JavaContext)this.$context, (Issue)WhisperImmutableDetector.Companion.getISSUE_WHISPER_IMMUTABLE(), (UElement)((UElement)call), (Location)Location.withSecondary$default((Location)this.$context.getLocation((UElement)call), (Location)this.$usage, (String)referenceMsg, (boolean)false, (int)4, null), (String)mainMsg, null, (int)16, null);
                }
            }

            public void field(@Nullable UElement assignment, @NotNull PsiField field) {
                Intrinsics.checkParameterIsNotNull((Object)field, (String)"field");
                if (assignment != null && !WhisperImmutableDetector.access$checkIsImmutable(this.this$0, (PsiModifierListOwner)field)) {
                    WhisperImmutableDetector.access$getReportFieldsToAssignment$p(this.this$0).add(TuplesKt.to((Object)field, (Object)assignment));
                }
            }

            public void returns(@NotNull UReturnExpression expression) {
                UMethod method;
                Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
                UMethod uMethod = UastUtils.getContainingUMethod((UElement)((UElement)expression));
                if (uMethod == null) {
                    return;
                }
                UMethod uMethod2 = method = uMethod;
                if (uMethod2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.PsiModifierListOwner");
                }
                if (!WhisperImmutableDetector.access$checkIsImmutable(this.this$0, (PsiModifierListOwner)uMethod2)) {
                    this.abort = true;
                    String mainMsg = "Unable to return an immutable expression within a method without @Immutable annotation.";
                    String referenceMsg = "This expression [" + expression.asSourceString() + "] " + "is immutable.";
                    Location methodLocation = this.$context.getNameLocation(method);
                    Location refLocation = this.$context.getLocation((UElement)expression);
                    LintFix quickFix = LintFix.create().name("Annotate method [" + method.getName() + "] with @Immutable").replace().range(this.$context.getLocation(method)).with("@com.github.yvescheung.whisper.Immutable " + method.asSourceString()).shortenNames().reformat(true).build();
                    this.$context.report(WhisperImmutableDetector.Companion.getISSUE_WHISPER_MISSING_IMMUTABLE(), method, Location.withSecondary$default((Location)methodLocation, (Location)refLocation, (String)referenceMsg, (boolean)false, (int)4, null), mainMsg, quickFix);
                }
            }

            public void argument(@NotNull UCallExpression call, @NotNull UElement reference) {
                Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                Intrinsics.checkParameterIsNotNull((Object)reference, (String)"reference");
                WhisperImmutableDetector.access$getReportArgumentToFunction$p(this.this$0).add(TuplesKt.to((Object)reference, (Object)call));
            }
            {
                this.this$0 = $outer;
                this.$context = $captured_local_variable$1;
                this.$usage = $captured_local_variable$2;
                this.$instances = $captured_local_variable$3;
                this.$references = $captured_local_variable$4;
                this.$properties = $captured_local_variable$5;
                super($super_call_param$6, $super_call_param$7, $super_call_param$8);
            }
        });
    }

    static /* synthetic */ void deepSearchUsage$default(WhisperImmutableDetector whisperImmutableDetector, JavaContext javaContext, Location location, UElement uElement, List list, List list2, List list3, int n, Object object) {
        if ((n & 8) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 0x10) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 0x20) != 0) {
            list3 = CollectionsKt.emptyList();
        }
        whisperImmutableDetector.deepSearchUsage(javaContext, location, uElement, list, list2, list3);
    }

    private final void reportArgument(JavaContext context, UCallExpression call, UElement reference) {
        PsiClassReferenceType psiClassReferenceType;
        PsiMethod psiMethod = call.resolve();
        if (psiMethod == null) {
            return;
        }
        PsiMethod method = psiMethod;
        int paramIndex = CollectionsKt.indexOf((List)call.getValueArguments(), (Object)reference);
        Object[] objectArray = method.getParameters();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"method.parameters");
        Object object = ArraysKt.getOrNull((Object[])objectArray, (int)paramIndex);
        if (!(object instanceof PsiParameter)) {
            object = null;
        }
        PsiParameter psiParameter = (PsiParameter)object;
        if (psiParameter == null) {
            return;
        }
        PsiParameter param = psiParameter;
        PsiType psiType = param.getType();
        if (!(psiType instanceof PsiClassReferenceType)) {
            psiType = null;
        }
        if ((psiClassReferenceType = (PsiClassReferenceType)psiType) == null || (psiClassReferenceType = psiClassReferenceType.resolve()) == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiClassReferenceType, (String)"(param.type as? PsiClass\u2026ype)?.resolve() ?: return");
        PsiClassReferenceType paramCls = psiClassReferenceType;
        Location refLocation = context.getLocation((PsiElement)param);
        if (refLocation.getStart() == null || refLocation.getEnd() == null) {
            return;
        }
        if (!this.checkIsAimClass(context, (PsiClass)paramCls)) {
            return;
        }
        String paramName = param.getName();
        PsiParameter psiParameter2 = param;
        if (psiParameter2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.PsiModifierListOwner");
        }
        if (!this.checkIsImmutable((PsiModifierListOwner)psiParameter2)) {
            String refMsg = "Unable to pass an immutable object [" + reference.asSourceString() + "] " + "to a mutable parameter [" + this.getSign(method) + ')';
            Location callLocation = context.getCallLocation(call, true, true);
            String msg = "The method [" + call.asSourceString() + "] is called but this parameter " + '[' + paramName + "] is mutable.";
            LintFix quickFix = LintFix.create().name("Annotate parameter [" + param.getText() + "] with @Immutable").replace().range(refLocation).with("@com.github.yvescheung.whisper.Immutable " + param.getText()).reformat(true).shortenNames().build();
            context.report(ISSUE_WHISPER_MISSING_IMMUTABLE, (UElement)call, Location.withSecondary$default((Location)refLocation, (Location)callLocation, (String)refMsg, (boolean)false, (int)4, null), msg, quickFix);
        }
    }

    private final String getSign(@NotNull PsiMethod $this$getSign) {
        Object object = $this$getSign.getReturnType();
        if (object == null || (object = object.getCanonicalText()) == null) {
            object = "fun";
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"this.returnType?.canonicalText ?: \"fun\"");
        Object returnType = object;
        String string = $this$getSign.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"this.name");
        String methodName = string;
        Object[] objectArray = $this$getSign.getParameters();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"this.parameters");
        String parameterList2 = ArraysKt.joinToString$default((Object[])objectArray, null, null, null, (int)0, null, (Function1)getSign.parameterList.1.INSTANCE, (int)31, null);
        return (String)returnType + ' ' + methodName + '(' + parameterList2 + ')';
    }

    private final void reportField(JavaContext context, UElement assignment, PsiField field) {
        String assignMsg = assignment.asSourceString();
        String mainMsg = "Unable to assign an immutable object [" + assignMsg + "] " + "to a mutable field [" + field.getName() + "].";
        String referenceMsg = "This expression [" + assignMsg + "] is immutable.";
        Location referenceLocation = context.getLocation(assignment);
        Location fieldLocation = context.getLocation((PsiElement)field);
        LintFix quickFix = LintFix.create().name("Annotate [" + field.getName() + "] with @Immutable").replace().range(fieldLocation).with("@com.github.yvescheung.whisper.Immutable " + field.getText()).shortenNames().reformat(true).build();
        context.report(ISSUE_WHISPER_MISSING_IMMUTABLE, (PsiElement)field, Location.withSecondary$default((Location)fieldLocation, (Location)referenceLocation, (String)referenceMsg, (boolean)false, (int)4, null), mainMsg, quickFix);
    }

    private final boolean checkIsImmutable(UElement element) {
        if (element instanceof UCallExpression) {
            PsiMethod method;
            if (CollectionsKt.contains((Iterable)checkReturnMethods, (Object)LintUtils.getMethodName((UCallExpression)((UCallExpression)element)))) {
                UExpression receiver = ((UCallExpression)element).getReceiver();
                while (receiver instanceof UQualifiedReferenceExpression) {
                    receiver = ((UQualifiedReferenceExpression)receiver).getReceiver();
                }
                if (receiver != null && this.checkIsImmutable((UElement)receiver)) {
                    return true;
                }
            }
            if ((method = ((UCallExpression)element).resolve()) != null && this.checkIsImmutable((PsiModifierListOwner)method)) {
                return true;
            }
        } else {
            if (element instanceof UQualifiedReferenceExpression) {
                return this.checkIsImmutable((UElement)((UQualifiedReferenceExpression)element).getSelector());
            }
            if (element instanceof USimpleNameReferenceExpression) {
                PsiVariable variable;
                PsiElement psiElement = UastUtils.tryResolve((UElement)element);
                if (!(psiElement instanceof PsiVariable)) {
                    psiElement = null;
                }
                if ((variable = (PsiVariable)psiElement) != null && this.checkIsImmutable((PsiModifierListOwner)variable)) {
                    return true;
                }
            }
        }
        if (element instanceof PsiModifierListOwner) {
            return this.checkIsImmutable((PsiModifierListOwner)element);
        }
        if (element instanceof UAnnotated) {
            return this.checkIsImmutable(((UAnnotated)element).getAnnotations());
        }
        return false;
    }

    private final boolean checkIsImmutable(List<? extends UAnnotation> element) {
        Object v0;
        block1: {
            Iterable iterable = element;
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                UAnnotation it = (UAnnotation)t;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)it.getQualifiedName(), (Object)immutableAnnotation)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0 != null;
    }

    private final boolean checkIsImmutable(PsiModifierListOwner element) {
        PsiAnnotation psiAnnotation;
        block1: {
            PsiAnnotation[] psiAnnotationArray = element.getAnnotations();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiAnnotationArray, (String)"element.annotations");
            PsiAnnotation[] psiAnnotationArray2 = psiAnnotationArray;
            boolean bl = false;
            PsiAnnotation[] psiAnnotationArray3 = psiAnnotationArray2;
            boolean bl2 = false;
            PsiAnnotation[] psiAnnotationArray4 = psiAnnotationArray3;
            int n = psiAnnotationArray4.length;
            for (int i = 0; i < n; ++i) {
                PsiAnnotation psiAnnotation2;
                PsiAnnotation it = psiAnnotation2 = psiAnnotationArray4[i];
                boolean bl3 = false;
                PsiAnnotation psiAnnotation3 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)psiAnnotation3, (String)"it");
                if (!Intrinsics.areEqual((Object)psiAnnotation3.getQualifiedName(), (Object)immutableAnnotation)) continue;
                psiAnnotation = psiAnnotation2;
                break block1;
            }
            psiAnnotation = null;
        }
        return psiAnnotation != null;
    }

    private final boolean checkIsAimClass(@NotNull JavaContext $this$checkIsAimClass, PsiClass cls) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = aimCls;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!$this$checkIsAimClass.getEvaluator().extendsClass(cls, it, false)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean isEntryMethod(UCallExpression call, JavaContext context) {
        return this.isMethodOf(call, context, (Collection<String>)entryMethods, entryCls);
    }

    private final boolean isMapMethod(UCallExpression call, JavaContext context) {
        return this.isMethodOf(call, context, (Collection<String>)mapMathods, mapCls);
    }

    private final boolean isVectorOrStackMethod(UCallExpression call, JavaContext context) {
        return this.isMethodOf(call, context, (Collection<String>)vectorAndStackMethods, vectorCls);
    }

    private final boolean isQueueMethod(UCallExpression call, JavaContext context) {
        return this.isMethodOf(call, context, (Collection<String>)queMethods, queCls);
    }

    private final boolean isListMethod(UCallExpression call, JavaContext context) {
        return this.isMethodOf(call, context, (Collection<String>)listMethods, listCls);
    }

    private final boolean isCollectionMethod(UCallExpression call, JavaContext context) {
        return this.isMethodOf(call, context, (Collection<String>)collectionMethods, collectionCls);
    }

    private final boolean isIteratorMethod(UCallExpression call, JavaContext context) {
        return this.isMethodOf(call, context, (Collection<String>)iteratorMethods, iteratorCls);
    }

    private final boolean isMethodOf(@NotNull UCallExpression $this$isMethodOf, JavaContext context, Collection<String> names, String clsName) {
        if (CollectionsKt.contains((Iterable)names, (Object)LintUtils.getMethodName((UCallExpression)$this$isMethodOf))) {
            PsiMethod method = $this$isMethodOf.resolve();
            return method != null && context.getEvaluator().isMemberInSubClassOf((PsiMember)method, clsName, false);
        }
        return false;
    }

    public WhisperImmutableDetector() {
        Set set;
        WhisperImmutableDetector whisperImmutableDetector = this;
        boolean bl = false;
        whisperImmutableDetector.checkFieldsToScope = set = (Set)new LinkedHashSet();
        whisperImmutableDetector = this;
        bl = false;
        whisperImmutableDetector.reportFieldsToAssignment = set = (Set)new LinkedHashSet();
        whisperImmutableDetector = this;
        bl = false;
        whisperImmutableDetector.reportArgumentToFunction = set = (Set)new LinkedHashSet();
    }

    static {
        Companion = new Companion(null);
        checkReturnMethods = SetsKt.setOf((Object[])new String[]{"iterator", "listIterator", "getIterator", "descendingIterator", "subSet", "subList", "subMap", "keySet", "entrySet", "values", "headMap", "tailMap", "headSet", "tailSet", "next"});
        collectionMethods = SetsKt.setOf((Object[])new String[]{"add", "addAll", "remove", "removeAll", "removeIf", "retainAll", "clear"});
        listMethods = SetsKt.setOf((Object[])new String[]{"set", "removeRange", "replaceAll", "sort"});
        queMethods = SetsKt.setOf((Object[])new String[]{"addFirst", "addLast", "offer", "offerFirst", "offerLast", "removeFirst", "removeLast", "put", "putFirst", "putLast", "poll", "pollFirst", "pollLast", "removeFirstOccurrence", "removeLastOccurrence", "push", "pop", "drainTo"});
        vectorAndStackMethods = SetsKt.setOf((Object[])new String[]{"push", "pop", "addElement", "removeElement", "removeAllElements", "insertElementAt", "removeElementAt"});
        mapMathods = SetsKt.setOf((Object[])new String[]{"put", "putAll", "putIfAbsent", "remove", "merge", "replace", "replaceAll", "pollFirstEntry", "pollLastEntry", "clear"});
        iteratorMethods = SetsKt.setOf((Object[])new String[]{"remove", "set", "add"});
        entryMethods = SetsKt.setOf((Object)"setValue");
        aimCls = CollectionsKt.listOf((Object[])new String[]{collectionCls, mapCls, entryCls, iteratorCls});
        ISSUE_WHISPER_IMMUTABLE = Issue.Companion.create("ImmutableObject", "The reference annotated by @Immutable should not be modified.", "Iterator, Entry, Collection, Map that annotated by @Immutable cannot be modified.", Category.CORRECTNESS, 7, Severity.ERROR, new Implementation(WhisperImmutableDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE)));
        ISSUE_WHISPER_MISSING_IMMUTABLE = Issue.Companion.create("ImmutableEscape", "The reference annotated by @Immutable has escaped.", "Can not assign an immutable object to a mutable object.", Category.CORRECTNESS, 7, Severity.ERROR, new Implementation(WhisperImmutableDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE)));
        ISSUE_WHISPER_OVERRIDE_IMMUTABLE = Issue.Companion.create("ImmutableOverride", "The method or parameter should annotate with @Immutable.", "The method in the super class inherited by this method has the return value or parameter annotated by @Immutable. Please annotate this method with @Immutable too.", Category.CORRECTNESS, 6, Severity.ERROR, new Implementation(WhisperImmutableDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE)));
        ISSUE_WHISPER_IMMUTABLE_TARGET = Issue.Companion.create("ImmutableTarget", "Types that cannot be annotated by @Immutable.", "The class or super class of target annotated by @Immutable must be one of the following:\n" + CollectionsKt.joinToString$default((Iterable)aimCls, null, null, null, (int)0, null, (Function1)Companion.ISSUE_WHISPER_IMMUTABLE_TARGET.1.INSTANCE, (int)31, null), Category.CORRECTNESS, 8, Severity.WARNING, new Implementation(WhisperImmutableDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE)));
    }

    public static final /* synthetic */ boolean access$checkIsImmutable(WhisperImmutableDetector $this, List element) {
        return $this.checkIsImmutable(element);
    }

    public static final /* synthetic */ void access$deepSearchUsage(WhisperImmutableDetector $this, JavaContext context, Location usage, UElement scope, List instances, List references, List properties) {
        $this.deepSearchUsage(context, usage, scope, instances, references, properties);
    }

    public static final /* synthetic */ boolean access$checkIsImmutable(WhisperImmutableDetector $this, UElement element) {
        return $this.checkIsImmutable(element);
    }

    public static final /* synthetic */ Set access$getReportFieldsToAssignment$p(WhisperImmutableDetector $this) {
        return $this.reportFieldsToAssignment;
    }

    public static final /* synthetic */ boolean access$checkIsImmutable(WhisperImmutableDetector $this, PsiModifierListOwner element) {
        return $this.checkIsImmutable(element);
    }

    public static final /* synthetic */ Set access$getCheckFieldsToScope$p(WhisperImmutableDetector $this) {
        return $this.checkFieldsToScope;
    }

    public static final /* synthetic */ String access$getSign(WhisperImmutableDetector $this, PsiMethod $this$access_u24getSign) {
        return $this.getSign($this$access_u24getSign);
    }

    public static final /* synthetic */ List access$getAimCls$cp() {
        return aimCls;
    }

    public static final /* synthetic */ Set access$getCheckReturnMethods$cp() {
        return checkReturnMethods;
    }

    public static final /* synthetic */ boolean access$isCollectionMethod(WhisperImmutableDetector $this, UCallExpression call, JavaContext context) {
        return $this.isCollectionMethod(call, context);
    }

    public static final /* synthetic */ boolean access$isIteratorMethod(WhisperImmutableDetector $this, UCallExpression call, JavaContext context) {
        return $this.isIteratorMethod(call, context);
    }

    public static final /* synthetic */ boolean access$isEntryMethod(WhisperImmutableDetector $this, UCallExpression call, JavaContext context) {
        return $this.isEntryMethod(call, context);
    }

    public static final /* synthetic */ boolean access$isListMethod(WhisperImmutableDetector $this, UCallExpression call, JavaContext context) {
        return $this.isListMethod(call, context);
    }

    public static final /* synthetic */ boolean access$isMapMethod(WhisperImmutableDetector $this, UCallExpression call, JavaContext context) {
        return $this.isMapMethod(call, context);
    }

    public static final /* synthetic */ boolean access$isQueueMethod(WhisperImmutableDetector $this, UCallExpression call, JavaContext context) {
        return $this.isQueueMethod(call, context);
    }

    public static final /* synthetic */ boolean access$isVectorOrStackMethod(WhisperImmutableDetector $this, UCallExpression call, JavaContext context) {
        return $this.isVectorOrStackMethod(call, context);
    }

    public static final /* synthetic */ Set access$getReportArgumentToFunction$p(WhisperImmutableDetector $this) {
        return $this.reportArgumentToFunction;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0010\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00040\"\u00a2\u0006\u0002\u0010#R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000fX\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u000fX\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u000fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u000fX\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u000fX\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u000fX\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u000fX\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u000fX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/github/yvescheung/whisperlint/WhisperImmutableDetector$Companion;", "", "()V", "ISSUE_WHISPER_IMMUTABLE", "Lcom/android/tools/lint/detector/api/Issue;", "getISSUE_WHISPER_IMMUTABLE", "()Lcom/android/tools/lint/detector/api/Issue;", "ISSUE_WHISPER_IMMUTABLE_TARGET", "getISSUE_WHISPER_IMMUTABLE_TARGET", "ISSUE_WHISPER_MISSING_IMMUTABLE", "getISSUE_WHISPER_MISSING_IMMUTABLE", "ISSUE_WHISPER_OVERRIDE_IMMUTABLE", "getISSUE_WHISPER_OVERRIDE_IMMUTABLE", "aimCls", "", "", "checkReturnMethods", "", "collectionCls", "collectionMethods", "entryCls", "entryMethods", "immutableAnnotation", "iteratorCls", "iteratorMethods", "listCls", "listMethods", "mapCls", "mapMathods", "queCls", "queMethods", "vectorAndStackMethods", "vectorCls", "getIssue", "", "()[Lcom/android/tools/lint/detector/api/Issue;", "whisperLint"})
    public static final class Companion {
        @NotNull
        public final Issue getISSUE_WHISPER_IMMUTABLE() {
            return ISSUE_WHISPER_IMMUTABLE;
        }

        @NotNull
        public final Issue getISSUE_WHISPER_MISSING_IMMUTABLE() {
            return ISSUE_WHISPER_MISSING_IMMUTABLE;
        }

        @NotNull
        public final Issue getISSUE_WHISPER_OVERRIDE_IMMUTABLE() {
            return ISSUE_WHISPER_OVERRIDE_IMMUTABLE;
        }

        @NotNull
        public final Issue getISSUE_WHISPER_IMMUTABLE_TARGET() {
            return ISSUE_WHISPER_IMMUTABLE_TARGET;
        }

        @NotNull
        public final Issue[] getIssue() {
            return new Issue[]{this.getISSUE_WHISPER_IMMUTABLE(), this.getISSUE_WHISPER_MISSING_IMMUTABLE(), this.getISSUE_WHISPER_OVERRIDE_IMMUTABLE(), this.getISSUE_WHISPER_IMMUTABLE_TARGET()};
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

