/*
 * Decompiled with CFR 0.152.
 */
package com.pitaya.mobile.uinspector;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.provider.Settings;
import android.view.View;
import androidx.annotation.AnyThread;
import androidx.annotation.MainThread;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.FragmentActivity;
import com.pitaya.mobile.uinspector.lifecycle.UInspectorLifecycle;
import com.pitaya.mobile.uinspector.notification.UInspectorNotificationService;
import com.pitaya.mobile.uinspector.plugins.FastServiceLoaderKt;
import com.pitaya.mobile.uinspector.plugins.UInspectorPluginService;
import com.pitaya.mobile.uinspector.plugins.UInspectorPlugins;
import com.pitaya.mobile.uinspector.plugins.UInspectorPluginsImpl;
import com.pitaya.mobile.uinspector.state.UInspectorLifecycleState;
import com.pitaya.mobile.uinspector.state.UInspectorState;
import com.pitaya.mobile.uinspector.ui.panel.fullscreen.UInspectorDialogFragment;
import com.pitaya.mobile.uinspector.ui.panel.fullscreen.UInspectorLegacyDialogFragment;
import com.pitaya.mobile.uinspector.ui.panel.fullscreen.UInspectorPanel;
import com.pitaya.mobile.uinspector.ui.panel.fullscreen.UInspectorWindow;
import com.pitaya.mobile.uinspector.util.UtilsKt;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\f\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\b\u0010\u000f\u001a\u00020\fH\u0007J\b\u0010\u0010\u001a\u00020\fH\u0007J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\b\u0010\u0013\u001a\u00020\fH\u0007J\u0015\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u001fH\u0000\u00a2\u0006\u0002\b J\r\u0010!\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\"J\r\u0010#\u001a\u00020\fH\u0001\u00a2\u0006\u0002\b$J\u0015\u0010%\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u001fH\u0001\u00a2\u0006\u0002\b&J\u0015\u0010'\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u001fH\u0001\u00a2\u0006\u0002\b(J\u0010\u0010*\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0015@BX\u0080.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010)\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/pitaya/mobile/uinspector/UInspector;", "", "<init>", "()V", "currentState", "Lcom/pitaya/mobile/uinspector/state/UInspectorState;", "pluginServices", "", "Lcom/pitaya/mobile/uinspector/plugins/UInspectorPluginService;", "plugins", "Lcom/pitaya/mobile/uinspector/plugins/UInspectorPlugins;", "create", "", "context", "Landroid/content/Context;", "destroy", "start", "inspectView", "Landroid/view/View;", "stop", "value", "Landroid/app/Application;", "application", "getApplication$com_github_YvesCheung_Uinspector_api", "()Landroid/app/Application;", "init", "Ljava/util/concurrent/atomic/AtomicBoolean;", "lifecycle", "Lcom/pitaya/mobile/uinspector/lifecycle/UInspectorLifecycle;", "startService", "running", "", "startService$com_github_YvesCheung_Uinspector_api", "stopService", "stopService$com_github_YvesCheung_Uinspector_api", "syncState", "syncState$com_github_YvesCheung_Uinspector_api", "changeStateInner", "changeStateInner$com_github_YvesCheung_Uinspector_api", "changeStateTemporary", "changeStateTemporary$com_github_YvesCheung_Uinspector_api", "pendingInspectView", "changePanelState", "com.github.YvesCheung.Uinspector-api"})
@SuppressLint(value={"StaticFieldLeak"})
@SourceDebugExtension(value={"SMAP\nUInspector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UInspector.kt\ncom/pitaya/mobile/uinspector/UInspector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,164:1\n1#2:165\n1863#3,2:166\n*S KotlinDebug\n*F\n+ 1 UInspector.kt\ncom/pitaya/mobile/uinspector/UInspector\n*L\n47#1:166,2\n*E\n"})
public final class UInspector {
    @NotNull
    public static final UInspector INSTANCE = new UInspector();
    @JvmField
    @NotNull
    public static final UInspectorState currentState = new UInspectorState();
    @NotNull
    private static final List<UInspectorPluginService> pluginServices = FastServiceLoaderKt.loadService(UInspectorPluginService.class);
    @JvmField
    @NotNull
    public static final UInspectorPlugins plugins = new UInspectorPluginsImpl((Function1<? super UInspectorPlugins, Unit>)((Function1)UInspector::plugins$lambda$1));
    private static Application application;
    @NotNull
    private static final AtomicBoolean init;
    @NotNull
    private static final UInspectorLifecycle lifecycle;
    @Nullable
    private static View pendingInspectView;

    private UInspector() {
    }

    @JvmStatic
    @MainThread
    public static final void create(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (init.compareAndSet(false, true)) {
            Context context2 = context.getApplicationContext();
            Intrinsics.checkNotNull((Object)context2, (String)"null cannot be cast to non-null type android.app.Application");
            application = (Application)context2;
            lifecycle.register(INSTANCE.getApplication$com_github_YvesCheung_Uinspector_api());
            INSTANCE.stop();
        }
    }

    @JvmStatic
    @MainThread
    public static final void destroy() {
        if (init.compareAndSet(true, false)) {
            INSTANCE.changeStateInner$com_github_YvesCheung_Uinspector_api(false);
            lifecycle.unRegister(INSTANCE.getApplication$com_github_YvesCheung_Uinspector_api());
            INSTANCE.getApplication$com_github_YvesCheung_Uinspector_api().stopService(new Intent((Context)INSTANCE.getApplication$com_github_YvesCheung_Uinspector_api(), UInspectorNotificationService.class));
        }
    }

    @JvmStatic
    @AnyThread
    public static final void start() {
        INSTANCE.startService$com_github_YvesCheung_Uinspector_api(true);
    }

    @JvmStatic
    @AnyThread
    public static final void start(@NotNull View inspectView) {
        Intrinsics.checkNotNullParameter((Object)inspectView, (String)"inspectView");
        pendingInspectView = inspectView;
        INSTANCE.start();
    }

    @JvmStatic
    @AnyThread
    public static final void stop() {
        INSTANCE.startService$com_github_YvesCheung_Uinspector_api(false);
    }

    @NotNull
    public final Application getApplication$com_github_YvesCheung_Uinspector_api() {
        Application application = UInspector.application;
        if (application != null) {
            return application;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"application");
        return null;
    }

    public final void startService$com_github_YvesCheung_Uinspector_api(boolean running) {
        if (!init.get()) {
            throw new IllegalStateException("UInspector has not been init");
        }
        ContextCompat.startForegroundService((Context)((Context)this.getApplication$com_github_YvesCheung_Uinspector_api()), (Intent)new Intent((Context)this.getApplication$com_github_YvesCheung_Uinspector_api(), UInspectorNotificationService.class).putExtra("pending_start", running));
    }

    public final void stopService$com_github_YvesCheung_Uinspector_api() {
        if (!init.get()) {
            throw new IllegalStateException("UInspector has not been init");
        }
        this.getApplication$com_github_YvesCheung_Uinspector_api().stopService(new Intent((Context)this.getApplication$com_github_YvesCheung_Uinspector_api(), UInspectorNotificationService.class));
    }

    @MainThread
    public final void syncState$com_github_YvesCheung_Uinspector_api() {
        this.changeStateInner$com_github_YvesCheung_Uinspector_api(currentState.isRunning());
    }

    @MainThread
    public final void changeStateInner$com_github_YvesCheung_Uinspector_api(boolean running) {
        this.changePanelState(running);
        currentState.setRunning$com_github_YvesCheung_Uinspector_api(running);
        UtilsKt.log("change state to " + (running ? "RUNNING" : "IDLE"));
    }

    @MainThread
    public final void changeStateTemporary$com_github_YvesCheung_Uinspector_api(boolean running) {
        this.changePanelState(running);
        UtilsKt.log("change state TEMPORARY to " + (running ? "RUNNING" : "IDLE"));
    }

    private final void changePanelState(boolean running) {
        UInspectorLifecycleState currentLifecycle = currentState.getWithLifecycle();
        if (currentLifecycle != null) {
            Activity activity = currentLifecycle.getActivity();
            currentLifecycle.clear$com_github_YvesCheung_Uinspector_api();
            if (running) {
                currentLifecycle.registerFragmentLifecycle$com_github_YvesCheung_Uinspector_api();
                UInspectorPanel mask = Build.VERSION.SDK_INT >= 23 && Settings.canDrawOverlays((Context)((Context)activity)) ? (UInspectorPanel)new UInspectorWindow() : (activity instanceof FragmentActivity ? (UInspectorPanel)new UInspectorDialogFragment() : (UInspectorPanel)new UInspectorLegacyDialogFragment());
                currentLifecycle.setPanel$com_github_YvesCheung_Uinspector_api(mask);
                mask.show(activity);
                View view = pendingInspectView;
                if (view != null) {
                    View it = view;
                    boolean bl = false;
                    mask.updateTargetView(it);
                }
                pendingInspectView = null;
            }
        }
    }

    private static final Unit plugins$lambda$1(UInspectorPlugins plugins) {
        Intrinsics.checkNotNullParameter((Object)plugins, (String)"plugins");
        Iterable $this$forEach$iv = pluginServices;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UInspectorPluginService service = (UInspectorPluginService)element$iv;
            boolean bl = false;
            service.onCreate((Context)INSTANCE.getApplication$com_github_YvesCheung_Uinspector_api(), plugins);
        }
        return Unit.INSTANCE;
    }

    static {
        init = new AtomicBoolean(false);
        lifecycle = new UInspectorLifecycle();
    }
}

