/*
 * Decompiled with CFR 0.152.
 */
package com.alimaddi.segmentedbutton;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.DashPathEffect;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.PointF;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.Typeface;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.RippleDrawable;
import android.graphics.drawable.VectorDrawable;
import android.os.Build;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.Gravity;
import android.view.View;
import androidx.annotation.ColorInt;
import androidx.annotation.FloatRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.core.content.res.ResourcesCompat;
import androidx.vectordrawable.graphics.drawable.VectorDrawableCompat;
import com.alimaddi.segmentedbutton.R;

public class SegmentedButton
extends View {
    private static final String TAG = "SegmentedButton";
    private static final Bitmap.Config BITMAP_CONFIG = Bitmap.Config.ARGB_8888;
    private static final int COLOR_DRAWABLE_SIZE = 2;
    private RectF rectF;
    private Path path;
    private TextPaint textPaint;
    private StaticLayout textStaticLayout;
    private int textMaxWidth;
    private PointF textPosition;
    private PointF drawablePosition;
    private Path backgroundClipPath;
    private int backgroundRadius;
    private SegmentedButton leftButton;
    private SegmentedButton rightButton;
    private Paint backgroundPaint;
    private Paint selectedBackgroundPaint;
    private int selectedButtonRadius;
    private float[] selectedButtonRadii;
    private Paint selectedButtonBorderPaint;
    private float relativeClipPosition;
    private boolean isClippingLeft;
    private Drawable backgroundDrawable;
    private Drawable selectedBackgroundDrawable;
    private boolean rounded;
    private int rippleColor;
    private RippleDrawable rippleDrawableLollipop;
    private PorterDuffColorFilter drawableColorFilter;
    private PorterDuffColorFilter selectedDrawableColorFilter;
    private Drawable drawable;
    private int drawablePadding;
    private boolean hasDrawableTint;
    private boolean hasSelectedDrawableTint;
    private int drawableTint;
    private int selectedDrawableTint;
    private boolean hasDrawableWidth;
    private boolean hasDrawableHeight;
    private int drawableWidth;
    private int drawableHeight;
    private int drawableGravity;
    private boolean hasText;
    private String text;
    private boolean hasSelectedTextColor;
    private int textColor;
    private int selectedTextColor;
    private float textSize;
    private Typeface textTypeface;
    private Typeface selectedTextTypeface;
    private OnVisibilityChangedListener onVisibilityChangedListener;

    public SegmentedButton(Context context) {
        super(context);
        this.init(context, null);
    }

    public SegmentedButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public SegmentedButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, @Nullable AttributeSet attrs) {
        boolean isLTR = this.getResources().getConfiguration().getLayoutDirection() == 0;
        this.getAttributes(context, attrs);
        this.initText();
        this.initDrawable();
        this.relativeClipPosition = isLTR ? 0.0f : 1.0f;
        this.isClippingLeft = true;
        this.backgroundRadius = 0;
        this.leftButton = null;
        this.rightButton = null;
        this.rectF = new RectF();
        this.path = new Path();
        this.setClickable(true);
    }

    private void getAttributes(Context context, @Nullable AttributeSet attrs) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.SegmentedButton);
        if (typedArray.hasValue(R.styleable.SegmentedButton_android_background)) {
            this.backgroundDrawable = typedArray.getDrawable(R.styleable.SegmentedButton_android_background);
        }
        if (typedArray.hasValue(R.styleable.SegmentedButton_selectedBackground)) {
            this.selectedBackgroundDrawable = typedArray.getDrawable(R.styleable.SegmentedButton_selectedBackground);
        }
        this.rounded = typedArray.getBoolean(R.styleable.SegmentedButton_rounded, false);
        this.setRipple(typedArray.getColor(R.styleable.SegmentedButton_rippleColor, -7829368));
        if (typedArray.hasValue(R.styleable.SegmentedButton_drawable)) {
            int drawableResId = typedArray.getResourceId(R.styleable.SegmentedButton_drawable, -1);
            this.drawable = this.readCompatDrawable(context, drawableResId);
        }
        this.drawablePadding = typedArray.getDimensionPixelSize(R.styleable.SegmentedButton_drawablePadding, 0);
        this.hasDrawableTint = typedArray.hasValue(R.styleable.SegmentedButton_drawableTint);
        this.drawableTint = typedArray.getColor(R.styleable.SegmentedButton_drawableTint, -1);
        this.hasSelectedDrawableTint = typedArray.hasValue(R.styleable.SegmentedButton_selectedDrawableTint);
        this.selectedDrawableTint = typedArray.getColor(R.styleable.SegmentedButton_selectedDrawableTint, -1);
        this.hasDrawableWidth = typedArray.hasValue(R.styleable.SegmentedButton_drawableWidth);
        this.hasDrawableHeight = typedArray.hasValue(R.styleable.SegmentedButton_drawableHeight);
        this.drawableWidth = typedArray.getDimensionPixelSize(R.styleable.SegmentedButton_drawableWidth, -1);
        this.drawableHeight = typedArray.getDimensionPixelSize(R.styleable.SegmentedButton_drawableHeight, -1);
        this.drawableGravity = typedArray.getInteger(R.styleable.SegmentedButton_drawableGravity, 3);
        this.hasText = typedArray.hasValue(R.styleable.SegmentedButton_text);
        this.text = typedArray.getString(R.styleable.SegmentedButton_text);
        this.textColor = typedArray.getColor(R.styleable.SegmentedButton_textColor, -7829368);
        this.hasSelectedTextColor = typedArray.hasValue(R.styleable.SegmentedButton_selectedTextColor);
        this.selectedTextColor = typedArray.getColor(R.styleable.SegmentedButton_selectedTextColor, -1);
        float px14sp = TypedValue.applyDimension((int)2, (float)14.0f, (DisplayMetrics)context.getResources().getDisplayMetrics());
        this.textSize = typedArray.getDimension(R.styleable.SegmentedButton_textSize, px14sp);
        boolean hasFontFamily = typedArray.hasValue(R.styleable.SegmentedButton_android_fontFamily);
        int textStyle = typedArray.getInt(R.styleable.SegmentedButton_textStyle, 0);
        int selectedTextStyle = typedArray.getInt(R.styleable.SegmentedButton_selectedTextStyle, textStyle);
        if (hasFontFamily) {
            if (Build.VERSION.SDK_INT >= 26) {
                this.textTypeface = Typeface.create((Typeface)typedArray.getFont(R.styleable.SegmentedButton_android_fontFamily), (int)textStyle);
                this.selectedTextTypeface = Typeface.create((Typeface)typedArray.getFont(R.styleable.SegmentedButton_android_fontFamily), (int)selectedTextStyle);
            } else {
                int fontFamily = typedArray.getResourceId(R.styleable.SegmentedButton_android_fontFamily, 0);
                if (fontFamily > 0) {
                    this.textTypeface = Typeface.create((Typeface)ResourcesCompat.getFont((Context)context, (int)fontFamily), (int)textStyle);
                    this.selectedTextTypeface = Typeface.create((Typeface)ResourcesCompat.getFont((Context)context, (int)fontFamily), (int)selectedTextStyle);
                } else {
                    this.textTypeface = Typeface.create((String)typedArray.getString(R.styleable.SegmentedButton_android_fontFamily), (int)textStyle);
                    this.selectedTextTypeface = Typeface.create((String)typedArray.getString(R.styleable.SegmentedButton_android_fontFamily), (int)selectedTextStyle);
                }
            }
        } else {
            this.textTypeface = Typeface.create((Typeface)null, (int)textStyle);
            this.selectedTextTypeface = Typeface.create((Typeface)null, (int)selectedTextStyle);
        }
        typedArray.recycle();
    }

    private void initText() {
        this.textPosition = new PointF();
        if (!this.hasText) {
            this.textStaticLayout = null;
            return;
        }
        this.textPaint = new TextPaint();
        this.textPaint.setAntiAlias(true);
        this.textPaint.setTextSize(this.textSize);
        this.textPaint.setColor(this.textColor);
        this.textPaint.setTypeface(this.textTypeface);
        this.textMaxWidth = (int)this.textPaint.measureText(this.text);
        this.textStaticLayout = Build.VERSION.SDK_INT >= 23 ? StaticLayout.Builder.obtain((CharSequence)this.text, (int)0, (int)this.text.length(), (TextPaint)this.textPaint, (int)this.textMaxWidth).build() : new StaticLayout((CharSequence)this.text, this.textPaint, this.textMaxWidth, Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, false);
    }

    private Drawable readCompatDrawable(Context context, int drawableResId) {
        Drawable drawable = AppCompatResources.getDrawable((Context)context, (int)drawableResId);
        if (drawable instanceof VectorDrawable || drawable instanceof VectorDrawableCompat) {
            Bitmap bitmap = SegmentedButton.getBitmapFromVectorDrawable(drawable);
            return new BitmapDrawable(context.getResources(), bitmap);
        }
        return drawable;
    }

    private void initDrawable() {
        this.drawablePosition = new PointF();
        if (this.drawable == null) {
            return;
        }
        if (this.hasDrawableTint) {
            this.drawableColorFilter = new PorterDuffColorFilter(this.drawableTint, PorterDuff.Mode.SRC_IN);
        }
        if (this.hasSelectedDrawableTint) {
            this.selectedDrawableColorFilter = new PorterDuffColorFilter(this.selectedDrawableTint, PorterDuff.Mode.SRC_IN);
        }
    }

    @SuppressLint(value={"DrawAllocation"})
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int drawableWidth = this.drawable != null ? (this.hasDrawableWidth ? this.drawableWidth : this.drawable.getIntrinsicWidth()) : 0;
        int textWidth = this.hasText ? this.textMaxWidth : 0;
        int desiredWidth = this.getPaddingStart() + this.getPaddingEnd();
        desiredWidth = Gravity.isHorizontal((int)this.drawableGravity) ? (desiredWidth += textWidth + this.drawablePadding + drawableWidth) : (desiredWidth += Math.max(textWidth, drawableWidth));
        int width = SegmentedButton.resolveSize((int)desiredWidth, (int)widthMeasureSpec);
        this.measureTextWidth(width, drawableWidth);
        int drawableHeight = this.drawable != null ? (this.hasDrawableHeight ? this.drawableHeight : this.drawable.getIntrinsicHeight()) : 0;
        int textHeight = this.hasText ? this.textStaticLayout.getHeight() : 0;
        int desiredHeight = this.getPaddingTop() + this.getPaddingBottom();
        desiredHeight = Gravity.isHorizontal((int)this.drawableGravity) ? (desiredHeight += Math.max(textHeight, drawableHeight)) : (desiredHeight += textHeight + this.drawablePadding + drawableHeight);
        int height = SegmentedButton.resolveSize((int)desiredHeight, (int)heightMeasureSpec);
        this.setMeasuredDimension(width, height);
    }

    protected void onSizeChanged(int w, int h, int oldWidth, int oldHeight) {
        super.onSizeChanged(w, h, oldWidth, oldHeight);
        this.updateSize();
        this.setupBackgroundClipPath();
    }

    private void measureTextWidth(int width, int drawableWidth) {
        if (!this.hasText) {
            return;
        }
        int newDrawableWidth = Gravity.isHorizontal((int)this.drawableGravity) ? drawableWidth : 0;
        int textWidth = Math.min(width - this.getPaddingStart() - this.getPaddingEnd() - newDrawableWidth, this.textMaxWidth);
        if (textWidth < 0) {
            return;
        }
        this.textStaticLayout = Build.VERSION.SDK_INT >= 23 ? StaticLayout.Builder.obtain((CharSequence)this.text, (int)0, (int)this.text.length(), (TextPaint)this.textPaint, (int)textWidth).build() : new StaticLayout((CharSequence)this.text, this.textPaint, textWidth, Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, false);
    }

    private void updateSize() {
        int drawableHeight;
        int drawableWidth;
        int textHeight;
        int width = this.getWidth();
        int height = this.getHeight();
        int textWidth = this.hasText ? this.textStaticLayout.getWidth() : 0;
        int n = textHeight = this.hasText ? this.textStaticLayout.getHeight() : 0;
        int n2 = this.drawable != null ? (this.hasDrawableWidth ? this.drawableWidth : this.drawable.getIntrinsicWidth()) : (drawableWidth = 0);
        int n3 = this.drawable != null ? (this.hasDrawableHeight ? this.drawableHeight : this.drawable.getIntrinsicHeight()) : (drawableHeight = 0);
        if (Gravity.isHorizontal((int)this.drawableGravity)) {
            this.textPosition.y = (float)this.getPaddingTop() + (float)(height - this.getPaddingTop() - this.getPaddingBottom() - textHeight) / 2.0f;
            this.drawablePosition.y = (float)this.getPaddingTop() + (float)(height - this.getPaddingTop() - this.getPaddingBottom() - drawableHeight) / 2.0f;
            float startPosition = (float)(width - textWidth - drawableWidth - this.drawablePadding) / 2.0f;
            if (this.drawableGravity == 3) {
                this.textPosition.x = startPosition + (float)drawableWidth + (float)this.drawablePadding;
                this.drawablePosition.x = startPosition;
            } else if (this.drawableGravity == 5) {
                this.textPosition.x = startPosition;
                this.drawablePosition.x = startPosition + (float)textWidth + (float)this.drawablePadding;
            } else if (this.drawableGravity == 0x800003) {
                if (this.getResources().getConfiguration().getLayoutDirection() == 0) {
                    this.textPosition.x = startPosition + (float)drawableWidth + (float)this.drawablePadding;
                    this.drawablePosition.x = startPosition;
                } else {
                    this.textPosition.x = startPosition;
                    this.drawablePosition.x = startPosition + (float)textWidth + (float)this.drawablePadding;
                }
            } else if (this.drawableGravity == 0x800005) {
                if (this.getResources().getConfiguration().getLayoutDirection() == 0) {
                    this.textPosition.x = startPosition;
                    this.drawablePosition.x = startPosition + (float)textWidth + (float)this.drawablePadding;
                } else {
                    this.textPosition.x = startPosition + (float)drawableWidth + (float)this.drawablePadding;
                    this.drawablePosition.x = startPosition;
                }
            }
        } else {
            this.textPosition.x = (float)this.getPaddingStart() + (float)(width - this.getPaddingStart() - this.getPaddingEnd() - textWidth) / 2.0f;
            this.drawablePosition.x = (float)this.getPaddingStart() + (float)(width - this.getPaddingStart() - this.getPaddingEnd() - drawableWidth) / 2.0f;
            float startPosition = (float)(height - textHeight - drawableHeight - this.drawablePadding) / 2.0f;
            if (this.drawableGravity == 48) {
                this.textPosition.y = startPosition + (float)drawableHeight + (float)this.drawablePadding;
                this.drawablePosition.y = startPosition;
            } else if (this.drawableGravity == 80) {
                this.textPosition.y = startPosition;
                this.drawablePosition.y = startPosition + (float)textHeight + (float)this.drawablePadding;
            }
        }
        if (this.drawable != null) {
            this.drawable.setBounds((int)this.drawablePosition.x, (int)this.drawablePosition.y, (int)this.drawablePosition.x + drawableWidth, (int)this.drawablePosition.y + drawableHeight);
        }
        if (this.backgroundDrawable != null) {
            this.backgroundDrawable.setBounds(0, 0, width, height);
        }
        if (this.selectedBackgroundDrawable != null) {
            this.selectedBackgroundDrawable.setBounds(0, 0, width, height);
        }
        if (this.rippleDrawableLollipop != null) {
            this.rippleDrawableLollipop.setBounds(0, 0, width, height);
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.backgroundDrawable != null) {
            if (this.backgroundClipPath != null && this.backgroundPaint != null) {
                canvas.drawPath(this.backgroundClipPath, this.backgroundPaint);
            } else {
                this.backgroundDrawable.draw(canvas);
            }
        }
        if (this.hasText) {
            canvas.save();
            canvas.translate(this.textPosition.x, this.textPosition.y);
            this.textPaint.setColor(this.textColor);
            this.textPaint.setTypeface(this.textTypeface);
            this.textStaticLayout.draw(canvas);
            canvas.restore();
        }
        if (this.drawable != null) {
            this.drawable.setColorFilter((ColorFilter)this.drawableColorFilter);
            this.drawable.draw(canvas);
        }
        canvas.save();
        if (this.isClippingLeft) {
            float leftButtonWidth;
            float f = leftButtonWidth = this.isLeftButton() ? (float)width : (float)this.leftButton.getWidth();
            if (this.getResources().getConfiguration().getLayoutDirection() == 0) {
                this.rectF.set((this.relativeClipPosition - 1.0f) * leftButtonWidth, 0.0f, this.relativeClipPosition * (float)width, (float)height);
            } else {
                this.rectF.set(-1.0f * this.relativeClipPosition * leftButtonWidth, 0.0f, (1.0f - this.relativeClipPosition) * (float)width, (float)height);
            }
        } else {
            float rightButtonWidth;
            float f = rightButtonWidth = this.isRightButton() ? (float)width : (float)this.rightButton.getWidth();
            if (this.getResources().getConfiguration().getLayoutDirection() == 0) {
                this.rectF.set(this.relativeClipPosition * (float)width, 0.0f, (float)width + this.relativeClipPosition * rightButtonWidth, (float)height);
            } else {
                this.rectF.set((1.0f - this.relativeClipPosition) * (float)width, 0.0f, (float)width + (1.0f - this.relativeClipPosition) * rightButtonWidth, (float)height);
            }
        }
        canvas.clipRect(this.rectF);
        if (this.selectedButtonRadius > 0 && this.selectedBackgroundPaint != null) {
            this.path.reset();
            this.path.addRoundRect(this.rectF, this.selectedButtonRadii, Path.Direction.CW);
            canvas.drawPath(this.path, this.selectedBackgroundPaint);
        } else if (this.backgroundClipPath != null && this.selectedBackgroundPaint != null) {
            canvas.drawPath(this.backgroundClipPath, this.selectedBackgroundPaint);
        } else if (this.selectedBackgroundDrawable != null) {
            this.selectedBackgroundDrawable.draw(canvas);
        }
        if (this.hasText) {
            canvas.save();
            canvas.translate(this.textPosition.x, this.textPosition.y);
            this.textPaint.setColor(this.hasSelectedTextColor ? this.selectedTextColor : this.textColor);
            this.textPaint.setTypeface(this.selectedTextTypeface);
            this.textStaticLayout.draw(canvas);
            canvas.restore();
        }
        if (this.drawable != null) {
            this.drawable.setColorFilter((ColorFilter)(this.hasSelectedDrawableTint ? this.selectedDrawableColorFilter : this.drawableColorFilter));
            this.drawable.draw(canvas);
        }
        if (this.selectedButtonBorderPaint != null) {
            float halfBorderWidth = this.selectedButtonBorderPaint.getStrokeWidth() / 2.0f;
            this.rectF.inset(halfBorderWidth - 0.5f, halfBorderWidth - 0.5f);
            this.path.reset();
            this.path.addRoundRect(this.rectF, this.selectedButtonRadii, Path.Direction.CW);
            canvas.drawPath(this.path, this.selectedButtonBorderPaint);
        }
        canvas.restore();
        canvas.save();
        if (this.backgroundClipPath != null) {
            canvas.clipPath(this.backgroundClipPath);
        }
        if (this.rippleDrawableLollipop != null) {
            this.rippleDrawableLollipop.draw(canvas);
        }
        canvas.restore();
    }

    void clipLeft(@FloatRange(from=0.0, to=1.0) float relativePosition) {
        this.isClippingLeft = true;
        this.relativeClipPosition = relativePosition;
        this.invalidate();
    }

    void clipRight(@FloatRange(from=0.0, to=1.0) float relativePosition) {
        this.isClippingLeft = false;
        this.relativeClipPosition = relativePosition;
        this.invalidate();
    }

    @SuppressLint(value={"NewApi"})
    public void drawableHotspotChanged(float x, float y) {
        super.drawableHotspotChanged(x, y);
        if (this.rippleDrawableLollipop != null) {
            this.rippleDrawableLollipop.setHotspot(x, y);
        }
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        if (this.rippleDrawableLollipop != null) {
            this.rippleDrawableLollipop.setState(this.getDrawableState());
        }
    }

    protected boolean verifyDrawable(@NonNull Drawable who) {
        return who == this.rippleDrawableLollipop || super.verifyDrawable(who);
    }

    void setBackgroundRadius(int backgroundRadius) {
        this.backgroundRadius = backgroundRadius;
    }

    public boolean isLeftButton() {
        return this.leftButton == null;
    }

    public boolean isRightButton() {
        return this.rightButton == null;
    }

    void setLeftButton(SegmentedButton leftButton) {
        this.leftButton = leftButton;
    }

    void setRightButton(SegmentedButton rightButton) {
        this.rightButton = rightButton;
    }

    public boolean isRounded() {
        return this.rounded;
    }

    public void setRounded(boolean rounded) {
        this.rounded = rounded;
    }

    void setSelectedButtonRadius(int selectedButtonRadius) {
        this.selectedButtonRadius = selectedButtonRadius;
    }

    void setupBackgroundClipPath() {
        if (this.backgroundRadius == 0) {
            this.backgroundClipPath = null;
            this.setupBackgroundBitmaps();
            return;
        }
        this.rectF.set(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight());
        float br = this.backgroundRadius;
        if (this.isRounded() || this.isLeftButton() && this.isRightButton()) {
            this.backgroundClipPath = new Path();
            this.backgroundClipPath.addRoundRect(this.rectF, new float[]{br, br, br, br, br, br, br, br}, Path.Direction.CW);
        } else if (this.isLeftButton()) {
            this.backgroundClipPath = new Path();
            this.backgroundClipPath.addRoundRect(this.rectF, new float[]{br, br, 0.0f, 0.0f, 0.0f, 0.0f, br, br}, Path.Direction.CW);
        } else if (this.isRightButton()) {
            this.backgroundClipPath = new Path();
            this.backgroundClipPath.addRoundRect(this.rectF, new float[]{0.0f, 0.0f, br, br, br, br, 0.0f, 0.0f}, Path.Direction.CW);
        } else {
            this.backgroundClipPath = null;
        }
        this.setupBackgroundBitmaps();
    }

    void setupBackgroundBitmaps() {
        Bitmap bitmap;
        if (this.backgroundClipPath != null && this.backgroundDrawable != null && (bitmap = SegmentedButton.getBitmapFromDrawable(this.backgroundDrawable)) != null) {
            BitmapShader backgroundBitmapShader = new BitmapShader(bitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
            this.backgroundPaint = new Paint(1);
            this.backgroundPaint.setShader((Shader)backgroundBitmapShader);
        } else {
            this.backgroundPaint = null;
        }
        if ((this.backgroundClipPath != null || this.selectedButtonRadius > 0) && this.selectedBackgroundDrawable != null && (bitmap = SegmentedButton.getBitmapFromDrawable(this.selectedBackgroundDrawable)) != null) {
            BitmapShader selectedBackgroundBitmapShader = new BitmapShader(bitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
            this.selectedBackgroundPaint = new Paint(1);
            this.selectedBackgroundPaint.setShader((Shader)selectedBackgroundBitmapShader);
        } else {
            this.selectedBackgroundPaint = null;
        }
    }

    void setupSelectedButtonClipPath() {
        this.selectedButtonRadii = new float[]{this.selectedButtonRadius, this.selectedButtonRadius, this.selectedButtonRadius, this.selectedButtonRadius, this.selectedButtonRadius, this.selectedButtonRadius, this.selectedButtonRadius, this.selectedButtonRadius};
        this.setupBackgroundBitmaps();
        this.invalidate();
    }

    void setSelectedButtonBorder(int width, @ColorInt int color, int dashWidth, int dashGap) {
        if (width > 0) {
            this.selectedButtonBorderPaint = new Paint(1);
            this.selectedButtonBorderPaint.setStyle(Paint.Style.STROKE);
            this.selectedButtonBorderPaint.setStrokeWidth((float)width);
            this.selectedButtonBorderPaint.setColor(color);
            if ((float)dashWidth > 0.0f) {
                this.selectedButtonBorderPaint.setPathEffect((PathEffect)new DashPathEffect(new float[]{dashWidth, dashGap}, 0.0f));
            }
        } else {
            this.selectedButtonBorderPaint = null;
        }
        this.invalidate();
    }

    public void setVisibility(int visibility) {
        super.setVisibility(visibility);
        if (this.onVisibilityChangedListener != null) {
            this.onVisibilityChangedListener.onVisibilityChanged(this, visibility);
        }
    }

    void setDefaultBackground(@Nullable Drawable drawable) {
        if (this.backgroundDrawable == null && drawable != null) {
            this.backgroundDrawable = drawable.getConstantState().newDrawable();
        }
    }

    void setDefaultSelectedBackground(@Nullable Drawable drawable) {
        if (this.selectedBackgroundDrawable == null && drawable != null) {
            this.selectedBackgroundDrawable = drawable.getConstantState().newDrawable();
        }
    }

    public Drawable getBackground() {
        return this.backgroundDrawable;
    }

    public void setBackground(Drawable drawable) {
        this.backgroundDrawable = drawable;
        this.backgroundDrawable.setBounds(0, 0, this.getWidth(), this.getHeight());
        this.setupBackgroundBitmaps();
        this.invalidate();
    }

    public void setBackground(@ColorInt int color) {
        if (this.backgroundDrawable instanceof ColorDrawable) {
            ((ColorDrawable)this.backgroundDrawable.mutate()).setColor(color);
        } else {
            this.backgroundDrawable = new ColorDrawable(color);
            this.backgroundDrawable.setBounds(0, 0, this.getWidth(), this.getHeight());
        }
        this.setupBackgroundBitmaps();
        this.invalidate();
    }

    public void setBackgroundColor(@ColorInt int color) {
        this.setBackground(color);
    }

    public Drawable getSelectedBackground() {
        return this.selectedBackgroundDrawable;
    }

    public void setSelectedBackground(Drawable drawable) {
        this.selectedBackgroundDrawable = drawable;
        this.selectedBackgroundDrawable.setBounds(0, 0, this.getWidth(), this.getHeight());
        this.setupBackgroundBitmaps();
        this.invalidate();
    }

    public void setSelectedBackground(@ColorInt int color) {
        if (this.selectedBackgroundDrawable instanceof ColorDrawable) {
            ((ColorDrawable)this.selectedBackgroundDrawable.mutate()).setColor(color);
        } else {
            this.selectedBackgroundDrawable = new ColorDrawable(color);
            this.selectedBackgroundDrawable.setBounds(0, 0, this.getWidth(), this.getHeight());
        }
        this.setupBackgroundBitmaps();
        this.invalidate();
    }

    public void setSelectedBackgroundColor(@ColorInt int color) {
        this.setSelectedBackground(color);
    }

    public int getRippleColor() {
        return this.rippleColor;
    }

    void setRipple(boolean enabled) {
        if (enabled) {
            this.setRipple(this.rippleColor);
        } else {
            this.rippleDrawableLollipop = null;
        }
    }

    public void setRipple(@ColorInt int color) {
        this.rippleColor = color;
        this.rippleDrawableLollipop = new RippleDrawable(ColorStateList.valueOf((int)this.rippleColor), null, null);
        this.rippleDrawableLollipop.setCallback((Drawable.Callback)this);
        this.rippleDrawableLollipop.setBounds(0, 0, this.getWidth(), this.getHeight());
        this.invalidate();
    }

    public Drawable getDrawable() {
        return this.drawable;
    }

    public void setDrawable(@Nullable Drawable drawable) {
        this.drawable = drawable;
        this.requestLayout();
        this.updateSize();
    }

    public int getDrawablePadding() {
        return this.drawablePadding;
    }

    public void setDrawablePadding(int padding) {
        this.drawablePadding = padding;
        this.requestLayout();
        this.updateSize();
    }

    public boolean hasDrawableTint() {
        return this.hasDrawableTint;
    }

    public int getDrawableTint() {
        return this.drawableTint;
    }

    public void setDrawableTint(@ColorInt int tint) {
        this.hasDrawableTint = true;
        this.drawableTint = tint;
        this.drawableColorFilter = new PorterDuffColorFilter(tint, PorterDuff.Mode.SRC_IN);
        this.invalidate();
    }

    public void removeDrawableTint() {
        this.hasDrawableTint = false;
        this.drawableColorFilter = null;
        this.invalidate();
    }

    public boolean hasSelectedDrawableTint() {
        return this.hasSelectedDrawableTint;
    }

    public int getSelectedDrawableTint() {
        return this.selectedDrawableTint;
    }

    public void setSelectedDrawableTint(@ColorInt int tint) {
        this.hasSelectedDrawableTint = true;
        this.selectedDrawableTint = tint;
        this.selectedDrawableColorFilter = new PorterDuffColorFilter(tint, PorterDuff.Mode.SRC_IN);
        this.invalidate();
    }

    public void removeSelectedDrawableTint() {
        this.hasSelectedDrawableTint = false;
        this.selectedDrawableColorFilter = null;
        this.invalidate();
    }

    public boolean hasDrawableWidth() {
        return this.hasDrawableWidth;
    }

    public int getDrawableWidth() {
        return this.drawableWidth;
    }

    public void setDrawableWidth(int width) {
        this.hasDrawableWidth = width != -1;
        this.drawableWidth = width;
        this.requestLayout();
        this.updateSize();
    }

    public boolean hasDrawableHeight() {
        return this.hasDrawableHeight;
    }

    public int getDrawableHeight() {
        return this.drawableHeight;
    }

    public void setDrawableHeight(int height) {
        this.hasDrawableHeight = height != -1;
        this.drawableHeight = height;
        this.requestLayout();
        this.updateSize();
    }

    public int getDrawableGravity() {
        return this.drawableGravity;
    }

    public void setDrawableGravity(int gravity) {
        this.drawableGravity = gravity;
        this.requestLayout();
        this.updateSize();
    }

    public String getText() {
        return this.text;
    }

    public void setText(@Nullable String text) {
        this.hasText = text != null && !text.isEmpty();
        this.text = text;
        this.initText();
        this.requestLayout();
        this.updateSize();
    }

    public int getTextColor() {
        return this.textColor;
    }

    public void setTextColor(@ColorInt int color) {
        this.textColor = color;
        this.invalidate();
    }

    public boolean hasSelectedTextColor() {
        return this.hasSelectedTextColor;
    }

    public int getSelectedTextColor() {
        return this.selectedTextColor;
    }

    public void setSelectedTextColor(@ColorInt int color) {
        this.hasSelectedTextColor = true;
        this.selectedTextColor = color;
        this.invalidate();
    }

    public void removeSelectedTextColor() {
        this.hasSelectedTextColor = false;
        this.invalidate();
    }

    public float getTextSize() {
        return this.textSize;
    }

    public void setTextSize(float size) {
        this.textSize = size;
        if (!this.hasText) {
            return;
        }
        this.textPaint.setTextSize(size);
        this.initText();
        this.requestLayout();
        this.updateSize();
    }

    public Typeface getTextTypeface() {
        return this.textTypeface;
    }

    public void setTextTypeface(Typeface typeface) {
        this.textTypeface = typeface;
        this.refreshTypeface();
    }

    public Typeface getSelectedTextTypeface() {
        return this.selectedTextTypeface;
    }

    public void setSelectedTextTypeface(Typeface typeface) {
        this.selectedTextTypeface = typeface;
        this.refreshTypeface();
    }

    private void refreshTypeface() {
        this.initText();
        this.requestLayout();
        this.updateSize();
    }

    void _setOnVisibilityChangedListener(OnVisibilityChangedListener listener) {
        this.onVisibilityChangedListener = listener;
    }

    public static Bitmap getBitmapFromVectorDrawable(Drawable vectorDrawable) {
        Bitmap bitmap = Bitmap.createBitmap((int)vectorDrawable.getIntrinsicWidth(), (int)vectorDrawable.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        vectorDrawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        vectorDrawable.draw(canvas);
        return bitmap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Bitmap getBitmapFromDrawable(@Nullable Drawable drawable) {
        if (drawable == null) {
            return null;
        }
        if (drawable instanceof BitmapDrawable) {
            return ((BitmapDrawable)drawable).getBitmap();
        }
        try {
            Bitmap bitmap;
            if (drawable instanceof ColorDrawable) {
                bitmap = Bitmap.createBitmap((int)2, (int)2, (Bitmap.Config)BITMAP_CONFIG);
            } else if (drawable instanceof GradientDrawable) {
                Rect bounds = drawable.getBounds();
                if (bounds.width() <= 0 || bounds.height() <= 0) return null;
                bitmap = Bitmap.createBitmap((int)bounds.width(), (int)bounds.height(), (Bitmap.Config)BITMAP_CONFIG);
            } else {
                bitmap = Bitmap.createBitmap((int)drawable.getIntrinsicWidth(), (int)drawable.getIntrinsicHeight(), (Bitmap.Config)BITMAP_CONFIG);
            }
            Canvas canvas = new Canvas(bitmap);
            Rect bounds = new Rect(drawable.getBounds());
            drawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
            drawable.draw(canvas);
            drawable.setBounds(bounds);
            return bitmap;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static interface OnVisibilityChangedListener {
        public void onVisibilityChanged(SegmentedButton var1, int var2);
    }
}

