/*
 * Decompiled with CFR 0.152.
 */
package pyxis.uzuki.live.mediaresizer.strategy;

import android.media.MediaFormat;
import android.util.Log;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.ypresto.androidtranscoder.format.MediaFormatStrategy;
import net.ypresto.androidtranscoder.format.OutputFormatUnavailableException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B#\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016J\b\u0010\u000e\u001a\u00020\u000fH&J\b\u0010\u0010\u001a\u00020\u0003H&J\b\u0010\u0011\u001a\u00020\u0003H&R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lpyxis/uzuki/live/mediaresizer/strategy/FormatStrategy;", "Lnet/ypresto/androidtranscoder/format/MediaFormatStrategy;", "videoBitrate", "", "audioBitrate", "audioChannels", "(III)V", "mAudioBitrate", "mAudioChannels", "mVideoBitrate", "createAudioOutputFormat", "Landroid/media/MediaFormat;", "inputFormat", "createVideoOutputFormat", "getLogTag", "", "getLongerLength", "getShorterLength", "Resizer_release"})
public abstract class FormatStrategy
implements MediaFormatStrategy {
    private int mVideoBitrate;
    private int mAudioBitrate;
    private int mAudioChannels;

    @NotNull
    public abstract String getLogTag();

    public abstract int getLongerLength();

    public abstract int getShorterLength();

    @Nullable
    public MediaFormat createVideoOutputFormat(@NotNull MediaFormat inputFormat) {
        int outHeight;
        int outWidth;
        int shorter;
        int longer;
        Intrinsics.checkParameterIsNotNull((Object)inputFormat, (String)"inputFormat");
        int width = inputFormat.getInteger("width");
        int height = inputFormat.getInteger("height");
        if (width >= height) {
            longer = width;
            shorter = height;
            outWidth = this.getLongerLength();
            outHeight = this.getShorterLength();
        } else {
            shorter = width;
            longer = height;
            outWidth = this.getShorterLength();
            outHeight = this.getLongerLength();
        }
        if (longer * 9 != shorter * 16) {
            throw (Throwable)new OutputFormatUnavailableException("This video is not 16:9, and is not able to transcode. (" + width + "x" + height + ")");
        }
        if (shorter <= this.getShorterLength()) {
            Log.d((String)this.getLogTag(), (String)("This video is less or equal to target resolution, pass-through. (" + width + "x" + height + ")"));
            return null;
        }
        MediaFormat format = MediaFormat.createVideoFormat((String)"video/avc", (int)outWidth, (int)outHeight);
        format.setInteger("bitrate", this.mVideoBitrate);
        format.setInteger("frame-rate", 30);
        format.setInteger("i-frame-interval", 3);
        format.setInteger("color-format", 2130708361);
        return format;
    }

    @Nullable
    public MediaFormat createAudioOutputFormat(@NotNull MediaFormat inputFormat) {
        Intrinsics.checkParameterIsNotNull((Object)inputFormat, (String)"inputFormat");
        if (this.mAudioBitrate == -1 || this.mAudioChannels == -1) {
            return null;
        }
        MediaFormat format = MediaFormat.createAudioFormat((String)"audio/mp4a-latm", (int)inputFormat.getInteger("sample-rate"), (int)this.mAudioChannels);
        format.setInteger("aac-profile", 2);
        format.setInteger("bitrate", this.mAudioBitrate);
        return format;
    }

    public FormatStrategy(int videoBitrate, int audioBitrate, int audioChannels) {
        this.mVideoBitrate = videoBitrate;
        this.mAudioBitrate = audioBitrate;
        this.mAudioChannels = audioChannels;
    }

    public /* synthetic */ FormatStrategy(int n, int n2, int n3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 1) != 0) {
            n = 8000000;
        }
        if ((n4 & 2) != 0) {
            n2 = -1;
        }
        if ((n4 & 4) != 0) {
            n3 = -1;
        }
        this(n, n2, n3);
    }

    public FormatStrategy() {
        this(0, 0, 0, 7, null);
    }
}

