/*
 * Decompiled with CFR 0.152.
 */
package nl.fountain.xelem.lex;

import nl.fountain.xelem.excel.ss.SSColumn;
import nl.fountain.xelem.excel.ss.SSNamedRange;
import nl.fountain.xelem.excel.ss.SSRow;
import nl.fountain.xelem.excel.ss.SSTable;
import nl.fountain.xelem.excel.x.XAutoFilter;
import nl.fountain.xelem.excel.x.XWorksheetOptions;
import nl.fountain.xelem.lex.AnonymousBuilder;
import nl.fountain.xelem.lex.Director;
import nl.fountain.xelem.lex.ExcelReaderListener;
import nl.fountain.xelem.lex.SSRowBuilder;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

class SSWorksheetBuilder
extends AnonymousBuilder {
    private int currentRowIndex;
    private int currentColumnIndex;

    SSWorksheetBuilder(Director director) {
        super(director);
    }

    @Override
    public void build(XMLReader reader, ContentHandler parent) {
        this.setUpBuilder(reader, parent);
        this.currentRowIndex = 0;
        this.currentColumnIndex = 0;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if ("urn:schemas-microsoft-com:office:spreadsheet".equals(uri)) {
            this.startSSElement(localName, atts);
        } else if ("urn:schemas-microsoft-com:office:excel".equals(uri)) {
            if ("WorksheetOptions".equals(localName)) {
                XWorksheetOptions wso = new XWorksheetOptions();
                AnonymousBuilder builder = this.director.getAnonymousBuilder();
                builder.build(this.reader, this, wso);
            } else if ("AutoFilter".equals(localName)) {
                XAutoFilter autoF = new XAutoFilter();
                autoF.setRange(atts.getValue("urn:schemas-microsoft-com:office:excel", "Range"));
                for (ExcelReaderListener listener : this.director.getListeners()) {
                    listener.setAutoFilter(this.director.getCurrentSheetIndex(), this.director.getCurrentSheetName(), autoF);
                }
            }
        }
    }

    private void startSSElement(String localName, Attributes atts) {
        block7: {
            block8: {
                block6: {
                    if (!"Row".equals(localName)) break block6;
                    String index = atts.getValue("urn:schemas-microsoft-com:office:spreadsheet", "Index");
                    this.currentRowIndex = index != null ? Integer.parseInt(index) : ++this.currentRowIndex;
                    if (!this.director.getBuildArea().isRowPartOfArea(this.currentRowIndex)) break block7;
                    SSRow row = new SSRow();
                    row.setIndex(this.currentRowIndex);
                    row.setAttributes(atts);
                    this.director.setCurrentRowIndex(this.currentRowIndex);
                    SSRowBuilder builder = this.director.getSSRowBuilder();
                    builder.build(this.reader, this, row);
                    break block7;
                }
                if (!"Column".equals(localName)) break block8;
                String index = atts.getValue("urn:schemas-microsoft-com:office:spreadsheet", "Index");
                this.currentColumnIndex = index != null ? Integer.parseInt(index) : ++this.currentColumnIndex;
                if (!this.director.getBuildArea().isColumnPartOfArea(this.currentColumnIndex)) break block7;
                SSColumn column = new SSColumn();
                column.setIndex(this.currentColumnIndex);
                column.setAttributes(atts);
                for (ExcelReaderListener listener : this.director.getListeners()) {
                    listener.setColumn(this.director.getCurrentSheetIndex(), this.director.getCurrentSheetName(), column);
                }
                break block7;
            }
            if ("Table".equals(localName)) {
                SSTable table = new SSTable();
                table.setAttributes(atts);
                for (ExcelReaderListener listener : this.director.getListeners()) {
                    listener.startTable(this.director.getCurrentSheetIndex(), this.director.getCurrentSheetName(), table);
                }
            } else if ("NamedRange".equals(localName)) {
                String name = atts.getValue("urn:schemas-microsoft-com:office:spreadsheet", "Name");
                SSNamedRange nr = new SSNamedRange(name, null);
                nr.setAttributes(atts);
                for (ExcelReaderListener listener : this.director.getListeners()) {
                    listener.setNamedRange(this.director.getCurrentSheetIndex(), this.director.getCurrentSheetName(), nr);
                }
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("Worksheet".equals(localName) && "urn:schemas-microsoft-com:office:spreadsheet".equals(uri)) {
            for (ExcelReaderListener listener : this.director.getListeners()) {
                listener.endWorksheet(this.director.getCurrentSheetIndex(), this.director.getCurrentSheetName());
            }
            this.reader.setContentHandler(this.parent);
            return;
        }
    }
}

