/*
 * Decompiled with CFR 0.152.
 */
package nl.fountain.xelem.lex;

import nl.fountain.xelem.excel.Cell;
import nl.fountain.xelem.excel.Row;
import nl.fountain.xelem.excel.XLElement;
import nl.fountain.xelem.excel.ss.SSRow;
import nl.fountain.xelem.lex.AnonymousBuilder;
import nl.fountain.xelem.lex.Director;
import nl.fountain.xelem.lex.ExcelReaderListener;
import nl.fountain.xelem.lex.SSCellBuilder;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

class SSRowBuilder
extends AnonymousBuilder {
    private Row currentRow;
    private int currentCellIndex;

    SSRowBuilder(Director director) {
        super(director);
    }

    @Override
    public void build(XMLReader reader, ContentHandler parent, XLElement xle) {
        this.setUpBuilder(reader, parent);
        this.currentRow = (SSRow)xle;
        this.currentCellIndex = 0;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if ("urn:schemas-microsoft-com:office:spreadsheet".equals(uri) && "Cell".equals(localName)) {
            String index = atts.getValue("urn:schemas-microsoft-com:office:spreadsheet", "Index");
            this.currentCellIndex = index != null ? Integer.parseInt(index) : ++this.currentCellIndex;
            if (this.director.getBuildArea().isColumnPartOfArea(this.currentCellIndex)) {
                Cell cell = this.currentRow.addCellAt(this.currentCellIndex);
                cell.setIndex(this.currentCellIndex);
                cell.setAttributes(atts);
                SSCellBuilder builder = this.director.getSSCellBuilder();
                builder.build(this.reader, this, cell);
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.currentRow.getTagName().equals(localName) && this.currentRow.getNameSpace().equals(uri)) {
            for (ExcelReaderListener listener : this.director.getListeners()) {
                listener.setRow(this.director.getCurrentSheetIndex(), this.director.getCurrentSheetName(), this.currentRow);
            }
            this.reader.setContentHandler(this.parent);
            return;
        }
    }
}

