/*
 * Decompiled with CFR 0.152.
 */
package nl.fountain.xelem.lex;

import java.io.File;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import nl.fountain.xelem.Area;
import nl.fountain.xelem.XSerializer;
import nl.fountain.xelem.excel.Cell;
import nl.fountain.xelem.excel.Row;
import nl.fountain.xelem.excel.Workbook;
import nl.fountain.xelem.excel.Worksheet;
import nl.fountain.xelem.lex.DefaultExcelReaderFilter;
import nl.fountain.xelem.lex.ExcelReader;
import nl.fountain.xelem.lex.WorkbookListener;

public class DefaultExcelReaderFilterTest
extends TestCase {
    ExcelReader reader;

    public static void main(String[] args) {
        TestRunner.run(DefaultExcelReaderFilterTest.class);
    }

    public void testSwapAreas() throws Exception {
        this.reader = new ExcelReader();
        WorkbookListener wbListener = new WorkbookListener();
        SwapAreaFilter saf = new SwapAreaFilter();
        saf.addExcelReaderListener(wbListener);
        this.reader.addExcelReaderListener(saf);
        this.reader.read("testsuitefiles/ReaderTest/reader.xml");
        Workbook wb = wbListener.getWorkbook();
        Worksheet sheet = wb.getWorksheetAt(0);
        DefaultExcelReaderFilterTest.assertTrue((boolean)sheet.hasColumnAt(1));
        Cell cell = sheet.getCellAt(6, 2);
        DefaultExcelReaderFilterTest.assertEquals((String)"=R[-2]C[1]+R[-1]C[1]", (String)cell.getFormula());
        sheet = wb.getWorksheetAt(1);
        cell = sheet.getCellAt(11, 7);
        Row row = sheet.getRowAt(11);
        DefaultExcelReaderFilterTest.assertSame((Object)cell, (Object)row.getCellAt(7));
        DefaultExcelReaderFilterTest.assertEquals((int)1, (int)row.size());
        File out = new File("testoutput/ReaderTest/filterTest.xls");
        new XSerializer().serialize(wb, out);
    }

    private class SwapAreaFilter
    extends DefaultExcelReaderFilter {
        private SwapAreaFilter() {
        }

        @Override
        public void startWorksheet(int sheetIndex, Worksheet sheet) {
            switch (sheetIndex) {
                case 1: {
                    DefaultExcelReaderFilterTest.this.reader.setReadArea(new Area("A1:C6"));
                    break;
                }
                case 2: {
                    DefaultExcelReaderFilterTest.this.reader.setReadArea(new Area("G11:G11"));
                    break;
                }
                default: {
                    DefaultExcelReaderFilterTest.this.reader.clearReadArea();
                }
            }
            super.startWorksheet(sheetIndex, sheet);
        }
    }
}

