/*
 * Decompiled with CFR 0.152.
 */
package nl.fountain.xelem.excel.x;

import junit.textui.TestRunner;
import nl.fountain.xelem.GIO;
import nl.fountain.xelem.excel.XLElementTest;
import nl.fountain.xelem.excel.x.XWorksheetOptions;

public class XWorksheetOptionsTest
extends XLElementTest {
    private XWorksheetOptions wso;

    public static void main(String[] args) {
        TestRunner.run(XWorksheetOptionsTest.class);
    }

    protected void setUp() {
        this.wso = new XWorksheetOptions();
    }

    public void testSetVisible() {
        try {
            this.wso.setVisible("foo");
            XWorksheetOptionsTest.fail((String)"should throw exception");
        }
        catch (IllegalArgumentException e) {
            XWorksheetOptionsTest.assertEquals((String)"foo. Should be one of WorksheetOptions.SHEET_xxx values.", (String)e.getMessage());
        }
    }

    public void testSetActiveCell() {
        try {
            this.wso.setActiveCell(4, 2, 3);
            XWorksheetOptionsTest.fail((String)"should throw exception.");
        }
        catch (IllegalArgumentException e) {
            XWorksheetOptionsTest.assertEquals((String)"4. Legal arguments are 0, 1, 2 and 3.", (String)e.getMessage());
        }
        try {
            this.wso.setActiveCell(0, 3);
            XWorksheetOptionsTest.fail((String)"should throw exception.");
        }
        catch (IllegalArgumentException e) {
            XWorksheetOptionsTest.assertEquals((String)"0. Can't be less than 1.", (String)e.getMessage());
        }
        try {
            this.wso.setActiveCell(5, -2);
            XWorksheetOptionsTest.fail((String)"should throw exception.");
        }
        catch (IllegalArgumentException e) {
            XWorksheetOptionsTest.assertEquals((String)"-2. Can't be less than 1.", (String)e.getMessage());
        }
    }

    public void testSplitHorizontal() {
        try {
            this.wso.splitHorizontal(5000, 0);
            XWorksheetOptionsTest.fail((String)"should throw exception.");
        }
        catch (IllegalArgumentException e) {
            XWorksheetOptionsTest.assertEquals((String)"0. Can't be less than 1.", (String)e.getMessage());
        }
        this.wso.splitHorizontal(5000, 8);
        this.wso.setActiveCell(2, 2, 3);
        String xml = this.xmlToString(this.wso, new GIO());
        XWorksheetOptionsTest.assertTrue((xml.indexOf("<x:SplitHorizontal>5000</x:SplitHorizontal>") > 0 ? 1 : 0) != 0);
        XWorksheetOptionsTest.assertTrue((xml.indexOf("<x:TopRowBottomPane>7</x:TopRowBottomPane>") > 0 ? 1 : 0) != 0);
        XWorksheetOptionsTest.assertTrue((xml.indexOf("<x:ActivePane>2</x:ActivePane>") > 0 ? 1 : 0) != 0);
        XWorksheetOptionsTest.assertTrue((xml.indexOf("<x:Number>2</x:Number>") > 0 ? 1 : 0) != 0);
        XWorksheetOptionsTest.assertTrue((xml.indexOf("<x:ActiveCol>2</x:ActiveCol>") > 0 ? 1 : 0) != 0);
        XWorksheetOptionsTest.assertTrue((xml.indexOf("<x:ActiveRow>1</x:ActiveRow>") > 0 ? 1 : 0) != 0);
    }

    public void testSplitVertical() {
        try {
            this.wso.splitVertical(5000, 0);
            XWorksheetOptionsTest.fail((String)"should throw exception.");
        }
        catch (IllegalArgumentException e) {
            XWorksheetOptionsTest.assertEquals((String)"0. Can't be less than 1.", (String)e.getMessage());
        }
        this.wso.splitVertical(5000, 8);
        this.wso.setActiveCell(1, 2, 3);
        String xml = this.xmlToString(this.wso, new GIO());
        XWorksheetOptionsTest.assertTrue((xml.indexOf("<x:SplitVertical>5000</x:SplitVertical>") > 0 ? 1 : 0) != 0);
        XWorksheetOptionsTest.assertTrue((xml.indexOf("<x:LeftColumnRightPane>7</x:LeftColumnRightPane>") > 0 ? 1 : 0) != 0);
        XWorksheetOptionsTest.assertTrue((xml.indexOf("<x:ActivePane>1</x:ActivePane>") > 0 ? 1 : 0) != 0);
        XWorksheetOptionsTest.assertTrue((xml.indexOf("<x:Number>1</x:Number>") > 0 ? 1 : 0) != 0);
        XWorksheetOptionsTest.assertTrue((xml.indexOf("<x:ActiveCol>2</x:ActiveCol>") > 0 ? 1 : 0) != 0);
        XWorksheetOptionsTest.assertTrue((xml.indexOf("<x:ActiveRow>1</x:ActiveRow>") > 0 ? 1 : 0) != 0);
    }

    public void testAssemble() {
        this.wso.doDisplayFormulas(true);
        this.wso.doNotDisplayGridlines(true);
        this.wso.doNotDisplayHeadings(true);
        this.wso.setGridlineColor(255, 0, 100);
        this.wso.setLeftColumnVisible(6);
        this.wso.setSelected(true);
        this.wso.setTabColorIndex(123456);
        this.wso.setTopRowVisible(7);
        this.wso.setVisible("SheetHidden");
        this.wso.setZoom(150);
        GIO gio = new GIO();
        String xml = this.xmlToString(this.wso, gio);
        XWorksheetOptionsTest.assertTrue((xml.indexOf("<x:WorksheetOptions>") > 0 ? 1 : 0) != 0);
        XWorksheetOptionsTest.assertTrue((xml.indexOf("<x:Selected/>") > 0 ? 1 : 0) != 0);
        XWorksheetOptionsTest.assertTrue((xml.indexOf("<x:DoNotDisplayHeadings/>") > 0 ? 1 : 0) != 0);
        XWorksheetOptionsTest.assertTrue((xml.indexOf("<x:DoNotDisplayGridlines/>") > 0 ? 1 : 0) != 0);
        XWorksheetOptionsTest.assertTrue((xml.indexOf("<x:DisplayFormulas/>") > 0 ? 1 : 0) != 0);
        XWorksheetOptionsTest.assertTrue((xml.indexOf("<x:TopRowVisible>7</x:TopRowVisible>") > 0 ? 1 : 0) != 0);
        XWorksheetOptionsTest.assertTrue((xml.indexOf("<x:LeftColumnVisible>6</x:LeftColumnVisible>") > 0 ? 1 : 0) != 0);
        XWorksheetOptionsTest.assertTrue((xml.indexOf("<x:Zoom>150</x:Zoom>") > 0 ? 1 : 0) != 0);
        XWorksheetOptionsTest.assertTrue((xml.indexOf("<x:TabColorIndex>123456</x:TabColorIndex>") > 0 ? 1 : 0) != 0);
        XWorksheetOptionsTest.assertTrue((xml.indexOf("<x:GridlineColor>#ff0064</x:GridlineColor>") > 0 ? 1 : 0) != 0);
        XWorksheetOptionsTest.assertTrue((xml.indexOf("<x:Visible>SheetHidden</x:Visible>") > 0 ? 1 : 0) != 0);
    }

    public void testPanesAssembly() {
        this.wso.setActiveCell(2, 2, 3);
        GIO gio = new GIO();
        String xml = this.xmlToString(this.wso, gio);
        XWorksheetOptionsTest.assertEquals((int)-1, (int)xml.indexOf("<x:ActivePane>"));
        XWorksheetOptionsTest.assertTrue((xml.indexOf("<x:Panes/>") > 0 ? 1 : 0) != 0);
        this.wso.setActiveCell(1, 2, 3);
        xml = this.xmlToString(this.wso, gio);
        XWorksheetOptionsTest.assertEquals((int)-1, (int)xml.indexOf("<x:ActivePane>"));
        XWorksheetOptionsTest.assertTrue((xml.indexOf("<x:Panes/>") > 0 ? 1 : 0) != 0);
        this.wso.setActiveCell(0, 2, 3);
        xml = this.xmlToString(this.wso, gio);
        XWorksheetOptionsTest.assertEquals((int)-1, (int)xml.indexOf("<x:ActivePane>"));
        XWorksheetOptionsTest.assertTrue((xml.indexOf("<x:Panes/>") > 0 ? 1 : 0) != 0);
        this.wso.setActiveCell(3, 2, 3);
        xml = this.xmlToString(this.wso, gio);
        XWorksheetOptionsTest.assertTrue((xml.indexOf("<x:ActivePane>3</x:ActivePane>") > 0 ? 1 : 0) != 0);
        XWorksheetOptionsTest.assertTrue((xml.indexOf("<x:Number>3</x:Number>") > 0 ? 1 : 0) != 0);
        XWorksheetOptionsTest.assertTrue((xml.indexOf("<x:ActiveCol>2</x:ActiveCol>") > 0 ? 1 : 0) != 0);
        XWorksheetOptionsTest.assertTrue((xml.indexOf("<x:ActiveRow>1</x:ActiveRow>") > 0 ? 1 : 0) != 0);
    }

    public void testSplitVertical2() {
        this.wso.splitVertical(5000, 8);
        this.wso.setActiveCell(2, 2, 3);
        String xml = this.xmlToString(this.wso, new GIO());
        XWorksheetOptionsTest.assertEquals((int)-1, (int)xml.indexOf("<x:ActivePane>"));
        XWorksheetOptionsTest.assertTrue((xml.indexOf("<x:Panes/>") > 0 ? 1 : 0) != 0);
        this.wso.setActiveCell(0, 2, 3);
        xml = this.xmlToString(this.wso, new GIO());
        XWorksheetOptionsTest.assertEquals((int)-1, (int)xml.indexOf("<x:ActivePane>"));
        XWorksheetOptionsTest.assertTrue((xml.indexOf("<x:Panes/>") > 0 ? 1 : 0) != 0);
    }

    public void testSplitHorizontal2() {
        this.wso.splitHorizontal(5000, 8);
        this.wso.setActiveCell(1, 2, 3);
        String xml = this.xmlToString(this.wso, new GIO());
        XWorksheetOptionsTest.assertEquals((int)-1, (int)xml.indexOf("<x:ActivePane>"));
        XWorksheetOptionsTest.assertTrue((xml.indexOf("<x:Panes/>") > 0 ? 1 : 0) != 0);
        this.wso.setActiveCell(0, 2, 3);
        xml = this.xmlToString(this.wso, new GIO());
        XWorksheetOptionsTest.assertEquals((int)-1, (int)xml.indexOf("<x:ActivePane>"));
        XWorksheetOptionsTest.assertTrue((xml.indexOf("<x:Panes/>") > 0 ? 1 : 0) != 0);
    }

    public void testFreezePanesAt() {
        this.wso.freezePanesAt(2, 3);
        String xml = this.xmlToString(this.wso, new GIO());
        XWorksheetOptionsTest.assertTrue((xml.indexOf("<x:FreezePanes/>") > 0 ? 1 : 0) != 0);
        XWorksheetOptionsTest.assertTrue((xml.indexOf("<x:FrozenNoSplit/>") > 0 ? 1 : 0) != 0);
        XWorksheetOptionsTest.assertTrue((xml.indexOf("<x:SplitHorizontal>2</x:SplitHorizontal>") > 0 ? 1 : 0) != 0);
        XWorksheetOptionsTest.assertTrue((xml.indexOf("<x:TopRowBottomPane>2</x:TopRowBottomPane>") > 0 ? 1 : 0) != 0);
        XWorksheetOptionsTest.assertTrue((xml.indexOf("<x:SplitVertical>3</x:SplitVertical>") > 0 ? 1 : 0) != 0);
        XWorksheetOptionsTest.assertTrue((xml.indexOf("<x:LeftColumnRightPane>3</x:LeftColumnRightPane>") > 0 ? 1 : 0) != 0);
        XWorksheetOptionsTest.assertTrue((xml.indexOf("<x:ActivePane>0</x:ActivePane>") > 0 ? 1 : 0) != 0);
    }
}

