/*
 * Decompiled with CFR 0.152.
 */
package nl.fountain.xelem.excel.x;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import nl.fountain.xelem.Area;
import nl.fountain.xelem.GIO;
import nl.fountain.xelem.XLUtil;
import nl.fountain.xelem.excel.AbstractXLElement;
import nl.fountain.xelem.excel.Pane;
import nl.fountain.xelem.excel.WorksheetOptions;
import nl.fountain.xelem.excel.x.XPane;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XWorksheetOptions
extends AbstractXLElement
implements WorksheetOptions {
    private Map<Integer, Pane> panes;
    private int zoom;
    private int tabColorIndex = -1;
    private String gridlineColor;
    private String visible;
    private boolean selected;
    private boolean noHeadings;
    private boolean noGridlines;
    private boolean displayFormulas;
    private int topRowVisible = -1;
    private int leftColumnVisible = -1;
    private int splitHorizontal;
    private int topRowBottomPane = -1;
    private int leftColumnRightPane = -1;
    private int activePane = -1;
    private int splitVertical;
    private boolean freezePanes;
    private Pane currentPane;

    @Override
    public void setTopRowVisible(int tr) {
        this.topRowVisible = tr;
    }

    private void setTopRowVisible(String s) {
        this.topRowVisible = Integer.parseInt(s);
    }

    @Override
    public int getTopRowVisible() {
        return this.topRowVisible;
    }

    @Override
    public void setLeftColumnVisible(int lc) {
        this.leftColumnVisible = lc;
    }

    private void setLeftColumnVisible(String s) {
        this.leftColumnVisible = Integer.parseInt(s);
    }

    @Override
    public int getLeftColumnVisible() {
        return this.leftColumnVisible;
    }

    @Override
    public void setZoom(int z) {
        this.zoom = z;
    }

    private void setZoom(String s) {
        this.zoom = Integer.parseInt(s);
    }

    @Override
    public int getZoom() {
        return this.zoom;
    }

    @Override
    public void setTabColorIndex(int ci) {
        this.tabColorIndex = ci;
    }

    private void setTabColorIndex(String s) {
        this.tabColorIndex = Integer.parseInt(s);
    }

    @Override
    public int getTabColorIndex() {
        return this.tabColorIndex;
    }

    @Override
    public void setSelected(boolean s) {
        this.selected = s;
    }

    private void setSelected(String s) {
        this.selected = "".equals(s);
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public void doNotDisplayHeadings(boolean b) {
        this.noHeadings = b;
    }

    private void setDoNotDisplayHeadings(String s) {
        this.noHeadings = "".equals(s);
    }

    @Override
    public boolean displaysNoHeadings() {
        return this.noHeadings;
    }

    @Override
    public void doNotDisplayGridlines(boolean b) {
        this.noGridlines = b;
    }

    private void setDoNotDisplayGridlines(String s) {
        this.noGridlines = "".equals(s);
    }

    @Override
    public boolean displaysNoGridlines() {
        return this.noGridlines;
    }

    @Override
    public void doDisplayFormulas(boolean f) {
        this.displayFormulas = f;
    }

    private void setDisplayFormulas(String s) {
        this.displayFormulas = "".equals(s);
    }

    @Override
    public boolean displaysFormulas() {
        return this.displayFormulas;
    }

    @Override
    public void setVisible(String wsoValue) {
        if (!("SheetHidden".equals(wsoValue) || "SheetVeryHidden".equals(wsoValue) || "SheetVisible".equals(wsoValue) || wsoValue == null)) {
            throw new IllegalArgumentException(wsoValue + ". Should be one of WorksheetOptions.SHEET_xxx values.");
        }
        this.visible = wsoValue;
    }

    @Override
    public String getVisible() {
        if (this.visible == null) {
            return "SheetVisible";
        }
        return this.visible;
    }

    @Override
    public void setActiveCell(int r, int c) {
        if (r < 1) {
            throw new IllegalArgumentException(r + ". Can't be less than 1.");
        }
        if (c < 1) {
            throw new IllegalArgumentException(c + ". Can't be less than 1.");
        }
        this.getPane(3).setActiveCell(r, c);
    }

    @Override
    public void setActiveCell(int paneNumber, int r, int c) {
        this.getPane(paneNumber).setActiveCell(r, c);
        this.activePane = paneNumber;
    }

    @Override
    public void setRangeSelection(String rcRange) {
        if (this.currentPane == null) {
            this.getPane(3).setRangeSelection(rcRange);
        } else {
            this.currentPane.setRangeSelection(rcRange);
        }
    }

    @Override
    public void setRangeSelection(Area area) {
        this.setRangeSelection(area.getAbsoluteRange());
    }

    @Override
    public void setRangeSelection(int paneNumber, String rcRange) {
        this.getPane(paneNumber).setRangeSelection(rcRange);
    }

    @Override
    public void splitHorizontal(int points, int topRow) {
        if (topRow < 1) {
            throw new IllegalArgumentException(topRow + ". Can't be less than 1.");
        }
        this.splitHorizontal = points;
        this.topRowBottomPane = topRow - 1;
    }

    @Override
    public boolean hasHorizontalSplit() {
        return this.splitHorizontal > 0 || this.topRowBottomPane > -1;
    }

    @Override
    public void splitVertical(int points, int leftColumn) {
        if (leftColumn < 1) {
            throw new IllegalArgumentException(leftColumn + ". Can't be less than 1.");
        }
        this.splitVertical = points;
        this.leftColumnRightPane = leftColumn - 1;
    }

    @Override
    public boolean hasVerticalSplit() {
        return this.splitVertical > 0 || this.leftColumnRightPane > -1;
    }

    @Override
    public boolean hasSplit() {
        return this.hasHorizontalSplit() || this.hasVerticalSplit();
    }

    @Override
    public void freezePanesAt(int row, int column) {
        this.freezePanes = true;
        this.splitHorizontal = row;
        this.topRowBottomPane = row;
        this.splitVertical = column;
        this.leftColumnRightPane = column;
        if (row > 0 && column > 0) {
            this.activePane = 0;
        } else if (row > 0) {
            this.activePane = 2;
        }
    }

    @Override
    public boolean hasFrozenPanes() {
        return this.freezePanes;
    }

    private void setFreezePanes(String s) {
        this.freezePanes = "".equals(s);
    }

    private void setSplitHorizontal(String s) {
        this.splitHorizontal = Integer.parseInt(s);
    }

    private void setTopRowBottomPane(String s) {
        this.topRowBottomPane = Integer.parseInt(s);
    }

    private void setSplitVertical(String s) {
        this.splitVertical = Integer.parseInt(s);
    }

    private void setLeftColumnRightPane(String s) {
        this.leftColumnRightPane = Integer.parseInt(s);
    }

    private void setActivePane(String s) {
        this.activePane = Integer.parseInt(s);
    }

    @Override
    public void setGridlineColor(int r, int g, int b) {
        this.gridlineColor = XLUtil.convertToHex(r, g, b);
    }

    private void setGridlineColor(String s) {
        this.gridlineColor = s;
    }

    @Override
    public String getGridlineColor() {
        return this.gridlineColor;
    }

    @Override
    public String getTagName() {
        return "WorksheetOptions";
    }

    @Override
    public String getNameSpace() {
        return "urn:schemas-microsoft-com:office:excel";
    }

    @Override
    public String getPrefix() {
        return "x";
    }

    @Override
    public Element assemble(Element parent, GIO gio) {
        Document doc = parent.getOwnerDocument();
        Element wsoe = this.assemble(doc, gio);
        parent.appendChild(wsoe);
        if (this.isSelected()) {
            wsoe.appendChild(this.createElementNS(doc, "Selected"));
            gio.increaseSelectedSheets();
        }
        if (this.displaysNoHeadings()) {
            wsoe.appendChild(this.createElementNS(doc, "DoNotDisplayHeadings"));
        }
        if (this.displaysNoGridlines()) {
            wsoe.appendChild(this.createElementNS(doc, "DoNotDisplayGridlines"));
        }
        if (this.displaysFormulas()) {
            wsoe.appendChild(this.createElementNS(doc, "DisplayFormulas"));
        }
        if (this.topRowVisible > -1) {
            wsoe.appendChild(this.createElementNS(doc, "TopRowVisible", this.topRowVisible));
        }
        if (this.leftColumnVisible > -1) {
            wsoe.appendChild(this.createElementNS(doc, "LeftColumnVisible", this.leftColumnVisible));
        }
        if (this.zoom > 0) {
            wsoe.appendChild(this.createElementNS(doc, "Zoom", this.zoom));
        }
        if (this.tabColorIndex != -1) {
            wsoe.appendChild(this.createElementNS(doc, "TabColorIndex", this.tabColorIndex));
        }
        if (this.gridlineColor != null) {
            wsoe.appendChild(this.createElementNS(doc, "GridlineColor", this.gridlineColor));
        }
        if (this.visible != null) {
            wsoe.appendChild(this.createElementNS(doc, "Visible", this.visible));
        }
        if (this.freezePanes) {
            wsoe.appendChild(this.createElementNS(doc, "FreezePanes"));
            wsoe.appendChild(this.createElementNS(doc, "FrozenNoSplit"));
        }
        boolean splitH = false;
        if (this.splitHorizontal > 0 || this.topRowBottomPane > -1) {
            splitH = true;
            wsoe.appendChild(this.createElementNS(doc, "SplitHorizontal", this.splitHorizontal));
            wsoe.appendChild(this.createElementNS(doc, "TopRowBottomPane", this.topRowBottomPane));
        }
        boolean splitV = false;
        if (this.splitVertical > 0 || this.leftColumnRightPane > -1) {
            splitV = true;
            wsoe.appendChild(this.createElementNS(doc, "SplitVertical", this.splitVertical));
            wsoe.appendChild(this.createElementNS(doc, "LeftColumnRightPane", this.leftColumnRightPane));
        }
        if (this.activePane == 3 || splitH && this.activePane == 2 || splitV && this.activePane == 1 || splitH && splitV && this.activePane == 0) {
            wsoe.appendChild(this.createElementNS(doc, "ActivePane", this.activePane));
        }
        if (this.panes != null) {
            Pane pane0;
            Pane pane1;
            Pane pane2;
            Element panesE = this.createElementNS(doc, "Panes");
            wsoe.appendChild(panesE);
            Pane pane3 = this.panes.get(new Integer(3));
            if (pane3 != null) {
                pane3.assemble(panesE, gio);
            }
            if ((pane2 = this.panes.get(new Integer(2))) != null && splitH) {
                pane2.assemble(panesE, gio);
            }
            if ((pane1 = this.panes.get(new Integer(1))) != null && splitV) {
                pane1.assemble(panesE, gio);
            }
            if ((pane0 = this.panes.get(new Integer(0))) != null && splitH && splitV) {
                pane0.assemble(panesE, gio);
            }
        }
        return wsoe;
    }

    private Pane getPane(int number) {
        Pane pane;
        if (this.panes == null) {
            this.panes = new HashMap<Integer, Pane>();
        }
        if ((pane = this.panes.get(new Integer(number))) == null) {
            pane = new XPane(number);
            this.panes.put(new Integer(pane.getNumber()), pane);
        }
        return pane;
    }

    private void setNumber(String s) {
        this.currentPane = this.getPane(Integer.parseInt(s));
    }

    private void setActiveRow(String s) {
        this.currentPane.setActiveRow(Integer.parseInt(s) + 1);
    }

    private void setActiveCol(String s) {
        this.currentPane.setActiveCol(Integer.parseInt(s) + 1);
    }

    private void setPane(String s) {
        this.currentPane = null;
        if (s == null) {
            // empty if block
        }
    }

    @Override
    public void setChildElement(String localName, String content) {
        this.invokeMethod(localName, content);
    }

    private void invokeMethod(String name, Object value) {
        Class[] types = new Class[]{value.getClass()};
        Method method = null;
        try {
            method = this.getClass().getDeclaredMethod("set" + name, types);
            method.invoke((Object)this, value);
        }
        catch (NoSuchMethodException e) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

