/*
 * Decompiled with CFR 0.152.
 */
package nl.fountain.xelem.excel.ss;

import java.util.Iterator;
import junit.textui.TestRunner;
import nl.fountain.xelem.GIO;
import nl.fountain.xelem.excel.Row;
import nl.fountain.xelem.excel.Table;
import nl.fountain.xelem.excel.XLElementTest;
import nl.fountain.xelem.excel.ss.SSRow;
import nl.fountain.xelem.excel.ss.SSTable;

public class SSTableTest
extends XLElementTest {
    private Table table;

    public static void main(String[] args) {
        TestRunner.run(SSTableTest.class);
    }

    protected void setUp() throws Exception {
        this.table = new SSTable();
    }

    public void testAddRow() {
        SSTableTest.assertEquals((int)0, (int)this.table.rowCount());
        Row row = this.table.addRow();
        SSTableTest.assertEquals((int)1, (int)this.table.rowCount());
        SSTableTest.assertSame((Object)row, (Object)this.table.getRowMap().get(new Integer(1)));
        Row row2 = this.table.addRow();
        SSTableTest.assertEquals((int)2, (int)this.table.rowCount());
        SSTableTest.assertSame((Object)row2, (Object)this.table.getRowMap().get(new Integer(2)));
        SSTableTest.assertNotSame((Object)row, (Object)row2);
        Iterator<Row> iter = this.table.getRows().iterator();
        SSTableTest.assertSame((Object)row, (Object)iter.next());
        SSTableTest.assertSame((Object)row2, (Object)iter.next());
        try {
            iter.next();
            SSTableTest.fail((String)"Alle rijen zijn doorlopen");
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void testAddRow_index() {
        SSTableTest.assertEquals((int)0, (int)this.table.rowCount());
        Row row = this.table.addRowAt(5);
        SSTableTest.assertEquals((int)1, (int)this.table.rowCount());
        SSTableTest.assertSame((Object)row, (Object)this.table.getRowMap().get(new Integer(5)));
        Row row6 = this.table.addRow();
        SSTableTest.assertEquals((int)2, (int)this.table.rowCount());
        SSTableTest.assertSame((Object)row6, (Object)this.table.getRowMap().get(new Integer(6)));
        Row row3 = this.table.addRowAt(3);
        SSTableTest.assertEquals((int)3, (int)this.table.rowCount());
        SSTableTest.assertSame((Object)row3, (Object)this.table.getRowMap().get(new Integer(3)));
        Iterator<Row> iter = this.table.getRows().iterator();
        SSTableTest.assertSame((Object)row3, (Object)iter.next());
        SSTableTest.assertSame((Object)row, (Object)iter.next());
        SSTableTest.assertSame((Object)row6, (Object)iter.next());
        try {
            iter.next();
            SSTableTest.fail((String)"Alle rijen zijn doorlopen");
        }
        catch (Exception e) {
            // empty catch block
        }
        Row row5 = this.table.addRowAt(5);
        SSTableTest.assertEquals((int)3, (int)this.table.rowCount());
        SSTableTest.assertSame((Object)row5, (Object)this.table.getRowMap().get(new Integer(5)));
        Row row7 = this.table.addRow();
        SSTableTest.assertEquals((int)4, (int)this.table.rowCount());
        SSTableTest.assertSame((Object)row7, (Object)this.table.getRowMap().get(new Integer(7)));
        iter = this.table.getRows().iterator();
        SSTableTest.assertSame((Object)row3, (Object)iter.next());
        SSTableTest.assertSame((Object)row5, (Object)iter.next());
        SSTableTest.assertSame((Object)row6, (Object)iter.next());
        SSTableTest.assertSame((Object)row7, (Object)iter.next());
        try {
            iter.next();
            SSTableTest.fail((String)"Alle rijen zijn doorlopen");
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void testAddRow_Row() {
        SSTableTest.assertEquals((int)0, (int)this.table.rowCount());
        SSRow row = new SSRow();
        Row returnRow = this.table.addRow(row);
        SSTableTest.assertEquals((int)1, (int)this.table.rowCount());
        SSTableTest.assertSame((Object)row, (Object)returnRow);
        SSTableTest.assertSame((Object)row, (Object)this.table.getRowMap().get(new Integer(1)));
    }

    public void testAddRow_index_Row() {
        SSTableTest.assertEquals((int)0, (int)this.table.rowCount());
        SSRow row = new SSRow();
        this.table.addRow(row);
        try {
            this.table.addRowAt(-1, row);
            SSTableTest.fail((String)"geen exceptie gegooid");
        }
        catch (IndexOutOfBoundsException e) {
            SSTableTest.assertEquals((String)"rowIndex = -1", (String)e.getMessage());
        }
        SSTableTest.assertEquals((int)1, (int)this.table.rowCount());
        SSTableTest.assertSame((Object)row, (Object)this.table.getRowMap().get(new Integer(1)));
        Row returnRow2 = this.table.addRowAt(5, row);
        SSTableTest.assertEquals((int)2, (int)this.table.rowCount());
        SSTableTest.assertSame((Object)row, (Object)returnRow2);
        SSTableTest.assertSame((Object)row, (Object)this.table.getRowMap().get(new Integer(5)));
    }

    public void testRemoveRow() {
        this.table.addRow();
        Row row = this.table.addRow();
        this.table.addRow();
        SSTableTest.assertEquals((int)3, (int)this.table.rowCount());
        SSTableTest.assertSame((Object)row, (Object)this.table.removeRowAt(2));
        SSTableTest.assertEquals((int)2, (int)this.table.rowCount());
        this.table.addRow();
        Iterator<Integer> iter = this.table.getRowMap().keySet().iterator();
        SSTableTest.assertEquals((Object)new Integer(1), (Object)iter.next());
        SSTableTest.assertEquals((Object)new Integer(3), (Object)iter.next());
        SSTableTest.assertEquals((Object)new Integer(4), (Object)iter.next());
        try {
            iter.next();
            SSTableTest.fail((String)"Alle rijen zijn doorlopen");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testIterator() {
        Row row1 = this.table.addRow();
        Row row2 = this.table.addRow();
        Iterator<Row> iter = this.table.rowIterator();
        SSTableTest.assertEquals((Object)row1, (Object)iter.next());
        SSTableTest.assertEquals((Object)row2, (Object)iter.next());
        try {
            iter.next();
            SSTableTest.fail((String)"alle rijen doorlopen");
        }
        catch (Exception e) {
            // empty catch block
        }
        iter = this.table.rowIterator();
        iter.next();
        try {
            iter.remove();
            SSTableTest.fail((String)"should throw UnsupportedPerationException.");
        }
        catch (UnsupportedOperationException e1) {
            // empty catch block
        }
    }

    public void testIterator2() {
        Row row1 = this.table.addRow();
        Row row2 = this.table.addRowAt(5);
        Row row3 = this.table.addRowAt(7, row2);
        Iterator<Row> iter = this.table.rowIterator();
        Row r1 = iter.next();
        SSTableTest.assertEquals((Object)row1, (Object)r1);
        Row r5 = iter.next();
        SSTableTest.assertEquals((Object)row2, (Object)r5);
        Row r7 = iter.next();
        SSTableTest.assertEquals((Object)row2, (Object)r7);
        SSTableTest.assertEquals((Object)row3, (Object)r7);
    }

    public void testAssemble() {
        this.table.setStyleID("foo");
        this.table.addColumnAt(5).setStyleID("col");
        this.table.addRowAt(7).addCell(new Double(1.2345), "currency");
        GIO gio = new GIO();
        String xml = this.xmlToString(this.table, gio);
        SSTableTest.assertTrue((xml.indexOf("<ss:Table ss:StyleID=\"foo\">") > 0 ? 1 : 0) != 0);
        SSTableTest.assertTrue((xml.indexOf("<ss:Column ss:Index=\"5\" ss:StyleID=\"col\"") > 0 ? 1 : 0) != 0);
        SSTableTest.assertTrue((xml.indexOf("<ss:Row ss:Index=\"7\">") > 0 ? 1 : 0) != 0);
        SSTableTest.assertTrue((xml.indexOf("<ss:Cell ss:StyleID=\"currency\">") > 0 ? 1 : 0) != 0);
        SSTableTest.assertTrue((xml.indexOf("<Data ss:Type=\"Number\">1.2345</Data>") > 0 ? 1 : 0) != 0);
        SSTableTest.assertEquals((int)3, (int)gio.getStyleIDSet().size());
    }
}

