/*
 * Decompiled with CFR 0.152.
 */
package nl.fountain.xelem.excel.ss;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeMap;
import nl.fountain.xelem.GIO;
import nl.fountain.xelem.excel.AbstractXLElement;
import nl.fountain.xelem.excel.Column;
import nl.fountain.xelem.excel.Row;
import nl.fountain.xelem.excel.Table;
import nl.fountain.xelem.excel.ss.SSColumn;
import nl.fountain.xelem.excel.ss.SSRow;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;

public class SSTable
extends AbstractXLElement
implements Table {
    TreeMap<Integer, Column> columns;
    TreeMap<Integer, Row> rows = new TreeMap();
    private String styleID;
    private double rowheight;
    private double columnwidth;
    private int expandedcolumncount;
    private int expandedrowcount;

    public SSTable() {
        this.columns = new TreeMap();
    }

    @Override
    public void setStyleID(String id) {
        this.styleID = id;
    }

    @Override
    public String getStyleID() {
        return this.styleID;
    }

    @Override
    public void setDefaultRowHeight(double points) {
        this.rowheight = points;
    }

    @Override
    public void setDefaultColumnWidth(double points) {
        this.columnwidth = points;
    }

    @Override
    public Column addColumn() {
        return this.addColumnAt(this.maxColumnIndex() + 1, new SSColumn());
    }

    @Override
    public Column addColumnAt(int index) {
        return this.addColumnAt(index, new SSColumn());
    }

    @Override
    public Column addColumn(Column column) {
        return this.addColumnAt(this.maxColumnIndex() + 1, column);
    }

    @Override
    public Column addColumnAt(int index, Column column) {
        if (index < 1 || index > 256) {
            throw new IndexOutOfBoundsException("columnIndex = " + index);
        }
        this.columns.put(new Integer(index), column);
        return column;
    }

    @Override
    public Column removeColumnAt(int columnIndex) {
        return this.columns.remove(new Integer(columnIndex));
    }

    @Override
    public Column getColumnAt(int columnIndex) {
        Column column = this.columns.get(new Integer(columnIndex));
        if (column == null) {
            column = this.addColumnAt(columnIndex);
        }
        return column;
    }

    @Override
    public boolean hasColumnAt(int index) {
        return this.columns.get(new Integer(index)) != null;
    }

    @Override
    public Collection<Column> getColumns() {
        return this.columns.values();
    }

    @Override
    public Row addRow() {
        return this.addRowAt(this.maxRowIndex() + 1, new SSRow());
    }

    @Override
    public Row addRowAt(int index) {
        return this.addRowAt(index, new SSRow());
    }

    @Override
    public Row addRow(Row row) {
        return this.addRowAt(this.maxRowIndex() + 1, row);
    }

    @Override
    public Row addRowAt(int index, Row row) {
        if (index < 1 || index > 65536) {
            throw new IndexOutOfBoundsException("rowIndex = " + index);
        }
        this.rows.put(new Integer(index), row);
        return row;
    }

    @Override
    public Row removeRowAt(int rowIndex) {
        Row row = this.rows.remove(new Integer(rowIndex));
        return row;
    }

    @Override
    public Collection<Row> getRows() {
        return this.rows.values();
    }

    @Override
    public TreeMap<Integer, Row> getRowMap() {
        return this.rows;
    }

    @Override
    public Row getRowAt(int rowIndex) {
        Row row = this.rows.get(new Integer(rowIndex));
        if (row == null) {
            row = this.addRowAt(rowIndex);
        }
        return row;
    }

    @Override
    public boolean hasRowAt(int index) {
        return this.rows.get(new Integer(index)) != null;
    }

    @Override
    public int rowCount() {
        return this.rows.size();
    }

    @Override
    public int columnCount() {
        return this.columns.size();
    }

    @Override
    public boolean hasChildren() {
        return this.columns.size() + this.rows.size() > 0;
    }

    @Override
    public int maxCellIndex() {
        int max = 0;
        for (Row r : this.rows.values()) {
            if (r.maxCellIndex() <= max) continue;
            max = r.maxCellIndex();
        }
        return max;
    }

    @Override
    public int maxRowIndex() {
        int lastKey = this.rows.size() == 0 ? 0 : this.rows.lastKey();
        return lastKey;
    }

    @Override
    public int maxColumnIndex() {
        int lastKey = this.columns.size() == 0 ? 0 : this.columns.lastKey();
        return lastKey;
    }

    @Override
    public Iterator<Row> rowIterator() {
        return new RowIterator();
    }

    @Override
    public Iterator<Column> columnIterator() {
        return new ColumnIterator();
    }

    @Override
    public String getTagName() {
        return "Table";
    }

    @Override
    public String getNameSpace() {
        return "urn:schemas-microsoft-com:office:spreadsheet";
    }

    @Override
    public String getPrefix() {
        return "ss";
    }

    @Override
    public Element assemble(Element parent, GIO gio) {
        Document doc = parent.getOwnerDocument();
        Element te = this.assemble(doc, gio);
        if (this.getStyleID() != null) {
            te.setAttributeNodeNS(this.createAttributeNS(doc, "StyleID", this.getStyleID()));
            gio.addStyleID(this.getStyleID());
        }
        if (this.rowheight > 0.0) {
            te.setAttributeNodeNS(this.createAttributeNS(doc, "DefaultRowHeight", "" + this.rowheight));
        }
        if (this.columnwidth > 0.0) {
            te.setAttributeNodeNS(this.createAttributeNS(doc, "DefaultColumnWidth", "" + this.columnwidth));
        }
        parent.appendChild(te);
        Iterator<Column> iterC = this.columnIterator();
        while (iterC.hasNext()) {
            iterC.next().assemble(te, gio);
        }
        Iterator<Row> iterR = this.rowIterator();
        while (iterR.hasNext()) {
            iterR.next().assemble(te, gio);
        }
        return te;
    }

    @Override
    public void setAttributes(Attributes attrs) {
        for (int i = 0; i < attrs.getLength(); ++i) {
            this.invokeMethod(attrs.getLocalName(i), attrs.getValue(i));
        }
    }

    private void invokeMethod(String name, Object value) {
        Class[] types = new Class[]{value.getClass()};
        Method method = null;
        try {
            method = this.getClass().getDeclaredMethod("set" + name, types);
            method.invoke((Object)this, value);
        }
        catch (NoSuchMethodException e) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getExpandedColumnCount() {
        return this.expandedcolumncount;
    }

    private void setExpandedColumnCount(String s) {
        this.expandedcolumncount = Integer.parseInt(s);
    }

    @Override
    public int getExpandedRowCount() {
        return this.expandedrowcount;
    }

    private void setExpandedRowCount(String s) {
        this.expandedrowcount = Integer.parseInt(s);
    }

    private class ColumnIterator
    implements Iterator<Column> {
        private Iterator<Integer> cit;
        private Integer current;
        private int prevIndex;
        private int maxSpan;

        protected ColumnIterator() {
            this.cit = SSTable.this.columns.keySet().iterator();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.cit.hasNext();
        }

        @Override
        public Column next() {
            this.current = this.cit.next();
            int curIndex = this.current;
            SSColumn c = (SSColumn)SSTable.this.columns.get(this.current);
            if (this.prevIndex + 1 != curIndex) {
                c.setIndex(curIndex);
            } else {
                c.setIndex(0);
            }
            this.prevIndex = curIndex;
            return c;
        }
    }

    private class RowIterator
    implements Iterator<Row> {
        private Iterator<Integer> rit;
        private Integer current;
        private int prevIndex;

        protected RowIterator() {
            this.rit = SSTable.this.rows.keySet().iterator();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.rit.hasNext();
        }

        @Override
        public Row next() {
            this.current = this.rit.next();
            int curIndex = this.current;
            SSRow r = (SSRow)SSTable.this.rows.get(this.current);
            if (this.prevIndex + 1 != curIndex) {
                r.setIndex(curIndex);
            } else {
                r.setIndex(0);
            }
            this.prevIndex = curIndex;
            return r;
        }
    }
}

