/*
 * Decompiled with CFR 0.152.
 */
package nl.fountain.xelem.excel.ss;

import java.lang.reflect.Method;
import nl.fountain.xelem.GIO;
import nl.fountain.xelem.excel.AbstractXLElement;
import nl.fountain.xelem.excel.Column;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;

public class SSColumn
extends AbstractXLElement
implements Column {
    private int idx;
    private String styleID;
    private int span;
    private double width;
    private boolean hidden;
    private boolean autoFitWidth = true;

    @Override
    public void setStyleID(String id) {
        this.styleID = id;
    }

    @Override
    public String getStyleID() {
        return this.styleID;
    }

    @Override
    public void setAutoFitWidth(boolean autoFit) {
        this.autoFitWidth = autoFit;
    }

    private void setAutoFitWidth(String s) {
        this.autoFitWidth = s.equals("1");
    }

    @Override
    public boolean getAutoFitWith() {
        return this.autoFitWidth;
    }

    @Override
    public void setSpan(int s) {
        this.span = s;
    }

    private void setSpan(String s) {
        this.span = Integer.parseInt(s);
    }

    @Override
    public int getSpan() {
        return this.span;
    }

    @Override
    public void setWidth(double w) {
        this.width = w;
    }

    private void setWidth(String s) {
        this.width = Double.parseDouble(s);
    }

    @Override
    public double getWidth() {
        return this.width;
    }

    @Override
    public void setHidden(boolean hide) {
        this.hidden = hide;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    private void setHidden(String s) {
        this.hidden = "1".equals(s);
    }

    @Override
    public String getTagName() {
        return "Column";
    }

    @Override
    public String getNameSpace() {
        return "urn:schemas-microsoft-com:office:spreadsheet";
    }

    @Override
    public String getPrefix() {
        return "ss";
    }

    @Override
    public Element assemble(Element parent, GIO gio) {
        Document doc = parent.getOwnerDocument();
        Element ce = this.assemble(doc, gio);
        if (this.idx != 0) {
            ce.setAttributeNodeNS(this.createAttributeNS(doc, "Index", this.idx));
        }
        if (this.getStyleID() != null) {
            ce.setAttributeNodeNS(this.createAttributeNS(doc, "StyleID", this.getStyleID()));
            gio.addStyleID(this.getStyleID());
        }
        if (this.span > 0) {
            ce.setAttributeNodeNS(this.createAttributeNS(doc, "Span", this.span));
        }
        if (this.width > 0.0) {
            ce.setAttributeNodeNS(this.createAttributeNS(doc, "Width", "" + this.width));
        }
        if (this.hidden) {
            ce.setAttributeNodeNS(this.createAttributeNS(doc, "Hidden", "1"));
        }
        if (!this.autoFitWidth) {
            ce.setAttributeNodeNS(this.createAttributeNS(doc, "AutoFitWidth", "0"));
        }
        parent.appendChild(ce);
        return ce;
    }

    @Override
    public void setAttributes(Attributes attrs) {
        for (int i = 0; i < attrs.getLength(); ++i) {
            this.invokeMethod(attrs.getLocalName(i), attrs.getValue(i));
        }
    }

    private void invokeMethod(String name, Object value) {
        Class[] types = new Class[]{value.getClass()};
        Method method = null;
        try {
            method = this.getClass().getDeclaredMethod("set" + name, types);
            method.invoke((Object)this, value);
        }
        catch (NoSuchMethodException e) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setIndex(int index) {
        this.idx = index;
    }

    @Override
    public int getIndex() {
        return this.idx;
    }
}

