/*
 * Decompiled with CFR 0.152.
 */
package nl.fountain.xelem.excel.ss;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Date;
import nl.fountain.xelem.GIO;
import nl.fountain.xelem.XLUtil;
import nl.fountain.xelem.excel.AbstractXLElement;
import nl.fountain.xelem.excel.Cell;
import nl.fountain.xelem.excel.Comment;
import nl.fountain.xelem.excel.ss.SSComment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;

public class SSCell
extends AbstractXLElement
implements Cell {
    private int idx;
    private boolean hasdata;
    private String styleID;
    private String formula;
    private String href;
    private String data$ = "";
    private String datatype = "String";
    private int mergeacross;
    private int mergedown;
    private Comment comment;

    @Override
    public void setStyleID(String id) {
        this.styleID = id;
    }

    @Override
    public String getStyleID() {
        return this.styleID;
    }

    @Override
    public void setFormula(String formula) {
        this.formula = formula;
    }

    @Override
    public String getFormula() {
        return this.formula;
    }

    @Override
    public void setHRef(String href) {
        this.href = href;
    }

    @Override
    public String getHRef() {
        return this.href;
    }

    @Override
    public Comment addComment() {
        this.comment = new SSComment();
        return this.comment;
    }

    @Override
    public Comment addComment(Comment comment) {
        this.comment = comment;
        return comment;
    }

    @Override
    public Comment addComment(String text) {
        this.comment = new SSComment();
        this.comment.setData(text);
        return this.comment;
    }

    @Override
    public boolean hasComment() {
        return this.comment != null;
    }

    @Override
    public Comment getComment() {
        return this.comment;
    }

    @Override
    public void setMergeAcross(int m) {
        this.mergeacross = m;
    }

    private void setMergeAcross(String s) {
        this.mergeacross = Integer.parseInt(s);
    }

    @Override
    public int getMergeAcross() {
        return this.mergeacross;
    }

    @Override
    public void setMergeDown(int m) {
        this.mergedown = m;
    }

    private void setMergeDown(String s) {
        this.mergedown = Integer.parseInt(s);
    }

    @Override
    public int getMergeDown() {
        return this.mergedown;
    }

    @Override
    public String getXLDataType() {
        return this.datatype;
    }

    @Override
    public void setData(Number data) {
        if (data == null) {
            this.setError("#N/A");
            return;
        }
        this.setData(data.doubleValue());
    }

    @Override
    public void setData(Integer data) {
        if (data == null) {
            this.setError("#N/A");
            return;
        }
        this.datatype = "Number";
        this.setData$(data.toString());
    }

    @Override
    public void setData(Double data) {
        if (data == null) {
            this.setError("#N/A");
            return;
        }
        this.datatype = data.isInfinite() || data.isNaN() ? "String" : "Number";
        this.setData$(data.toString());
    }

    @Override
    public void setData(Long data) {
        if (data == null) {
            this.setError("#N/A");
            return;
        }
        this.datatype = "Number";
        this.setData$(data.toString());
    }

    @Override
    public void setData(Float data) {
        if (data == null) {
            this.setError("#N/A");
            return;
        }
        this.datatype = data.isInfinite() || data.isNaN() ? "String" : "Number";
        this.setData$(data.toString());
    }

    @Override
    public void setData(Date data) {
        if (data == null) {
            this.setError("#N/A");
            return;
        }
        this.datatype = "DateTime";
        this.setData$(XLUtil.format(data));
    }

    @Override
    public void setData(Boolean data) {
        if (data == null) {
            this.setError("#N/A");
            return;
        }
        this.setData((boolean)data);
    }

    @Override
    public void setData(String data) {
        if (data == null) {
            this.setError("#N/A");
            return;
        }
        this.datatype = "String";
        this.setData$(data);
    }

    @Override
    public void setData(Object data) {
        if (data == null) {
            this.setError("#N/A");
            return;
        }
        Class[] types = new Class[]{data.getClass()};
        Method method = null;
        try {
            method = this.getClass().getMethod("setData", types);
            method.invoke((Object)this, data);
        }
        catch (NoSuchMethodException e) {
            this.setData(data.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setError(String error_value) {
        this.datatype = "Error";
        this.setData$(error_value);
        this.setFormula("=" + error_value);
    }

    @Override
    public void setData(byte data) {
        this.datatype = "Number";
        this.setData$(String.valueOf(data));
    }

    @Override
    public void setData(short data) {
        this.datatype = "Number";
        this.setData$(String.valueOf(data));
    }

    @Override
    public void setData(int data) {
        this.datatype = "Number";
        this.setData$(String.valueOf(data));
    }

    @Override
    public void setData(long data) {
        this.datatype = "Number";
        this.setData$(String.valueOf(data));
    }

    @Override
    public void setData(float data) {
        this.datatype = Float.isInfinite(data) || Float.isNaN(data) ? "String" : "Number";
        this.setData$(String.valueOf(data));
    }

    @Override
    public void setData(double data) {
        this.datatype = Double.isInfinite(data) || Double.isNaN(data) ? "String" : "Number";
        this.setData$(String.valueOf(data));
    }

    @Override
    public void setData(BigDecimal data) {
        this.datatype = "Number";
        this.setData$(String.valueOf(data));
    }

    @Override
    public void setData(char data) {
        this.setData(String.valueOf(data));
    }

    @Override
    public void setData(boolean data) {
        this.datatype = "Boolean";
        if (data) {
            this.setData$("1");
        } else {
            this.setData$("0");
        }
    }

    private void setData$(String s) {
        this.data$ = s;
        this.hasdata = true;
    }

    @Override
    public boolean hasData() {
        return this.hasdata;
    }

    @Override
    public boolean hasError() {
        return "Error".equals(this.getXLDataType());
    }

    @Override
    public String getData$() {
        return this.data$;
    }

    @Override
    public Object getData() {
        if ("Number".equals(this.datatype)) {
            return new Double(this.data$);
        }
        if ("DateTime".equals(this.datatype)) {
            return XLUtil.parse(this.data$);
        }
        if ("Boolean".equals(this.datatype)) {
            return new Boolean("1".equals(this.data$));
        }
        return this.data$;
    }

    @Override
    public int intValue() {
        try {
            return new Double(this.data$).intValue();
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    @Override
    public double doubleValue() {
        try {
            return new Double(this.data$);
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    @Override
    public boolean booleanValue() {
        return "1".equals(this.data$);
    }

    @Override
    public String getTagName() {
        return "Cell";
    }

    @Override
    public String getNameSpace() {
        return "urn:schemas-microsoft-com:office:spreadsheet";
    }

    @Override
    public String getPrefix() {
        return "ss";
    }

    @Override
    public Element assemble(Element parent, GIO gio) {
        Document doc = parent.getOwnerDocument();
        Element ce = this.assemble(doc, gio);
        if (this.idx != 0) {
            ce.setAttributeNodeNS(this.createAttributeNS(doc, "Index", this.idx));
        }
        if (this.getStyleID() != null) {
            ce.setAttributeNodeNS(this.createAttributeNS(doc, "StyleID", this.getStyleID()));
            gio.addStyleID(this.getStyleID());
        }
        if (this.formula != null) {
            ce.setAttributeNodeNS(this.createAttributeNS(doc, "Formula", this.formula));
        }
        if (this.href != null) {
            ce.setAttributeNodeNS(this.createAttributeNS(doc, "HRef", this.href));
        }
        if (this.mergeacross > 0) {
            ce.setAttributeNodeNS(this.createAttributeNS(doc, "MergeAcross", this.mergeacross));
        }
        if (this.mergedown > 0) {
            ce.setAttributeNodeNS(this.createAttributeNS(doc, "MergeDown", this.mergedown));
        }
        parent.appendChild(ce);
        if (!"".equals(this.getData$())) {
            Element data = this.getDataElement(doc);
            ce.appendChild(data);
        }
        if (this.comment != null) {
            this.comment.assemble(ce, gio);
        }
        return ce;
    }

    @Override
    public void setAttributes(Attributes attrs) {
        for (int i = 0; i < attrs.getLength(); ++i) {
            this.invokeMethod(attrs.getLocalName(i), attrs.getValue(i));
        }
    }

    @Override
    public void setChildElement(String localName, String content) {
        if ("Data".equals(localName)) {
            this.setData$(content);
        }
    }

    private void invokeMethod(String name, Object value) {
        Class[] types = new Class[]{value.getClass()};
        Method method = null;
        try {
            method = this.getClass().getDeclaredMethod("set" + name, types);
            method.invoke((Object)this, value);
        }
        catch (NoSuchMethodException e) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Element getDataElement(Document doc) {
        Element data = doc.createElement("Data");
        data.setAttributeNodeNS(this.createAttributeNS(doc, "Type", this.getXLDataType()));
        data.appendChild(doc.createTextNode(this.getData$()));
        return data;
    }

    protected void setXLDataType(String type) {
        this.setType(type);
    }

    protected void setType(String type) {
        if (!("Boolean".equals(type) || "DateTime".equals(type) || "Error".equals(type) || "Number".equals(type) || "String".equals(type))) {
            throw new IllegalArgumentException(type + " is not a valid datatype.");
        }
        this.datatype = type;
    }

    @Override
    public void setIndex(int index) {
        this.idx = index;
    }

    @Override
    public int getIndex() {
        return this.idx;
    }
}

