/*
 * Decompiled with CFR 0.152.
 */
package nl.fountain.xelem;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class XLUtil {
    private static SimpleDateFormat xldf;

    private XLUtil() {
    }

    public static String convertToHex(int r, int g, int b) {
        StringBuffer sb = new StringBuffer("#");
        String red = Integer.toHexString(XLUtil.toByte(r));
        sb.append(red.length() < 2 ? "0" + red : red);
        String green = Integer.toHexString(XLUtil.toByte(g));
        sb.append(green.length() < 2 ? "0" + green : green);
        String blue = Integer.toHexString(XLUtil.toByte(b));
        sb.append(blue.length() < 2 ? "0" + blue : blue);
        return sb.toString();
    }

    private static int toByte(int i) {
        if (i < 0) {
            i = 0;
        }
        if (i > 255) {
            i = 255;
        }
        return i;
    }

    public static String format(Date date) {
        StringBuffer sb = new StringBuffer(XLUtil.getDateFormat().format(date));
        sb.append("T");
        sb.append(XLUtil.getTimeFormat().format(date));
        return sb.toString();
    }

    public static Date parse(String dateString) {
        String datum = dateString.substring(0, 10);
        String tijd = dateString.substring(11, 19);
        Date date = null;
        try {
            date = XLUtil.getExcelFormat().parse(datum + " " + tijd);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }

    private static DateFormat getDateFormat() {
        if (xldf == null) {
            xldf = new SimpleDateFormat();
        }
        xldf.applyPattern("yyyy-MM-dd");
        return xldf;
    }

    private static DateFormat getTimeFormat() {
        if (xldf == null) {
            xldf = new SimpleDateFormat();
        }
        xldf.applyPattern("HH:mm:ss.SSS");
        return xldf;
    }

    private static DateFormat getExcelFormat() {
        if (xldf == null) {
            xldf = new SimpleDateFormat();
        }
        xldf.applyPattern("yyyy-MM-dd HH:mm:ss");
        return xldf;
    }
}

