/*
 * Decompiled with CFR 0.152.
 */
package nl.fountain.xelem;

import java.io.FileNotFoundException;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import junit.textui.TestRunner;
import nl.fountain.xelem.GIO;
import nl.fountain.xelem.UnsupportedStyleException;
import nl.fountain.xelem.XFactory;
import nl.fountain.xelem.XelemException;
import nl.fountain.xelem.excel.XLElementTest;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XFactoryTest
extends XLElementTest {
    public static void main(String[] args) {
        TestRunner.run(XFactoryTest.class);
    }

    protected void setUp() throws Exception {
        String configFileName = "testsuitefiles/XFactoryTest/XFactoryTest.xml";
        XFactory.setConfigurationFileName(configFileName);
    }

    protected void tearDown() throws Exception {
        XFactory.reset();
    }

    public void testNewInstance() throws XelemException {
        XFactory x = XFactory.newInstance();
        XFactoryTest.assertNotNull((Object)x);
        XFactory x2 = XFactory.newInstance();
        XFactoryTest.assertNotSame((Object)x, (Object)x2);
        XFactory.reset();
        XFactoryTest.assertNotNull((Object)x);
        XFactoryTest.assertNotSame((Object)x, (Object)x2);
        XFactory x3 = XFactory.newInstance();
        XFactoryTest.assertNotSame((Object)x, (Object)x3);
    }

    public void testEmptyInstance() throws XelemException {
        XFactory x = XFactory.newInstance();
        XFactoryTest.assertEquals((int)3, (int)x.getDocComments().size());
        XFactoryTest.assertEquals((int)4, (int)x.getStylesCount());
        XFactory ef = XFactory.emptyFactory();
        XFactoryTest.assertEquals((int)0, (int)ef.getDocComments().size());
        XFactoryTest.assertEquals((int)0, (int)ef.getStylesCount());
        XFactoryTest.assertEquals((int)0, (int)x.getDocComments().size());
        XFactoryTest.assertEquals((int)0, (int)x.getStylesCount());
        XFactoryTest.assertEquals((String)"config/xelem.xml", (String)XFactory.getConfigurationFileName());
    }

    public void testReset() throws XelemException {
        XFactory x = XFactory.newInstance();
        XFactoryTest.assertEquals((int)3, (int)x.getDocComments().size());
        XFactoryTest.assertEquals((int)4, (int)x.getStylesCount());
        XFactoryTest.assertNotNull((Object)XFactory.getConfigurationFileName());
        XFactoryTest.assertTrue((!"config/xelem.xml".equals(XFactory.getConfigurationFileName()) ? 1 : 0) != 0);
        XFactory.reset();
        XFactoryTest.assertEquals((int)3, (int)x.getDocComments().size());
        XFactoryTest.assertEquals((int)4, (int)x.getStylesCount());
        XFactoryTest.assertEquals((String)"config/xelem.xml", (String)XFactory.getConfigurationFileName());
    }

    public void testGetDocComments() throws XelemException {
        List<String> docComments = XFactory.newInstance().getDocComments();
        XFactoryTest.assertNotNull(docComments);
        Iterator<String> iter = docComments.iterator();
        XFactoryTest.assertEquals((String)"      f:comment 1      ", (String)iter.next());
        XFactoryTest.assertEquals((String)"      f:comment 2      ", (String)iter.next());
        XFactoryTest.assertEquals((String)"      f:comment 3      ", (String)iter.next());
    }

    public void testGetStyles() throws XelemException {
        XFactory x = XFactory.newInstance();
        XFactoryTest.assertNotNull((Object)x.getStyle("decimal1"));
        XFactoryTest.assertNotNull((Object)x.getStyle("decimal2"));
        XFactoryTest.assertNotNull((Object)x.getStyle("bold"));
        XFactoryTest.assertNotNull((Object)x.getStyle("b_yellow"));
    }

    public void testException() {
        XFactory.setConfigurationFileName("this/file/does/not/exist");
        try {
            XFactory.newInstance();
            XFactoryTest.fail((String)"a file with a very inordinate name does exist.");
        }
        catch (XelemException e) {
            XFactoryTest.assertEquals(FileNotFoundException.class, e.getCause().getClass());
        }
    }

    public void testMergeStylesExc() throws XelemException {
        XFactory x = XFactory.newInstance();
        try {
            x.mergeStyles("noID", "foo", "bar");
            XFactoryTest.fail((String)"geen Exceptie gegooid");
        }
        catch (UnsupportedStyleException e) {
            XFactoryTest.assertEquals((String)"Style(s) 'foo' 'bar' not found.", (String)e.getMessage());
        }
        XFactoryTest.assertNull((Object)x.getStyle("noID"));
    }

    public void testMergeStyles() throws Exception {
        XFactory x = XFactory.newInstance();
        x.mergeStyles("nieuw", "bold", "b_yellow");
        XFactoryTest.assertNotNull((Object)x.getStyle("nieuw"));
        Element nieuw = x.getStyle("nieuw");
        String xml = this.xmlToString(nieuw);
        XFactoryTest.assertTrue((xml.indexOf("<Style ss:ID=\"nieuw\">") > 0 ? 1 : 0) != 0);
        XFactoryTest.assertTrue((xml.indexOf("x:Family=\"Swiss\"") > 0 ? 1 : 0) != 0);
        XFactoryTest.assertTrue((xml.indexOf("ss:Bold=\"1\"") > 0 ? 1 : 0) != 0);
        XFactoryTest.assertTrue((xml.indexOf("<Interior ss:Color=\"#FFFF00\" ss:Pattern=\"Solid\"/>") > 0 ? 1 : 0) != 0);
        x.mergeStyles("nieuwer", "nieuw", "decimal2");
        XFactoryTest.assertNotNull((Object)x.getStyle("nieuwer"));
        XFactoryTest.assertEquals((int)6, (int)x.getStylesCount());
        xml = this.xmlToString(x.getStyle("nieuwer"));
        XFactoryTest.assertTrue((xml.indexOf("<Style ss:ID=\"nieuwer\">") > 0 ? 1 : 0) != 0);
        XFactoryTest.assertTrue((xml.indexOf("x:Family=\"Swiss\"") > 0 ? 1 : 0) != 0);
        XFactoryTest.assertTrue((xml.indexOf("ss:Bold=\"1\"") > 0 ? 1 : 0) != 0);
        XFactoryTest.assertTrue((xml.indexOf("<Interior ss:Color=\"#FFFF00\" ss:Pattern=\"Solid\"/>") > 0 ? 1 : 0) != 0);
        XFactoryTest.assertTrue((xml.indexOf("<NumberFormat ss:Format=\"0.00\"/>") > 0 ? 1 : 0) != 0);
        x.mergeStyles("nieuwer", null, null);
        XFactoryTest.assertEquals((int)6, (int)x.getStylesCount());
        x.mergeStyles("stay0.00", "nieuwer", "decimal1");
        XFactoryTest.assertNotNull((Object)x.getStyle("stay0.00"));
        XFactoryTest.assertEquals((int)7, (int)x.getStylesCount());
        xml = this.xmlToString(x.getStyle("stay0.00"));
        XFactoryTest.assertTrue((xml.indexOf("<NumberFormat ss:Format=\"0.00\"/>") > 0 ? 1 : 0) != 0);
        XFactoryTest.assertEquals((int)-1, (int)xml.indexOf("<NumberFormat ss:Format=\"0.0\"/>"));
    }

    public void testAddStyle() throws XelemException {
        Element style;
        XFactory x = XFactory.newInstance();
        XFactoryTest.assertTrue((!x.addStyle(style = x.getStyle("b_yellow")) ? 1 : 0) != 0);
        Element nStyle = style.getOwnerDocument().createElement("Style");
        Attr attr = style.getOwnerDocument().createAttributeNS("urn:schemas-microsoft-com:office:spreadsheet", "ID");
        attr.setPrefix("ss");
        attr.setNodeValue("nieuw");
        nStyle.setAttributeNodeNS(attr);
        XFactoryTest.assertTrue((boolean)x.addStyle(nStyle));
        Element noStyle = style.getOwnerDocument().createElement("Style");
        attr = style.getOwnerDocument().createAttributeNS("urn:schemas-microsoft-com:office:spreadsheet", "FOO");
        attr.setPrefix("ss");
        attr.setNodeValue("no_id");
        noStyle.setAttributeNodeNS(attr);
        try {
            x.addStyle(noStyle);
            XFactoryTest.fail((String)"should have thrown Exception.");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
    }

    public void testGetInfoSheet() throws XelemException {
        XFactory x = XFactory.newInstance();
        Node infoSheet = x.loadInfoSheet();
        String xml = this.xmlToString(infoSheet);
        XFactoryTest.assertTrue((xml.indexOf("<ss:Worksheet ss:Name=") > 0 ? 1 : 0) != 0);
    }

    public void testAppendInfoSheet() throws ParserConfigurationException, XelemException {
        Document doc = this.getDoc();
        XFactory x = XFactory.newInstance();
        GIO gio = new GIO();
        x.appendInfoSheet(doc.getDocumentElement(), gio);
        XFactoryTest.assertTrue((gio.getStyleIDSet().size() > 0 ? 1 : 0) != 0);
        XFactoryTest.assertTrue((!gio.getStyleIDSet().contains("Default") ? 1 : 0) != 0);
        String xml = this.xmlToString(doc.getElementsByTagNameNS("urn:schemas-microsoft-com:office:spreadsheet", "Worksheet").item(0));
        XFactoryTest.assertTrue((xml.indexOf("<ss:Worksheet ss:Name=") > 0 ? 1 : 0) != 0);
    }
}

