/*
 * Decompiled with CFR 0.152.
 */
package nl.fountain.xelem;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import nl.fountain.xelem.Address;
import nl.fountain.xelem.CellPointer;

public class CellPointerTest
extends TestCase {
    public static void main(String[] args) {
        TestRunner.run(CellPointerTest.class);
    }

    public void testConstructor() {
        CellPointer cp = new CellPointer();
        CellPointerTest.assertEquals((int)1, (int)cp.getColumnIndex());
        CellPointerTest.assertEquals((int)1, (int)cp.getRowIndex());
    }

    public void testParameterlessMove() {
        CellPointer cp = new CellPointer();
        cp.move();
        CellPointerTest.assertEquals((int)2, (int)cp.getColumnIndex());
        CellPointerTest.assertEquals((int)1, (int)cp.getRowIndex());
    }

    public void testMoveToString() {
        CellPointer cp = new CellPointer();
        cp.moveTo("AA10");
        CellPointerTest.assertEquals((int)10, (int)cp.getRowIndex());
        CellPointerTest.assertEquals((int)27, (int)cp.getColumnIndex());
        cp.move(-2, -1);
        CellPointerTest.assertEquals((String)"Z8", (String)cp.getA1Reference());
        cp.move(7, 2);
        CellPointerTest.assertEquals((String)"AB15", (String)cp.getA1Reference());
        cp.moveTo("012point");
        CellPointerTest.assertEquals((String)"POINT12", (String)cp.getA1Reference());
    }

    public void testSetMovement() {
        CellPointer cp = new CellPointer();
        cp.setMovement(2);
        cp.move();
        CellPointerTest.assertEquals((int)1, (int)cp.getColumnIndex());
        CellPointerTest.assertEquals((int)2, (int)cp.getRowIndex());
        cp.setMovement(1);
        cp.move();
        CellPointerTest.assertEquals((int)0, (int)cp.getColumnIndex());
        CellPointerTest.assertEquals((int)2, (int)cp.getRowIndex());
        cp.setMovement(0);
        cp.move();
        CellPointerTest.assertEquals((int)1, (int)cp.getColumnIndex());
        CellPointerTest.assertEquals((int)2, (int)cp.getRowIndex());
        cp.setMovement(3);
        cp.move();
        CellPointerTest.assertEquals((int)1, (int)cp.getColumnIndex());
        CellPointerTest.assertEquals((int)1, (int)cp.getRowIndex());
        try {
            cp.setMovement(-1);
            CellPointerTest.fail((String)"geen exceptie gegooid.");
        }
        catch (IllegalArgumentException e) {
            CellPointerTest.assertEquals((String)"-1. Legal values are 0, 1, 2 and 3.", (String)e.getMessage());
        }
    }

    public void testStepDistance() {
        CellPointer cp = new CellPointer();
        cp.setHorizontalStepDistance(10);
        cp.move();
        CellPointerTest.assertEquals((int)11, (int)cp.getColumnIndex());
        CellPointerTest.assertEquals((int)1, (int)cp.getRowIndex());
        cp.setVerticalStepDistance(5);
        cp.setMovement(2);
        cp.move();
        CellPointerTest.assertEquals((int)11, (int)cp.getColumnIndex());
        CellPointerTest.assertEquals((int)6, (int)cp.getRowIndex());
        cp.setMovement(1);
        cp.move();
        CellPointerTest.assertEquals((int)1, (int)cp.getColumnIndex());
        CellPointerTest.assertEquals((int)6, (int)cp.getRowIndex());
        cp.setMovement(3);
        cp.move();
        CellPointerTest.assertEquals((int)1, (int)cp.getColumnIndex());
        CellPointerTest.assertEquals((int)1, (int)cp.getRowIndex());
    }

    public void testIsWithinSheet() {
        CellPointer cp = new CellPointer();
        CellPointerTest.assertTrue((boolean)cp.isWithinSheet());
        cp.moveTo(0, 1);
        CellPointerTest.assertTrue((!cp.isWithinSheet() ? 1 : 0) != 0);
        cp.moveTo(1, 0);
        CellPointerTest.assertTrue((!cp.isWithinSheet() ? 1 : 0) != 0);
        cp.moveTo(65537, 1);
        CellPointerTest.assertTrue((!cp.isWithinSheet() ? 1 : 0) != 0);
        cp.moveTo(1, 257);
        CellPointerTest.assertTrue((!cp.isWithinSheet() ? 1 : 0) != 0);
        cp.moveTo(1000, 10);
        CellPointerTest.assertTrue((boolean)cp.isWithinSheet());
    }

    public void testGetAbsoluteAddress() {
        CellPointer cp = new CellPointer();
        CellPointerTest.assertEquals((String)"R1C1", (String)cp.getAbsoluteAddress());
        cp.moveTo(25, 107);
        CellPointerTest.assertEquals((String)"R25C107", (String)cp.getAbsoluteAddress());
    }

    public void testToString() {
        CellPointer cp = new CellPointer();
        CellPointerTest.assertEquals((String)"nl.fountain.xelem.CellPointer[row=1,column=1]", (String)cp.toString());
    }

    public void testEquals() {
        Address adr = new Address(5, 7);
        CellPointer cp = new CellPointer();
        CellPointerTest.assertTrue((!adr.equals(cp) ? 1 : 0) != 0);
        CellPointerTest.assertTrue((!cp.equals(adr) ? 1 : 0) != 0);
        cp.moveTo(5, 7);
        CellPointerTest.assertTrue((!adr.equals(cp) ? 1 : 0) != 0);
        CellPointerTest.assertTrue((!cp.equals(adr) ? 1 : 0) != 0);
        CellPointer cpo = new CellPointer();
        CellPointerTest.assertTrue((!adr.equals(cpo) ? 1 : 0) != 0);
        CellPointerTest.assertTrue((!((Object)cpo).equals(adr) ? 1 : 0) != 0);
        Address adrn = new Address(1, 1);
        CellPointerTest.assertTrue((!adrn.equals(cpo) ? 1 : 0) != 0);
        CellPointerTest.assertTrue((!((Object)cpo).equals(adrn) ? 1 : 0) != 0);
    }

    public void testCompareTo() {
        CellPointer cp = new CellPointer();
        try {
            cp.compareTo((Object)null);
            CellPointerTest.fail((String)"geen exceptie gegooid");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        Address adr = new Address(5, 7);
        try {
            cp.compareTo(adr);
            CellPointerTest.fail((String)"geen exceptie gegooid");
        }
        catch (ClassCastException e1) {
            // empty catch block
        }
        CellPointer cp2 = new CellPointer();
        CellPointerTest.assertEquals((int)0, (int)cp.compareTo(cp2));
        cp2.moveTo(1, 2);
        CellPointerTest.assertTrue((cp.compareTo(cp2) < 0 ? 1 : 0) != 0);
        cp2.moveTo(2, 1);
        CellPointerTest.assertTrue((cp.compareTo(cp2) < 0 ? 1 : 0) != 0);
        cp2.moveTo(1, 257);
        CellPointerTest.assertTrue((cp.compareTo(cp2) < 0 ? 1 : 0) != 0);
        cp.moveTo(2, 1);
        CellPointerTest.assertTrue((cp.compareTo(cp2) > 0 ? 1 : 0) != 0);
    }
}

