/*
 * Decompiled with CFR 0.152.
 */
package nl.fountain.xelem;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import nl.fountain.xelem.Address;
import nl.fountain.xelem.Area;

public class AreaTest
extends TestCase {
    public static void main(String[] args) {
        TestRunner.run(AreaTest.class);
    }

    public void testIntConstructor() {
        Area area = new Area(1, 2, 3, 4);
        AreaTest.assertEquals((int)1, (int)area.getFirstRow());
        AreaTest.assertEquals((int)2, (int)area.getFirstColumn());
        AreaTest.assertEquals((int)3, (int)area.getLastRow());
        AreaTest.assertEquals((int)4, (int)area.getLastColumn());
        area = new Area(4, 3, 2, 1);
        AreaTest.assertEquals((int)2, (int)area.getFirstRow());
        AreaTest.assertEquals((int)1, (int)area.getFirstColumn());
        AreaTest.assertEquals((int)4, (int)area.getLastRow());
        AreaTest.assertEquals((int)3, (int)area.getLastColumn());
    }

    public void testAddressConstructor() {
        Address address1 = new Address(2, 3);
        Address address2 = new Address(5, 8);
        Area area = new Area(address1, address2);
        AreaTest.assertEquals((int)2, (int)area.getFirstRow());
        AreaTest.assertEquals((int)3, (int)area.getFirstColumn());
        AreaTest.assertEquals((int)5, (int)area.getLastRow());
        AreaTest.assertEquals((int)8, (int)area.getLastColumn());
    }

    public void testStringConstructor() {
        Area area = new Area("C2:H5");
        AreaTest.assertEquals((int)2, (int)area.getFirstRow());
        AreaTest.assertEquals((int)3, (int)area.getFirstColumn());
        AreaTest.assertEquals((int)5, (int)area.getLastRow());
        AreaTest.assertEquals((int)8, (int)area.getLastColumn());
        area = new Area("H5:C2");
        AreaTest.assertEquals((int)2, (int)area.getFirstRow());
        AreaTest.assertEquals((int)3, (int)area.getFirstColumn());
        AreaTest.assertEquals((int)5, (int)area.getLastRow());
        AreaTest.assertEquals((int)8, (int)area.getLastColumn());
        area = new Area("foo:bar");
        AreaTest.assertEquals((int)0, (int)area.getFirstRow());
        AreaTest.assertEquals((int)1396, (int)area.getFirstColumn());
        AreaTest.assertEquals((int)0, (int)area.getLastRow());
        AreaTest.assertEquals((int)4461, (int)area.getLastColumn());
        area = new Area("1:2");
        AreaTest.assertEquals((int)1, (int)area.getFirstRow());
        AreaTest.assertEquals((int)0, (int)area.getFirstColumn());
        AreaTest.assertEquals((int)2, (int)area.getLastRow());
        AreaTest.assertEquals((int)0, (int)area.getLastColumn());
        try {
            area = new Area(":");
            AreaTest.fail((String)"geen exceptie gegooid.");
        }
        catch (IllegalArgumentException e1) {
            AreaTest.assertEquals((String)"use format 'A1:A1'.", (String)e1.getMessage());
        }
        try {
            area = new Area("foobar");
            AreaTest.fail((String)"geen exceptie gegooid.");
        }
        catch (IllegalArgumentException e) {
            AreaTest.assertEquals((String)"use format 'A1:A1'.", (String)e.getMessage());
        }
    }

    public void testGetA1Reference() {
        Area area = new Area("bz50:ab60");
        AreaTest.assertEquals((String)"AB50:BZ60", (String)area.getA1Reference());
    }

    public void testGetAbsoluteRange() {
        Area area = new Area(2, 3, 5, 8);
        AreaTest.assertEquals((String)"R2C3:R5C8", (String)area.getAbsoluteRange());
    }

    public void testIsWithinArea() {
        Area area = new Area(2, 3, 5, 8);
        AreaTest.assertTrue((boolean)area.isWithinArea(2, 3));
        AreaTest.assertTrue((boolean)area.isWithinArea(5, 3));
        AreaTest.assertTrue((boolean)area.isWithinArea(2, 8));
        AreaTest.assertTrue((boolean)area.isWithinArea(5, 8));
        AreaTest.assertTrue((boolean)area.isWithinArea(3, 7));
        AreaTest.assertFalse((boolean)area.isWithinArea(1, 7));
    }
}

