/*
 * Decompiled with CFR 0.152.
 */
package nl.fountain.xelem;

import nl.fountain.xelem.Address;

public class Area {
    protected int r1;
    protected int r2;
    protected int c1;
    protected int c2;

    public Area(int row1, int column1, int row2, int column2) {
        this.setDimensions(row1, column1, row2, column2);
    }

    public Area(Address address1, Address address2) {
        this.setDimensions(address1.r, address1.c, address2.r, address2.c);
    }

    public Area(String a1_ref) {
        String[] ar = a1_ref.split(":");
        if (ar.length < 2) {
            throw new IllegalArgumentException("use format 'A1:A1'.");
        }
        this.setDimensions(Address.calculateRow(ar[0]), Address.calculateColumn(ar[0]), Address.calculateRow(ar[1]), Address.calculateColumn(ar[1]));
    }

    public int getFirstRow() {
        return this.r1;
    }

    public int getLastRow() {
        return this.r2;
    }

    public int getFirstColumn() {
        return this.c1;
    }

    public int getLastColumn() {
        return this.c2;
    }

    public String getA1Reference() {
        StringBuffer sb = new StringBuffer();
        sb.append(Address.calculateColumn(this.c1));
        sb.append(this.r1);
        sb.append(":");
        sb.append(Address.calculateColumn(this.c2));
        sb.append(this.r2);
        return sb.toString();
    }

    public String getAbsoluteRange() {
        StringBuffer sb = new StringBuffer("R");
        sb.append(this.r1);
        sb.append("C");
        sb.append(this.c1);
        sb.append(":R");
        sb.append(this.r2);
        sb.append("C");
        sb.append(this.c2);
        return sb.toString();
    }

    public boolean isWithinArea(int rowIndex, int columnIndex) {
        return rowIndex >= this.r1 && rowIndex <= this.r2 && columnIndex >= this.c1 && columnIndex <= this.c2;
    }

    public boolean isWithinArea(Address address) {
        return this.isWithinArea(address.r, address.c);
    }

    public boolean isRowPartOfArea(int rowIndex) {
        return rowIndex >= this.r1 && rowIndex <= this.r2;
    }

    public boolean isColumnPartOfArea(int columnIndex) {
        return columnIndex >= this.c1 && columnIndex <= this.c2;
    }

    private void setDimensions(int row1, int column1, int row2, int column2) {
        if (row2 > row1) {
            this.r1 = row1;
            this.r2 = row2;
        } else {
            this.r1 = row2;
            this.r2 = row1;
        }
        if (column2 > column1) {
            this.c1 = column1;
            this.c2 = column2;
        } else {
            this.c1 = column2;
            this.c2 = column1;
        }
    }
}

