/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.curseapi.forgesvc;

import com.therandomlabs.curseapi.CurseAPI;
import com.therandomlabs.curseapi.CurseException;
import com.therandomlabs.curseapi.forgesvc.ForgeSvcCategorySection;
import com.therandomlabs.curseapi.game.CurseCategory;
import com.therandomlabs.curseapi.game.CurseCategorySection;
import com.therandomlabs.curseapi.game.CurseGame;
import com.therandomlabs.curseapi.game.CurseGameVersion;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;

final class ForgeSvcGame
extends CurseGame {
    private int id;
    private String name;
    private String slug;
    private Set<ForgeSvcCategorySection> categorySections;
    private transient Set<CurseCategory> categories;
    private transient NavigableSet<CurseGameVersion<?>> versions;

    ForgeSvcGame() {
    }

    @Override
    public int id() {
        return this.id;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String slug() {
        return this.slug;
    }

    @Override
    public Set<CurseCategorySection> categorySections() {
        return new TreeSet<CurseCategorySection>(this.categorySections);
    }

    @Override
    public Set<CurseCategory> categories() throws CurseException {
        if (this.categories == null) {
            this.categories = CurseAPI.categories().orElse(null);
            if (this.categories == null) {
                throw new CurseException("Failed to retrieve categories in game: " + this);
            }
            this.categories.removeIf(category -> category.gameID() != this.id);
        }
        return this.categories;
    }

    @Override
    public Set<CurseCategory> refreshCategories() throws CurseException {
        this.categories = null;
        return this.categories();
    }

    @Override
    public <V extends CurseGameVersion<?>> NavigableSet<V> versions() throws CurseException {
        if (this.versions == null) {
            this.versions = CurseAPI.gameVersions(this.id()).orElseGet(TreeSet::new);
        }
        return this.versions;
    }

    @Override
    public <V extends CurseGameVersion<?>> NavigableSet<V> refreshVersions() throws CurseException {
        this.versions = null;
        return this.versions();
    }
}

