/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.curseapi.file;

import com.therandomlabs.curseapi.CurseAPI;
import com.therandomlabs.curseapi.CurseException;
import com.therandomlabs.curseapi.file.BasicCurseFile;
import com.therandomlabs.curseapi.file.CurseFile;
import com.therandomlabs.curseapi.file.ExistingCurseFile;
import com.therandomlabs.curseapi.project.CurseProject;
import java.util.Optional;
import okhttp3.HttpUrl;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jsoup.nodes.Element;

public abstract class CurseAlternateFile
extends BasicCurseFile
implements ExistingCurseFile {
    private transient @Nullable CurseProject project;
    private transient @Nullable HttpUrl downloadURL;
    private transient @Nullable Element changelog;
    private transient @Nullable CurseFile mainFile;

    @Override
    public @NonNull CurseProject project() throws CurseException {
        if (this.project == null) {
            Optional<CurseProject> optionalProject = CurseAPI.project(this.projectID());
            if (!optionalProject.isPresent()) {
                throw new CurseException("Failed to retrieve CurseProject: " + this);
            }
            this.project = optionalProject.get();
        }
        return this.project;
    }

    @Override
    public CurseProject refreshProject() throws CurseException {
        this.project = null;
        return this.project();
    }

    @Override
    public HttpUrl url() throws CurseException {
        return this.project().fileURL(this.id());
    }

    @Override
    public HttpUrl downloadURL() throws CurseException {
        if (this.downloadURL == null) {
            Optional<HttpUrl> optionalDownloadURL = CurseAPI.fileDownloadURL(this.projectID(), this.id());
            if (!optionalDownloadURL.isPresent()) {
                throw new CurseException("Failed to retrieve download URL: " + this);
            }
            this.downloadURL = optionalDownloadURL.get();
        }
        return this.downloadURL;
    }

    @Override
    public HttpUrl refreshDownloadURL() throws CurseException {
        this.downloadURL = null;
        return this.downloadURL();
    }

    @Override
    public Element changelog() throws CurseException {
        if (this.changelog == null) {
            Optional<Element> optionalChangelog = CurseAPI.fileChangelog(this.projectID(), this.id());
            if (!optionalChangelog.isPresent()) {
                throw new CurseException("Failed to retrieve changelog: " + this);
            }
            this.changelog = optionalChangelog.get();
        }
        return this.changelog;
    }

    @Override
    public Element refreshChangelog() throws CurseException {
        this.changelog = null;
        return this.changelog();
    }

    public abstract int mainFileID();

    public CurseFile mainFile() throws CurseException {
        if (this.mainFile == null) {
            Optional<CurseFile> optionalFile = CurseAPI.file(this.projectID(), this.mainFileID());
            if (!optionalFile.isPresent()) {
                throw new CurseException("Failed to retrieve main file as CurseFile: " + this);
            }
            this.mainFile = optionalFile.get();
        }
        return this.mainFile;
    }

    public CurseFile refreshMainFile() throws CurseException {
        this.mainFile = null;
        return this.mainFile();
    }
}

